/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.xipki.ocsp.api.RequestIssuer;
import org.xipki.ocsp.server.store.IssuerEntry;

public class IssuerStore {
    private final List<IssuerEntry> entries;
    private Set<Integer> ids;

    public IssuerStore(List<IssuerEntry> entries) {
        this.entries = new ArrayList<IssuerEntry>(entries.size());
        HashSet<Integer> idSet = new HashSet<Integer>(entries.size());
        for (IssuerEntry entry : entries) {
            for (IssuerEntry existingEntry : this.entries) {
                if (existingEntry.getId() != entry.getId()) continue;
                throw new IllegalArgumentException("issuer with the same id " + entry.getId() + " already available");
            }
            this.entries.add(entry);
            idSet.add(entry.getId());
        }
        this.ids = Collections.unmodifiableSet(idSet);
    }

    public int size() {
        return this.ids.size();
    }

    public Set<Integer> getIds() {
        return this.ids;
    }

    public Integer getIssuerIdForFp(RequestIssuer reqIssuer) {
        IssuerEntry issuerEntry = this.getIssuerForFp(reqIssuer);
        return issuerEntry == null ? null : Integer.valueOf(issuerEntry.getId());
    }

    public IssuerEntry getIssuerForId(int id) {
        for (IssuerEntry entry : this.entries) {
            if (entry.getId() != id) continue;
            return entry;
        }
        return null;
    }

    public IssuerEntry getIssuerForFp(RequestIssuer reqIssuer) {
        for (IssuerEntry entry : this.entries) {
            if (!entry.matchHash(reqIssuer)) continue;
            return entry;
        }
        return null;
    }

    public void addIssuer(IssuerEntry issuer) {
        this.entries.add(issuer);
        HashSet<Integer> newIds = new HashSet<Integer>(this.ids);
        newIds.add(issuer.getId());
        this.ids = Collections.unmodifiableSet(newIds);
    }
}

