/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.store;

import org.xipki.ocsp.api.OcspStore;
import org.xipki.ocsp.api.OcspStoreFactory;
import org.xipki.ocsp.server.store.CrlDbCertStatusStore;
import org.xipki.ocsp.server.store.DbCertStatusStore;
import org.xipki.util.ObjectCreationException;

public class OcspStoreFactoryImpl
implements OcspStoreFactory {
    private static final String TYPE_XIPKI_DB = "xipki-db";
    private static final String TYPE_CRL = "crl";

    public boolean canCreateOcspStore(String type) {
        return TYPE_XIPKI_DB.equalsIgnoreCase(type) || TYPE_CRL.equalsIgnoreCase(type);
    }

    public OcspStore newOcspStore(String type) throws ObjectCreationException {
        if (TYPE_XIPKI_DB.equalsIgnoreCase(type)) {
            return new DbCertStatusStore();
        }
        if (TYPE_CRL.equalsIgnoreCase(type)) {
            return new CrlDbCertStatusStore();
        }
        throw new ObjectCreationException("unknown type OCSP store type " + type);
    }
}

