/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.store;

import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.x509.Certificate;
import org.xipki.ocsp.api.RequestIssuer;
import org.xipki.ocsp.server.store.crl.CrlInfo;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.CrlReason;
import org.xipki.security.HashAlgo;
import org.xipki.util.Args;
import org.xipki.util.CompareUtil;

class IssuerEntry {
    private final int id;
    private final Map<HashAlgo, byte[]> issuerHashMap;
    private final Date notBefore;
    private final X509Certificate cert;
    private CertRevocationInfo revocationInfo;
    private CrlInfo crlInfo;

    public IssuerEntry(int id, X509Certificate cert) throws CertificateEncodingException {
        this.id = id;
        this.cert = (X509Certificate)Args.notNull((Object)cert, (String)"cert");
        this.notBefore = cert.getNotBefore();
        this.issuerHashMap = IssuerEntry.getIssuerHashAndKeys(cert.getEncoded());
    }

    private static Map<HashAlgo, byte[]> getIssuerHashAndKeys(byte[] encodedCert) throws CertificateEncodingException {
        byte[] encodedKey;
        byte[] encodedName;
        try {
            Certificate bcCert = Certificate.getInstance((Object)encodedCert);
            encodedName = bcCert.getSubject().getEncoded("DER");
            encodedKey = bcCert.getSubjectPublicKeyInfo().getPublicKeyData().getBytes();
        }
        catch (IOException | IllegalArgumentException ex) {
            throw new CertificateEncodingException(ex.getMessage(), ex);
        }
        HashMap<HashAlgo, byte[]> hashes = new HashMap<HashAlgo, byte[]>();
        for (HashAlgo ha : HashAlgo.values()) {
            int hlen = ha.getLength();
            byte[] nameAndKeyHash = new byte[2 + hlen << 1];
            int offset = 0;
            nameAndKeyHash[offset++] = 4;
            nameAndKeyHash[offset++] = (byte)hlen;
            System.arraycopy(ha.hash((byte[][])new byte[][]{encodedName}), 0, nameAndKeyHash, offset, hlen);
            offset += hlen;
            nameAndKeyHash[offset++] = 4;
            nameAndKeyHash[offset++] = (byte)hlen;
            System.arraycopy(ha.hash((byte[][])new byte[][]{encodedKey}), 0, nameAndKeyHash, offset, hlen);
            hashes.put(ha, nameAndKeyHash);
        }
        return hashes;
    }

    public int getId() {
        return this.id;
    }

    public byte[] getEncodedHash(HashAlgo hashAlgo) {
        byte[] data = this.issuerHashMap.get(hashAlgo);
        return Arrays.copyOf(data, data.length);
    }

    public boolean matchHash(RequestIssuer reqIssuer) {
        byte[] issuerHash = this.issuerHashMap.get(reqIssuer.hashAlgorithm());
        if (issuerHash == null) {
            return false;
        }
        return CompareUtil.areEqual((byte[])issuerHash, (int)0, (byte[])reqIssuer.getData(), (int)reqIssuer.getNameHashFrom(), (int)issuerHash.length);
    }

    public void setRevocationInfo(Date revocationTime) {
        Args.notNull((Object)revocationTime, (String)"revocationTime");
        this.revocationInfo = new CertRevocationInfo(CrlReason.CA_COMPROMISE, revocationTime, null);
    }

    public void setCrlInfo(CrlInfo crlInfo) {
        this.crlInfo = crlInfo;
    }

    public CrlInfo getCrlInfo() {
        return this.crlInfo;
    }

    public CertRevocationInfo getRevocationInfo() {
        return this.revocationInfo;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public X509Certificate getCert() {
        return this.cert;
    }
}

