/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.store.crl;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.ocsp.api.OcspStoreException;
import org.xipki.ocsp.server.store.DbCertStatusStore;
import org.xipki.ocsp.server.store.crl.ImportCrl;
import org.xipki.util.Args;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;

public class CrlDbCertStatusStore
extends DbCertStatusStore {
    private static final Logger LOG = LoggerFactory.getLogger(CrlDbCertStatusStore.class);
    private final AtomicBoolean crlUpdateInProcess = new AtomicBoolean(false);
    private String dir;
    private boolean crlUpdated;

    @Override
    public void init(Map<String, ? extends Object> sourceConf, DataSourceWrapper datasource) throws OcspStoreException {
        Args.notNull(sourceConf, (String)"sourceConf");
        this.dir = IoUtil.expandFilepath((String)CrlDbCertStatusStore.getStrValue(sourceConf, "dir", true));
        this.updateStore(datasource);
        super.init(sourceConf, datasource);
    }

    private static String getStrValue(Map<String, ? extends Object> sourceConf, String confName, boolean mandatory) {
        Object objVal = sourceConf.get(confName);
        if (objVal == null) {
            if (mandatory) {
                throw new IllegalArgumentException("mandatory " + confName + " is not specified in sourceConf");
            }
            return null;
        }
        if (objVal instanceof String) {
            return (String)objVal;
        }
        throw new IllegalArgumentException("content of " + confName + " is not String, but " + objVal.getClass().getName());
    }

    @Override
    protected List<Runnable> getScheduledServices() {
        return Arrays.asList(new CrlUpdateService());
    }

    @Override
    protected boolean isInitialized() {
        return this.crlUpdated && super.isInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateStore(DataSourceWrapper datasource) {
        if (this.crlUpdateInProcess.get()) {
            return;
        }
        File updateMeFile = new File(this.dir, "UPDATEME");
        if (!updateMeFile.exists()) {
            LOG.info("The CRL will not be updated. Create new file {} to force the update", (Object)updateMeFile.getAbsolutePath());
            return;
        }
        this.crlUpdateInProcess.set(true);
        try {
            ImportCrl importCrl = new ImportCrl(datasource, this.dir);
            if (importCrl.importCrlToOcspDb()) {
                updateMeFile.delete();
                LOG.info("updated CertStore {} successfully", (Object)this.name);
            } else {
                LOG.error("updating CertStore {} failed", (Object)this.name);
            }
        }
        catch (Throwable th) {
            LogUtil.error((Logger)LOG, (Throwable)th, (String)"error while executing updateStore()");
        }
        finally {
            this.crlUpdated = true;
            this.crlUpdateInProcess.set(false);
        }
    }

    private class CrlUpdateService
    implements Runnable {
        private CrlUpdateService() {
        }

        @Override
        public void run() {
            try {
                CrlDbCertStatusStore.this.updateStore(CrlDbCertStatusStore.this.datasource);
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)("error while calling initializeStore() for store " + CrlDbCertStatusStore.this.name));
            }
        }
    }
}

