/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.store.crl;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;
import org.bouncycastle.asn1.ocsp.CrlID;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.ConfPairs;
import org.xipki.util.DateUtil;
import org.xipki.util.StringUtil;

public class CrlInfo {
    public static final String BASE_CRL_NUMBER = "base-crl-number";
    public static final String CRL_ID = "crl-id";
    public static final String CRL_NUMBER = "crl-number";
    public static final String NEXT_UPDATE = "next-update";
    public static final String THIS_UPDATE = "this-update";
    private BigInteger crlNumber;
    private BigInteger baseCrlNumber;
    private Date thisUpdate;
    private Date nextUpdate;
    private CrlID crlId;

    public CrlInfo(String conf) {
        ConfPairs pairs = new ConfPairs(conf);
        String str = CrlInfo.getNotBlankValue(pairs, CRL_NUMBER);
        this.crlNumber = new BigInteger(str, 16);
        str = pairs.value(BASE_CRL_NUMBER);
        if (StringUtil.isNotBlank((String)str)) {
            this.baseCrlNumber = new BigInteger(str, 16);
        }
        str = CrlInfo.getNotBlankValue(pairs, THIS_UPDATE);
        this.thisUpdate = DateUtil.parseUtcTimeyyyyMMddhhmmss((String)str);
        str = CrlInfo.getNotBlankValue(pairs, NEXT_UPDATE);
        this.nextUpdate = DateUtil.parseUtcTimeyyyyMMddhhmmss((String)str);
        str = CrlInfo.getNotBlankValue(pairs, CRL_ID);
        this.crlId = CrlID.getInstance((Object)Base64.decodeFast((String)str));
    }

    private static final String getNotBlankValue(ConfPairs pairs, String name) {
        String str = pairs.value(name);
        if (StringUtil.isBlank((String)str)) {
            throw new IllegalArgumentException(name + " is not specified");
        }
        return str;
    }

    public CrlInfo(BigInteger crlNumber, BigInteger baseCrlNumber, Date thisUpdate, Date nextUpdate, CrlID crlId) {
        this.crlNumber = (BigInteger)Args.notNull((Object)crlNumber, (String)"crlNumber");
        this.baseCrlNumber = baseCrlNumber;
        this.thisUpdate = (Date)Args.notNull((Object)thisUpdate, (String)"thisUpdate");
        this.nextUpdate = (Date)Args.notNull((Object)nextUpdate, (String)"nextUpdate");
        this.crlId = (CrlID)Args.notNull((Object)crlId, (String)"crlId");
    }

    public String getEncoded() throws IOException {
        ConfPairs pairs = new ConfPairs();
        pairs.putPair(CRL_NUMBER, this.crlNumber.toString(16));
        if (this.baseCrlNumber != null) {
            pairs.putPair(BASE_CRL_NUMBER, this.baseCrlNumber.toString(16));
        }
        pairs.putPair(THIS_UPDATE, DateUtil.toUtcTimeyyyyMMddhhmmss((Date)this.thisUpdate));
        pairs.putPair(NEXT_UPDATE, DateUtil.toUtcTimeyyyyMMddhhmmss((Date)this.nextUpdate));
        pairs.putPair(CRL_ID, Base64.encodeToString((byte[])this.crlId.getEncoded()));
        return pairs.getEncoded();
    }

    public BigInteger getCrlNumber() {
        return this.crlNumber;
    }

    public void setCrlNumber(BigInteger crlNumber) {
        this.crlNumber = (BigInteger)Args.notNull((Object)crlNumber, (String)"crlNumber");
    }

    public BigInteger getBaseCrlNumber() {
        return this.baseCrlNumber;
    }

    public void setBaseCrlNumber(BigInteger baseCrlNumber) {
        this.baseCrlNumber = baseCrlNumber;
    }

    public Date getThisUpdate() {
        return this.thisUpdate;
    }

    public void setThisUpdate(Date thisUpdate) {
        this.thisUpdate = (Date)Args.notNull((Object)thisUpdate, (String)"thisUpdate");
    }

    public Date getNextUpdate() {
        return this.nextUpdate;
    }

    public void setNextUpdate(Date nextUpdate) {
        this.nextUpdate = (Date)Args.notNull((Object)nextUpdate, (String)"nextUpdate");
    }

    public CrlID getCrlId() {
        return this.crlId;
    }

    public void setCrlId(CrlID crlId) {
        this.crlId = crlId;
    }
}

