/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.store.ejbca;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.ocsp.api.CertStatusInfo;
import org.xipki.ocsp.api.OcspStore;
import org.xipki.ocsp.api.OcspStoreException;
import org.xipki.ocsp.api.RequestIssuer;
import org.xipki.ocsp.server.IssuerFilter;
import org.xipki.ocsp.server.OcspServerConf;
import org.xipki.ocsp.server.store.ejbca.EjbcaIssuerEntry;
import org.xipki.ocsp.server.store.ejbca.EjbcaIssuerStore;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.CrlReason;
import org.xipki.security.HashAlgo;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.Hex;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;

public class EjbcaCertStatusStore
extends OcspStore {
    private static final Logger LOG = LoggerFactory.getLogger(EjbcaCertStatusStore.class);
    private final HashAlgo certHashAlgo = HashAlgo.SHA1;
    private final StoreUpdateService storeUpdateService = new StoreUpdateService();
    private final AtomicBoolean storeUpdateInProcess = new AtomicBoolean(false);
    private DataSourceWrapper datasource;
    private String sqlCs;
    private String sqlCsWithCertHash;
    private IssuerFilter issuerFilter;
    private EjbcaIssuerStore issuerStore;
    private boolean initialized;
    private boolean initializationFailed;
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;

    protected List<Runnable> getScheduledServices() {
        return Arrays.asList(this.storeUpdateService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateIssuerStore() {
        if (this.storeUpdateInProcess.get()) {
            return;
        }
        String sql = "SELECT data FROM CAData";
        this.storeUpdateInProcess.set(true);
        try {
            HashMap<String, EjbcaIssuerEntry> newIssuers;
            ResultSet rs;
            PreparedStatement ps;
            block15: {
                ps = this.preparedStatement("SELECT data FROM CAData");
                rs = null;
                try {
                    boolean issuersUnchanged;
                    newIssuers = new HashMap<String, EjbcaIssuerEntry>();
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        X509Certificate cert;
                        EjbcaIssuerEntry issuerEntry;
                        String sha1Fp;
                        String b64Cert;
                        String caData = rs.getString("data");
                        String str = EjbcaCertStatusStore.extractTextFromCaData(caData, "catype", "int");
                        if (!"1".contentEquals(str) || (b64Cert = EjbcaCertStatusStore.extractTextFromCaData(caData, "certificatechain", "string")) == null || !this.issuerFilter.includeIssuerWithSha1Fp(sha1Fp = (issuerEntry = new EjbcaIssuerEntry(cert = X509Util.parseCert((byte[])StringUtil.toUtf8Bytes((String)b64Cert.trim())))).getId())) continue;
                        RequestIssuer reqIssuer = new RequestIssuer(HashAlgo.SHA1, issuerEntry.getEncodedHash(HashAlgo.SHA1));
                        for (EjbcaIssuerEntry m : newIssuers.values()) {
                            if (!m.matchHash(reqIssuer)) continue;
                            throw new Exception("found at least two issuers with the same subject and key");
                        }
                        str = EjbcaCertStatusStore.extractTextFromCaData(caData, "revokationreason", "int");
                        if (str != null && !"-1".contentEquals(str)) {
                            str = EjbcaCertStatusStore.extractTextFromCaData(caData, "revokationdate", "long");
                            Date revTime = str == null || "-1".contentEquals(str) ? new Date() : new Date(Long.parseLong(str));
                            issuerEntry.setRevocationInfo(revTime);
                        }
                        newIssuers.put(sha1Fp, issuerEntry);
                    }
                    Set newIds = newIssuers.keySet();
                    Set ids = this.issuerStore != null ? this.issuerStore.getIds() : Collections.emptySet();
                    boolean bl = issuersUnchanged = ids.size() == newIds.size() && ids.containsAll(newIds) && newIds.containsAll(ids);
                    if (issuersUnchanged) {
                        for (String id : newIds) {
                            EjbcaIssuerEntry entry = this.issuerStore.getIssuerForId(id);
                            EjbcaIssuerEntry newEntry = (EjbcaIssuerEntry)newIssuers.get(id);
                            if (newEntry.equals(entry)) continue;
                            issuersUnchanged = false;
                            break;
                        }
                    }
                    if (!issuersUnchanged) break block15;
                    this.releaseDbResources(ps, rs);
                    return;
                }
                catch (Throwable throwable) {
                    this.releaseDbResources(ps, rs);
                    throw throwable;
                }
            }
            this.initialized = false;
            this.issuerStore = new EjbcaIssuerStore(newIssuers.values());
            LOG.info("Updated issuers: {}", (Object)this.name);
            this.initializationFailed = false;
            this.initialized = true;
            this.releaseDbResources(ps, rs);
        }
        catch (Throwable th) {
            LogUtil.error((Logger)LOG, (Throwable)th, (String)"error while executing updateIssuerStore()");
            this.initializationFailed = true;
            this.initialized = true;
        }
        finally {
            this.storeUpdateInProcess.set(false);
        }
    }

    protected CertStatusInfo getCertStatus0(Date time, RequestIssuer reqIssuer, BigInteger serialNumber, boolean includeCertHash, boolean includeRit, boolean inheritCaRevocation) throws OcspStoreException {
        if (includeRit) {
            throw new OcspStoreException("EJBCA store does not support includeRit");
        }
        if (serialNumber.signum() != 1) {
            return CertStatusInfo.getUnknownCertStatusInfo((Date)new Date(), null);
        }
        if (!this.initialized) {
            throw new OcspStoreException("initialization of CertStore is still in process");
        }
        if (this.initializationFailed) {
            throw new OcspStoreException("initialization of CertStore failed");
        }
        try {
            EjbcaIssuerEntry issuer = this.issuerStore.getIssuerForFp(reqIssuer);
            if (issuer == null) {
                return null;
            }
            String sql = includeCertHash ? this.sqlCsWithCertHash : this.sqlCs;
            Date thisUpdate = new Date();
            Date nextUpdate = null;
            ResultSet rs = null;
            CertStatusInfo certStatusInfo = null;
            boolean unknown = true;
            boolean ignore = false;
            String hexCertHash = null;
            boolean revoked = false;
            int reason = 0;
            long revTime = 0L;
            PreparedStatement ps = this.datasource.prepareStatement(sql);
            try {
                ps.setString(1, issuer.getId());
                ps.setString(2, serialNumber.toString());
                rs = ps.executeQuery();
                if (rs.next()) {
                    long notAfterInSec;
                    long notBefore;
                    unknown = false;
                    long timeInMs = time.getTime();
                    if (!ignore && this.ignoreNotYetValidCert && timeInMs < (notBefore = rs.getLong("notBefore"))) {
                        ignore = true;
                    }
                    if (!ignore && this.ignoreExpiredCert && timeInMs > (notAfterInSec = rs.getLong("expireDate"))) {
                        ignore = true;
                    }
                    if (!ignore) {
                        int status;
                        if (includeCertHash) {
                            hexCertHash = rs.getString("fingerprint");
                        }
                        boolean bl = revoked = (status = rs.getInt("status")) == 40;
                        if (revoked) {
                            reason = rs.getInt("revocationReason");
                            revTime = rs.getLong("revocationDate") / 1000L;
                        }
                    }
                }
                this.releaseDbResources(ps, rs);
            }
            catch (SQLException ex) {
                try {
                    throw this.datasource.translate(sql, ex);
                }
                catch (Throwable throwable) {
                    this.releaseDbResources(ps, rs);
                    throw throwable;
                }
            }
            if (unknown) {
                certStatusInfo = CertStatusInfo.getUnknownCertStatusInfo((Date)thisUpdate, nextUpdate);
            } else if (ignore) {
                certStatusInfo = CertStatusInfo.getIgnoreCertStatusInfo((Date)thisUpdate, nextUpdate);
            } else {
                byte[] certHash;
                byte[] byArray = certHash = hexCertHash == null ? null : Hex.decode(hexCertHash);
                if (revoked) {
                    CertRevocationInfo revInfo = new CertRevocationInfo(reason, new Date(revTime * 1000L), null);
                    certStatusInfo = CertStatusInfo.getRevokedCertStatusInfo((CertRevocationInfo)revInfo, (HashAlgo)this.certHashAlgo, (byte[])certHash, (Date)thisUpdate, nextUpdate, null);
                } else {
                    certStatusInfo = CertStatusInfo.getGoodCertStatusInfo((HashAlgo)this.certHashAlgo, (byte[])certHash, (Date)thisUpdate, nextUpdate, null);
                }
            }
            if (this.includeArchiveCutoff && this.retentionInterval != 0) {
                Date date;
                if (this.retentionInterval < 0) {
                    date = issuer.getNotBefore();
                } else {
                    long nowInMs = System.currentTimeMillis();
                    long dateInMs = Math.max(issuer.getNotBefore().getTime(), nowInMs - 86400000L * (long)this.retentionInterval);
                    date = new Date(dateInMs);
                }
                certStatusInfo.setArchiveCutOff(date);
            }
            if (!inheritCaRevocation || issuer.getRevocationInfo() == null) {
                return certStatusInfo;
            }
            CertRevocationInfo caRevInfo = issuer.getRevocationInfo();
            CertStatusInfo.CertStatus certStatus = certStatusInfo.getCertStatus();
            boolean replaced = false;
            if (certStatus == CertStatusInfo.CertStatus.GOOD) {
                replaced = true;
            } else if (certStatus == CertStatusInfo.CertStatus.UNKNOWN || certStatus == CertStatusInfo.CertStatus.IGNORE) {
                if (this.unknownCertBehaviour == CertStatusInfo.UnknownCertBehaviour.good) {
                    replaced = true;
                }
            } else if (certStatus == CertStatusInfo.CertStatus.REVOKED && certStatusInfo.getRevocationInfo().getRevocationTime().after(caRevInfo.getRevocationTime())) {
                replaced = true;
            }
            if (replaced) {
                CertRevocationInfo newRevInfo = caRevInfo.getReason() == CrlReason.CA_COMPROMISE ? caRevInfo : new CertRevocationInfo(CrlReason.CA_COMPROMISE, caRevInfo.getRevocationTime(), caRevInfo.getInvalidityTime());
                certStatusInfo = CertStatusInfo.getRevokedCertStatusInfo((CertRevocationInfo)newRevInfo, (HashAlgo)certStatusInfo.getCertHashAlgo(), (byte[])certStatusInfo.getCertHash(), (Date)certStatusInfo.getThisUpdate(), (Date)certStatusInfo.getNextUpdate(), (String)certStatusInfo.getCertprofile());
            }
            return certStatusInfo;
        }
        catch (DataAccessException ex) {
            throw new OcspStoreException(ex.getMessage(), (Throwable)ex);
        }
    }

    private PreparedStatement preparedStatement(String sqlQuery) throws DataAccessException {
        return this.datasource.prepareStatement(sqlQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHealthy() {
        if (!this.isInitialized()) {
            return false;
        }
        if (this.isInitializationFailed()) {
            return false;
        }
        String sql = "SELECT cAId FROM CAData";
        PreparedStatement ps = this.preparedStatement("SELECT cAId FROM CAData");
        ResultSet rs = null;
        try {
            rs = ps.executeQuery();
            boolean bl = true;
            this.releaseDbResources(ps, rs);
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.releaseDbResources(ps, rs);
                throw throwable;
            }
            catch (Exception ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex);
                return false;
            }
        }
    }

    private void releaseDbResources(Statement ps, ResultSet rs) {
        this.datasource.releaseResources(ps, rs);
    }

    public void init(Map<String, ? extends Object> sourceConf, DataSourceWrapper datasource) throws OcspStoreException {
        Object objValue;
        if (this.includeCrlId) {
            throw new OcspStoreException("includeCrlId must not be true");
        }
        OcspServerConf.CaCerts caCerts = null;
        if (sourceConf != null && (objValue = sourceConf.get("caCerts")) != null) {
            caCerts = (OcspServerConf.CaCerts)((Object)JSON.parseObject((byte[])JSON.toJSONBytes((Object)objValue, (SerializerFeature[])new SerializerFeature[0]), OcspServerConf.CaCerts.class, (Feature[])new Feature[0]));
        }
        this.datasource = (DataSourceWrapper)Args.notNull((Object)datasource, (String)"datasource");
        String coreSql = "notBefore,expireDate,status,revocationReason,revocationDate FROM CertificateData WHERE cAFingerprint=? AND serialNumber=?";
        this.sqlCs = datasource.buildSelectFirstSql(1, coreSql);
        this.sqlCsWithCertHash = datasource.buildSelectFirstSql(1, "fingerprint," + coreSql);
        try {
            Set<X509Certificate> includeIssuers = null;
            Set<X509Certificate> excludeIssuers = null;
            if (caCerts != null) {
                if (CollectionUtil.isNotEmpty(caCerts.getIncludes())) {
                    includeIssuers = EjbcaCertStatusStore.parseCerts(caCerts.getIncludes());
                }
                if (CollectionUtil.isNotEmpty(caCerts.getExcludes())) {
                    excludeIssuers = EjbcaCertStatusStore.parseCerts(caCerts.getExcludes());
                }
            }
            this.issuerFilter = new IssuerFilter(includeIssuers, excludeIssuers);
        }
        catch (CertificateException ex) {
            throw new OcspStoreException(ex.getMessage(), (Throwable)ex);
        }
        this.updateIssuerStore();
        if (this.scheduledThreadPoolExecutor != null) {
            this.scheduledThreadPoolExecutor.shutdownNow();
        }
        if (this.updateInterval != null) {
            int size;
            List<Runnable> scheduledServices = this.getScheduledServices();
            int n = size = scheduledServices == null ? 0 : scheduledServices.size();
            if (size > 0) {
                this.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(size);
                Random random = new Random();
                long intervalSeconds = this.updateInterval.approxMinutes() * 60L;
                for (Runnable service : scheduledServices) {
                    this.scheduledThreadPoolExecutor.scheduleAtFixedRate(service, intervalSeconds + (long)random.nextInt(60), intervalSeconds, TimeUnit.SECONDS);
                }
            }
        }
    }

    public void close() {
        if (this.scheduledThreadPoolExecutor != null) {
            this.scheduledThreadPoolExecutor.shutdown();
            this.scheduledThreadPoolExecutor = null;
        }
        if (this.datasource != null) {
            this.datasource.close();
        }
    }

    public boolean knowsIssuer(RequestIssuer reqIssuer) {
        return null != this.issuerStore.getIssuerForFp(reqIssuer);
    }

    public X509Certificate getIssuerCert(RequestIssuer reqIssuer) {
        EjbcaIssuerEntry issuer = this.issuerStore.getIssuerForFp(reqIssuer);
        return issuer == null ? null : issuer.getCert();
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected boolean isInitializationFailed() {
        return this.initializationFailed;
    }

    private static Set<X509Certificate> parseCerts(Collection<String> certFiles) throws OcspStoreException {
        HashSet<X509Certificate> certs = new HashSet<X509Certificate>(certFiles.size());
        for (String certFile : certFiles) {
            try {
                certs.add(X509Util.parseCert((File)new File(certFile)));
            }
            catch (IOException | CertificateException ex) {
                throw new OcspStoreException("could not parse X.509 certificate from file " + certFile + ": " + ex.getMessage(), (Throwable)ex);
            }
        }
        return certs;
    }

    private static String extractTextFromCaData(String caData, String key, String valueType) {
        String keyTag = "<string>" + key + "</string>";
        int index = caData.indexOf(keyTag);
        if (index == -1) {
            return null;
        }
        String valueStartTag = "<" + valueType + ">";
        String valueEndTag = "</" + valueType + ">";
        if ((index = caData.indexOf(valueStartTag, index + keyTag.length())) == -1) {
            return null;
        }
        int startIndex = index + valueStartTag.length();
        if ((index = caData.indexOf(valueEndTag, startIndex)) == -1) {
            return null;
        }
        return caData.substring(startIndex, index);
    }

    private class StoreUpdateService
    implements Runnable {
        private StoreUpdateService() {
        }

        @Override
        public void run() {
            EjbcaCertStatusStore.this.updateIssuerStore();
        }
    }
}

