/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server;

import java.security.cert.CertificateEncodingException;
import java.util.HashSet;
import java.util.Set;
import org.xipki.security.HashAlgo;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;

public class IssuerFilter {
    private final Set<String> includeSha1Fps;
    private final Set<String> excludeSha1Fps;

    public IssuerFilter(Set<X509Cert> includes, Set<X509Cert> excludes) throws CertificateEncodingException {
        if (CollectionUtil.isEmpty(includes)) {
            this.includeSha1Fps = null;
        } else {
            this.includeSha1Fps = new HashSet<String>(includes.size());
            for (X509Cert include : includes) {
                this.includeSha1Fps.add(HashAlgo.SHA1.base64Hash((byte[][])new byte[][]{include.getEncoded()}));
            }
        }
        if (CollectionUtil.isEmpty(excludes)) {
            this.excludeSha1Fps = null;
        } else {
            this.excludeSha1Fps = new HashSet<String>(excludes.size());
            for (X509Cert exclude : excludes) {
                this.excludeSha1Fps.add(HashAlgo.SHA1.base64Hash((byte[][])new byte[][]{exclude.getEncoded()}));
            }
        }
    }

    public boolean includeAll() {
        return this.includeSha1Fps == null && this.excludeSha1Fps == null;
    }

    public boolean includeIssuerWithSha1Fp(String sha1Fp) {
        Args.notBlank((String)sha1Fp, (String)"sha1Fp");
        if (this.includeSha1Fps == null || this.includeSha1Fps.contains(sha1Fp)) {
            return this.excludeSha1Fps == null ? true : !this.excludeSha1Fps.contains(sha1Fp);
        }
        return false;
    }
}

