/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.store;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.cert.CertificateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.ocsp.CrlID;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.ocsp.server.store.CrlInfo;
import org.xipki.ocsp.server.store.DbCertStatusStore;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.CrlReason;
import org.xipki.security.HashAlgo;
import org.xipki.security.X509Cert;
import org.xipki.security.asn1.CrlStreamParser;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.DateUtil;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;

class ImportCrl {
    private static final Logger LOG = LoggerFactory.getLogger(ImportCrl.class);
    private static final String KEY_CA_REVOCATION_TIME = "ca.revocation.time";
    private static final String KEY_CA_INVALIDITY_TIME = "ca.invalidity.time";
    private static final String SQL_UPDATE_CRL_INFO = "UPDATE CRL_INFO SET INFO=? WHERE ID=?";
    private static final String SQL_INSERT_CRL_INFO = "INSERT INTO CRL_INFO (ID,NAME,INFO) VALUES(?,?,?)";
    private static final String SQL_UPDATE_CERT_REV = "UPDATE CERT SET REV=?,RR=?,RT=?,RIT=?,LUPDATE=?,CRL_ID=? WHERE ID=?";
    private static final String SQL_INSERT_CERT_REV = "INSERT INTO CERT (ID,IID,SN,REV,RR,RT,RIT,LUPDATE,CRL_ID) VALUES(?,?,?,?,?,?,?,?,?)";
    private static final String SQL_DELETE_CERT = "DELETE FROM CERT WHERE IID=? AND SN=?";
    private static final String SQL_UPDATE_CERT_LUPDATE = "UPDATE CERT SET LUPDATE=? WHERE ID=?";
    private static final String SQL_UPDATE_CERT = "UPDATE CERT SET LUPDATE=?,NBEFORE=?,NAFTER=?,CRL_ID=?,HASH=? WHERE ID=?";
    private static final String SQL_INSERT_CERT = "INSERT INTO CERT (ID,IID,SN,REV,RR,RT,RIT,LUPDATE,NBEFORE,NAFTER,CRL_ID,HASH) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String CORE_SQL_SELECT_ID_CERT = "ID,REV,RR,RT,RIT,CRL_ID FROM CERT WHERE IID=? AND SN=?";
    private final String basedir;
    private final String sqlSelectIdCert;
    private final DataSourceWrapper datasource;
    private final HashAlgo certhashAlgo;
    private final int sqlBatchCommit;
    private final boolean ignoreExpiredCrls;
    private PreparedStatement psDeleteCert;
    private PreparedStatement psInsertCert;
    private PreparedStatement psInsertCertRev;
    private PreparedStatement psSelectIdCert;
    private PreparedStatement psUpdateCert;
    private PreparedStatement psUpdateCertRev;
    private PreparedStatement psUpdateCertLastupdate;
    private final AtomicInteger cachedIssuerId = new AtomicInteger(0);

    public ImportCrl(DataSourceWrapper datasource, String basedir, int sqlBatchCommit, boolean ignoreExpiredCrls) throws DataAccessException {
        this.sqlBatchCommit = Args.min((int)sqlBatchCommit, (String)"sqlBatchCommit", (int)1);
        this.ignoreExpiredCrls = ignoreExpiredCrls;
        this.datasource = (DataSourceWrapper)Args.notNull((Object)datasource, (String)"datasource");
        this.basedir = (String)Args.notNull((Object)basedir, (String)"basedir");
        this.certhashAlgo = DbCertStatusStore.getCertHashAlgo(datasource);
        LOG.info("UPDATE_CERTSTORE");
        this.sqlSelectIdCert = datasource.buildSelectFirstSql(1, CORE_SQL_SELECT_ID_CERT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean importCrlToOcspDb() {
        File[] crlDirs = new File(this.basedir).listFiles();
        HashSet<CrlDirInfo> crlDirInfos = new HashSet<CrlDirInfo>();
        for (File crlDir : crlDirs) {
            String base64Sha1Fp;
            String string = ImportCrl.getCrlNameFromDir(crlDir);
            if (StringUtil.isBlank((String)string)) continue;
            int crlId = ImportCrl.getCrlIdFromName(string);
            if (crlId == 0) {
                LOG.error("Please rename the directory {}", (Object)crlDir.getPath());
                return false;
            }
            CrlDirInfo parsedInfo = null;
            for (CrlDirInfo m : crlDirInfos) {
                if (m.crlId != crlId) continue;
                parsedInfo = m;
            }
            if (parsedInfo != null) {
                LOG.error("Please rename one of the directories {} or {}", (Object)crlDir.getPath(), (Object)parsedInfo.crlDir.getPath());
                return false;
            }
            File updatemeFile = new File(crlDir, "UPDATEME");
            if (!updatemeFile.exists()) continue;
            File caCertFile = new File(crlDir, "ca.crt");
            if (!caCertFile.exists()) {
                LOG.error("CA certificate file {} does not exist", (Object)caCertFile.getPath());
                return false;
            }
            CertRevocationInfo caRevInfo = null;
            File revFile = new File(crlDir, "REVOCATION");
            if (revFile.exists()) {
                Properties props = new Properties();
                try (InputStream is = Files.newInputStream(revFile.toPath(), new OpenOption[0]);){
                    props.load(is);
                }
                catch (IOException ex) {
                    LOG.error("error reading " + revFile.getPath(), (Throwable)ex);
                    return false;
                }
                String str = props.getProperty(KEY_CA_REVOCATION_TIME);
                if (StringUtil.isNotBlank((String)str)) {
                    Date revocationTime = DateUtil.parseUtcTimeyyyyMMddhhmmss((String)str);
                    Date invalidityTime = null;
                    str = props.getProperty(KEY_CA_INVALIDITY_TIME);
                    if (StringUtil.isNotBlank((String)str)) {
                        invalidityTime = DateUtil.parseUtcTimeyyyyMMddhhmmss((String)str);
                    }
                    caRevInfo = new CertRevocationInfo(CrlReason.UNSPECIFIED, revocationTime, invalidityTime);
                }
            }
            try {
                byte[] derCertBytes = X509Util.toDerEncoded((byte[])IoUtil.read((File)caCertFile));
                base64Sha1Fp = HashAlgo.SHA1.base64Hash((byte[][])new byte[][]{derCertBytes});
            }
            catch (IOException ex) {
                LOG.error("error reading " + caCertFile.getPath(), (Throwable)ex);
                return false;
            }
            boolean updateMe = new File(crlDir, "UPDATEME").exists();
            boolean deleteMe = new File(crlDir, "DELETEME").exists();
            CrlDirInfo crlDirInfo = new CrlDirInfo(crlId, string, crlDir, updateMe, deleteMe);
            crlDirInfo.base64Sha1Fp = base64Sha1Fp;
            crlDirInfo.revocationinfo = caRevInfo;
            crlDirInfos.add(crlDirInfo);
        }
        for (CrlDirInfo m : crlDirInfos) {
            File crlFile;
            File crlDir = m.crlDir;
            if (m.deleteMe || m.revocationinfo != null) {
                for (CrlDirInfo crlDirInfo : crlDirInfos) {
                    if (m == crlDirInfo || !m.base64Sha1Fp.equals(crlDirInfo.base64Sha1Fp)) continue;
                    LOG.error("{} and {} specify duplicatedly a revoked CA certificate.", (Object)crlDir.getPath(), (Object)crlDirInfo.crlDir.getPath());
                    return false;
                }
            } else if (!(!m.updateMe || (crlFile = new File(crlDir, "ca.crl")).exists() && crlFile.isFile())) {
                LOG.error("{} has UPDATEME but no ca.crl", (Object)crlDir.getPath());
                return false;
            }
            boolean shareCaWithOtherCrl = false;
            for (CrlDirInfo n3 : crlDirInfos) {
                if (m == n3 || !m.base64Sha1Fp.equals(n3.base64Sha1Fp)) continue;
                shareCaWithOtherCrl = true;
                break;
            }
            m.shareCaWithOtherCrl = shareCaWithOtherCrl;
        }
        Connection conn = null;
        boolean autoCommitChanged = false;
        try {
            conn = this.datasource.getConnection();
            boolean origAutocommit = conn.getAutoCommit();
            if (origAutocommit) {
                conn.setAutoCommit(false);
                autoCommitChanged = true;
            }
            this.psDeleteCert = this.datasource.prepareStatement(conn, SQL_DELETE_CERT);
            this.psInsertCert = this.datasource.prepareStatement(conn, SQL_INSERT_CERT);
            this.psInsertCertRev = this.datasource.prepareStatement(conn, SQL_INSERT_CERT_REV);
            this.psSelectIdCert = this.datasource.prepareStatement(conn, this.sqlSelectIdCert);
            this.psUpdateCert = this.datasource.prepareStatement(conn, SQL_UPDATE_CERT);
            this.psUpdateCertRev = this.datasource.prepareStatement(conn, SQL_UPDATE_CERT_REV);
            this.psUpdateCertLastupdate = this.datasource.prepareStatement(conn, SQL_UPDATE_CERT_LUPDATE);
            for (CrlDirInfo crlDirInfo : crlDirInfos) {
                if (!crlDirInfo.updateMe) continue;
                this.importCrl(conn, crlDirInfo);
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable th) {
            LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not import CRL to OCSP database");
        }
        finally {
            try {
                this.commit(conn);
            }
            catch (Throwable throwable) {
                LOG.error("could not import CRL to OCSP database (Connection.commit)");
            }
            if (autoCommitChanged) {
                try {
                    conn.setAutoCommit(true);
                }
                catch (SQLException sQLException) {
                    LOG.error("could not import CRL to OCSP database (Connection.setAutoCommit)");
                }
            }
            this.releaseResources(this.psDeleteCert, null);
            this.releaseResources(this.psInsertCert, null);
            this.releaseResources(this.psInsertCertRev, null);
            this.releaseResources(this.psSelectIdCert, null);
            this.releaseResources(this.psUpdateCert, null);
            this.releaseResources(this.psUpdateCertRev, null);
            this.releaseResources(this.psUpdateCertLastupdate, null);
            if (conn != null) {
                this.datasource.returnConnection(conn);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void importCrl(Connection conn, CrlDirInfo crlDirInfo) {
        block98: {
            block97: {
                block95: {
                    block96: {
                        block94: {
                            block93: {
                                block92: {
                                    block91: {
                                        block99: {
                                            block90: {
                                                block89: {
                                                    IoUtil.deleteFile((File)new File(CrlDirInfo.access$100(crlDirInfo), "UPDATEME.SUCC"));
                                                    IoUtil.deleteFile((File)new File(CrlDirInfo.access$100(crlDirInfo), "UPDATEME.FAIL"));
                                                    startTimeSec = System.currentTimeMillis() / 1000L;
                                                    id = CrlDirInfo.access$000(crlDirInfo);
                                                    crlName = CrlDirInfo.access$700(crlDirInfo);
                                                    crlDir = CrlDirInfo.access$100(crlDirInfo);
                                                    updateSucc = false;
                                                    caCert = null;
                                                    ImportCrl.LOG.info("Importing CRL (id={}, name={}) in the folder {}", new Object[]{id, crlName, crlDir.getPath()});
                                                    caCertFile = new File(CrlDirInfo.access$100(crlDirInfo), "ca.crt");
                                                    try {
                                                        cert = X509Util.parseCert((File)caCertFile);
                                                        caCert = new CertWrapper(cert);
                                                    }
                                                    catch (CertificateException ex) {
                                                        ImportCrl.LOG.error("could not parse CA certificate " + caCertFile.getPath(), (Throwable)ex);
                                                        try {
                                                            this.commit(conn);
                                                        }
                                                        catch (Throwable th) {
                                                            ImportCrl.LOG.error(String.format("Importing CRL (id=%s) in the folder %s FAILED (Connect.commit)", new Object[]{id, crlDir.getPath()}), th);
                                                        }
                                                        updatemeFile = new File(CrlDirInfo.access$100(crlDirInfo), "UPDATEME");
                                                        updatemeFile.setLastModified(System.currentTimeMillis());
                                                        updatemeFile.renameTo(new File(updatemeFile.getPath() + (updateSucc != false ? ".SUCC" : ".FAIL")));
                                                        if (!updateSucc && caCert != null && !CrlDirInfo.access$600(crlDirInfo) && CertWrapper.access$1100(caCert) != null) {
                                                            try {
                                                                this.datasource.deleteFromTableWithException(conn, "ISSUER", "ID", (long)CertWrapper.access$1100(caCert).intValue());
                                                            }
                                                            catch (Throwable th) {
                                                                ImportCrl.LOG.warn("error deleting from table ISSUER for ID {}", (Object)CertWrapper.access$1100(caCert));
                                                            }
                                                        }
                                                        return;
                                                    }
                                                    crl = null;
                                                    crlInfo = null;
                                                    if (!(CrlDirInfo.access$400(crlDirInfo) == false & CrlDirInfo.access$300(crlDirInfo) == null)) ** GOTO lbl262
                                                    crl = new CrlStreamParser(new File(crlDir, "ca.crl"));
                                                    now = new Date();
                                                    if (crl.getNextUpdate() == null || !crl.getNextUpdate().before(now)) break block89;
                                                    if (!this.ignoreExpiredCrls) break block90;
                                                    ImportCrl.LOG.error("CRL is expired, ignore it");
                                                    try {
                                                        this.commit(conn);
                                                    }
                                                    catch (Throwable th) {
                                                        ImportCrl.LOG.error(String.format("Importing CRL (id=%s) in the folder %s FAILED (Connect.commit)", new Object[]{id, crlDir.getPath()}), th);
                                                    }
                                                    updatemeFile = new File(CrlDirInfo.access$100(crlDirInfo), "UPDATEME");
                                                    updatemeFile.setLastModified(System.currentTimeMillis());
                                                    updatemeFile.renameTo(new File(updatemeFile.getPath() + (updateSucc != false ? ".SUCC" : ".FAIL")));
                                                    if (!updateSucc && caCert != null && !CrlDirInfo.access$600(crlDirInfo) && CertWrapper.access$1100(caCert) != null) {
                                                        try {
                                                            this.datasource.deleteFromTableWithException(conn, "ISSUER", "ID", (long)CertWrapper.access$1100(caCert).intValue());
                                                        }
                                                        catch (Throwable th) {
                                                            ImportCrl.LOG.warn("error deleting from table ISSUER for ID {}", (Object)CertWrapper.access$1100(caCert));
                                                        }
                                                    }
                                                    return;
                                                }
                                                if (!crl.getThisUpdate().after(now)) break block90;
                                                ImportCrl.LOG.error("CRL is not valid yet, ignore it");
                                                try {
                                                    this.commit(conn);
                                                }
                                                catch (Throwable th) {
                                                    ImportCrl.LOG.error(String.format("Importing CRL (id=%s) in the folder %s FAILED (Connect.commit)", new Object[]{id, crlDir.getPath()}), th);
                                                }
                                                updatemeFile = new File(CrlDirInfo.access$100(crlDirInfo), "UPDATEME");
                                                updatemeFile.setLastModified(System.currentTimeMillis());
                                                updatemeFile.renameTo(new File(updatemeFile.getPath() + (updateSucc != false ? ".SUCC" : ".FAIL")));
                                                if (!updateSucc && caCert != null && !CrlDirInfo.access$600(crlDirInfo) && CertWrapper.access$1100(caCert) != null) {
                                                    try {
                                                        this.datasource.deleteFromTableWithException(conn, "ISSUER", "ID", (long)CertWrapper.access$1100(caCert).intValue());
                                                    }
                                                    catch (Throwable th) {
                                                        ImportCrl.LOG.warn("error deleting from table ISSUER for ID {}", (Object)CertWrapper.access$1100(caCert));
                                                    }
                                                }
                                                return;
                                            }
                                            issuer = crl.getIssuer();
                                            if (!CertWrapper.access$800(caCert).equals((Object)issuer)) break block99;
                                            crlSignerCert = CertWrapper.access$900(caCert);
                                            ** GOTO lbl138
                                        }
                                        crlIssuerCert = null;
                                        issuerCertFile = new File(crlDir, "issuer.crt");
                                        if (issuerCertFile.exists()) {
                                            crlIssuerCert = ImportCrl.parseCert(issuerCertFile);
                                        }
                                        if (crlIssuerCert != null) break block91;
                                        ImportCrl.LOG.error("issuerCert may not be null");
                                        try {
                                            this.commit(conn);
                                        }
                                        catch (Throwable th) {
                                            ImportCrl.LOG.error(String.format("Importing CRL (id=%s) in the folder %s FAILED (Connect.commit)", new Object[]{id, crlDir.getPath()}), th);
                                        }
                                        updatemeFile = new File(CrlDirInfo.access$100(crlDirInfo), "UPDATEME");
                                        updatemeFile.setLastModified(System.currentTimeMillis());
                                        updatemeFile.renameTo(new File(updatemeFile.getPath() + (updateSucc != false ? ".SUCC" : ".FAIL")));
                                        if (!updateSucc && caCert != null && !CrlDirInfo.access$600(crlDirInfo) && CertWrapper.access$1100(caCert) != null) {
                                            try {
                                                this.datasource.deleteFromTableWithException(conn, "ISSUER", "ID", (long)CertWrapper.access$1100(caCert).intValue());
                                            }
                                            catch (Throwable th) {
                                                ImportCrl.LOG.warn("error deleting from table ISSUER for ID {}", (Object)CertWrapper.access$1100(caCert));
                                            }
                                        }
                                        return;
                                    }
                                    if (crlIssuerCert.getSubject().equals((Object)issuer)) break block92;
                                    ImportCrl.LOG.error("issuerCert and CRL do not match");
                                    try {
                                        this.commit(conn);
                                    }
                                    catch (Throwable th) {
                                        ImportCrl.LOG.error(String.format("Importing CRL (id=%s) in the folder %s FAILED (Connect.commit)", new Object[]{id, crlDir.getPath()}), th);
                                    }
                                    updatemeFile = new File(CrlDirInfo.access$100(crlDirInfo), "UPDATEME");
                                    updatemeFile.setLastModified(System.currentTimeMillis());
                                    updatemeFile.renameTo(new File(updatemeFile.getPath() + (updateSucc != false ? ".SUCC" : ".FAIL")));
                                    if (!updateSucc && caCert != null && !CrlDirInfo.access$600(crlDirInfo) && CertWrapper.access$1100(caCert) != null) {
                                        try {
                                            this.datasource.deleteFromTableWithException(conn, "ISSUER", "ID", (long)CertWrapper.access$1100(caCert).intValue());
                                        }
                                        catch (Throwable th) {
                                            ImportCrl.LOG.warn("error deleting from table ISSUER for ID {}", (Object)CertWrapper.access$1100(caCert));
                                        }
                                    }
                                    return;
                                }
                                crlSignerCert = crlIssuerCert;
lbl138:
                                // 2 sources

                                if (crl.getCrlNumber() != null) break block93;
                                ImportCrl.LOG.error("crlNumber is not specified, ignore the CRL");
                                try {
                                    this.commit(conn);
                                }
                                catch (Throwable th) {
                                    ImportCrl.LOG.error(String.format("Importing CRL (id=%s) in the folder %s FAILED (Connect.commit)", new Object[]{id, crlDir.getPath()}), th);
                                }
                                updatemeFile = new File(CrlDirInfo.access$100(crlDirInfo), "UPDATEME");
                                updatemeFile.setLastModified(System.currentTimeMillis());
                                updatemeFile.renameTo(new File(updatemeFile.getPath() + (updateSucc != false ? ".SUCC" : ".FAIL")));
                                if (!updateSucc && caCert != null && !CrlDirInfo.access$600(crlDirInfo) && CertWrapper.access$1100(caCert) != null) {
                                    try {
                                        this.datasource.deleteFromTableWithException(conn, "ISSUER", "ID", (long)CertWrapper.access$1100(caCert).intValue());
                                    }
                                    catch (Throwable th) {
                                        ImportCrl.LOG.warn("error deleting from table ISSUER for ID {}", (Object)CertWrapper.access$1100(caCert));
                                    }
                                }
                                return;
                            }
                            ImportCrl.LOG.info("The CRL is a {}", (Object)(crl.isDeltaCrl() != false ? "DeltaCRL" : "FullCRL"));
                            vec = new ASN1EncodableVector();
                            urlFile = new File(this.basedir, "crl.url");
                            if (urlFile.exists() && StringUtil.isNotBlank((String)(crlUrl = StringUtil.toUtf8String((byte[])IoUtil.read((File)urlFile)).trim()))) {
                                vec.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new DERIA5String(crlUrl, true)));
                            }
                            vec.add((ASN1Encodable)new DERTaggedObject(true, 1, (ASN1Encodable)new ASN1Integer(crl.getCrlNumber())));
                            vec.add((ASN1Encodable)new DERTaggedObject(true, 2, (ASN1Encodable)new ASN1GeneralizedTime(crl.getThisUpdate())));
                            crlId = CrlID.getInstance((Object)new DERSequence(vec));
                            crlNumber = crl.getCrlNumber();
                            baseCrlNumber = crl.getBaseCrlNumber();
                            str = (String)this.datasource.getFirstValue(conn, "CRL_INFO", "INFO", "ID='" + id + "'", String.class);
                            v0 = addNew = str == null;
                            if (!addNew) break block94;
                            if (!crl.isDeltaCrl()) break block95;
                            ImportCrl.LOG.error("Given CRL is a DeltaCRL for the full CRL with number {}, please import this full CRL first.", (Object)baseCrlNumber);
                            try {
                                this.commit(conn);
                            }
                            catch (Throwable th) {
                                ImportCrl.LOG.error(String.format("Importing CRL (id=%s) in the folder %s FAILED (Connect.commit)", new Object[]{id, crlDir.getPath()}), th);
                            }
                            updatemeFile = new File(CrlDirInfo.access$100(crlDirInfo), "UPDATEME");
                            updatemeFile.setLastModified(System.currentTimeMillis());
                            updatemeFile.renameTo(new File(updatemeFile.getPath() + (updateSucc != false ? ".SUCC" : ".FAIL")));
                            if (!updateSucc && caCert != null && !CrlDirInfo.access$600(crlDirInfo) && CertWrapper.access$1100(caCert) != null) {
                                try {
                                    this.datasource.deleteFromTableWithException(conn, "ISSUER", "ID", (long)CertWrapper.access$1100(caCert).intValue());
                                }
                                catch (Throwable th) {
                                    ImportCrl.LOG.warn("error deleting from table ISSUER for ID {}", (Object)CertWrapper.access$1100(caCert));
                                }
                            }
                            return;
                        }
                        oldCrlInfo = new CrlInfo(str);
                        if (crlNumber.compareTo(oldCrlInfo.getCrlNumber()) >= 0) break block96;
                        ImportCrl.LOG.error("Given CRL is older than existing CRL, ignore it");
                        try {
                            this.commit(conn);
                        }
                        catch (Throwable th) {
                            ImportCrl.LOG.error(String.format("Importing CRL (id=%s) in the folder %s FAILED (Connect.commit)", new Object[]{id, crlDir.getPath()}), th);
                        }
                        updatemeFile = new File(CrlDirInfo.access$100(crlDirInfo), "UPDATEME");
                        updatemeFile.setLastModified(System.currentTimeMillis());
                        updatemeFile.renameTo(new File(updatemeFile.getPath() + (updateSucc != false ? ".SUCC" : ".FAIL")));
                        if (!updateSucc && caCert != null && !CrlDirInfo.access$600(crlDirInfo) && CertWrapper.access$1100(caCert) != null) {
                            try {
                                this.datasource.deleteFromTableWithException(conn, "ISSUER", "ID", (long)CertWrapper.access$1100(caCert).intValue());
                            }
                            catch (Throwable th) {
                                ImportCrl.LOG.warn("error deleting from table ISSUER for ID {}", (Object)CertWrapper.access$1100(caCert));
                            }
                        }
                        return;
                    }
                    if (!crl.isDeltaCrl()) break block95;
                    lastFullCrlNumber = oldCrlInfo.getBaseCrlNumber();
                    if (lastFullCrlNumber == null) {
                        lastFullCrlNumber = oldCrlInfo.getCrlNumber();
                    }
                    if (baseCrlNumber.equals(lastFullCrlNumber)) break block95;
                    ImportCrl.LOG.error("Given CRL is a deltaCRL for the full CRL with number {}, please import this full CRL first.", (Object)crlNumber);
                    try {
                        this.commit(conn);
                    }
                    catch (Throwable th) {
                        ImportCrl.LOG.error(String.format("Importing CRL (id=%s) in the folder %s FAILED (Connect.commit)", new Object[]{id, crlDir.getPath()}), th);
                    }
                    updatemeFile = new File(CrlDirInfo.access$100(crlDirInfo), "UPDATEME");
                    updatemeFile.setLastModified(System.currentTimeMillis());
                    updatemeFile.renameTo(new File(updatemeFile.getPath() + (updateSucc != false ? ".SUCC" : ".FAIL")));
                    if (!updateSucc && caCert != null && !CrlDirInfo.access$600(crlDirInfo) && CertWrapper.access$1100(caCert) != null) {
                        try {
                            this.datasource.deleteFromTableWithException(conn, "ISSUER", "ID", (long)CertWrapper.access$1100(caCert).intValue());
                        }
                        catch (Throwable th) {
                            ImportCrl.LOG.warn("error deleting from table ISSUER for ID {}", (Object)CertWrapper.access$1100(caCert));
                        }
                    }
                    return;
                }
                if (crl.verifySignature(crlSignerCert.getSubjectPublicKeyInfo())) break block97;
                ImportCrl.LOG.error("signature of CRL is invalid, ignore the CRL");
                try {
                    this.commit(conn);
                }
                catch (Throwable th) {
                    ImportCrl.LOG.error(String.format("Importing CRL (id=%s) in the folder %s FAILED (Connect.commit)", new Object[]{id, crlDir.getPath()}), th);
                }
                updatemeFile = new File(CrlDirInfo.access$100(crlDirInfo), "UPDATEME");
                updatemeFile.setLastModified(System.currentTimeMillis());
                updatemeFile.renameTo(new File(updatemeFile.getPath() + (updateSucc != false ? ".SUCC" : ".FAIL")));
                if (!updateSucc && caCert != null && !CrlDirInfo.access$600(crlDirInfo) && CertWrapper.access$1100(caCert) != null) {
                    try {
                        this.datasource.deleteFromTableWithException(conn, "ISSUER", "ID", (long)CertWrapper.access$1100(caCert).intValue());
                    }
                    catch (Throwable th) {
                        ImportCrl.LOG.warn("error deleting from table ISSUER for ID {}", (Object)CertWrapper.access$1100(caCert));
                    }
                }
                return;
            }
            crlInfo = new CrlInfo(crlNumber, baseCrlNumber, crl.getThisUpdate(), crl.getNextUpdate(), crlId);
lbl262:
            // 2 sources

            if (CrlDirInfo.access$400(crlDirInfo)) {
                this.deleteCa(conn, crlDirInfo, caCert);
            } else {
                this.importCa(conn, crlDirInfo, caCert);
            }
            this.commit(conn);
            if (crl == null) {
                ImportCrl.LOG.info("Ignored CRL (name={}) in the folder {}: CA is revoked", (Object)crlName, (Object)crlDir.getPath());
            } else {
                this.importCrlInfo(conn, id, crlName, crlInfo, CrlDirInfo.access$600(crlDirInfo), CertWrapper.access$1000(caCert));
                this.commit(conn);
                this.importCrlRevokedCertificates(conn, id, caCert, crl, crlDir, startTimeSec);
                this.commit(conn);
                if (!crl.isDeltaCrl()) {
                    this.deleteEntriesNotUpdatedSince(conn, id, startTimeSec);
                    this.commit(conn);
                }
            }
            updateSucc = true;
            ImportCrl.LOG.info("Imported CRL (id={}) in the folder {}", (Object)id, (Object)crlDir.getPath());
            try {
                this.commit(conn);
            }
            catch (Throwable th) {
                ImportCrl.LOG.error(String.format("Importing CRL (id=%s) in the folder %s FAILED (Connect.commit)", new Object[]{id, crlDir.getPath()}), th);
            }
            updatemeFile = new File(CrlDirInfo.access$100(crlDirInfo), "UPDATEME");
            updatemeFile.setLastModified(System.currentTimeMillis());
            updatemeFile.renameTo(new File(updatemeFile.getPath() + (updateSucc != false ? ".SUCC" : ".FAIL")));
            if (!updateSucc && caCert != null && !CrlDirInfo.access$600(crlDirInfo) && CertWrapper.access$1100(caCert) != null) {
                try {
                    this.datasource.deleteFromTableWithException(conn, "ISSUER", "ID", (long)CertWrapper.access$1100(caCert).intValue());
                }
                catch (Throwable th) {
                    ImportCrl.LOG.warn("error deleting from table ISSUER for ID {}", (Object)CertWrapper.access$1100(caCert));
                }
            }
            break block98;
            catch (Throwable th) {
                try {
                    ImportCrl.LOG.error(String.format("Importing CRL (id=%s) in the folder %s FAILED", new Object[]{id, crlDir.getPath()}), th);
                }
                catch (Throwable var27_59) {
                    try {
                        this.commit(conn);
                    }
                    catch (Throwable th) {
                        ImportCrl.LOG.error(String.format("Importing CRL (id=%s) in the folder %s FAILED (Connect.commit)", new Object[]{id, crlDir.getPath()}), th);
                    }
                    updatemeFile = new File(CrlDirInfo.access$100(crlDirInfo), "UPDATEME");
                    updatemeFile.setLastModified(System.currentTimeMillis());
                    updatemeFile.renameTo(new File(updatemeFile.getPath() + (updateSucc != false ? ".SUCC" : ".FAIL")));
                    if (!updateSucc && caCert != null && !CrlDirInfo.access$600(crlDirInfo) && CertWrapper.access$1100(caCert) != null) {
                        try {
                            this.datasource.deleteFromTableWithException(conn, "ISSUER", "ID", (long)CertWrapper.access$1100(caCert).intValue());
                        }
                        catch (Throwable th) {
                            ImportCrl.LOG.warn("error deleting from table ISSUER for ID {}", (Object)CertWrapper.access$1100(caCert));
                        }
                    }
                    throw var27_59;
                }
                try {
                    this.commit(conn);
                }
                catch (Throwable th) {
                    ImportCrl.LOG.error(String.format("Importing CRL (id=%s) in the folder %s FAILED (Connect.commit)", new Object[]{id, crlDir.getPath()}), th);
                }
                updatemeFile = new File(CrlDirInfo.access$100(crlDirInfo), "UPDATEME");
                updatemeFile.setLastModified(System.currentTimeMillis());
                updatemeFile.renameTo(new File(updatemeFile.getPath() + (updateSucc != false ? ".SUCC" : ".FAIL")));
                if (!updateSucc && caCert != null && !CrlDirInfo.access$600(crlDirInfo) && CertWrapper.access$1100(caCert) != null) {
                    try {
                        this.datasource.deleteFromTableWithException(conn, "ISSUER", "ID", (long)CertWrapper.access$1100(caCert).intValue());
                    }
                    catch (Throwable th) {
                        ImportCrl.LOG.warn("error deleting from table ISSUER for ID {}", (Object)CertWrapper.access$1100(caCert));
                    }
                }
            }
        }
    }

    private void deleteCa(Connection conn, CrlDirInfo crlDirInfo, CertWrapper caCert) throws DataAccessException, ImportCrlException, IOException {
        Integer issuerId = (Integer)this.datasource.getFirstValue(conn, "ISSUER", "ID", "S1C='" + caCert.base64Sha1Fp + "'", Integer.class);
        if (issuerId == null) {
            LOG.info("No issuer for CRL {} in the folder {} found in database", (Object)crlDirInfo.crlId, (Object)crlDirInfo.crlDir.getPath());
            return;
        }
        this.datasource.deleteFromTable(conn, "CERT", "IID", (long)issuerId.intValue());
        this.datasource.deleteFromTable(conn, "ISSUER", "ID", (long)issuerId.intValue());
    }

    private void importCa(Connection conn, CrlDirInfo crlDirInfo, CertWrapper caCert) throws DataAccessException, ImportCrlException, IOException {
        CertRevocationInfo revInfo = crlDirInfo.revocationinfo;
        Integer issuerId = (Integer)this.datasource.getFirstValue(conn, "ISSUER", "ID", "S1C='" + caCert.base64Sha1Fp + "'", Integer.class);
        PreparedStatement ps = null;
        ResultSet rs = null;
        String sql = null;
        try {
            int offset = 1;
            if (issuerId == null) {
                int maxId = (int)this.datasource.getMax(conn, "ISSUER", "ID");
                issuerId = Math.max(this.cachedIssuerId.get(), maxId) + 1;
                this.cachedIssuerId.set(issuerId);
                sql = "INSERT INTO ISSUER (ID,SUBJECT,NBEFORE,NAFTER,S1C,CERT,REV_INFO) VALUES(?,?,?,?,?,?,?)";
                ps = this.datasource.prepareStatement(conn, sql);
                String subject = X509Util.getRfc4519Name((X500Name)caCert.subject);
                ps.setInt(offset++, issuerId);
                ps.setString(offset++, subject);
                ps.setLong(offset++, caCert.cert.getNotBefore().getTime() / 1000L);
                ps.setLong(offset++, caCert.cert.getNotAfter().getTime() / 1000L);
                ps.setString(offset++, caCert.base64Sha1Fp);
                ps.setString(offset++, caCert.base64Encoded);
                ps.setString(offset++, revInfo == null ? null : revInfo.getEncoded());
            } else {
                sql = "UPDATE ISSUER SET REV_INFO=? WHERE ID=?";
                ps = this.datasource.prepareStatement(conn, sql);
                ps.setString(offset++, revInfo == null ? null : revInfo.getEncoded());
                ps.setInt(offset++, issuerId);
            }
            ps.executeUpdate();
            caCert.databaseId = issuerId;
            this.releaseResources(ps, rs);
        }
        catch (SQLException ex) {
            try {
                throw this.datasource.translate(sql, ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(ps, rs);
                throw throwable;
            }
        }
    }

    private void importCrlInfo(Connection conn, int id, String name, CrlInfo crlInfo, boolean shareCaWithOtherCrl, String sha1FpOfIssuerCert) throws DataAccessException {
        boolean exists = this.datasource.columnExists(conn, "CRL_INFO", "ID", (Object)id);
        PreparedStatement ps = null;
        ResultSet rs = null;
        String sql = null;
        try {
            if (exists) {
                sql = SQL_UPDATE_CRL_INFO;
                ps = this.datasource.prepareStatement(conn, sql);
                ps.setString(1, crlInfo.getEncoded());
                ps.setInt(2, id);
            } else {
                sql = SQL_INSERT_CRL_INFO;
                ps = this.datasource.prepareStatement(conn, sql);
                ps.setInt(1, id);
                ps.setString(2, name);
                ps.setString(3, crlInfo.getEncoded());
            }
            ps.executeUpdate();
            this.releaseResources(ps, rs);
        }
        catch (SQLException ex) {
            try {
                throw this.datasource.translate(sql, ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(ps, rs);
                throw throwable;
            }
        }
        try {
            sql = "UPDATE ISSUER SET CRL_ID=? WHERE S1C=?";
            ps = this.datasource.prepareStatement(conn, sql);
            if (shareCaWithOtherCrl) {
                ps.setNull(1, 4);
            } else {
                ps.setInt(1, id);
            }
            ps.setString(2, sha1FpOfIssuerCert);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw this.datasource.translate(sql, ex);
        }
        finally {
            this.releaseResources(ps, rs);
        }
    }

    private void importCrlRevokedCertificates(Connection conn, int crlInfoId, CertWrapper caCert, CrlStreamParser crl, File crlDir, long startTimeSec) throws DataAccessException, ImportCrlException, IOException {
        File[] serialNumbersFiles;
        int num;
        int caId = caCert.databaseId;
        AtomicLong maxId = new AtomicLong(this.datasource.getMax(conn, "CERT", "ID"));
        boolean isDeltaCrl = crl.isDeltaCrl();
        try (CrlStreamParser.RevokedCertsIterator revokedCertList = crl.revokedCertificates();){
            num = 0;
            while (revokedCertList.hasNext()) {
                ++num;
                long updateTimeSec = Math.max(System.currentTimeMillis() / 1000L, startTimeSec);
                CrlStreamParser.RevokedCert revCert = revokedCertList.next();
                BigInteger serial = revCert.getSerialNumber();
                long rt = revCert.getRevocationDate();
                long rit = revCert.getInvalidityDate();
                int reason = revCert.getReason();
                X500Name issuer = revCert.getCertificateIssuer();
                if (issuer != null && !issuer.equals((Object)caCert.subject)) {
                    throw new ImportCrlException("invalid CRLEntry for certificate number " + serial);
                }
                String sql = null;
                try {
                    PreparedStatement ps;
                    if (reason == CrlReason.REMOVE_FROM_CRL.getCode()) {
                        if (isDeltaCrl) {
                            sql = SQL_DELETE_CERT;
                            this.psDeleteCert.setInt(1, caId);
                            this.psDeleteCert.setString(2, serial.toString(16));
                            this.psDeleteCert.executeUpdate();
                            continue;
                        }
                        LOG.warn("ignore CRL entry with reason removeFromCRL in non-Delta CRL");
                        continue;
                    }
                    CertInfo existingCertInfo = this.getCertInfo(caId, serial);
                    if (existingCertInfo == null) {
                        sql = SQL_INSERT_CERT_REV;
                        long id = maxId.incrementAndGet();
                        ps = this.psInsertCertRev;
                        int offset = 1;
                        ps.setLong(offset++, id);
                        ps.setInt(offset++, caId);
                        ps.setString(offset++, serial.toString(16));
                        ps.setInt(offset++, 1);
                        ps.setInt(offset++, reason);
                        ps.setLong(offset++, rt);
                        if (rit != 0L) {
                            ps.setLong(offset++, rit);
                        } else {
                            ps.setNull(offset++, -5);
                        }
                        ps.setLong(offset++, updateTimeSec);
                        ps.setInt(offset++, crlInfoId);
                    } else if (existingCertInfo.isDifferent(revCert, crlInfoId)) {
                        sql = SQL_UPDATE_CERT_REV;
                        ps = this.psUpdateCertRev;
                        int offset = 1;
                        ps.setInt(offset++, 1);
                        ps.setInt(offset++, reason);
                        ps.setLong(offset++, rt);
                        if (rit != 0L) {
                            ps.setLong(offset++, rit);
                        } else {
                            ps.setNull(offset++, -5);
                        }
                        ps.setLong(offset++, updateTimeSec);
                        ps.setInt(offset++, crlInfoId);
                        ps.setLong(offset++, existingCertInfo.id);
                    } else {
                        sql = SQL_UPDATE_CERT_LUPDATE;
                        ps = this.psUpdateCertLastupdate;
                        ps.setLong(1, updateTimeSec);
                        ps.setLong(2, existingCertInfo.id);
                    }
                    ps.executeUpdate();
                    if (num % this.sqlBatchCommit != 0) continue;
                    this.commit(conn);
                }
                catch (SQLException ex) {
                    throw this.datasource.translate(sql, ex);
                }
            }
            LOG.info("imported {} revoked certificates", (Object)num);
        }
        this.commit(conn);
        File certsDir = new File(crlDir, "certs");
        if (!certsDir.exists()) {
            LOG.info("the folder {} does not exist, ignore it", (Object)certsDir.getPath());
            return;
        }
        if (!certsDir.isDirectory()) {
            LOG.warn("the path {} does not point to a folder, ignore it", (Object)certsDir.getPath());
            return;
        }
        if (!certsDir.canRead()) {
            LOG.warn("the folder {} may not be read, ignore it", (Object)certsDir.getPath());
            return;
        }
        File[] certFiles = certsDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".der") || name.endsWith(".crt") || name.endsWith(".pem");
            }
        });
        if (certFiles != null && certFiles.length > 0) {
            num = 0;
            for (File certFile : certFiles) {
                X509Cert cert;
                ++num;
                try {
                    cert = X509Util.parseCert((File)certFile);
                }
                catch (IOException | IllegalArgumentException | CertificateException ex) {
                    LOG.warn("could not parse certificate {}, ignore it", (Object)certFile.getPath());
                    continue;
                }
                String certLogId = "(file " + certFile.getName() + ")";
                this.addCertificate(maxId, crlInfoId, caCert, cert, null, certLogId);
                if (num < this.sqlBatchCommit) continue;
                num = 0;
                this.commit(conn);
            }
            this.commit(conn);
        }
        if ((serialNumbersFiles = certsDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".serials");
            }
        })) != null && serialNumbersFiles.length > 0) {
            int num2 = 0;
            for (File serialNumbersFile : serialNumbersFiles) {
                ++num2;
                try (BufferedReader reader = new BufferedReader(new FileReader(serialNumbersFile));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        BigInteger serialNumber = new BigInteger(line.trim(), 16);
                        this.addCertificateBySerialNumber(maxId, caId, crlInfoId, serialNumber);
                    }
                }
                catch (IOException ex) {
                    LOG.warn("could not import certificates by serial numbers from file {}, ignore it", (Object)serialNumbersFile.getPath());
                    continue;
                }
                if (num2 < this.sqlBatchCommit) continue;
                num2 = 0;
                this.commit(conn);
            }
            this.commit(conn);
        }
    }

    private static X509Cert parseCert(File certFile) throws ImportCrlException {
        try {
            return X509Util.parseCert((File)certFile);
        }
        catch (IOException | CertificateException ex) {
            throw new ImportCrlException("could not parse X.509 certificate from file " + certFile + ": " + ex.getMessage(), ex);
        }
    }

    private CertInfo getCertInfo(int caId, BigInteger serialNumber) throws DataAccessException {
        ResultSet rs;
        block5: {
            rs = null;
            this.psSelectIdCert.setInt(1, caId);
            this.psSelectIdCert.setString(2, serialNumber.toString(16));
            rs = this.psSelectIdCert.executeQuery();
            if (rs.next()) break block5;
            CertInfo certInfo = null;
            this.releaseResources(null, rs);
            return certInfo;
        }
        try {
            CertInfo ci = new CertInfo();
            ci.crlId = rs.getInt("CRL_ID");
            ci.id = rs.getLong("ID");
            ci.invalidityTime = rs.getLong("RIT");
            ci.revocationReason = rs.getInt("RR");
            ci.revocationTime = rs.getLong("RT");
            ci.revoked = rs.getBoolean("REV");
            CertInfo certInfo = ci;
            this.releaseResources(null, rs);
            return certInfo;
        }
        catch (SQLException ex) {
            try {
                throw this.datasource.translate(this.sqlSelectIdCert, ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(null, rs);
                throw throwable;
            }
        }
    }

    private void addCertificate(AtomicLong maxId, int crlInfoId, CertWrapper caCert, X509Cert cert, String profileName, String certLogId) throws DataAccessException, ImportCrlException {
        byte[] aki;
        int caId = caCert.databaseId;
        if (!caCert.subject.equals((Object)cert.getIssuer())) {
            LOG.warn("certificate {} is not issued by the given CA, ignore it", (Object)certLogId);
            return;
        }
        byte[] encodedCert = cert.getEncoded();
        String b64CertHash = this.certhashAlgo.base64Hash((byte[][])new byte[][]{encodedCert});
        if (!(caCert.subjectKeyIdentifier == null || (aki = cert.getAuthorityKeyId()) != null && Arrays.equals(caCert.subjectKeyIdentifier, aki))) {
            LOG.warn("certificate {} is not issued by the given CA, ignore it", (Object)certLogId);
            return;
        }
        LOG.info("Importing certificate {}", (Object)certLogId);
        CertInfo existingCertInfo = this.getCertInfo(caId, cert.getSerialNumber());
        PreparedStatement ps = null;
        String sql = null;
        try {
            if (existingCertInfo == null) {
                sql = SQL_INSERT_CERT;
                ps = this.psInsertCert;
                long id = maxId.incrementAndGet();
                int offset = 1;
                ps.setLong(offset++, id);
                ps.setInt(offset++, caId);
                ps.setString(offset++, cert.getSerialNumber().toString(16));
                ps.setInt(offset++, 0);
                ps.setNull(offset++, 5);
                ps.setNull(offset++, -5);
                ps.setNull(offset++, -5);
                ps.setLong(offset++, System.currentTimeMillis() / 1000L);
                TBSCertificate tbsCert = cert.toBcCert().toASN1Structure().getTBSCertificate();
                ps.setLong(offset++, tbsCert.getStartDate().getDate().getTime() / 1000L);
                ps.setLong(offset++, tbsCert.getEndDate().getDate().getTime() / 1000L);
                ps.setInt(offset++, crlInfoId);
                ps.setString(offset++, b64CertHash);
            } else if (existingCertInfo.revoked || existingCertInfo.crlId != crlInfoId) {
                sql = SQL_UPDATE_CERT;
                ps = this.psUpdateCert;
                int offset = 1;
                ps.setLong(offset++, System.currentTimeMillis() / 1000L);
                TBSCertificate tbsCert = cert.toBcCert().toASN1Structure().getTBSCertificate();
                ps.setLong(offset++, tbsCert.getStartDate().getDate().getTime() / 1000L);
                ps.setLong(offset++, tbsCert.getEndDate().getDate().getTime() / 1000L);
                ps.setInt(offset++, crlInfoId);
                ps.setString(offset++, b64CertHash);
                ps.setLong(offset++, existingCertInfo.id);
            } else {
                sql = SQL_UPDATE_CERT_LUPDATE;
                ps = this.psUpdateCertLastupdate;
                ps.setLong(1, System.currentTimeMillis() / 1000L);
                ps.setLong(2, existingCertInfo.id);
            }
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw this.datasource.translate(sql, ex);
        }
        LOG.info("Imported  certificate {}", (Object)certLogId);
    }

    private void addCertificateBySerialNumber(AtomicLong maxId, int caId, int crlInfoId, BigInteger serialNumber) throws DataAccessException {
        LOG.info("Importing certificate by serial number {}", (Object)serialNumber);
        CertInfo existingCertInfo = this.getCertInfo(caId, serialNumber);
        PreparedStatement ps = null;
        String sql = null;
        try {
            if (existingCertInfo == null) {
                sql = SQL_INSERT_CERT;
                ps = this.psInsertCert;
                long id = maxId.incrementAndGet();
                int offset = 1;
                ps.setLong(offset++, id);
                ps.setInt(offset++, caId);
                ps.setString(offset++, serialNumber.toString(16));
                ps.setInt(offset++, 0);
                ps.setNull(offset++, 5);
                ps.setNull(offset++, -5);
                ps.setNull(offset++, -5);
                ps.setLong(offset++, System.currentTimeMillis() / 1000L);
                ps.setLong(offset++, 0L);
                ps.setLong(offset++, Long.MAX_VALUE);
                ps.setInt(offset++, crlInfoId);
                ps.setString(offset++, null);
            } else if (existingCertInfo.revoked | existingCertInfo.crlId != crlInfoId) {
                sql = SQL_UPDATE_CERT;
                ps = this.psUpdateCert;
                int offset = 1;
                ps.setLong(offset++, System.currentTimeMillis() / 1000L);
                ps.setLong(offset++, 0L);
                ps.setLong(offset++, Long.MAX_VALUE);
                ps.setInt(offset++, crlInfoId);
                ps.setString(offset++, null);
                ps.setLong(offset++, existingCertInfo.id);
            } else {
                sql = SQL_UPDATE_CERT_LUPDATE;
                ps = this.psUpdateCertLastupdate;
                ps.setLong(1, System.currentTimeMillis() / 1000L);
                ps.setLong(2, existingCertInfo.id);
            }
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw this.datasource.translate(sql, ex);
        }
        LOG.info(" Imported certificate by serial number {}", (Object)serialNumber);
    }

    private void deleteEntriesNotUpdatedSince(Connection conn, int crlInfoId, long timeSec) throws DataAccessException {
        String sql = "DELETE FROM CERT WHERE CRL_ID=" + crlInfoId + " AND LUPDATE<" + timeSec;
        Statement stmt = this.datasource.createStatement(conn);
        try {
            stmt.executeUpdate(sql);
        }
        catch (SQLException ex) {
            throw this.datasource.translate(sql, ex);
        }
        finally {
            this.releaseResources(stmt, null);
        }
    }

    private void releaseResources(Statement ps, ResultSet rs) {
        this.datasource.releaseResources(ps, rs, false);
    }

    private static int getCrlIdFromName(String name) {
        int intvalue = name.hashCode();
        if (intvalue < 0) {
            intvalue *= -1;
        }
        return intvalue;
    }

    private void commit(Connection conn) throws DataAccessException {
        try {
            conn.commit();
        }
        catch (SQLException ex) {
            throw this.datasource.translate("commit", ex);
        }
    }

    private static String getCrlNameFromDir(File dir) {
        if (!dir.isDirectory()) {
            return null;
        }
        String dirName = dir.getName();
        String crlName = null;
        if (dirName.length() > 4 && dirName.startsWith("crl-")) {
            crlName = dirName.substring(4).trim();
        }
        return StringUtil.isBlank((String)dirName) ? null : crlName;
    }

    private static class ImportCrlException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ImportCrlException(String message, Throwable cause) {
            super(message, cause);
        }

        public ImportCrlException(String message) {
            super(message);
        }
    }

    private static class CertWrapper {
        private final X509Cert cert;
        private final X500Name subject;
        private final String base64Sha1Fp;
        private final String base64Encoded;
        private final byte[] subjectKeyIdentifier;
        private Integer databaseId;

        CertWrapper(X509Cert cert) {
            this.cert = cert;
            this.subject = cert.getSubject();
            byte[] encoded = cert.getEncoded();
            this.base64Sha1Fp = HashAlgo.SHA1.base64Hash((byte[][])new byte[][]{encoded});
            this.base64Encoded = Base64.encodeToString((byte[])encoded);
            this.subjectKeyIdentifier = cert.getSubjectKeyId();
        }
    }

    private static class CrlDirInfo {
        private final int crlId;
        private final String crlName;
        private final File crlDir;
        private final boolean updateMe;
        private String base64Sha1Fp;
        private CertRevocationInfo revocationinfo;
        private boolean shareCaWithOtherCrl = false;
        private boolean deleteMe;

        CrlDirInfo(int crlId, String crlName, File crlDir, boolean updateMe, boolean deleteMe) {
            this.crlId = crlId;
            this.crlName = crlName;
            this.crlDir = crlDir;
            this.updateMe = updateMe;
            this.deleteMe = deleteMe;
        }

        static /* synthetic */ String access$700(CrlDirInfo x0) {
            return x0.crlName;
        }

        static /* synthetic */ boolean access$600(CrlDirInfo x0) {
            return x0.shareCaWithOtherCrl;
        }
    }

    private static class CertInfo {
        private long id;
        private int crlId;
        private boolean revoked;
        private int revocationReason;
        private long revocationTime;
        private long invalidityTime;

        private CertInfo() {
        }

        boolean isDifferent(CrlStreamParser.RevokedCert revokedCert, int crlId) {
            if (this.crlId != crlId) {
                return true;
            }
            if (this.revoked) {
                if (this.revocationReason != revokedCert.getReason()) {
                    return true;
                }
                if (this.revocationTime != revokedCert.getRevocationDate()) {
                    return true;
                }
                return this.invalidityTime != revokedCert.getInvalidityDate();
            }
            return true;
        }
    }
}

