/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.store.ejbca;

import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.x509.Certificate;
import org.xipki.ocsp.api.RequestIssuer;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.CrlReason;
import org.xipki.security.HashAlgo;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;
import org.xipki.util.CompareUtil;

class EjbcaIssuerEntry {
    private final String id;
    private final Map<HashAlgo, byte[]> issuerHashMap;
    private final Date notBefore;
    private final X509Cert cert;
    private CertRevocationInfo revocationInfo;

    public EjbcaIssuerEntry(X509Cert cert) throws CertificateEncodingException {
        this.cert = (X509Cert)Args.notNull((Object)cert, (String)"cert");
        this.notBefore = cert.getNotBefore();
        byte[] encodedCert = cert.getEncoded();
        this.id = HashAlgo.SHA1.hexHash((byte[][])new byte[][]{encodedCert});
        this.issuerHashMap = EjbcaIssuerEntry.getIssuerHashAndKeys(encodedCert);
    }

    private static Map<HashAlgo, byte[]> getIssuerHashAndKeys(byte[] encodedCert) throws CertificateEncodingException {
        byte[] encodedKey;
        byte[] encodedName;
        try {
            Certificate bcCert = Certificate.getInstance((Object)encodedCert);
            encodedName = bcCert.getSubject().getEncoded("DER");
            encodedKey = bcCert.getSubjectPublicKeyInfo().getPublicKeyData().getBytes();
        }
        catch (IOException | IllegalArgumentException ex) {
            throw new CertificateEncodingException(ex.getMessage(), ex);
        }
        HashMap<HashAlgo, byte[]> hashes = new HashMap<HashAlgo, byte[]>();
        for (HashAlgo ha : HashAlgo.values()) {
            int hlen = ha.getLength();
            byte[] nameAndKeyHash = new byte[2 + hlen << 1];
            int offset = 0;
            nameAndKeyHash[offset++] = 4;
            nameAndKeyHash[offset++] = (byte)hlen;
            System.arraycopy(ha.hash((byte[][])new byte[][]{encodedName}), 0, nameAndKeyHash, offset, hlen);
            offset += hlen;
            nameAndKeyHash[offset++] = 4;
            nameAndKeyHash[offset++] = (byte)hlen;
            System.arraycopy(ha.hash((byte[][])new byte[][]{encodedKey}), 0, nameAndKeyHash, offset, hlen);
            hashes.put(ha, nameAndKeyHash);
        }
        return hashes;
    }

    public String getId() {
        return this.id;
    }

    public byte[] getEncodedHash(HashAlgo hashAlgo) {
        byte[] data = this.issuerHashMap.get(hashAlgo);
        return Arrays.copyOf(data, data.length);
    }

    public boolean matchHash(RequestIssuer reqIssuer) {
        byte[] issuerHash = this.issuerHashMap.get(reqIssuer.hashAlgorithm());
        if (issuerHash == null) {
            return false;
        }
        return CompareUtil.areEqual((byte[])issuerHash, (int)0, (byte[])reqIssuer.getData(), (int)reqIssuer.getNameHashFrom(), (int)issuerHash.length);
    }

    public void setRevocationInfo(Date revocationTime) {
        Args.notNull((Object)revocationTime, (String)"revocationTime");
        this.revocationInfo = new CertRevocationInfo(CrlReason.CA_COMPROMISE, revocationTime, null);
    }

    public CertRevocationInfo getRevocationInfo() {
        return this.revocationInfo;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public X509Cert getCert() {
        return this.cert;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EjbcaIssuerEntry)) {
            return false;
        }
        EjbcaIssuerEntry other = (EjbcaIssuerEntry)obj;
        return this.id.equals(other.id) && CompareUtil.equalsObject((Object)this.revocationInfo, (Object)other.revocationInfo);
    }
}

