/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.store;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.ocsp.api.OcspStoreException;
import org.xipki.ocsp.server.store.DbCertStatusStore;
import org.xipki.ocsp.server.store.ImportCrl;
import org.xipki.util.Args;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;

public class CrlDbCertStatusStore
extends DbCertStatusStore {
    private static final Logger LOG = LoggerFactory.getLogger(CrlDbCertStatusStore.class);
    private final CrlUpdateService storeUpdateService = new CrlUpdateService();
    private final Object lock = new Object();
    private final AtomicBoolean crlUpdateInProcess = new AtomicBoolean(false);
    private String dir;
    private int sqlBatchCommit;
    private boolean ignoreExpiredCrls;
    private boolean crlUpdated;

    @Override
    public void init(Map<String, ?> sourceConf, DataSourceWrapper datasource) throws OcspStoreException {
        String value;
        Args.notNull(sourceConf, (String)"sourceConf");
        this.dir = IoUtil.expandFilepath((String)CrlDbCertStatusStore.getStrValue(sourceConf, "dir", true), (boolean)true);
        File dirObj = new File(this.dir);
        if (!dirObj.exists()) {
            throw new OcspStoreException("the dir " + this.dir + " does not exist");
        }
        if (!dirObj.isDirectory()) {
            throw new OcspStoreException(this.dir + " is not a directory");
        }
        File[] subDirs = new File(this.dir).listFiles();
        boolean foundCrlDir = false;
        if (subDirs != null) {
            for (File subDir : subDirs) {
                String dirName;
                if (!subDir.isDirectory() || !(dirName = subDir.getName()).startsWith("crl-")) continue;
                foundCrlDir = true;
                break;
            }
        }
        if (!foundCrlDir) {
            LOG.warn("Found no sub-directory starting with 'crl-' in " + this.dir);
        }
        this.sqlBatchCommit = StringUtil.isBlank((String)(value = CrlDbCertStatusStore.getStrValue(sourceConf, "sqlBatchCommit", false))) ? 1000 : Integer.parseInt(value);
        value = CrlDbCertStatusStore.getStrValue(sourceConf, "ignoreExpiredCrls", false);
        this.ignoreExpiredCrls = StringUtil.isBlank((String)value) || Boolean.parseBoolean(value);
        this.datasource = datasource;
        this.updateStore(true);
        super.init(sourceConf, datasource);
    }

    private static String getStrValue(Map<String, ?> sourceConf, String confName, boolean mandatory) {
        Object objVal = sourceConf.get(confName);
        if (objVal == null) {
            if (mandatory) {
                throw new IllegalArgumentException("mandatory " + confName + " is not specified in sourceConf");
            }
            return null;
        }
        if (objVal instanceof String) {
            return (String)objVal;
        }
        return objVal.toString();
    }

    protected boolean isIgnoreExpiredCrls() {
        return this.ignoreExpiredCrls;
    }

    @Override
    protected List<Runnable> getScheduledServices() {
        return Collections.singletonList(this.storeUpdateService);
    }

    @Override
    protected boolean isInitialized() {
        return this.crlUpdated && super.isInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStore(boolean firstTime) {
        if (this.crlUpdateInProcess.get()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.crlUpdateInProcess.set(true);
            try {
                File[] subDirs = new File(this.dir).listFiles();
                boolean updateMe = false;
                if (subDirs != null) {
                    for (File subDir : subDirs) {
                        String dirName;
                        if (!subDir.isDirectory() || !(dirName = subDir.getName()).startsWith("crl-") || !new File(subDir, "UPDATEME").exists()) continue;
                        updateMe = true;
                        break;
                    }
                }
                if (!updateMe) {
                    LOG.info("CertStore {} not changed", (Object)this.name);
                    return;
                }
                ImportCrl importCrl = new ImportCrl(this.datasource, this.dir, this.sqlBatchCommit, this.ignoreExpiredCrls);
                if (importCrl.importCrlToOcspDb()) {
                    LOG.info("updated CertStore {} successfully", (Object)this.name);
                } else {
                    LOG.error("updating CertStore {} failed", (Object)this.name);
                }
                if (!firstTime) {
                    super.updateIssuerStore(true);
                }
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)"error while executing updateStore()");
            }
            finally {
                this.crlUpdated = true;
                this.crlUpdateInProcess.set(false);
            }
        }
    }

    private class CrlUpdateService
    implements Runnable {
        private CrlUpdateService() {
        }

        @Override
        public void run() {
            try {
                CrlDbCertStatusStore.this.updateStore(false);
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)("error while calling initializeStore() for store " + CrlDbCertStatusStore.this.name));
            }
        }
    }
}

