/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.store;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;
import org.bouncycastle.asn1.ocsp.CrlID;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.ConfPairs;
import org.xipki.util.DateUtil;
import org.xipki.util.StringUtil;

public class CrlInfo {
    public static final String BASE_CRL_NUMBER = "base-crl-number";
    public static final String CRL_ID = "crl-id";
    public static final String CRL_NUMBER = "crl-number";
    public static final String NEXT_UPDATE = "next-update";
    public static final String THIS_UPDATE = "this-update";
    private final BigInteger crlNumber;
    private BigInteger baseCrlNumber;
    private final Date thisUpdate;
    private final Date nextUpdate;
    private final CrlID crlId;
    private String encoded;

    public CrlInfo(String conf) {
        ConfPairs pairs = new ConfPairs(conf);
        String str = CrlInfo.getNotBlankValue(pairs, CRL_NUMBER);
        this.crlNumber = new BigInteger(str, 16);
        str = pairs.value(BASE_CRL_NUMBER);
        if (StringUtil.isNotBlank((String)str)) {
            this.baseCrlNumber = new BigInteger(str, 16);
        }
        str = CrlInfo.getNotBlankValue(pairs, THIS_UPDATE);
        this.thisUpdate = DateUtil.parseUtcTimeyyyyMMddhhmmss((String)str);
        str = CrlInfo.getNotBlankValue(pairs, NEXT_UPDATE);
        this.nextUpdate = DateUtil.parseUtcTimeyyyyMMddhhmmss((String)str);
        str = CrlInfo.getNotBlankValue(pairs, CRL_ID);
        this.crlId = CrlID.getInstance((Object)Base64.decodeFast((String)str));
        this.initEncoded();
    }

    private static String getNotBlankValue(ConfPairs pairs, String name) {
        String str = pairs.value(name);
        if (StringUtil.isBlank((String)str)) {
            throw new IllegalArgumentException(name + " is not specified");
        }
        return str;
    }

    public CrlInfo(BigInteger crlNumber, BigInteger baseCrlNumber, Date thisUpdate, Date nextUpdate, CrlID crlId) {
        this.crlNumber = (BigInteger)Args.notNull((Object)crlNumber, (String)"crlNumber");
        this.baseCrlNumber = baseCrlNumber;
        this.thisUpdate = (Date)Args.notNull((Object)thisUpdate, (String)"thisUpdate");
        this.nextUpdate = (Date)Args.notNull((Object)nextUpdate, (String)"nextUpdate");
        this.crlId = (CrlID)Args.notNull((Object)crlId, (String)"crlId");
        this.initEncoded();
    }

    private void initEncoded() {
        byte[] encodedCrlId;
        ConfPairs pairs = new ConfPairs();
        pairs.putPair(CRL_NUMBER, this.crlNumber.toString(16));
        if (this.baseCrlNumber != null) {
            pairs.putPair(BASE_CRL_NUMBER, this.baseCrlNumber.toString(16));
        }
        pairs.putPair(THIS_UPDATE, DateUtil.toUtcTimeyyyyMMddhhmmss((Date)this.thisUpdate));
        pairs.putPair(NEXT_UPDATE, DateUtil.toUtcTimeyyyyMMddhhmmss((Date)this.nextUpdate));
        try {
            encodedCrlId = this.crlId.getEncoded();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("error encoding CrlID");
        }
        pairs.putPair(CRL_ID, Base64.encodeToString((byte[])encodedCrlId));
        this.encoded = pairs.getEncoded();
    }

    public String getEncoded() {
        return this.encoded;
    }

    public BigInteger getCrlNumber() {
        return this.crlNumber;
    }

    public BigInteger getBaseCrlNumber() {
        return this.baseCrlNumber;
    }

    public Date getThisUpdate() {
        return this.thisUpdate;
    }

    public Date getNextUpdate() {
        return this.nextUpdate;
    }

    public CrlID getCrlId() {
        return this.crlId;
    }

    public int hashCode() {
        return this.encoded.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CrlInfo)) {
            return false;
        }
        return ((CrlInfo)obj).encoded.equals(this.encoded);
    }
}

