/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.type;

import org.xipki.ocsp.server.type.ASN1Type;

public class TaggedCertSequence
extends ASN1Type {
    private final byte[] encoded;
    private final int encodedLen;

    public TaggedCertSequence(byte[] encodedCert) {
        this(new byte[][]{encodedCert});
    }

    public TaggedCertSequence(byte[][] encodedCerts) {
        int seqBodyLen = 0;
        for (int i = 0; i < encodedCerts.length; ++i) {
            seqBodyLen += encodedCerts[i].length;
        }
        int seqLen = TaggedCertSequence.getLen(seqBodyLen);
        this.encodedLen = TaggedCertSequence.getLen(seqLen);
        this.encoded = new byte[this.encodedLen];
        int idx = 0;
        idx += TaggedCertSequence.writeHeader((byte)-96, seqLen, this.encoded, idx);
        idx += TaggedCertSequence.writeHeader((byte)48, seqBodyLen, this.encoded, idx);
        for (int i = 0; i < encodedCerts.length; ++i) {
            idx += TaggedCertSequence.arraycopy(encodedCerts[i], this.encoded, idx);
        }
    }

    @Override
    public int getEncodedLength() {
        return this.encodedLen;
    }

    @Override
    public int write(byte[] out, int offset) {
        return TaggedCertSequence.arraycopy(this.encoded, out, offset);
    }
}

