/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.xipki.util.Args;

public class CertWithEncoded {
    private final X509Certificate cert;
    private final String className;
    private final byte[] encoded;

    public CertWithEncoded(X509Certificate cert) throws CertificateEncodingException {
        this.cert = (X509Certificate)Args.notNull((Object)cert, (String)"cert");
        this.className = cert.getClass().getName();
        this.encoded = cert.getEncoded();
    }

    public X509Certificate getCert() {
        return this.cert;
    }

    public boolean equalsCert(X509Certificate cert) {
        byte[] encodedCert;
        if (cert == null) {
            return false;
        }
        if (this.cert == cert) {
            return true;
        }
        if (this.className.equals(cert.getClass().getName())) {
            return this.cert.equals(cert);
        }
        if (this.cert.equals(cert)) {
            return true;
        }
        try {
            encodedCert = cert.getEncoded();
        }
        catch (CertificateEncodingException ex) {
            return false;
        }
        return Arrays.equals(this.encoded, encodedCert);
    }
}

