/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.type;

import java.util.List;
import org.xipki.ocsp.server.type.ASN1Type;
import org.xipki.ocsp.server.type.Extension;

public class Extensions
extends ASN1Type {
    private final List<Extension> extensions;
    private final int bodyLen;
    private final int encodedLen;

    public Extensions(List<Extension> extensions) {
        int len = 0;
        for (Extension m : extensions) {
            len += m.getEncodedLength();
        }
        this.bodyLen = len;
        this.encodedLen = Extensions.getLen(this.bodyLen);
        this.extensions = extensions;
    }

    @Override
    public int getEncodedLength() {
        return this.encodedLen;
    }

    @Override
    public int write(byte[] out, int offset) {
        int idx = offset;
        idx += Extensions.writeHeader((byte)48, this.bodyLen, out, idx);
        for (Extension m : this.extensions) {
            idx += m.write(out, idx);
        }
        return idx - offset;
    }
}

