/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.type;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ocsp.server.type.EncodingException;
import org.xipki.ocsp.server.type.Extension;
import org.xipki.ocsp.server.type.OID;
import org.xipki.ocsp.server.type.OcspRequest;
import org.xipki.util.Hex;

public class ExtendedExtension
extends Extension {
    private static final Logger LOG = LoggerFactory.getLogger(ExtendedExtension.class);
    private static final byte[] bytes_critical = Hex.decode((String)"0101FF");
    private final OID extnType;
    private final byte[] encoded;
    private final int from;
    private final boolean critical;
    private final int encodedLength;
    private final int extnValueFrom;
    private final int extnValueLength;

    public ExtendedExtension(OID extnType, boolean critical, byte[] extnValue) {
        int bodyLen = extnType.getEncodedLength();
        if (critical) {
            bodyLen += 3;
        }
        this.extnType = extnType;
        this.critical = critical;
        this.encodedLength = ExtendedExtension.getLen(bodyLen += ExtendedExtension.getLen(extnValue.length));
        this.extnValueLength = extnValue.length;
        this.extnValueFrom = this.encodedLength - this.extnValueLength;
        this.from = 0;
        this.encoded = new byte[this.encodedLength];
        int offset = ExtendedExtension.writeHeader((byte)48, bodyLen, this.encoded, 0);
        offset += extnType.write(this.encoded, offset);
        if (critical) {
            offset += ExtendedExtension.arraycopy(bytes_critical, this.encoded, offset);
        }
        offset += ExtendedExtension.writeHeader((byte)4, extnValue.length, this.encoded, offset);
        ExtendedExtension.arraycopy(extnValue, this.encoded, offset);
    }

    private ExtendedExtension(OID extnType, byte[] encoded, int from, boolean critical, int encodedLength, int extnValueFrom, int extnValueLength) {
        this.extnType = extnType;
        this.encoded = encoded;
        this.from = from;
        this.critical = critical;
        this.encodedLength = encodedLength;
        this.extnValueFrom = extnValueFrom;
        this.extnValueLength = extnValueLength;
    }

    public static ExtendedExtension getInstance(byte[] encoded, int from, int len) throws EncodingException {
        OcspRequest.Header hdrExtValue;
        boolean critical;
        OcspRequest.Header hdrExtn = OcspRequest.readHeader(encoded, from);
        OcspRequest.Header hdrOid = OcspRequest.readHeader(encoded, hdrExtn.readerIndex);
        OcspRequest.Header hdrNext = OcspRequest.readHeader(encoded, hdrOid.readerIndex + hdrOid.len);
        if (hdrNext.tag == 1) {
            critical = encoded[hdrNext.readerIndex] == -1;
            hdrExtValue = OcspRequest.readHeader(encoded, hdrNext.readerIndex + hdrNext.len);
        } else {
            critical = false;
            hdrExtValue = hdrNext;
        }
        OID extnType = OID.getInstanceForEncoded(encoded, hdrOid.tagIndex);
        if (extnType == null) {
            byte[] bytes = new byte[hdrOid.readerIndex - hdrOid.tagIndex + hdrOid.len];
            System.arraycopy(encoded, hdrOid.tag, bytes, 0, bytes.length);
            ASN1ObjectIdentifier oid = ASN1ObjectIdentifier.getInstance((Object)bytes);
            LOG.warn("unknown extension {}", (Object)oid.getId());
            if (critical) {
                throw new EncodingException("unkown critical extension: " + oid.getId());
            }
            return null;
        }
        int extnValueFrom = hdrExtValue.readerIndex;
        int extnValueLength = hdrExtValue.len;
        return new ExtendedExtension(extnType, encoded, from, critical, len, extnValueFrom, extnValueLength);
    }

    @Override
    public int getEncodedLength() {
        return this.encodedLength;
    }

    public static int getEncodedLength(OID extnType, boolean critical, int extnValueLength) {
        int bodyLen = extnType.getEncodedLength();
        if (critical) {
            bodyLen += 3;
        }
        return ExtendedExtension.getLen(bodyLen += ExtendedExtension.getLen(extnValueLength));
    }

    public boolean isCritical() {
        return this.critical;
    }

    public OID getExtnType() {
        return this.extnType;
    }

    public int getExtnValueLength() {
        return this.extnValueLength;
    }

    public InputStream getExtnValueStream() {
        return new ByteArrayInputStream(this.encoded, this.extnValueFrom, this.extnValueLength);
    }

    @Override
    public int write(byte[] out, int offset) {
        System.arraycopy(this.encoded, this.from, out, offset, this.encodedLength);
        return this.encodedLength;
    }

    public int writeExtnValue(byte[] out, int offset) {
        System.arraycopy(this.encoded, this.extnValueFrom, out, offset, this.extnValueLength);
        return this.extnValueLength;
    }

    public ExtendedExtension revertCritical() {
        byte[] extnValue = Arrays.copyOfRange(this.encoded, this.extnValueFrom, this.extnValueFrom + this.extnValueLength);
        return new ExtendedExtension(this.extnType, !this.critical, extnValue);
    }
}

