/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.ocsp.api.OcspStore;
import org.xipki.ocsp.api.OcspStoreException;
import org.xipki.ocsp.server.OcspServerConf;
import org.xipki.ocsp.server.RequestOption;
import org.xipki.ocsp.server.ResponseSigner;
import org.xipki.ocsp.server.store.CaDbCertStatusStore;
import org.xipki.ocsp.server.store.CrlDbCertStatusStore;
import org.xipki.ocsp.server.store.DbCertStatusStore;
import org.xipki.ocsp.server.store.ejbca.EjbcaCertStatusStore;
import org.xipki.ocsp.server.type.ExtendedExtension;
import org.xipki.ocsp.server.type.OID;
import org.xipki.security.CertpathValidationModel;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignerConf;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.CollectionUtil;
import org.xipki.util.FileOrBinary;
import org.xipki.util.FileOrValue;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.Validity;
import org.xipki.util.exception.InvalidConfException;
import org.xipki.util.exception.ObjectCreationException;

public class OcspServerUtil {
    private static final Logger LOG = LoggerFactory.getLogger(OcspServerUtil.class);
    private static final String STORE_TYPE_XIPKI_DB = "xipki-db";
    private static final String STORE_TYPE_XIPKI_CA_DB = "xipki-ca-db";
    private static final String STORE_TYPE_CRL = "crl";
    private static final String STORE_TYPE_EJBCA_DB = "ejbca-db";

    static ResponseSigner initSigner(OcspServerConf.Signer signerType, SecurityFactory securityFactory) throws InvalidConfException {
        X509Cert[] explicitCertificateChain = null;
        X509Cert explicitResponderCert = null;
        if (signerType.getCert() != null) {
            explicitResponderCert = OcspServerUtil.parseCert(signerType.getCert());
        }
        if (explicitResponderCert != null) {
            HashSet<X509Cert> caCerts = null;
            if (signerType.getCaCerts() != null) {
                caCerts = new HashSet<X509Cert>();
                for (FileOrBinary certConf : signerType.getCaCerts()) {
                    caCerts.add(OcspServerUtil.parseCert(certConf));
                }
            }
            try {
                explicitCertificateChain = X509Util.buildCertPath((X509Cert)explicitResponderCert, caCerts);
            }
            catch (CertPathBuilderException ex) {
                throw new InvalidConfException((Throwable)ex);
            }
        }
        String responderSignerType = signerType.getType();
        String responderKeyConf = signerType.getKey();
        List<String> sigAlgos = signerType.getAlgorithms();
        ArrayList<ConcurrentContentSigner> singleSigners = new ArrayList<ConcurrentContentSigner>(sigAlgos.size());
        String name = signerType.getName();
        LinkedList<String> succSigAlgos = new LinkedList<String>();
        LinkedList<String> failSigAlgos = new LinkedList<String>();
        for (String sigAlgo : sigAlgos) {
            try {
                ConcurrentContentSigner requestorSigner = securityFactory.createSigner(responderSignerType, new SignerConf("algo=" + sigAlgo + "," + responderKeyConf), explicitCertificateChain);
                singleSigners.add(requestorSigner);
                succSigAlgos.add(sigAlgo);
            }
            catch (Exception ex) {
                failSigAlgos.add(sigAlgo);
                LOG.debug("could not create OCSP responder " + name, (Throwable)ex);
            }
        }
        if (singleSigners.isEmpty()) {
            throw new InvalidConfException("could not create any signer for OCSP responder " + name);
        }
        LOG.info("Create signers of sign algorithms {} for the OCSP responder {}", succSigAlgos, (Object)name);
        if (!failSigAlgos.isEmpty()) {
            LOG.info("ignore sign algorithms {} for the OCSP responder {}", failSigAlgos, (Object)name);
        }
        try {
            return new ResponseSigner(singleSigners);
        }
        catch (IOException | CertificateException ex) {
            throw new InvalidConfException(ex.getMessage(), (Throwable)ex);
        }
    }

    static OcspStore newStore(OcspServerConf.Store conf, Map<String, DataSourceWrapper> datasources) throws InvalidConfException {
        OcspStore store;
        block16: {
            try {
                String type = conf.getSource().getType();
                if (type != null) {
                    type = type.trim().toLowerCase();
                }
                if (StringUtil.isBlank((String)type)) {
                    throw new ObjectCreationException("OCSP store type is not specified");
                }
                if (STORE_TYPE_XIPKI_DB.equals(type)) {
                    store = new DbCertStatusStore();
                    break block16;
                }
                if (STORE_TYPE_CRL.equals(type)) {
                    store = new CrlDbCertStatusStore();
                    break block16;
                }
                if (STORE_TYPE_XIPKI_CA_DB.equals(type)) {
                    store = new CaDbCertStatusStore();
                    break block16;
                }
                if (STORE_TYPE_EJBCA_DB.equals(type)) {
                    store = new EjbcaCertStatusStore();
                    break block16;
                }
                if (type.startsWith("java:")) {
                    String className = type.substring("java:".length()).trim();
                    try {
                        Class<?> clazz = Class.forName(className, false, OcspServerUtil.class.getClassLoader());
                        store = (OcspStore)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        break block16;
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                        throw new InvalidConfException("ObjectCreationException of store " + conf.getName() + ":" + ex.getMessage(), (Throwable)ex);
                    }
                }
                throw new ObjectCreationException("unknown OCSP store type " + type);
            }
            catch (ObjectCreationException ex) {
                throw new InvalidConfException("ObjectCreationException of store " + conf.getName() + ":" + ex.getMessage(), (Throwable)ex);
            }
        }
        store.setName(conf.getName());
        Integer interval = conf.getRetentionInterval();
        int retentionInterva = interval == null ? -1 : interval;
        store.setRetentionInterval(retentionInterva);
        store.setUnknownCertBehaviour(conf.getUnknownCertBehaviour());
        store.setIncludeArchiveCutoff(OcspServerUtil.getBoolean(conf.getIncludeArchiveCutoff(), true));
        store.setIncludeCrlId(OcspServerUtil.getBoolean(conf.getIncludeCrlId(), true));
        store.setIgnoreExpiredCert(OcspServerUtil.getBoolean(conf.getIgnoreExpiredCert(), true));
        store.setIgnoreNotYetValidCert(OcspServerUtil.getBoolean(conf.getIgnoreNotYetValidCert(), true));
        Validity minPeriod = conf.getMinNextUpdatePeriod() == null ? null : Validity.getInstance((String)conf.getMinNextUpdatePeriod());
        Validity maxPeriod = conf.getMaxNextUpdatePeriod() == null ? null : Validity.getInstance((String)conf.getMaxNextUpdatePeriod());
        store.setNextUpdatePeriodLimit(minPeriod, maxPeriod);
        if ("NEVER".equalsIgnoreCase(conf.getUpdateInterval())) {
            store.setUpdateInterval(null);
        } else {
            String str = conf.getUpdateInterval();
            Validity updateInterval = Validity.getInstance((String)(StringUtil.isBlank((String)str) ? "5m" : str));
            store.setUpdateInterval(updateInterval);
        }
        String datasourceName = conf.getSource().getDatasource();
        DataSourceWrapper datasource = null;
        if (datasourceName != null && (datasource = datasources.get(datasourceName)) == null) {
            throw new InvalidConfException("datasource named '" + datasourceName + "' not defined");
        }
        try {
            Map<String, ?> sourceConf = conf.getSource().getConf();
            store.init(sourceConf, datasource);
        }
        catch (OcspStoreException ex) {
            throw new InvalidConfException("CertStatusStoreException of store " + conf.getName() + ":" + ex.getMessage(), (Throwable)ex);
        }
        return store;
    }

    static boolean canBuildCertpath(X509Cert[] certsInReq, RequestOption requestOption, Date referenceTime) {
        X509Cert[] certpath;
        X509Cert target = certsInReq[0];
        Set<X509Cert> trustanchors = requestOption.getTrustanchors();
        HashSet<X509Cert> certstore = new HashSet<X509Cert>(trustanchors);
        Set<X509Cert> configuredCerts = requestOption.getCerts();
        if (CollectionUtil.isNotEmpty(configuredCerts)) {
            certstore.addAll(requestOption.getCerts());
        }
        try {
            certpath = X509Util.buildCertPath((X509Cert)target, certstore);
        }
        catch (CertPathBuilderException ex) {
            LogUtil.warn((Logger)LOG, (Throwable)ex);
            return false;
        }
        CertpathValidationModel model = requestOption.getCertpathValidationModel();
        if (model == null || model == CertpathValidationModel.PKIX) {
            for (X509Cert m : certpath) {
                if (!m.getNotBefore().after(referenceTime) && !m.getNotAfter().before(referenceTime)) continue;
                return false;
            }
        } else if (model != CertpathValidationModel.CHAIN) {
            throw new IllegalStateException("invalid CertpathValidationModel " + model.name());
        }
        for (int i = certpath.length - 1; i >= 0; --i) {
            X509Cert targetCert = certpath[i];
            for (X509Cert m : trustanchors) {
                if (!m.equals((Object)targetCert)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean getBoolean(Boolean bo, boolean defaultValue) {
        return bo == null ? defaultValue : bo;
    }

    private static InputStream getInputStream(FileOrBinary conf) throws IOException {
        return conf.getFile() != null ? Files.newInputStream(Paths.get(IoUtil.expandFilepath((String)conf.getFile(), (boolean)true), new String[0]), new OpenOption[0]) : new ByteArrayInputStream(conf.getBinary());
    }

    static InputStream getInputStream(FileOrValue conf) throws IOException {
        return conf.getFile() != null ? Files.newInputStream(Paths.get(IoUtil.expandFilepath((String)conf.getFile(), (boolean)true), new String[0]), new OpenOption[0]) : new ByteArrayInputStream(StringUtil.toUtf8Bytes((String)conf.getValue()));
    }

    static void closeStream(InputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException ex) {
            LOG.warn("could not close stream: {}", (Object)ex.getMessage());
        }
    }

    private static X509Cert parseCert(FileOrBinary certConf) throws InvalidConfException {
        InputStream is = null;
        try {
            is = OcspServerUtil.getInputStream(certConf);
            X509Cert x509Cert = X509Util.parseCert((InputStream)is);
            return x509Cert;
        }
        catch (IOException | CertificateException ex) {
            String msg = "could not parse certificate";
            if (certConf.getFile() != null) {
                msg = msg + " from file " + certConf.getFile();
            }
            throw new InvalidConfException(msg);
        }
        finally {
            OcspServerUtil.closeStream(is);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static OcspServerConf parseConf(String confFilename) throws InvalidConfException {
        try (InputStream is = Files.newInputStream(Paths.get(IoUtil.expandFilepath((String)confFilename, (boolean)true), new String[0]), new OpenOption[0]);){
            OcspServerConf root = (OcspServerConf)((Object)JSON.parseObject((InputStream)is, OcspServerConf.class, (Feature[])new Feature[0]));
            root.validate();
            OcspServerConf ocspServerConf = root;
            return ocspServerConf;
        }
        catch (IOException | RuntimeException ex) {
            throw new InvalidConfException("parse profile failed, message: " + ex.getMessage(), (Throwable)ex);
        }
    }

    static ExtendedExtension removeExtension(List<ExtendedExtension> extensions, OID extnType) {
        ExtendedExtension extn = null;
        for (ExtendedExtension m : extensions) {
            if (extnType != m.getExtnType()) continue;
            extn = m;
            break;
        }
        if (extn != null) {
            extensions.remove(extn);
        }
        return extn;
    }
}

