/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xipki.ocsp.api.RequestIssuer;
import org.xipki.ocsp.server.store.CrlInfo;
import org.xipki.ocsp.server.store.IssuerEntry;

class IssuerStore {
    private List<IssuerEntry> issuers = new ArrayList<IssuerEntry>();
    private Set<Integer> ids = Collections.emptySet();
    private Map<Integer, CrlInfo> crlInfos = new HashMap<Integer, CrlInfo>();

    public void setIssuers(List<IssuerEntry> issuers) {
        HashSet<Integer> newIds = new HashSet<Integer>();
        for (IssuerEntry issuer : issuers) {
            int id = issuer.getId();
            if (newIds.contains(id)) {
                throw new IllegalArgumentException("issuer with the same id " + id + " duplicated");
            }
            newIds.add(id);
        }
        ArrayList<IssuerEntry> copy = new ArrayList<IssuerEntry>(issuers);
        this.ids = Collections.unmodifiableSet(newIds);
        this.issuers = copy;
    }

    public int size() {
        return this.ids.size();
    }

    public Set<Integer> getIds() {
        return this.ids;
    }

    public IssuerEntry getIssuerForId(int id) {
        for (IssuerEntry entry : this.issuers) {
            if (entry.getId() != id) continue;
            return entry;
        }
        return null;
    }

    public IssuerEntry getIssuerForFp(RequestIssuer reqIssuer) {
        for (IssuerEntry entry : this.issuers) {
            if (!entry.matchHash(reqIssuer)) continue;
            return entry;
        }
        return null;
    }

    public void addIssuer(IssuerEntry issuer) {
        this.issuers.add(issuer);
        HashSet<Integer> newIds = new HashSet<Integer>(this.ids);
        newIds.add(issuer.getId());
        this.ids = Collections.unmodifiableSet(newIds);
    }

    public void setCrlInfos(Map<Integer, CrlInfo> crlInfos) {
        this.crlInfos = crlInfos == null ? Collections.emptyMap() : new HashMap<Integer, CrlInfo>(crlInfos);
    }

    public CrlInfo getCrlInfo(int crlInfoId) {
        return this.crlInfos.get(crlInfoId);
    }
}

