/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.store.ejbca;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.xipki.ocsp.api.RequestIssuer;
import org.xipki.ocsp.server.store.ejbca.EjbcaIssuerEntry;

class EjbcaIssuerStore {
    private final List<EjbcaIssuerEntry> entries;
    private final Set<String> ids;

    public EjbcaIssuerStore(Collection<EjbcaIssuerEntry> entries) {
        this.entries = new ArrayList<EjbcaIssuerEntry>(entries.size());
        HashSet<String> idSet = new HashSet<String>(entries.size());
        for (EjbcaIssuerEntry entry : entries) {
            for (EjbcaIssuerEntry existingEntry : this.entries) {
                if (!existingEntry.getId().contentEquals(entry.getId())) continue;
                throw new IllegalArgumentException("issuer with the same id (fingerprint) " + entry.getId() + " already available");
            }
            this.entries.add(entry);
            idSet.add(entry.getId());
        }
        this.ids = Collections.unmodifiableSet(idSet);
    }

    public int size() {
        return this.ids.size();
    }

    public Set<String> getIds() {
        return this.ids;
    }

    public EjbcaIssuerEntry getIssuerForId(String id) {
        for (EjbcaIssuerEntry entry : this.entries) {
            if (!entry.getId().contentEquals(id)) continue;
            return entry;
        }
        return null;
    }

    public EjbcaIssuerEntry getIssuerForFp(RequestIssuer reqIssuer) {
        for (EjbcaIssuerEntry entry : this.entries) {
            if (!entry.matchHash(reqIssuer)) continue;
            return entry;
        }
        return null;
    }
}

