/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.type;

import java.math.BigInteger;
import org.xipki.ocsp.api.RequestIssuer;
import org.xipki.ocsp.server.type.ASN1Type;

public class CertID
extends ASN1Type {
    private final RequestIssuer issuer;
    private final BigInteger serialNumber;
    private final int bodyLength;
    private final int encodedLength;

    public CertID(RequestIssuer issuer, BigInteger serialNumber) {
        this.issuer = issuer;
        this.serialNumber = serialNumber;
        int len = issuer.getLength();
        int snBytesLen = 1 + serialNumber.bitLength() / 8;
        this.bodyLength = len += CertID.getLen(snBytesLen);
        this.encodedLength = CertID.getLen(this.bodyLength);
    }

    public RequestIssuer getIssuer() {
        return this.issuer;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    @Override
    public int getEncodedLength() {
        return this.encodedLength;
    }

    @Override
    public int write(byte[] out, int offset) {
        int idx = offset;
        idx += CertID.writeHeader((byte)48, this.bodyLength, out, idx);
        idx += this.issuer.write(out, idx);
        byte[] snBytes = this.serialNumber.toByteArray();
        idx += CertID.writeHeader((byte)2, snBytes.length, out, idx);
        idx += CertID.arraycopy(snBytes, out, idx);
        return idx - offset;
    }
}

