/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.ocsp.OCSPRequest;
import org.bouncycastle.asn1.ocsp.OCSPResponse;
import org.bouncycastle.asn1.ocsp.OCSPResponseStatus;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.datasource.DataSourceConf;
import org.xipki.datasource.DataSourceFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.license.api.OcspLicense;
import org.xipki.ocsp.api.CertStatusInfo;
import org.xipki.ocsp.api.OcspRespWithCacheInfo;
import org.xipki.ocsp.api.OcspServer;
import org.xipki.ocsp.api.OcspStore;
import org.xipki.ocsp.api.OcspStoreException;
import org.xipki.ocsp.api.RequestIssuer;
import org.xipki.ocsp.api.Responder;
import org.xipki.ocsp.api.ResponderAndPath;
import org.xipki.ocsp.server.OCSPRespBuilder;
import org.xipki.ocsp.server.OcspResponseStatus;
import org.xipki.ocsp.server.OcspServerConf;
import org.xipki.ocsp.server.OcspServerUtil;
import org.xipki.ocsp.server.QuadrupleState;
import org.xipki.ocsp.server.RequestOption;
import org.xipki.ocsp.server.ResponderImpl;
import org.xipki.ocsp.server.ResponderOption;
import org.xipki.ocsp.server.ResponseSigner;
import org.xipki.ocsp.server.Template;
import org.xipki.ocsp.server.store.IssuerEntry;
import org.xipki.ocsp.server.store.ResponseCacher;
import org.xipki.ocsp.server.type.CertID;
import org.xipki.ocsp.server.type.EncodingException;
import org.xipki.ocsp.server.type.ExtendedExtension;
import org.xipki.ocsp.server.type.Extension;
import org.xipki.ocsp.server.type.Extensions;
import org.xipki.ocsp.server.type.OID;
import org.xipki.ocsp.server.type.OcspRequest;
import org.xipki.ocsp.server.type.ResponderID;
import org.xipki.ocsp.server.type.TaggedCertSequence;
import org.xipki.ocsp.server.type.WritableOnlyExtension;
import org.xipki.password.PasswordResolverException;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.HashAlgo;
import org.xipki.security.NoIdleSignerException;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignAlgo;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.Hex;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.InvalidConfException;

public class OcspServerImpl
implements OcspServer {
    private static final byte[] DERNullBytes = new byte[]{5, 0};
    private static final byte[] bytes_certstatus_good = new byte[]{-128, 0};
    private static final byte[] bytes_certstatus_unknown = new byte[]{-126, 0};
    private static final byte[] bytes_certstatus_rfc6960_unknown = Hex.decode((String)"a116180f31393730303130313030303030305aa0030a0106");
    private static final WritableOnlyExtension extension_pkix_ocsp_extendedRevoke;
    private static final Logger LOG;
    private static final Map<OcspResponseStatus, OcspRespWithCacheInfo> unsuccesfulOCSPRespMap;
    private static final byte[] encodedAcceptableResponses_Basic;
    private static final String version;
    private final DataSourceFactory datasourceFactory;
    private SecurityFactory securityFactory;
    private String confFile;
    private boolean master;
    private final OcspLicense license;
    private CertStatusInfo.UnknownIssuerBehaviour unknownIssuerBehaviour = CertStatusInfo.UnknownIssuerBehaviour.unknown;
    private ResponseCacher responseCacher;
    private final Map<String, ResponderImpl> responders = new HashMap<String, ResponderImpl>();
    private final Map<String, ResponseSigner> signers = new HashMap<String, ResponseSigner>();
    private final Map<String, RequestOption> requestOptions = new HashMap<String, RequestOption>();
    private final Map<String, OcspServerConf.ResponseOption> responseOptions = new HashMap<String, OcspServerConf.ResponseOption>();
    private final Map<String, OcspStore> stores = new HashMap<String, OcspStore>();
    private final List<String> servletPaths = new ArrayList<String>();
    private final Map<String, ResponderImpl> path2responderMap = new HashMap<String, ResponderImpl>();
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    public OcspServerImpl(OcspLicense license) {
        LOG.info("XiPKI OCSP Responder version {}", (Object)version);
        this.datasourceFactory = new DataSourceFactory();
        this.license = (OcspLicense)Args.notNull((Object)license, (String)"license");
    }

    public void setSecurityFactory(SecurityFactory securityFactory) {
        this.securityFactory = securityFactory;
    }

    public void setConfFile(String confFile) {
        this.confFile = confFile;
    }

    public ResponderAndPath getResponderForPath(String path) {
        for (String servletPath : this.servletPaths) {
            if (!path.startsWith(servletPath)) continue;
            return new ResponderAndPath(servletPath, (Responder)this.path2responderMap.get(servletPath));
        }
        return null;
    }

    public ResponderImpl getResponder(String name) {
        return this.responders.get(Args.notBlank((String)name, (String)"name"));
    }

    public boolean isInitialized() {
        return this.initialized.get();
    }

    public void init() throws InvalidConfException, PasswordResolverException {
        this.init(true);
    }

    public void init(boolean force) throws InvalidConfException, PasswordResolverException {
        LOG.info("starting OCSPResponder server ...");
        if (this.initialized.get() && !force) {
            LOG.info("already started, skipping ...");
            return;
        }
        try {
            this.init0();
            this.initialized.set(true);
            LOG.info("started OCSPResponder server");
        }
        catch (Error | RuntimeException | PasswordResolverException | InvalidConfException ex) {
            LOG.error("could not start OCSP responder", ex);
            throw ex;
        }
        catch (Throwable th) {
            LOG.error("could not start OCSP responder", th);
            throw new IllegalStateException(th);
        }
    }

    private void init0() throws OcspStoreException, InvalidConfException, PasswordResolverException {
        OcspServerConf.ResponseCache responseCache;
        String name;
        if (this.confFile == null) {
            throw new IllegalStateException("confFile is not set");
        }
        if (this.datasourceFactory == null) {
            throw new IllegalStateException("datasourceFactory is not set");
        }
        if (this.securityFactory == null) {
            throw new IllegalStateException("securityFactory is not set");
        }
        this.initialized.set(false);
        this.responseCacher = null;
        this.responders.clear();
        this.signers.clear();
        this.requestOptions.clear();
        this.responseOptions.clear();
        for (Map.Entry<String, OcspStore> entry : this.stores.entrySet()) {
            OcspStore store = entry.getValue();
            try {
                store.close();
            }
            catch (IOException iOException) {
                throw new OcspStoreException("could not close OCSP store " + entry.getKey(), (Throwable)iOException);
            }
        }
        this.stores.clear();
        this.servletPaths.clear();
        this.path2responderMap.clear();
        OcspServerConf conf = OcspServerUtil.parseConf(this.confFile);
        HashSet<String> set = new HashSet<String>();
        for (OcspServerConf.Responder responder : conf.getResponders()) {
            name = responder.getName();
            if (StringUtil.orEqualsIgnoreCase((String)name, (String[])new String[]{"health", "mgmt"})) {
                throw new InvalidConfException("responder name '" + name + "' is not permitted");
            }
            if (set.contains(name)) {
                throw new InvalidConfException("duplicated definition of responder named '" + name + "'");
            }
            if (StringUtil.isBlank((String)name)) {
                throw new InvalidConfException("responder name may not be empty");
            }
            for (int i = 0; i < name.length(); ++i) {
                char ch = name.charAt(i);
                if (ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch == '-' || ch == '_' || ch == '.') continue;
                throw new InvalidConfException("invalid OCSP responder name '" + name + "'");
            }
            set.add(name);
        }
        set.clear();
        for (OcspServerConf.Signer signer : conf.getSigners()) {
            name = signer.getName();
            if (set.contains(name)) {
                throw new InvalidConfException("duplicated definition of signer option named '" + name + "'");
            }
            set.add(name);
        }
        set.clear();
        for (OcspServerConf.RequestOption requestOption : conf.getRequestOptions()) {
            name = requestOption.getName();
            if (set.contains(name)) {
                throw new InvalidConfException("duplicated definition of request option named '" + name + "'");
            }
            set.add(name);
        }
        set.clear();
        for (OcspServerConf.ResponseOption responseOption : conf.getResponseOptions()) {
            name = responseOption.getName();
            if (set.contains(name)) {
                throw new InvalidConfException("duplicated definition of response option named '" + name + "'");
            }
            set.add(name);
        }
        set.clear();
        for (OcspServerConf.Store store : conf.getStores()) {
            name = store.getName();
            if (set.contains(name)) {
                throw new InvalidConfException("duplicated definition of store named '" + name + "'");
            }
            set.add(name);
        }
        set.clear();
        if (conf.getDatasources() != null) {
            for (DataSourceConf dataSourceConf : conf.getDatasources()) {
                name = dataSourceConf.getName();
                if (set.contains(name)) {
                    throw new InvalidConfException("duplicated definition of datasource named '" + name + "'");
                }
                set.add(name);
            }
        }
        HashSet<String> crlsDirs = new HashSet<String>();
        for (OcspServerConf.Store m : conf.getStores()) {
            String canonicalPath;
            Object obj;
            OcspServerConf.Source source = m.getSource();
            if (!"crl".equalsIgnoreCase(source.getType()) || !((obj = source.getConf().get("dir")) instanceof String)) continue;
            File file = new File((String)obj);
            try {
                canonicalPath = file.getCanonicalPath();
            }
            catch (IOException ex) {
                throw new InvalidConfException("error getCanonicalPath:" + ex.getMessage());
            }
            if (crlsDirs.contains(canonicalPath)) {
                throw new InvalidConfException("duplicated use of dir '" + canonicalPath + "' in store " + m.getName());
            }
            crlsDirs.add(canonicalPath);
        }
        this.master = conf.isMaster();
        this.unknownIssuerBehaviour = conf.getUnknownIssuerBehaviour();
        if (this.unknownIssuerBehaviour == null) {
            this.unknownIssuerBehaviour = CertStatusInfo.UnknownIssuerBehaviour.unknown;
        }
        if ((responseCache = conf.getResponseCache()) != null) {
            DataSourceWrapper datasource;
            DataSourceConf cacheSourceConf = responseCache.getDatasource();
            InputStream dsStream = null;
            try {
                dsStream = OcspServerUtil.getInputStream(cacheSourceConf.getConf());
                datasource = this.datasourceFactory.createDataSource(cacheSourceConf.getName(), dsStream, this.securityFactory.getPasswordResolver());
            }
            catch (IOException iOException) {
                throw new InvalidConfException(iOException.getMessage(), (Throwable)iOException);
            }
            finally {
                OcspServerUtil.closeStream(dsStream);
            }
            this.responseCacher = new ResponseCacher(datasource, this.master, responseCache.validity());
            this.responseCacher.init();
        }
        for (OcspServerConf.Signer m : conf.getSigners()) {
            this.signers.put(m.getName(), OcspServerUtil.initSigner(m, this.securityFactory));
        }
        for (OcspServerConf.RequestOption m : conf.getRequestOptions()) {
            this.requestOptions.put(m.getName(), new RequestOption(m));
        }
        for (OcspServerConf.ResponseOption m : conf.getResponseOptions()) {
            this.responseOptions.put(m.getName(), m);
        }
        HashMap<String, DataSourceWrapper> datasources = new HashMap<String, DataSourceWrapper>();
        if (conf.getDatasources() != null) {
            for (DataSourceConf m : conf.getDatasources()) {
                DataSourceWrapper datasource;
                String string = m.getName();
                InputStream dsStream = null;
                try {
                    dsStream = OcspServerUtil.getInputStream(m.getConf());
                    datasource = this.datasourceFactory.createDataSource(string, dsStream, this.securityFactory.getPasswordResolver());
                }
                catch (IOException ex) {
                    throw new InvalidConfException(ex.getMessage(), (Throwable)ex);
                }
                finally {
                    OcspServerUtil.closeStream(dsStream);
                }
                datasources.put(string, datasource);
            }
        }
        HashMap<String, ResponderOption> responderOptions = new HashMap<String, ResponderOption>();
        for (OcspServerConf.Responder responder : conf.getResponders()) {
            ResponderOption option = new ResponderOption(responder);
            String optName = option.getSignerName();
            if (!this.signers.containsKey(optName)) {
                throw new InvalidConfException("no signer named '" + optName + "' is defined");
            }
            String reqOptName = option.getRequestOptionName();
            if (!this.requestOptions.containsKey(reqOptName)) {
                throw new InvalidConfException("no requestOption named '" + reqOptName + "' is defined");
            }
            String respOptName = option.getResponseOptionName();
            if (!this.responseOptions.containsKey(respOptName)) {
                throw new InvalidConfException("no responseOption named '" + (String)respOptName + "' is defined");
            }
            responderOptions.put(responder.getName(), option);
        }
        for (OcspServerConf.Store store : conf.getStores()) {
            OcspStore store2 = OcspServerUtil.newStore(store, datasources);
            this.stores.put(store.getName(), store2);
        }
        for (Map.Entry entry : responderOptions.entrySet()) {
            String name3 = (String)entry.getKey();
            ResponderOption option = (ResponderOption)entry.getValue();
            ArrayList<OcspStore> statusStores = new ArrayList<OcspStore>(option.getStoreNames().size());
            for (String storeName : option.getStoreNames()) {
                statusStores.add(this.stores.get(storeName));
            }
            OcspServerConf.ResponseOption responseOption = this.responseOptions.get(option.getResponseOptionName());
            ResponseSigner signer = this.signers.get(option.getSignerName());
            if (signer.isMacSigner()) {
                if (responseOption.isResponderIdByName()) {
                    throw new InvalidConfException("could not use ResponderIdByName for signer " + option.getSignerName());
                }
                if (OcspServerConf.EmbedCertsMode.NONE != responseOption.getEmbedCertsMode()) {
                    throw new InvalidConfException("could not embed certifcate in response for signer " + option.getSignerName());
                }
            }
            ResponderImpl responder = new ResponderImpl(option, this.requestOptions.get(option.getRequestOptionName()), responseOption, signer, statusStores);
            this.responders.put(name3, responder);
        }
        LinkedList<String> tmpList = new LinkedList<String>();
        for (Map.Entry entry : responderOptions.entrySet()) {
            String name4 = (String)entry.getKey();
            ResponderImpl responder = this.responders.get(name4);
            ResponderOption option = (ResponderOption)entry.getValue();
            List<String> strs = option.getServletPaths();
            for (String path : strs) {
                tmpList.add(path);
                this.path2responderMap.put(path, responder);
            }
        }
        tmpList.sort((o1, o2) -> o2.length() - o1.length());
        this.servletPaths.clear();
        this.servletPaths.addAll(tmpList);
    }

    public void close() {
        LOG.info("stopped OCSP Responder");
        if (this.responseCacher != null) {
            this.responseCacher.close();
        }
        for (OcspStore store : this.stores.values()) {
            try {
                store.close();
            }
            catch (Exception ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("shutdown store " + store.getName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OcspRespWithCacheInfo answer(Responder responder2, byte[] request, boolean viaGet) {
        int version;
        ResponderImpl responder = (ResponderImpl)responder2;
        RequestOption reqOpt = responder.getRequestOption();
        try {
            version = OcspRequest.readRequestVersion(request);
        }
        catch (EncodingException ex) {
            String message = "could not extract version from request";
            LOG.warn(message);
            return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
        }
        if (!reqOpt.isVersionAllowed(version)) {
            String message = "invalid request version " + version;
            LOG.warn(message);
            return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
        }
        ResponseSigner signer = responder.getSigner();
        OcspServerConf.ResponseOption repOpt = responder.getResponseOption();
        try {
            byte[] encodeOcspResponse;
            OcspServerConf.EmbedCertsMode certsMode;
            boolean canCacheDb;
            ExtendedExtension extn;
            ExtendedExtension nonceExtn;
            Object reqOrErrorResp = this.checkSignature(request, reqOpt);
            if (reqOrErrorResp instanceof OcspRespWithCacheInfo) {
                return (OcspRespWithCacheInfo)reqOrErrorResp;
            }
            OcspRequest req = (OcspRequest)reqOrErrorResp;
            List<CertID> requestList = req.getRequestList();
            int requestsSize = requestList.size();
            if (requestsSize > reqOpt.getMaxRequestListCount()) {
                String message = requestsSize + " entries in RequestList, but maximal " + reqOpt.getMaxRequestListCount() + " is allowed";
                LOG.warn(message);
                return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
            }
            if (!this.license.isValid()) {
                LOG.error("License not valid, need new license");
                return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.internalError);
            }
            if (!this.license.grantAllCAs()) {
                for (CertID cid : requestList) {
                    for (OcspStore store : responder.getStores()) {
                        String issuerSubject;
                        boolean granted;
                        X509Cert caCert = store.getIssuerCert(cid.getIssuer());
                        if (caCert == null || (granted = this.license.grant(issuerSubject = caCert.getSubjectText()))) continue;
                        LOG.error("Not granted for CA {}, need new license", (Object)issuerSubject);
                        return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.internalError);
                    }
                }
            }
            this.license.regulateSpeed();
            OcspRespControl repControl = new OcspRespControl();
            repControl.canCacheInfo = true;
            List<ExtendedExtension> reqExtensions = req.getExtensions();
            LinkedList<Extension> respExtensions = new LinkedList<Extension>();
            ExtendedExtension ocspRespExtn = OcspServerUtil.removeExtension(reqExtensions, OID.ID_PKIX_OCSP_RESPONSE);
            if (ocspRespExtn != null) {
                boolean containsBasic = ocspRespExtn.equalsExtnValue(encodedAcceptableResponses_Basic);
                if (!containsBasic) {
                    byte[] extnValue = new byte[ocspRespExtn.getExtnValueLength()];
                    ocspRespExtn.writeExtnValue(extnValue, 0);
                    ASN1Sequence seq = ASN1Sequence.getInstance((Object)extnValue);
                    int size = seq.size();
                    for (int i = 0; i < size; ++i) {
                        ASN1ObjectIdentifier oid = ASN1ObjectIdentifier.getInstance((Object)seq.getObjectAt(i));
                        if (!OCSPObjectIdentifiers.id_pkix_ocsp_basic.equals((ASN1Primitive)oid)) continue;
                        containsBasic = true;
                        break;
                    }
                }
                if (!containsBasic) {
                    LOG.warn("basic OCSP response is not accepted by the client");
                    return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
                }
            }
            if ((nonceExtn = OcspServerUtil.removeExtension(reqExtensions, OID.ID_PKIX_OCSP_NONCE)) != null) {
                if (reqOpt.getNonceOccurrence() == QuadrupleState.forbidden) {
                    LOG.warn("nonce forbidden, but is present in the request");
                    return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
                }
                if (reqOpt.getNonceOccurrence() == QuadrupleState.ignore) {
                    nonceExtn = null;
                } else {
                    int len = nonceExtn.getExtnValueLength();
                    int min = reqOpt.getNonceMinLen();
                    int max = reqOpt.getNonceMaxLen();
                    if (len < min || len > max) {
                        LOG.warn("length of nonce {} not within [{},{}]", new Object[]{len, min, max});
                        return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
                    }
                    repControl.canCacheInfo = false;
                    if (nonceExtn.isCritical()) {
                        respExtensions.add(nonceExtn.revertCritical());
                    } else {
                        respExtensions.add(nonceExtn);
                    }
                }
            } else if (reqOpt.getNonceOccurrence() == QuadrupleState.required) {
                LOG.warn("nonce required, but is not present in the request");
                return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
            }
            ConcurrentContentSigner concurrentSigner = null;
            if (responder.getResponderOption().getMode() != ResponderOption.OcspMode.RFC2560 && (extn = OcspServerUtil.removeExtension(reqExtensions, OID.ID_PKIX_OCSP_PREFSIGALGS)) != null) {
                ArrayList<AlgorithmIdentifier> prefSigAlgs;
                try (ASN1InputStream asn1Stream = new ASN1InputStream(extn.getExtnValueStream());){
                    ASN1Sequence seq = ASN1Sequence.getInstance((Object)asn1Stream.readObject());
                    int size = seq.size();
                    prefSigAlgs = new ArrayList<AlgorithmIdentifier>(size);
                    for (int i = 0; i < size; ++i) {
                        prefSigAlgs.add(AlgorithmIdentifier.getInstance((Object)seq.getObjectAt(i)));
                    }
                }
                concurrentSigner = signer.getSignerForPreferredSigAlgs(prefSigAlgs);
            }
            if (!reqExtensions.isEmpty()) {
                boolean flag = false;
                for (ExtendedExtension m : reqExtensions) {
                    if (!m.isCritical()) continue;
                    flag = true;
                    break;
                }
                if (flag) {
                    if (LOG.isWarnEnabled()) {
                        LinkedList<OID> oids = new LinkedList<OID>();
                        for (ExtendedExtension m : reqExtensions) {
                            if (!m.isCritical()) continue;
                            oids.add(m.getExtnType());
                        }
                        LOG.warn("could not process critical request extensions: {}", oids);
                    }
                    return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
                }
            }
            if (concurrentSigner == null) {
                concurrentSigner = signer.getFirstSigner();
            }
            SignAlgo cacheDbSigAlg = null;
            BigInteger cacheDbSerialNumber = null;
            IssuerEntry cacheDbIssuer = null;
            boolean bl = canCacheDb = requestsSize == 1 && this.responseCacher != null && nonceExtn == null && this.responseCacher.isOnService();
            if (canCacheDb) {
                CertID certId = requestList.get(0);
                HashAlgo reqHashAlgo = certId.getIssuer().hashAlgorithm();
                if (!reqOpt.allows(reqHashAlgo)) {
                    LOG.warn("CertID.hashAlgorithm {} not allowed", reqHashAlgo != null ? reqHashAlgo : certId.getIssuer().hashAlgorithmOID());
                    return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
                }
                cacheDbSigAlg = concurrentSigner.getAlgorithm();
                cacheDbIssuer = this.responseCacher.getIssuer(certId.getIssuer());
                cacheDbSerialNumber = certId.getSerialNumber();
                if (cacheDbIssuer != null) {
                    OcspRespWithCacheInfo cachedResp = this.responseCacher.getOcspResponse(cacheDbIssuer.getId(), cacheDbSerialNumber, cacheDbSigAlg);
                    if (cachedResp != null) {
                        if (this.license.grant(cacheDbIssuer.getCert().getSubjectText())) {
                            return cachedResp;
                        }
                        LOG.error("Not granted, new license needed");
                        return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
                    }
                } else if (this.master) {
                    OcspStore store;
                    X509Cert issuerCert = null;
                    Iterator<OcspStore> iterator = responder.getStores().iterator();
                    while (iterator.hasNext() && (issuerCert = (store = iterator.next()).getIssuerCert(certId.getIssuer())) == null) {
                    }
                    if (issuerCert != null) {
                        cacheDbIssuer = this.responseCacher.storeIssuer(issuerCert);
                    }
                }
                if (cacheDbIssuer == null) {
                    canCacheDb = false;
                }
            }
            ResponderID responderId = signer.getResponderId(repOpt.isResponderIdByName());
            OCSPRespBuilder builder = new OCSPRespBuilder(responderId);
            boolean unknownAsRevoked = false;
            AtomicBoolean unknownAsRevoked0 = new AtomicBoolean(false);
            for (CertID certID : requestList) {
                OcspRespWithCacheInfo failureOcspResp = this.processCertReq(unknownAsRevoked0, certID, builder, responder, reqOpt, repOpt, repControl);
                if (failureOcspResp != null) {
                    return failureOcspResp;
                }
                if (!unknownAsRevoked0.get()) continue;
                unknownAsRevoked = true;
            }
            if (unknownAsRevoked && repControl.includeExtendedRevokeExtension) {
                respExtensions.add(extension_pkix_ocsp_extendedRevoke);
            }
            if (!respExtensions.isEmpty()) {
                builder.setResponseExtensions(new Extensions(respExtensions));
            }
            TaggedCertSequence certsInResp = (certsMode = repOpt.getEmbedCertsMode()) == OcspServerConf.EmbedCertsMode.SIGNER ? signer.getSequenceOfCert() : (certsMode == OcspServerConf.EmbedCertsMode.NONE ? null : signer.getSequenceOfCertChain());
            Date producedAt = new Date();
            try {
                encodeOcspResponse = builder.buildOCSPResponse(concurrentSigner, certsInResp, producedAt);
            }
            catch (NoIdleSignerException ex) {
                return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.tryLater);
            }
            catch (OCSPException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)"answer() basicOcspBuilder.build");
                return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.internalError);
            }
            long producedAtSeconds = producedAt.getTime() / 1000L;
            if (canCacheDb && repControl.canCacheInfo) {
                this.responseCacher.storeOcspResponse(cacheDbIssuer.getId(), cacheDbSerialNumber, producedAtSeconds, repControl.cacheNextUpdate, cacheDbSigAlg, encodeOcspResponse);
            }
            if (viaGet && repControl.canCacheInfo) {
                OcspRespWithCacheInfo.ResponseCacheInfo cacheInfo = new OcspRespWithCacheInfo.ResponseCacheInfo(producedAtSeconds);
                if (repControl.cacheNextUpdate != Long.MAX_VALUE) {
                    cacheInfo.setNextUpdate(Long.valueOf(repControl.cacheNextUpdate));
                }
                return new OcspRespWithCacheInfo(encodeOcspResponse, cacheInfo);
            }
            return new OcspRespWithCacheInfo(encodeOcspResponse, null);
        }
        catch (Throwable th) {
            LogUtil.error((Logger)LOG, (Throwable)th);
            return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.internalError);
        }
    }

    private OcspRespWithCacheInfo processCertReq(AtomicBoolean unknownAsRevoked, CertID certId, OCSPRespBuilder builder, ResponderImpl responder, RequestOption reqOpt, OcspServerConf.ResponseOption repOpt, OcspRespControl repControl) {
        byte[] certHash;
        byte[] certStatus;
        Date thisUpdate;
        HashAlgo reqHashAlgo = certId.getIssuer().hashAlgorithm();
        if (!reqOpt.allows(reqHashAlgo)) {
            LOG.warn("CertID.hashAlgorithm {} not allowed", (Object)reqHashAlgo);
            return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
        }
        CertStatusInfo certStatusInfo = null;
        boolean exceptionOccurs = false;
        BigInteger serial = certId.getSerialNumber();
        RequestIssuer reqIssuer = certId.getIssuer();
        Date now = new Date();
        for (OcspStore store : responder.getStores()) {
            if (!store.knowsIssuer(reqIssuer)) continue;
            try {
                block39: {
                    CertStatusInfo.CertStatus status;
                    block38: {
                        certStatusInfo = store.getCertStatus(now, certId.getIssuer(), serial, repOpt.isIncludeCerthash(), repOpt.isIncludeInvalidityDate(), responder.getResponderOption().isInheritCaRevocation());
                        if (certStatusInfo == null) continue;
                        status = certStatusInfo.getCertStatus();
                        if (status != CertStatusInfo.CertStatus.UNKNOWN && status != CertStatusInfo.CertStatus.IGNORE) break block38;
                        switch (store.getUnknownCertBehaviour()) {
                            case good: {
                                if (status == CertStatusInfo.CertStatus.UNKNOWN) {
                                    certStatusInfo.setCertStatus(CertStatusInfo.CertStatus.GOOD);
                                    break;
                                }
                                break block39;
                            }
                            case malformedRequest: {
                                return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
                            }
                            case internalError: {
                                return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.internalError);
                            }
                            case tryLater: {
                                return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.tryLater);
                            }
                        }
                        break block39;
                    }
                    if (status == CertStatusInfo.CertStatus.CRL_EXPIRED) {
                        return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.tryLater);
                    }
                }
                exceptionOccurs = false;
                break;
            }
            catch (OcspStoreException ex) {
                exceptionOccurs = true;
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("getCertStatus() of CertStatusStore " + store.getName()));
            }
        }
        if (exceptionOccurs) {
            return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.tryLater);
        }
        if (certStatusInfo == null) {
            LOG.info("issuer unknown, return {}", (Object)this.unknownIssuerBehaviour);
            switch (this.unknownIssuerBehaviour) {
                case unknown: {
                    long msPerDay = 86400000L;
                    Date nextUpdate = new Date(now.getTime() + 86400000L);
                    certStatusInfo = CertStatusInfo.getIssuerUnknownCertStatusInfo((Date)now, (Date)nextUpdate);
                    break;
                }
                case malformedRequest: {
                    return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
                }
                case unauthorized: {
                    return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.unauthorized);
                }
                case internalError: {
                    return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.internalError);
                }
                case tryLater: {
                    return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.tryLater);
                }
                default: {
                    throw new IllegalStateException("unreachable code");
                }
            }
        }
        if ((thisUpdate = certStatusInfo.getThisUpdate()) == null) {
            thisUpdate = new Date();
        }
        Date nextUpdate = certStatusInfo.getNextUpdate();
        LinkedList<Extension> extensions = new LinkedList<Extension>();
        unknownAsRevoked.set(false);
        switch (certStatusInfo.getCertStatus()) {
            case GOOD: {
                certStatus = bytes_certstatus_good;
                break;
            }
            case ISSUER_UNKNOWN: {
                repControl.canCacheInfo = false;
                certStatus = bytes_certstatus_unknown;
                break;
            }
            case UNKNOWN: 
            case IGNORE: {
                repControl.canCacheInfo = false;
                if (responder.getResponderOption().getMode() == ResponderOption.OcspMode.RFC2560) {
                    certStatus = bytes_certstatus_unknown;
                    break;
                }
                unknownAsRevoked.set(true);
                certStatus = bytes_certstatus_rfc6960_unknown;
                break;
            }
            case REVOKED: {
                CertRevocationInfo revInfo = certStatusInfo.getRevocationInfo();
                certStatus = Template.getEncodeRevokedInfo(repOpt.isIncludeRevReason() ? revInfo.getReason() : null, revInfo.getRevocationTime());
                Date invalidityDate = revInfo.getInvalidityTime();
                if (!repOpt.isIncludeInvalidityDate() || invalidityDate == null || invalidityDate.equals(revInfo.getRevocationTime())) break;
                extensions.add(Template.getInvalidityDateExtension(invalidityDate));
                break;
            }
            default: {
                throw new IllegalStateException("unknown CertificateStatus:" + certStatusInfo.getCertStatus());
            }
        }
        if (responder.getResponderOption().getMode() != ResponderOption.OcspMode.RFC2560) {
            repControl.includeExtendedRevokeExtension = true;
        }
        if ((certHash = certStatusInfo.getCertHash()) != null) {
            extensions.add(Template.getCertHashExtension(certStatusInfo.getCertHashAlgo(), certHash));
        }
        if (certStatusInfo.getArchiveCutOff() != null) {
            extensions.add(Template.getArchiveOffExtension(certStatusInfo.getArchiveCutOff()));
        }
        if (LOG.isDebugEnabled()) {
            String certStatusText = Arrays.equals(certStatus, bytes_certstatus_good) ? "good" : (Arrays.equals(certStatus, bytes_certstatus_unknown) ? "unknown" : (Arrays.equals(certStatus, bytes_certstatus_rfc6960_unknown) ? "RFC6960_unknown" : (unknownAsRevoked.get() ? "unknown_as_revoked" : "revoked")));
            String msg = StringUtil.concatObjectsCap((int)250, (Object)"issuer: ", (Object[])new Object[]{certId.getIssuer(), ", serialNumber: ", LogUtil.formatCsn((BigInteger)certId.getSerialNumber()), ", certStatus: ", certStatusText, ", thisUpdate: ", thisUpdate, ", nextUpdate: ", nextUpdate});
            if (certHash == null) {
                LOG.debug(msg);
            } else {
                LOG.debug(msg + ", certHash: " + Hex.encode((byte[])certHash));
            }
        }
        if (CollectionUtil.isEmpty(extensions)) {
            builder.addResponse(certId, certStatus, thisUpdate, nextUpdate, null);
        } else {
            builder.addResponse(certId, certStatus, thisUpdate, nextUpdate, new Extensions(extensions));
        }
        if (nextUpdate != null) {
            repControl.cacheNextUpdate = Math.min(repControl.cacheNextUpdate, nextUpdate.getTime() / 1000L);
        }
        return null;
    }

    public boolean healthCheck(Responder responder2) {
        ResponderImpl responder = (ResponderImpl)responder2;
        for (OcspStore store : responder.getStores()) {
            boolean storeHealthy = store.isHealthy();
            if (storeHealthy) continue;
            return false;
        }
        return responder.getSigner().isHealthy();
    }

    private Object checkSignature(byte[] request, RequestOption requestOption) throws OCSPException {
        ContentVerifierProvider cvp;
        OCSPRequest req;
        try {
            if (!requestOption.isValidateSignature()) {
                return OcspRequest.getInstance(request);
            }
            if (!OcspRequest.containsSignature(request)) {
                if (requestOption.isSignatureRequired()) {
                    LOG.warn("signature in request required");
                    return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.sigRequired);
                }
                return OcspRequest.getInstance(request);
            }
            try {
                req = OCSPRequest.getInstance((Object)request);
            }
            catch (IllegalArgumentException ex) {
                throw new EncodingException("could not parse OCSP request", ex);
            }
        }
        catch (EncodingException ex) {
            return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
        }
        OCSPReq ocspReq = new OCSPReq(req);
        X509CertificateHolder[] bcCerts = ocspReq.getCerts();
        if (bcCerts == null || bcCerts.length < 1) {
            LOG.warn("no certificate found in request to verify the signature");
            return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.unauthorized);
        }
        X509Cert[] certs = new X509Cert[bcCerts.length];
        for (int i = 0; i < certs.length; ++i) {
            certs[i] = new X509Cert(bcCerts[i]);
        }
        try {
            cvp = this.securityFactory.getContentVerifierProvider(certs[0]);
        }
        catch (InvalidKeyException ex) {
            String message = ex.getMessage();
            LOG.warn("securityFactory.getContentVerifierProvider, InvalidKeyException: {}", (Object)message);
            return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.unauthorized);
        }
        if (!ocspReq.isSignatureValid(cvp)) {
            LOG.warn("request signature is invalid");
            return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.unauthorized);
        }
        Date referenceTime = new Date();
        if (OcspServerUtil.canBuildCertpath(certs, requestOption, referenceTime)) {
            try {
                return OcspRequest.getInstance(req);
            }
            catch (EncodingException ex) {
                return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
            }
        }
        LOG.warn("could not build certpath for the request's signer certificate");
        return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.unauthorized);
    }

    static {
        LOG = LoggerFactory.getLogger(OcspServerImpl.class);
        unsuccesfulOCSPRespMap = new HashMap<OcspResponseStatus, OcspRespWithCacheInfo>(10);
        for (OcspResponseStatus status : OcspResponseStatus.values()) {
            byte[] encoded;
            if (status == OcspResponseStatus.successful) continue;
            OCSPResponse resp = new OCSPResponse(new OCSPResponseStatus(status.getStatus()), null);
            try {
                encoded = resp.getEncoded();
            }
            catch (IOException ex) {
                throw new ExceptionInInitializerError("could not encode OCSPResp for status " + (Object)((Object)status) + ": " + ex.getMessage());
            }
            unsuccesfulOCSPRespMap.put(status, new OcspRespWithCacheInfo(encoded, null));
        }
        ExtendedExtension ext = new ExtendedExtension(OID.ID_PKIX_OCSP_EXTENDEDREVOKE, false, DERNullBytes);
        byte[] encoded = new byte[ext.getEncodedLength()];
        ext.write(encoded, 0);
        extension_pkix_ocsp_extendedRevoke = new WritableOnlyExtension(encoded);
        encodedAcceptableResponses_Basic = Hex.decode((String)"300B06092B0601050507300101");
        version = StringUtil.getVersion(OcspServerImpl.class);
    }

    private static class OcspRespControl {
        boolean canCacheInfo;
        boolean includeExtendedRevokeExtension = false;
        long cacheNextUpdate = Long.MAX_VALUE;
    }
}

