/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.xipki.ocsp.server.OcspServerConf;
import org.xipki.ocsp.server.QuadrupleState;
import org.xipki.security.CertpathValidationModel;
import org.xipki.security.HashAlgo;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.FileOrBinary;
import org.xipki.util.exception.InvalidConfException;

public class RequestOption {
    static final Set<HashAlgo> SUPPORTED_HASH_ALGORITHMS = CollectionUtil.asSet((Object[])new HashAlgo[]{HashAlgo.SHA1, HashAlgo.SHA224, HashAlgo.SHA256, HashAlgo.SHA384, HashAlgo.SHA512, HashAlgo.SHA3_224, HashAlgo.SHA3_256, HashAlgo.SHA3_384, HashAlgo.SHA3_512, HashAlgo.SHAKE128, HashAlgo.SHAKE256, HashAlgo.SM3});
    private final boolean supportsHttpGet;
    private final boolean signatureRequired;
    private final boolean validateSignature;
    private final int maxRequestListCount;
    private final int maxRequestSize;
    private final Collection<Integer> versions;
    private final QuadrupleState nonceOccurrence;
    private final int nonceMinLen;
    private final int nonceMaxLen;
    private final Set<HashAlgo> hashAlgos;
    private final Set<X509Cert> trustanchors;
    private final Set<X509Cert> certs;
    private final CertpathValidationModel certpathValidationModel;

    RequestOption(OcspServerConf.RequestOption conf) throws InvalidConfException {
        Args.notNull((Object)((Object)conf), (String)"conf");
        this.supportsHttpGet = conf.isSupportsHttpGet();
        this.signatureRequired = conf.isSignatureRequired();
        this.validateSignature = conf.isValidateSignature();
        OcspServerConf.Nonce nonceConf = conf.getNonce();
        this.nonceOccurrence = conf.getNonce().getOccurrence();
        this.nonceMinLen = nonceConf.getMinLen() != null ? nonceConf.getMinLen() : 4;
        int n = this.nonceMaxLen = nonceConf.getMaxLen() != null ? nonceConf.getMaxLen() : 96;
        if (this.nonceMinLen < 0) {
            throw new InvalidConfException("invalid nonceMinLen (<1): " + this.nonceMinLen);
        }
        if (this.nonceMinLen > this.nonceMaxLen) {
            throw new InvalidConfException("nonceMinLen > nonceMaxLen");
        }
        this.maxRequestListCount = conf.getMaxRequestListCount();
        if (this.maxRequestListCount < 1) {
            throw new InvalidConfException("invalid maxRequestListCount " + this.maxRequestListCount);
        }
        this.maxRequestSize = conf.getMaxRequestSize();
        if (this.maxRequestSize < 100) {
            throw new InvalidConfException("invalid maxRequestSize " + this.maxRequestSize);
        }
        this.versions = new HashSet<Integer>();
        for (String m : conf.getVersions()) {
            if ("v1".equalsIgnoreCase(m)) {
                this.versions.add(0);
                continue;
            }
            throw new InvalidConfException("invalid OCSP request version '" + m + "'");
        }
        this.hashAlgos = new HashSet<HashAlgo>();
        if (conf.getHashAlgorithms().isEmpty()) {
            this.hashAlgos.addAll(SUPPORTED_HASH_ALGORITHMS);
        } else {
            for (String token : conf.getHashAlgorithms()) {
                HashAlgo algo;
                try {
                    algo = HashAlgo.getInstance((String)token);
                }
                catch (NoSuchAlgorithmException ex) {
                    throw new InvalidConfException(ex.getMessage());
                }
                if (SUPPORTED_HASH_ALGORITHMS.contains(algo)) {
                    this.hashAlgos.add(algo);
                    continue;
                }
                throw new InvalidConfException("hash algorithm " + token + " is unsupported");
            }
        }
        OcspServerConf.CertpathValidation certpathConf = conf.getCertpathValidation();
        if (certpathConf == null) {
            if (this.validateSignature) {
                throw new InvalidConfException("certpathValidation is not specified");
            }
            this.trustanchors = null;
            this.certs = null;
            this.certpathValidationModel = CertpathValidationModel.PKIX;
            return;
        }
        this.certpathValidationModel = certpathConf.getValidationModel();
        try {
            Set<X509Cert> tmpCerts = RequestOption.getCerts(certpathConf.getTrustanchors());
            this.trustanchors = new HashSet<X509Cert>(tmpCerts.size());
            this.trustanchors.addAll(tmpCerts);
        }
        catch (Exception ex) {
            throw new InvalidConfException("could not initialize the trustanchors: " + ex.getMessage(), (Throwable)ex);
        }
        OcspServerConf.CertCollection certsType = certpathConf.getCerts();
        try {
            this.certs = certsType == null ? null : RequestOption.getCerts(certsType);
        }
        catch (Exception ex) {
            throw new InvalidConfException("could not initialize the certs: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public Set<HashAlgo> getHashAlgos() {
        return this.hashAlgos;
    }

    public boolean isSignatureRequired() {
        return this.signatureRequired;
    }

    public boolean isValidateSignature() {
        return this.validateSignature;
    }

    public boolean supportsHttpGet() {
        return this.supportsHttpGet;
    }

    public QuadrupleState getNonceOccurrence() {
        return this.nonceOccurrence;
    }

    public int getMaxRequestListCount() {
        return this.maxRequestListCount;
    }

    public int getMaxRequestSize() {
        return this.maxRequestSize;
    }

    public int getNonceMinLen() {
        return this.nonceMinLen;
    }

    public int getNonceMaxLen() {
        return this.nonceMaxLen;
    }

    public boolean allows(HashAlgo hashAlgo) {
        return hashAlgo != null && this.hashAlgos.contains(hashAlgo);
    }

    public CertpathValidationModel getCertpathValidationModel() {
        return this.certpathValidationModel;
    }

    public Set<X509Cert> getTrustanchors() {
        return this.trustanchors;
    }

    public boolean isVersionAllowed(Integer version) {
        return this.versions == null || this.versions.contains(version);
    }

    public Set<X509Cert> getCerts() {
        return this.certs;
    }

    private static Set<X509Cert> getCerts(OcspServerConf.CertCollection conf) throws CertificateException, IOException {
        Args.notNull((Object)((Object)conf), (String)"conf");
        HashSet<X509Cert> tmpCerts = new HashSet<X509Cert>();
        if (conf.getCerts() != null) {
            for (FileOrBinary fn : conf.getCerts()) {
                tmpCerts.add(X509Util.parseCert((byte[])fn.readContent()));
            }
        } else if (conf.getDir() != null) {
            File dir = new File(conf.getDir());
            File[] files = dir.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!file.exists() || !file.isFile()) continue;
                    tmpCerts.add(X509Util.parseCert((File)file));
                }
            }
        } else {
            throw new IllegalStateException("should not happen, neither keystore nor dir is defined");
        }
        return tmpCerts;
    }
}

