/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.store;

import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.ocsp.api.CertStatusInfo;
import org.xipki.ocsp.api.OcspStore;
import org.xipki.ocsp.api.OcspStoreException;
import org.xipki.ocsp.api.RequestIssuer;
import org.xipki.ocsp.server.IssuerFilter;
import org.xipki.ocsp.server.OcspServerConf;
import org.xipki.ocsp.server.store.DbCertStatusStore;
import org.xipki.ocsp.server.store.IssuerEntry;
import org.xipki.ocsp.server.store.IssuerStore;
import org.xipki.ocsp.server.store.SimpleIssuerEntry;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.CrlReason;
import org.xipki.security.HashAlgo;
import org.xipki.security.X509Cert;
import org.xipki.security.util.JSON;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.CollectionUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.RandomUtil;

public class CaDbCertStatusStore
extends OcspStore {
    private DataSourceWrapper datasource;
    private static final Logger LOG = LoggerFactory.getLogger(CaDbCertStatusStore.class);
    private final StoreUpdateService storeUpdateService = new StoreUpdateService();
    private final Object lock = new Object();
    private final AtomicBoolean storeUpdateInProcess = new AtomicBoolean(false);
    private String sqlCsNoRit;
    private String sqlCs;
    private String sqlCsNoRitWithCertHash;
    private String sqlCsWithCertHash;
    private IssuerFilter issuerFilter;
    private final IssuerStore issuerStore = new IssuerStore();
    private HashAlgo certHashAlgo;
    private boolean initialized;
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;

    protected List<Runnable> getScheduledServices() {
        return Collections.singletonList(this.storeUpdateService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void updateIssuerStore() {
        if (this.storeUpdateInProcess.get()) {
            return;
        }
        Object object = this.lock;
        // MONITORENTER : object
        this.storeUpdateInProcess.set(true);
        try {
            String sha1Fp;
            byte[] certBytes;
            ResultSet rs;
            PreparedStatement ps;
            String sql;
            if (this.initialized) {
                sql = "SELECT ID,REV_INFO,CERT FROM CA";
                ps = this.preparedStatement("SELECT ID,REV_INFO,CERT FROM CA");
                rs = null;
                try {
                    boolean issuersUnchanged;
                    HashMap<Integer, SimpleIssuerEntry> newIssuers = new HashMap<Integer, SimpleIssuerEntry>();
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        certBytes = Base64.decode((String)rs.getString("CERT"));
                        if (!this.issuerFilter.includeAll() && !this.issuerFilter.includeIssuerWithSha1Fp(sha1Fp = HashAlgo.SHA1.base64Hash((byte[][])new byte[][]{certBytes}))) continue;
                        int id = rs.getInt("ID");
                        Long revTimeMs = null;
                        String str = rs.getString("REV_INFO");
                        if (str != null) {
                            CertRevocationInfo revInfo = CertRevocationInfo.fromEncoded((String)str);
                            revTimeMs = revInfo.getRevocationTime().getTime();
                        }
                        SimpleIssuerEntry issuerEntry = new SimpleIssuerEntry(id, revTimeMs);
                        newIssuers.put(id, issuerEntry);
                    }
                    Set newIds = newIssuers.keySet();
                    Set<Integer> ids = this.issuerStore.getIds();
                    boolean bl = issuersUnchanged = ids.size() == newIds.size() && ids.containsAll(newIds) && newIds.containsAll(ids);
                    if (issuersUnchanged) {
                        for (Integer id : newIds) {
                            IssuerEntry entry = this.issuerStore.getIssuerForId(id);
                            SimpleIssuerEntry newEntry = (SimpleIssuerEntry)newIssuers.get(id);
                            if (newEntry.match(entry)) continue;
                            issuersUnchanged = false;
                            break;
                        }
                    }
                    if (issuersUnchanged) {
                        return;
                    }
                }
                finally {
                    this.releaseDbResources(ps, rs);
                }
            }
            sql = "SELECT ID,REV_INFO,CERT FROM CA";
            ps = this.preparedStatement("SELECT ID,REV_INFO,CERT FROM CA");
            rs = null;
            try {
                rs = ps.executeQuery();
                LinkedList<IssuerEntry> caInfos = new LinkedList<IssuerEntry>();
                while (rs.next()) {
                    certBytes = Base64.decode((String)rs.getString("CERT"));
                    sha1Fp = HashAlgo.SHA1.base64Hash((byte[][])new byte[][]{certBytes});
                    if (!this.issuerFilter.includeIssuerWithSha1Fp(sha1Fp)) continue;
                    X509Cert cert = X509Util.parseCert((byte[])certBytes);
                    IssuerEntry caInfoEntry = new IssuerEntry(rs.getInt("ID"), cert);
                    RequestIssuer reqIssuer = new RequestIssuer(HashAlgo.SHA1, caInfoEntry.getEncodedHash(HashAlgo.SHA1));
                    for (IssuerEntry existingIssuer : caInfos) {
                        if (!existingIssuer.matchHash(reqIssuer)) continue;
                        throw new Exception("found at least two issuers with the same subject and key");
                    }
                    String str = rs.getString("REV_INFO");
                    if (str != null) {
                        CertRevocationInfo revInfo = CertRevocationInfo.fromEncoded((String)str);
                        caInfoEntry.setRevocationInfo(revInfo.getRevocationTime());
                    }
                    caInfos.add(caInfoEntry);
                }
                this.issuerStore.setIssuers(caInfos);
                if (!LOG.isInfoEnabled()) return;
                StringBuilder sb = new StringBuilder();
                for (IssuerEntry m : caInfos) {
                    sb.append(CaDbCertStatusStore.overviewString((X509Cert)m.getCert())).append("\n");
                }
                if (sb.length() > 1) {
                    sb.deleteCharAt(sb.length() - 1);
                }
                LOG.info("Updated store {} with issuers {}", (Object)this.name, (Object)sb);
                return;
            }
            finally {
                this.releaseDbResources(ps, rs);
            }
        }
        catch (Throwable th) {
            LogUtil.error((Logger)LOG, (Throwable)th, (String)"error while executing updateIssuerStore()");
            return;
        }
        finally {
            this.initialized = true;
            this.storeUpdateInProcess.set(false);
        }
    }

    protected CertStatusInfo getCertStatus0(Date time, RequestIssuer reqIssuer, BigInteger serialNumber, boolean includeCertHash, boolean includeRit, boolean inheritCaRevocation) throws OcspStoreException {
        if (serialNumber.signum() != 1) {
            return CertStatusInfo.getUnknownCertStatusInfo((Date)new Date(), null);
        }
        if (!this.initialized) {
            throw new OcspStoreException("initialization of CertStore is still in process");
        }
        try {
            CertStatusInfo certStatusInfo;
            IssuerEntry issuer = this.issuerStore.getIssuerForFp(reqIssuer);
            if (issuer == null) {
                return null;
            }
            String sql = includeCertHash ? (includeRit ? this.sqlCsWithCertHash : this.sqlCsNoRitWithCertHash) : (includeRit ? this.sqlCs : this.sqlCsNoRit);
            Date thisUpdate = new Date();
            ResultSet rs = null;
            boolean unknown = true;
            boolean ignore = false;
            String b64CertHash = null;
            boolean revoked = false;
            int reason = 0;
            long revTime = 0L;
            long invalTime = 0L;
            PreparedStatement ps = this.datasource.prepareStatement(sql);
            try {
                ps.setInt(1, issuer.getId());
                ps.setString(2, serialNumber.toString(16));
                rs = ps.executeQuery();
                if (rs.next()) {
                    long notAfterInSec;
                    long notBeforeInSec;
                    unknown = false;
                    long timeInSec = time.getTime() / 1000L;
                    if (this.ignoreNotYetValidCert && (notBeforeInSec = rs.getLong("NBEFORE")) != 0L && timeInSec < notBeforeInSec) {
                        ignore = true;
                    }
                    if (!ignore && this.ignoreExpiredCert && (notAfterInSec = rs.getLong("NAFTER")) != 0L && timeInSec > notAfterInSec) {
                        ignore = true;
                    }
                    if (!ignore) {
                        if (includeCertHash) {
                            b64CertHash = rs.getString("SHA1");
                        }
                        if (revoked = rs.getBoolean("REV")) {
                            reason = rs.getInt("RR");
                            revTime = rs.getLong("RT");
                            if (includeRit) {
                                invalTime = rs.getLong("RIT");
                            }
                        }
                    }
                }
                this.releaseDbResources(ps, rs);
            }
            catch (SQLException ex) {
                try {
                    throw this.datasource.translate(sql, ex);
                }
                catch (Throwable throwable) {
                    this.releaseDbResources(ps, rs);
                    throw throwable;
                }
            }
            Date nextUpdate = null;
            if (unknown) {
                certStatusInfo = CertStatusInfo.getUnknownCertStatusInfo((Date)thisUpdate, nextUpdate);
            } else if (ignore) {
                certStatusInfo = CertStatusInfo.getIgnoreCertStatusInfo((Date)thisUpdate, nextUpdate);
            } else {
                byte[] certHash;
                byte[] byArray = certHash = b64CertHash == null ? null : Base64.decodeFast(b64CertHash);
                if (revoked) {
                    Date invTime = invalTime == 0L || invalTime == revTime ? null : new Date(invalTime * 1000L);
                    CertRevocationInfo revInfo = new CertRevocationInfo(reason, new Date(revTime * 1000L), invTime);
                    certStatusInfo = CertStatusInfo.getRevokedCertStatusInfo((CertRevocationInfo)revInfo, (HashAlgo)this.certHashAlgo, (byte[])certHash, (Date)thisUpdate, nextUpdate, null);
                } else {
                    certStatusInfo = CertStatusInfo.getGoodCertStatusInfo((HashAlgo)this.certHashAlgo, (byte[])certHash, (Date)thisUpdate, nextUpdate, null);
                }
            }
            if (this.includeArchiveCutoff && this.retentionInterval != 0) {
                Date date;
                if (this.retentionInterval < 0) {
                    date = issuer.getNotBefore();
                } else {
                    long nowInMs = System.currentTimeMillis();
                    long dateInMs = Math.max(issuer.getNotBefore().getTime(), nowInMs - 86400000L * (long)this.retentionInterval);
                    date = new Date(dateInMs);
                }
                certStatusInfo.setArchiveCutOff(date);
            }
            if (!inheritCaRevocation || issuer.getRevocationInfo() == null) {
                return certStatusInfo;
            }
            CertRevocationInfo caRevInfo = issuer.getRevocationInfo();
            CertStatusInfo.CertStatus certStatus = certStatusInfo.getCertStatus();
            boolean replaced = false;
            if (certStatus == CertStatusInfo.CertStatus.GOOD) {
                replaced = true;
            } else if (certStatus == CertStatusInfo.CertStatus.UNKNOWN || certStatus == CertStatusInfo.CertStatus.IGNORE) {
                if (this.unknownCertBehaviour == CertStatusInfo.UnknownCertBehaviour.good) {
                    replaced = true;
                }
            } else if (certStatus == CertStatusInfo.CertStatus.REVOKED && certStatusInfo.getRevocationInfo().getRevocationTime().after(caRevInfo.getRevocationTime())) {
                replaced = true;
            }
            if (replaced) {
                CertRevocationInfo newRevInfo = caRevInfo.getReason() == CrlReason.CA_COMPROMISE ? caRevInfo : new CertRevocationInfo(CrlReason.CA_COMPROMISE, caRevInfo.getRevocationTime(), caRevInfo.getInvalidityTime());
                certStatusInfo = CertStatusInfo.getRevokedCertStatusInfo((CertRevocationInfo)newRevInfo, (HashAlgo)certStatusInfo.getCertHashAlgo(), (byte[])certStatusInfo.getCertHash(), (Date)certStatusInfo.getThisUpdate(), (Date)certStatusInfo.getNextUpdate(), (String)certStatusInfo.getCertprofile());
            }
            return certStatusInfo;
        }
        catch (DataAccessException ex) {
            throw new OcspStoreException(ex.getMessage(), (Throwable)ex);
        }
    }

    private PreparedStatement preparedStatement(String sqlQuery) throws DataAccessException {
        return this.datasource.prepareStatement(sqlQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHealthy() {
        if (!this.isInitialized()) {
            return false;
        }
        String sql = "SELECT ID FROM CA";
        PreparedStatement ps = this.preparedStatement("SELECT ID FROM CA");
        ResultSet rs = null;
        try {
            rs = ps.executeQuery();
            boolean bl = true;
            this.releaseDbResources(ps, rs);
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.releaseDbResources(ps, rs);
                throw throwable;
            }
            catch (Exception ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex);
                return false;
            }
        }
    }

    private void releaseDbResources(Statement ps, ResultSet rs) {
        this.datasource.releaseResources(ps, rs);
    }

    public void init(Map<String, ?> sourceConf, DataSourceWrapper datasource) throws OcspStoreException {
        List<Runnable> scheduledServices;
        int size;
        Object objValue;
        OcspServerConf.CaCerts caCerts = null;
        if (sourceConf != null && (objValue = sourceConf.get("caCerts")) != null) {
            caCerts = (OcspServerConf.CaCerts)((Object)JSON.parseObject((byte[])JSON.toJSONBytes(objValue), OcspServerConf.CaCerts.class));
        }
        this.datasource = (DataSourceWrapper)Args.notNull((Object)datasource, (String)"datasource");
        this.sqlCs = datasource.buildSelectFirstSql(1, "NBEFORE,NAFTER,REV,RR,RT,RIT FROM CERT WHERE CA_ID=? AND SN=?");
        this.sqlCsNoRit = datasource.buildSelectFirstSql(1, "NBEFORE,NAFTER,REV,RR,RT FROM CERT WHERE CA_ID=? AND SN=?");
        this.sqlCsWithCertHash = datasource.buildSelectFirstSql(1, "NBEFORE,NAFTER,REV,RR,RT,RIT,SHA1 FROM CERT WHERE CA_ID=? AND SN=?");
        this.sqlCsNoRitWithCertHash = datasource.buildSelectFirstSql(1, "NBEFORE,NAFTER,REV,RR,RT,SHA1 FROM CERT WHERE CA_ID=? AND SN=?");
        this.certHashAlgo = HashAlgo.SHA1;
        try {
            Set<X509Cert> includeIssuers = null;
            Set<X509Cert> excludeIssuers = null;
            if (caCerts != null) {
                if (CollectionUtil.isNotEmpty(caCerts.getIncludes())) {
                    includeIssuers = DbCertStatusStore.parseCerts(caCerts.getIncludes());
                }
                if (CollectionUtil.isNotEmpty(caCerts.getExcludes())) {
                    excludeIssuers = DbCertStatusStore.parseCerts(caCerts.getExcludes());
                }
            }
            this.issuerFilter = new IssuerFilter(includeIssuers, excludeIssuers);
        }
        catch (CertificateException ex) {
            throw new OcspStoreException(ex.getMessage(), (Throwable)ex);
        }
        this.updateIssuerStore();
        if (this.scheduledThreadPoolExecutor != null) {
            this.scheduledThreadPoolExecutor.shutdownNow();
        }
        if (this.updateInterval != null && (size = (scheduledServices = this.getScheduledServices()).size()) > 0) {
            this.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(size);
            long intervalSeconds = this.updateInterval.approxMinutes() * 60L;
            for (Runnable service : scheduledServices) {
                this.scheduledThreadPoolExecutor.scheduleAtFixedRate(service, intervalSeconds + (long)RandomUtil.nextInt((int)60), intervalSeconds, TimeUnit.SECONDS);
            }
        }
    }

    public void close() {
        if (this.scheduledThreadPoolExecutor != null) {
            this.scheduledThreadPoolExecutor.shutdown();
            this.scheduledThreadPoolExecutor = null;
        }
        if (this.datasource != null) {
            this.datasource.close();
        }
    }

    public boolean knowsIssuer(RequestIssuer reqIssuer) {
        return null != this.issuerStore.getIssuerForFp(reqIssuer);
    }

    public X509Cert getIssuerCert(RequestIssuer reqIssuer) {
        IssuerEntry issuer = this.issuerStore.getIssuerForFp(reqIssuer);
        return issuer == null ? null : issuer.getCert();
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    private class StoreUpdateService
    implements Runnable {
        private StoreUpdateService() {
        }

        @Override
        public void run() {
            CaDbCertStatusStore.this.updateIssuerStore();
        }
    }
}

