/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.store;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bouncycastle.crypto.ExtendedDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.ocsp.api.OcspStoreException;
import org.xipki.ocsp.server.store.DbCertStatusStore;
import org.xipki.ocsp.server.store.ImportCrl;
import org.xipki.security.HashAlgo;
import org.xipki.security.asn1.CrlStreamParser;
import org.xipki.util.Args;
import org.xipki.util.ConfPairs;
import org.xipki.util.Curl;
import org.xipki.util.DateUtil;
import org.xipki.util.DefaultCurl;
import org.xipki.util.Hex;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.Validity;
import org.xipki.util.http.SslContextConf;

public class CrlDbCertStatusStore
extends DbCertStatusStore {
    private static final Logger LOG = LoggerFactory.getLogger(CrlDbCertStatusStore.class);
    private static final String CT_PKIX_CRL = "application/pkix-crl";
    private final CrlUpdateService storeUpdateService = new CrlUpdateService();
    private final Object lock = new Object();
    private final AtomicBoolean crlUpdateInProcess = new AtomicBoolean(false);
    private final ConcurrentHashMap<String, Curl> curls = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Long> curlsConfLastModified = new ConcurrentHashMap();
    private String dir;
    private int sqlBatchCommit;
    private boolean ignoreExpiredCrls;
    private boolean crlUpdated;
    private boolean firstTime = true;
    private Map<String, ?> sourceConf;

    @Override
    public void init(Map<String, ?> sourceConf, DataSourceWrapper datasource) throws OcspStoreException {
        String value;
        new ConfPairs(sourceConf);
        this.sourceConf = (Map)Args.notNull(sourceConf, (String)"sourceConf");
        this.dir = IoUtil.expandFilepath((String)CrlDbCertStatusStore.getStrValue(sourceConf, "dir", true), (boolean)true);
        File dirObj = new File(this.dir);
        if (!dirObj.exists()) {
            throw new OcspStoreException("the dir " + this.dir + " does not exist");
        }
        if (!dirObj.isDirectory()) {
            throw new OcspStoreException(this.dir + " is not a directory");
        }
        File[] subDirs = new File(this.dir).listFiles();
        boolean foundCrlDir = false;
        if (subDirs != null) {
            for (File subDir : subDirs) {
                String dirName;
                if (!subDir.isDirectory() || !(dirName = subDir.getName()).startsWith("crl-")) continue;
                foundCrlDir = true;
                break;
            }
        }
        if (!foundCrlDir) {
            LOG.warn("Found no sub-directory starting with 'crl-' in " + this.dir);
        }
        this.sqlBatchCommit = StringUtil.isBlank((String)(value = CrlDbCertStatusStore.getStrValue(sourceConf, "sqlBatchCommit", false))) ? 1000 : (int)Double.parseDouble(value);
        value = CrlDbCertStatusStore.getStrValue(sourceConf, "ignoreExpiredCrls", false);
        this.ignoreExpiredCrls = StringUtil.isBlank((String)value) || Boolean.parseBoolean(value);
        this.datasource = datasource;
        value = CrlDbCertStatusStore.getStrValue(sourceConf, "startupDelay", false);
        int startupDelaySeconds = value == null ? 5 : (int)Double.parseDouble(value);
        Runnable runnable = this::updateStore;
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
        executor.schedule(runnable, (long)startupDelaySeconds, TimeUnit.SECONDS);
        executor.shutdown();
    }

    private static String getStrValue(Map<String, ?> sourceConf, String confName, boolean mandatory) {
        Object objVal = sourceConf.get(confName);
        if (objVal == null) {
            if (mandatory) {
                throw new IllegalArgumentException("mandatory " + confName + " is not specified in sourceConf");
            }
            return null;
        }
        return objVal instanceof String ? (String)objVal : objVal.toString();
    }

    protected boolean isIgnoreExpiredCrls() {
        return this.ignoreExpiredCrls;
    }

    @Override
    protected List<Runnable> getScheduledServices() {
        return Collections.singletonList(this.storeUpdateService);
    }

    @Override
    protected boolean isInitialized() {
        return this.crlUpdated && super.isInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStore() {
        if (this.crlUpdateInProcess.get()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.crlUpdateInProcess.set(true);
            try {
                File[] subDirs = new File(this.dir).listFiles();
                boolean withValidSubDirs = false;
                if (subDirs != null) {
                    for (File subDir : subDirs) {
                        if (!subDir.isDirectory() || !subDir.getName().startsWith("crl-")) continue;
                        new File(subDir, ".generated").mkdirs();
                        withValidSubDirs = true;
                    }
                }
                if (!withValidSubDirs) {
                    return;
                }
                ArrayList<File> downloadDirs = new ArrayList<File>();
                for (File subDir : subDirs) {
                    if (!subDir.isDirectory() || !subDir.getName().startsWith("crl-") || !new File(subDir, "crl.download").exists()) continue;
                    downloadDirs.add(subDir);
                    try {
                        this.downloadCrl(subDir);
                    }
                    catch (Exception ex) {
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)("error downloading CRL for path " + subDir.getPath()));
                    }
                }
                boolean updateMe = false;
                for (File subDir : subDirs) {
                    File dir;
                    if (!subDir.isDirectory() || !subDir.getName().startsWith("crl-")) continue;
                    boolean isDownloadDir = downloadDirs.contains(subDir);
                    File file = dir = isDownloadDir ? new File(subDir, ".generated") : subDir;
                    if (!new File(dir, "UPDATEME").exists()) continue;
                    updateMe = true;
                    break;
                }
                if (updateMe) {
                    ImportCrl importCrl = new ImportCrl(this.datasource, this.dir, this.sqlBatchCommit, this.ignoreExpiredCrls);
                    if (importCrl.importCrlToOcspDb()) {
                        LOG.info("updated CertStore {} successfully", (Object)this.name);
                    } else {
                        LOG.error("updating CertStore {} failed", (Object)this.name);
                    }
                } else {
                    LOG.info("CertStore {} not changed", (Object)this.name);
                }
                if (this.firstTime) {
                    super.init(this.sourceConf, this.datasource);
                    this.firstTime = false;
                } else if (updateMe) {
                    super.updateIssuerStore(true);
                }
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)"error while executing updateStore()");
            }
            finally {
                this.crlUpdated = true;
                this.crlUpdateInProcess.set(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadCrl(File subDir) throws Exception {
        boolean useNewCrl;
        Curl.CurlResult downResult;
        Curl.CurlResult downResult2;
        Properties props;
        if (new File(subDir, "REMOVEME").exists()) {
            return;
        }
        Properties revocationProps = CrlDbCertStatusStore.loadProperties(new File(subDir, "REVOCATION"));
        if (null != revocationProps.getProperty("ca.revocation.time")) {
            return;
        }
        File generatedDir = new File(subDir, ".generated");
        File updatemeFile = new File(generatedDir, "UPDATEME");
        if (updatemeFile.exists()) {
            return;
        }
        File crlInfoFile = new File(generatedDir, "ca.crl.info");
        BigInteger crlNumber = null;
        File crlDownloadFile = new File(subDir, "crl.download");
        File updateMeNowFile = new File(subDir, "UPDATEME_NOW");
        boolean downloadCrl = false;
        String hashAlgo = null;
        byte[] hashValue = null;
        if (!crlInfoFile.exists()) {
            downloadCrl = true;
        } else if (updateMeNowFile.exists()) {
            downloadCrl = true;
        } else {
            props = CrlDbCertStatusStore.loadProperties(crlInfoFile);
            Date nextUpdate = DateUtil.parseUtcTimeyyyyMMddhhmmss((String)props.getProperty("nextupdate"));
            crlNumber = new BigInteger(props.getProperty("crlnumber"));
            String[] tokens = props.getProperty("hash").split(" ");
            hashAlgo = tokens[0];
            hashValue = Hex.decode((String)tokens[1]);
            props = CrlDbCertStatusStore.loadProperties(crlDownloadFile);
            Validity validity = Validity.getInstance((String)props.getProperty("download.before.nextupdate"));
            if (validity.getValidity() < 1) {
                LOG.error("invalid download.before.nextupdate {}", (Object)validity);
            } else if (validity.add(new Date()).after(nextUpdate)) {
                downloadCrl = true;
            }
        }
        if (!downloadCrl) {
            return;
        }
        props = CrlDbCertStatusStore.loadProperties(crlDownloadFile);
        String downloadUrl = props.getProperty("download.url");
        if (downloadUrl == null) {
            downloadUrl = props.getProperty("crldp");
        }
        if (StringUtil.isBlank((String)downloadUrl)) {
            LOG.error("Neither download.url nor crldp in {} is specified, skip it", (Object)crlDownloadFile.getPath());
            return;
        }
        String str = props.getProperty("download.fp.url");
        String hashUrl = null;
        if (str != null) {
            String[] tokens = str.split(" ");
            if (hashValue != null && !hashAlgo.equalsIgnoreCase(tokens[0])) {
                hashValue = null;
            }
            hashAlgo = tokens[0];
            hashUrl = tokens[1];
        }
        String subDirPath = subDir.getPath();
        Curl curl = this.curls.get(subDirPath);
        File trustanchorFile = new File(subDir, "tls-trustanchor.pem");
        if (trustanchorFile.exists()) {
            if (curl != null) {
                long lastModified = this.curlsConfLastModified.get(subDirPath);
                if (trustanchorFile.lastModified() != lastModified) {
                    curl = null;
                    this.curlsConfLastModified.remove(subDirPath);
                    this.curls.remove(subDirPath);
                }
            }
            if (curl == null) {
                SslContextConf sslContextConf = new SslContextConf();
                sslContextConf.setSslTrustanchors(trustanchorFile.getPath());
                curl = new DefaultCurl(sslContextConf);
                this.curls.put(subDirPath, curl);
                this.curlsConfLastModified.put(subDirPath, trustanchorFile.lastModified());
            }
        } else if (curl == null) {
            curl = new DefaultCurl(null);
            this.curls.put(subDirPath, curl);
            this.curlsConfLastModified.put(subDirPath, 0L);
        }
        if (hashUrl != null && (downResult2 = curl.curlGet(hashUrl, false, null, null)).getContentLength() > 0 && Arrays.equals(hashValue, downResult2.getContent())) {
            LOG.info("Fingerprint of the CRL has not changed, skip downloading CRL");
            return;
        }
        File tmpCrlFile = new File(generatedDir, "tmp-ca.crl");
        try (CompositeOutputStream crlStream = new CompositeOutputStream(hashAlgo == null ? null : HashAlgo.getInstance((String)hashAlgo), Files.newOutputStream(tmpCrlFile.toPath(), new OpenOption[0]));){
            downResult = curl.curlGet(downloadUrl, (OutputStream)crlStream, false, null, null);
        }
        String contentType = downResult.getContentType();
        if (!CT_PKIX_CRL.equals(contentType)) {
            LOG.error("Downloading CRL failed, expected content type {}, but received {}", (Object)CT_PKIX_CRL, (Object)contentType);
            return;
        }
        if (downResult.getContentLength() < 10) {
            byte[] errorContent = downResult.getErrorContent();
            if (errorContent == null) {
                LOG.error("Downloading CRL failed, CRL too short (len={}): ", (Object)downResult.getContentLength());
            } else {
                LOG.error("Downloading CRL failed with error: {}", (Object)new String(errorContent));
            }
            return;
        }
        CrlStreamParser newCrlStreamParser = new CrlStreamParser(tmpCrlFile);
        BigInteger newCrlNumber = newCrlStreamParser.getCrlNumber();
        boolean bl = useNewCrl = crlNumber == null || newCrlNumber.compareTo(crlNumber) > 0;
        if (useNewCrl) {
            String hashProp = hashAlgo + " " + Hex.encode((byte[])crlStream.getHashValue());
            IoUtil.save((File)new File(generatedDir, "new-ca.crl.fp"), (byte[])hashProp.getBytes(StandardCharsets.UTF_8));
            tmpCrlFile.renameTo(new File(generatedDir, "new-ca.crl"));
            LOG.info(crlNumber == null ? "Downloaded CRL at first time" : "Downloaded CRL is newer than existing one");
            updatemeFile.createNewFile();
        } else {
            tmpCrlFile.delete();
            LOG.info("Downloaded CRL is not newer than existing one");
        }
        updateMeNowFile.delete();
    }

    static Properties loadProperties(File file) throws IOException {
        Properties props = new Properties();
        if (file.exists() && file.isFile()) {
            try (InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                props.load(is);
            }
        }
        return props;
    }

    private static class CompositeOutputStream
    extends OutputStream {
        private final ExtendedDigest digest;
        private byte[] hashValue;
        private final OutputStream outputStream;

        public CompositeOutputStream(HashAlgo hashAlgo, OutputStream outputStream) {
            this.digest = hashAlgo == null ? null : hashAlgo.createDigest();
            this.outputStream = outputStream;
        }

        @Override
        public void write(byte[] b) throws IOException {
            if (this.digest != null) {
                this.digest.update(b, 0, b.length);
            }
            this.outputStream.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.digest != null) {
                this.digest.update(b, off, len);
            }
            this.outputStream.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.outputStream.flush();
        }

        @Override
        public void close() throws IOException {
            this.outputStream.close();
        }

        @Override
        public void write(int i) throws IOException {
            if (this.digest != null) {
                this.digest.update((byte)i);
            }
            this.outputStream.write(i);
        }

        public byte[] getHashValue() {
            if (this.digest == null) {
                return null;
            }
            if (this.hashValue == null) {
                byte[] t = new byte[this.digest.getDigestSize()];
                this.digest.doFinal(t, 0);
                this.hashValue = t;
            }
            return this.hashValue;
        }
    }

    private class CrlUpdateService
    implements Runnable {
        private CrlUpdateService() {
        }

        @Override
        public void run() {
            try {
                CrlDbCertStatusStore.this.updateStore();
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)("error while calling initializeStore() for store " + CrlDbCertStatusStore.this.name));
            }
        }
    }
}

