/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.store;

import java.io.Closeable;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.bouncycastle.crypto.Digest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.ocsp.api.OcspRespWithCacheInfo;
import org.xipki.ocsp.api.RequestIssuer;
import org.xipki.ocsp.server.store.IssuerEntry;
import org.xipki.ocsp.server.store.IssuerStore;
import org.xipki.security.HashAlgo;
import org.xipki.security.SignAlgo;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.LogUtil;
import org.xipki.util.SqlUtil;
import org.xipki.util.Validity;
import org.xipki.util.concurrent.ConcurrentBag;
import org.xipki.util.concurrent.ConcurrentBagEntry;

public class ResponseCacher
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseCacher.class);
    private static final long SEC_DFLT_NEXT_UPDATE_DURATION = 604800L;
    private static final long SEC_NEXT_UPDATE_BUFFER = 600L;
    private static final String SQL_ADD_ISSUER = SqlUtil.buildInsertSql((String)"ISSUER", (String)"ID,S1C,CERT");
    private static final String SQL_SELECT_ISSUER_ID = "SELECT ID FROM ISSUER";
    private static final String SQL_DELETE_EXPIRED_RESP = "DELETE FROM OCSP WHERE GENERATED_AT<? OR NEXT_UPDATE<?";
    private static final String SQL_ADD_RESP = SqlUtil.buildInsertSql((String)"OCSP", (String)"ID,IID,IDENT,GENERATED_AT,NEXT_UPDATE,RESP");
    private static final String SQL_UPDATE_RESP = "UPDATE OCSP SET GENERATED_AT=?,NEXT_UPDATE=?,RESP=? WHERE ID=?";
    private final ConcurrentBag<ConcurrentBagEntry<Digest>> idDigesters;
    private final String sqlSelectIssuerCert;
    private final String sqlSelectOcsp;
    private final boolean master;
    private final int validity;
    private final AtomicBoolean onService;
    private DataSourceWrapper datasource;
    private final IssuerStore issuerStore = new IssuerStore();
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    private ScheduledFuture<?> responseCleaner;
    private ScheduledFuture<?> issuerUpdater;
    private final AtomicInteger cachedIssuerId = new AtomicInteger(0);

    public ResponseCacher(DataSourceWrapper datasource, boolean master, Validity validity) {
        this.datasource = (DataSourceWrapper)Args.notNull((Object)datasource, (String)"datasource");
        this.master = master;
        this.validity = (int)(((Validity)Args.notNull((Object)validity, (String)"validity")).approxMinutes() * 60L);
        this.sqlSelectIssuerCert = datasource.buildSelectFirstSql(1, "CERT FROM ISSUER WHERE ID=?");
        this.sqlSelectOcsp = datasource.buildSelectFirstSql(1, "IID,IDENT,GENERATED_AT,NEXT_UPDATE,RESP FROM OCSP WHERE ID=?");
        this.onService = new AtomicBoolean(false);
        this.idDigesters = new ConcurrentBag();
        for (int i = 0; i < 20; ++i) {
            this.idDigesters.add(new ConcurrentBagEntry((Object)HashAlgo.SHA1.createDigest()));
        }
    }

    public boolean isOnService() {
        return this.onService.get();
    }

    public void init() {
        this.updateCacheStore();
        this.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
        this.scheduledThreadPoolExecutor.setRemoveOnCancelPolicy(true);
        this.responseCleaner = this.scheduledThreadPoolExecutor.scheduleAtFixedRate(new ExpiredResponsesCleaner(), 348L, 600L, TimeUnit.SECONDS);
        this.issuerUpdater = this.scheduledThreadPoolExecutor.scheduleAtFixedRate(new IssuerUpdater(), 448L, 600L, TimeUnit.SECONDS);
    }

    @Override
    public void close() {
        if (this.datasource != null) {
            this.datasource.close();
            this.datasource = null;
        }
        if (this.responseCleaner != null) {
            this.responseCleaner.cancel(false);
            this.responseCleaner = null;
        }
        if (this.issuerUpdater != null) {
            this.issuerUpdater.cancel(false);
            this.issuerUpdater = null;
        }
        if (this.scheduledThreadPoolExecutor != null) {
            this.scheduledThreadPoolExecutor.shutdown();
            while (!this.scheduledThreadPoolExecutor.isTerminated()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    LOG.error("interrupted: {}", (Object)ex.getMessage());
                }
            }
            this.scheduledThreadPoolExecutor = null;
        }
    }

    public IssuerEntry getIssuer(RequestIssuer reqIssuer) {
        return this.issuerStore.getIssuerForFp(reqIssuer);
    }

    public synchronized IssuerEntry storeIssuer(X509Cert issuerCert) throws CertificateException, DataAccessException {
        IssuerEntry issuerEntry;
        if (!this.master) {
            throw new IllegalStateException("storeIssuer is not permitted in slave mode");
        }
        for (Integer id : this.issuerStore.getIds()) {
            IssuerEntry issuer = this.issuerStore.getIssuerForId(id);
            if (!issuer.getCert().equals((Object)issuerCert)) continue;
            return issuer;
        }
        byte[] encodedCert = issuerCert.getEncoded();
        String sha1FpCert = HashAlgo.SHA1.base64Hash((byte[][])new byte[][]{encodedCert});
        int maxId = (int)this.datasource.getMax(null, "ISSUER", "ID");
        int id = Math.max(maxId, this.cachedIssuerId.get()) + 1;
        this.cachedIssuerId.set(id);
        String sql = SQL_ADD_ISSUER;
        PreparedStatement ps = null;
        try {
            ps = this.datasource.prepareStatement(sql);
            int idx = 1;
            ps.setInt(idx++, id);
            ps.setString(idx++, sha1FpCert);
            ps.setString(idx, Base64.encodeToString((byte[])encodedCert));
            ps.execute();
            IssuerEntry newInfo = new IssuerEntry(id, issuerCert);
            this.issuerStore.addIssuer(newInfo);
            issuerEntry = newInfo;
        }
        catch (SQLException ex) {
            try {
                try {
                    throw this.datasource.translate(sql, ex);
                }
                catch (Throwable throwable) {
                    this.datasource.releaseResources((Statement)ps, null);
                    throw throwable;
                }
            }
            catch (DataAccessException ex2) {
                if (ex2.getReason().isDescendantOrSelfOf(DataAccessException.Reason.DuplicateKey)) {
                    return this.issuerStore.getIssuerForId(id);
                }
                throw ex2;
            }
        }
        this.datasource.releaseResources((Statement)ps, null);
        return issuerEntry;
    }

    public OcspRespWithCacheInfo getOcspResponse(int issuerId, BigInteger serialNumber, SignAlgo sigAlgo) throws DataAccessException {
        String sql = this.sqlSelectOcsp;
        byte[] identBytes = ResponseCacher.buildIdent(serialNumber, sigAlgo);
        long id = this.deriveId(issuerId, identBytes);
        PreparedStatement ps = this.datasource.prepareStatement(sql);
        ResultSet rs = null;
        try {
            long minNextUpdate;
            String dbIdent;
            ps.setLong(1, id);
            rs = ps.executeQuery();
            if (!rs.next()) {
                OcspRespWithCacheInfo ocspRespWithCacheInfo = null;
                return ocspRespWithCacheInfo;
            }
            int dbIid = rs.getInt("IID");
            if (dbIid != issuerId) {
                OcspRespWithCacheInfo ocspRespWithCacheInfo = null;
                return ocspRespWithCacheInfo;
            }
            String ident = Base64.encodeToString((byte[])identBytes);
            if (!ident.equals(dbIdent = rs.getString("IDENT"))) {
                OcspRespWithCacheInfo ocspRespWithCacheInfo = null;
                return ocspRespWithCacheInfo;
            }
            long nextUpdate = rs.getLong("NEXT_UPDATE");
            if (nextUpdate != 0L && nextUpdate < (minNextUpdate = System.currentTimeMillis() / 1000L + 600L)) {
                OcspRespWithCacheInfo ocspRespWithCacheInfo = null;
                return ocspRespWithCacheInfo;
            }
            long generatedAt = rs.getLong("GENERATED_AT");
            String b64Resp = rs.getString("RESP");
            byte[] resp = Base64.decodeFast((String)b64Resp);
            OcspRespWithCacheInfo.ResponseCacheInfo cacheInfo = new OcspRespWithCacheInfo.ResponseCacheInfo(generatedAt);
            if (nextUpdate != 0L) {
                cacheInfo.setNextUpdate(Long.valueOf(nextUpdate));
            }
            OcspRespWithCacheInfo ocspRespWithCacheInfo = new OcspRespWithCacheInfo(resp, cacheInfo);
            return ocspRespWithCacheInfo;
        }
        catch (SQLException ex) {
            throw this.datasource.translate(sql, ex);
        }
        finally {
            this.datasource.releaseResources((Statement)ps, rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeOcspResponse(int issuerId, BigInteger serialNumber, long generatedAt, Long nextUpdate, SignAlgo sigAlgo, byte[] response) {
        block21: {
            long nowInSec = System.currentTimeMillis() / 1000L;
            if (nextUpdate == null) {
                nextUpdate = nowInSec + 604800L;
            }
            if (nextUpdate - nowInSec < (long)this.validity) {
                return;
            }
            byte[] identBytes = ResponseCacher.buildIdent(serialNumber, sigAlgo);
            String ident = Base64.encodeToString((byte[])identBytes);
            try {
                long id = this.deriveId(issuerId, identBytes);
                Connection conn = this.datasource.getConnection();
                try {
                    Boolean dataIntegrityViolationException;
                    String b64Response;
                    PreparedStatement ps;
                    String sql;
                    block20: {
                        sql = SQL_ADD_RESP;
                        ps = this.datasource.prepareStatement(conn, sql);
                        b64Response = Base64.encodeToString((byte[])response);
                        dataIntegrityViolationException = null;
                        try {
                            int idx = 1;
                            ps.setLong(idx++, id);
                            ps.setInt(idx++, issuerId);
                            ps.setString(idx++, ident);
                            ps.setLong(idx++, generatedAt);
                            ps.setLong(idx++, nextUpdate);
                            ps.setString(idx, b64Response);
                            ps.execute();
                        }
                        catch (SQLException ex) {
                            DataAccessException dex = this.datasource.translate(sql, ex);
                            if (dex.getReason().isDescendantOrSelfOf(DataAccessException.Reason.DataIntegrityViolation)) {
                                dataIntegrityViolationException = Boolean.TRUE;
                                break block20;
                            }
                            throw dex;
                        }
                        finally {
                            this.datasource.releaseResources((Statement)ps, null, false);
                        }
                    }
                    if (dataIntegrityViolationException == null) {
                        LOG.debug("added cached OCSP response iid={}, ident={}", (Object)issuerId, (Object)ident);
                        return;
                    }
                    sql = SQL_UPDATE_RESP;
                    ps = this.datasource.prepareStatement(conn, sql);
                    try {
                        int idx = 1;
                        ps.setLong(idx++, generatedAt);
                        ps.setLong(idx++, nextUpdate);
                        ps.setString(idx++, b64Response);
                        ps.setLong(idx, id);
                        ps.executeUpdate();
                    }
                    catch (SQLException ex) {
                        throw this.datasource.translate(sql, ex);
                    }
                    finally {
                        this.datasource.releaseResources((Statement)ps, null, false);
                    }
                }
                finally {
                    this.datasource.returnConnection(conn);
                }
            }
            catch (DataAccessException ex) {
                LOG.info("could not cache OCSP response iid={}, ident={}", (Object)issuerId, (Object)ident);
                if (!LOG.isDebugEnabled()) break block21;
                LOG.debug("could not cache OCSP response iid=" + issuerId + ", ident=" + ident, (Throwable)ex);
            }
        }
    }

    private int removeExpiredResponses(long maxGeneratedAt, long minNextUpdate) throws DataAccessException {
        String sql = SQL_DELETE_EXPIRED_RESP;
        PreparedStatement ps = null;
        try {
            ps = this.datasource.prepareStatement(SQL_DELETE_EXPIRED_RESP);
            ps.setLong(1, maxGeneratedAt);
            ps.setLong(2, minNextUpdate);
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException ex) {
            throw this.datasource.translate(SQL_DELETE_EXPIRED_RESP, ex);
        }
        finally {
            this.datasource.releaseResources((Statement)ps, null);
        }
    }

    private void updateCacheStore() {
        boolean stillOnService = this.updateCacheStore0();
        this.onService.set(stillOnService);
        if (!stillOnService) {
            LOG.error("OCSP response cacher is out of service");
        } else {
            LOG.info("OCSP response cacher is on service");
        }
    }

    /*
     * Exception decompiling
     */
    private boolean updateCacheStore0() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[CATCHBLOCK], 3[TRYBLOCK], 16[CATCHBLOCK], 14[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static byte[] buildIdent(BigInteger serialNumber, SignAlgo sigAlgo) {
        byte[] snBytes = serialNumber.toByteArray();
        byte[] bytes = new byte[1 + snBytes.length];
        bytes[0] = sigAlgo.getCode();
        System.arraycopy(snBytes, 0, bytes, 1, snBytes.length);
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long deriveId(int issuerId, byte[] identBytes) {
        boolean newDigest;
        ConcurrentBagEntry digest0 = null;
        try {
            digest0 = this.idDigesters.borrow(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        boolean bl = newDigest = digest0 == null;
        if (newDigest) {
            digest0 = new ConcurrentBagEntry((Object)HashAlgo.SHA1.createDigest());
        }
        byte[] hash = new byte[20];
        try {
            Digest digest = (Digest)digest0.value();
            digest.reset();
            digest.update(ResponseCacher.int2Bytes(issuerId), 0, 2);
            digest.update(identBytes, 0, identBytes.length);
            digest.doFinal(hash, 0);
        }
        finally {
            if (newDigest) {
                this.idDigesters.add(digest0);
            } else {
                this.idDigesters.requite(digest0);
            }
        }
        return (0x7FL & (long)hash[0]) << 56 | (0xFFL & (long)hash[1]) << 48 | (0xFFL & (long)hash[2]) << 40 | (0xFFL & (long)hash[3]) << 32 | (0xFFL & (long)hash[4]) << 24 | (0xFFL & (long)hash[5]) << 16 | (0xFFL & (long)hash[6]) << 8 | 0xFFL & (long)hash[7];
    }

    private static byte[] int2Bytes(int value) {
        if (value > -1 && value < 65535) {
            return new byte[]{(byte)(value >> 8), (byte)value};
        }
        throw new IllegalArgumentException("value is out of the range [0, 65535]: " + value);
    }

    private class ExpiredResponsesCleaner
    implements Runnable {
        private final Object lock = new Object();
        private final AtomicBoolean inProcess = new AtomicBoolean(false);

        private ExpiredResponsesCleaner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.inProcess.get()) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                this.inProcess.set(true);
                long now = System.currentTimeMillis() / 1000L;
                long maxGeneratedAt = now - (long)ResponseCacher.this.validity;
                long minNextUpdate = now + 600L;
                try {
                    int num1 = ResponseCacher.this.removeExpiredResponses(maxGeneratedAt, minNextUpdate);
                    if (num1 > 0 && LOG.isInfoEnabled()) {
                        LOG.info("removed {} with thisUpdate < {} ({}) OR nextUpdate < {} ({})", new Object[]{num1 == 1 ? "1 response" : num1 + " responses", maxGeneratedAt, new Date(maxGeneratedAt * 1000L), minNextUpdate, new Date(minNextUpdate * 1000L)});
                    }
                }
                catch (Throwable th) {
                    LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not remove expired responses");
                }
                finally {
                    this.inProcess.set(false);
                }
            }
        }
    }

    private class IssuerUpdater
    implements Runnable {
        private IssuerUpdater() {
        }

        @Override
        public void run() {
            try {
                ResponseCacher.this.updateCacheStore();
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)"error while calling updateCacheStore()");
            }
        }
    }
}

