/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.qa;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.util.Args;
import org.xipki.util.InvalidConfException;
import org.xipki.util.LogUtil;
import org.xipki.util.ValidatableConf;
import org.xipki.util.concurrent.CountLatch;

public class BenchmarkHttpClient {
    private static final Logger LOG;
    private static Boolean epollAvailable;
    private static Boolean kqueueAvailable;
    private final CountLatch latch = new CountLatch(0L, 0L);
    private int queueSize = 1000;
    private ResponseHandler responseHandler;
    private EventLoopGroup workerGroup;
    private Channel channel;
    private SslContext sslContext;
    private int pendingRequests = 0;
    private String host;
    private int port;
    private String hostHeader;

    public BenchmarkHttpClient(String host, int port, SslContext sslContext, ResponseHandler responseHandler, int queueSize) {
        this.sslContext = sslContext;
        if (queueSize > 0) {
            this.queueSize = queueSize;
        }
        this.responseHandler = (ResponseHandler)Args.notNull((Object)responseHandler, (String)"responseHandler");
        this.workerGroup = new NioEventLoopGroup(1);
        this.host = host;
        this.port = port;
        this.hostHeader = host + ":" + port;
    }

    public void start() {
        Class<?> clazz;
        Class channelClass = NioSocketChannel.class;
        boolean numThreads = true;
        ClassLoader loader = this.getClass().getClassLoader();
        if (epollAvailable != null && epollAvailable.booleanValue()) {
            try {
                channelClass = Class.forName("io.netty.channel.epoll.EpollSocketChannel", false, loader);
                clazz = Class.forName("io.netty.channel.epoll.EpollEventLoopGroup", true, loader);
                Constructor<?> constructor = clazz.getConstructor(Integer.TYPE);
                this.workerGroup = (EventLoopGroup)constructor.newInstance(1);
                LOG.info("use Epoll Transport");
            }
            catch (Throwable th) {
                if (th instanceof ClassNotFoundException) {
                    LOG.info("epoll linux is not in classpath");
                } else {
                    LogUtil.warn((Logger)LOG, (Throwable)th, (String)"could not use Epoll transport");
                }
                channelClass = null;
                this.workerGroup = null;
            }
        } else if (kqueueAvailable != null && kqueueAvailable.booleanValue()) {
            try {
                channelClass = Class.forName("io.netty.channel.kqueue.KQueueSocketChannel", false, loader);
                clazz = Class.forName("io.netty.channel.kqueue.KQueueEventLoopGroup", true, loader);
                Constructor<?> constructor = clazz.getConstructor(Integer.TYPE);
                this.workerGroup = (EventLoopGroup)constructor.newInstance(1);
                LOG.info("Use KQueue Transport");
            }
            catch (Exception ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)"could not use KQueue transport");
                channelClass = null;
                this.workerGroup = null;
            }
        }
        if (this.workerGroup == null) {
            channelClass = NioSocketChannel.class;
            this.workerGroup = new NioEventLoopGroup(1);
        }
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(this.workerGroup)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)60000)).channel(channelClass)).handler((ChannelHandler)new HttpClientInitializer(this.sslContext));
        this.channel = bootstrap.connect(this.host, this.port).syncUninterruptibly().channel();
    }

    public void send(FullHttpRequest request) throws HttpClientException {
        request.headers().add((CharSequence)HttpHeaderNames.HOST, (Object)this.hostHeader);
        if (!this.channel.isActive()) {
            throw new HttpClientException("channel is not active");
        }
        try {
            this.latch.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            throw new HttpClientException("sending poll is full");
        }
        this.incrementPendingRequests();
        ChannelFuture future = this.channel.writeAndFlush((Object)request);
        future.awaitUninterruptibly();
    }

    public void shutdown() {
        if (this.channel != null) {
            this.channel = null;
        }
        this.workerGroup.shutdownGracefully();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementPendingRequests() {
        CountLatch countLatch = this.latch;
        synchronized (countLatch) {
            if (++this.pendingRequests >= this.queueSize && this.latch.getCount() == 0L) {
                this.latch.countUp();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementPendingRequests() {
        CountLatch countLatch = this.latch;
        synchronized (countLatch) {
            if (--this.pendingRequests < this.queueSize) {
                int count = (int)this.latch.getCount();
                if (count > 0) {
                    while (this.latch.getCount() != 0L) {
                        this.latch.countDown();
                    }
                } else if (count < 0) {
                    while (this.latch.getCount() != 0L) {
                        this.latch.countUp();
                    }
                }
            }
        }
    }

    static {
        block10: {
            LOG = LoggerFactory.getLogger(BenchmarkHttpClient.class);
            String os = System.getProperty("os.name").toLowerCase();
            ClassLoader loader = BenchmarkHttpClient.class.getClassLoader();
            if (os.contains("linux")) {
                try {
                    Class<?> checkClazz = Class.forName("io.netty.channel.epoll.Epoll", false, loader);
                    Method mt = checkClazz.getMethod("isAvailable", new Class[0]);
                    Object obj = mt.invoke(null, new Object[0]);
                    if (obj instanceof Boolean) {
                        epollAvailable = (Boolean)obj;
                    }
                }
                catch (Throwable th) {
                    if (th instanceof ClassNotFoundException) {
                        LOG.info("epoll linux is not in classpath");
                        break block10;
                    }
                    LogUtil.warn((Logger)LOG, (Throwable)th, (String)"could not use Epoll transport");
                }
            } else if (os.contains("mac os") || os.contains("os x")) {
                try {
                    Class<?> checkClazz = Class.forName("io.netty.channel.epoll.kqueue.KQueue", false, loader);
                    Method mt = checkClazz.getMethod("isAvailable", new Class[0]);
                    Object obj = mt.invoke(null, new Object[0]);
                    if (obj instanceof Boolean) {
                        kqueueAvailable = (Boolean)obj;
                    }
                }
                catch (Throwable th) {
                    LogUtil.warn((Logger)LOG, (Throwable)th, (String)"could not use KQueue transport");
                }
            }
        }
    }

    private class HttpClientHandler
    extends SimpleChannelInboundHandler<FullHttpResponse> {
        private HttpClientHandler() {
        }

        public void channelRead0(ChannelHandlerContext ctx, FullHttpResponse resp) {
            try {
                BenchmarkHttpClient.this.decrementPendingRequests();
                BenchmarkHttpClient.this.responseHandler.onComplete(resp);
            }
            catch (Throwable th) {
                LOG.error("unexpected error", th);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            BenchmarkHttpClient.this.decrementPendingRequests();
            ctx.close();
            LOG.warn("error", cause);
            BenchmarkHttpClient.this.responseHandler.onError();
        }
    }

    private class HttpClientInitializer
    extends ChannelInitializer<SocketChannel> {
        private SslContext sslContext;

        public HttpClientInitializer(SslContext sslContext) {
            this.sslContext = sslContext;
        }

        public void initChannel(SocketChannel ch) {
            ChannelPipeline pipeline = ch.pipeline();
            if (this.sslContext != null) {
                pipeline.addLast("ssl", (ChannelHandler)this.sslContext.newHandler(ch.alloc()));
            }
            pipeline.addLast(new ChannelHandler[]{new ReadTimeoutHandler(60L, TimeUnit.SECONDS)}).addLast(new ChannelHandler[]{new WriteTimeoutHandler(60L, TimeUnit.SECONDS)}).addLast(new ChannelHandler[]{new HttpClientCodec()}).addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)}).addLast(new ChannelHandler[]{new HttpClientHandler()});
        }
    }

    public static class HttpClientException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public HttpClientException(String message) {
            super(message);
        }

        public HttpClientException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static interface ResponseHandler {
        public void onComplete(FullHttpResponse var1);

        public void onError();
    }

    public static class SslConf
    extends ValidatableConf {
        private String storeType;
        private String keystore;
        private String keystorePassword;
        private String truststore;
        private String truststorePassword;
        private SslContext sslContext;

        public String getStoreType() {
            return this.storeType;
        }

        public void setStoreType(String storeType) {
            this.storeType = storeType;
        }

        public String getKeystore() {
            return this.keystore;
        }

        public void setKeystore(String keystore) {
            this.keystore = keystore;
        }

        public String getKeystorePassword() {
            return this.keystorePassword;
        }

        public void setKeystorePassword(String keystorePassword) {
            this.keystorePassword = keystorePassword;
        }

        public String getTruststore() {
            return this.truststore;
        }

        public void setTruststore(String truststore) {
            this.truststore = truststore;
        }

        public String getTruststorePassword() {
            return this.truststorePassword;
        }

        public void setTruststorePassword(String truststorePassword) {
            this.truststorePassword = truststorePassword;
        }

        public void validate() throws InvalidConfException {
        }

        public SslContext buildSslContext() throws GeneralSecurityException, IOException {
            Enumeration<String> aliases;
            KeyStore ks;
            char[] pwd;
            if (this.sslContext != null) {
                return this.sslContext;
            }
            SslContextBuilder builder = SslContextBuilder.forClient();
            if (this.keystore != null) {
                pwd = this.keystorePassword == null ? null : this.keystorePassword.toCharArray();
                ks = SslConf.loadKeyStore(this.storeType, this.keystore, pwd);
                aliases = ks.aliases();
                boolean foundKey = false;
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    if (!ks.isKeyEntry(alias)) continue;
                    foundKey = true;
                    PrivateKey key = (PrivateKey)ks.getKey(alias, pwd);
                    Certificate[] certs = ks.getCertificateChain(alias);
                    X509Certificate[] keyCertChain = new X509Certificate[certs.length];
                    for (int i = 0; i < certs.length; ++i) {
                        keyCertChain[i] = (X509Certificate)certs[i];
                    }
                    builder.keyManager(key, alias, keyCertChain);
                }
                if (!foundKey) {
                    throw new GeneralSecurityException("found no key entries in the keystore " + this.keystore);
                }
            }
            if (this.truststore != null) {
                pwd = this.truststorePassword == null ? null : this.truststorePassword.toCharArray();
                ks = SslConf.loadKeyStore(this.storeType, this.truststore, pwd);
                aliases = ks.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    Certificate cert = ks.getCertificate(alias);
                    if (!(cert instanceof X509Certificate)) continue;
                    builder.trustManager(new X509Certificate[]{(X509Certificate)cert});
                }
            }
            SslProvider sslProvider = OpenSsl.isAvailable() ? SslProvider.OPENSSL : SslContext.defaultServerProvider();
            System.out.println("use SSL provider " + sslProvider);
            builder.sslProvider(sslProvider);
            builder.protocols(new String[]{"TLSv1.1", "TLSv1.2"});
            return builder.build();
        }

        private static KeyStore loadKeyStore(String storeType, String store, char[] password) throws GeneralSecurityException, IOException {
            if (storeType == null) {
                storeType = "JKS";
            }
            try (InputStream stream = Files.newInputStream(Paths.get(store, new String[0]), new OpenOption[0]);){
                KeyStore keystore = KeyStore.getInstance(storeType);
                keystore.load(stream, password);
                KeyStore keyStore = keystore;
                return keyStore;
            }
        }
    }
}

