/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.qa.ca;

import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.isismtt.x509.AdmissionSyntax;
import org.bouncycastle.asn1.isismtt.x509.Admissions;
import org.bouncycastle.asn1.isismtt.x509.ProfessionInfo;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.x500.DirectoryString;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.Attribute;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.CertPolicyId;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.CertificatePolicies;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.GeneralSubtree;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.NameConstraints;
import org.bouncycastle.asn1.x509.PolicyConstraints;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.PolicyQualifierId;
import org.bouncycastle.asn1.x509.PolicyQualifierInfo;
import org.bouncycastle.asn1.x509.PrivateKeyUsagePeriod;
import org.bouncycastle.asn1.x509.SubjectDirectoryAttributes;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.UserNotice;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.asn1.x509.qualified.BiometricData;
import org.bouncycastle.asn1.x509.qualified.Iso4217CurrencyCode;
import org.bouncycastle.asn1.x509.qualified.MonetaryValue;
import org.bouncycastle.asn1.x509.qualified.QCStatement;
import org.bouncycastle.asn1.x509.qualified.TypeOfBiometricData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.BadCertTemplateException;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.api.profile.SubjectDnSpec;
import org.xipki.ca.certprofile.xijson.AdmissionSyntaxOption;
import org.xipki.ca.certprofile.xijson.BiometricInfoOption;
import org.xipki.ca.certprofile.xijson.DirectoryStringType;
import org.xipki.ca.certprofile.xijson.SubjectDirectoryAttributesControl;
import org.xipki.ca.certprofile.xijson.XijsonCertprofile;
import org.xipki.ca.certprofile.xijson.conf.CertificatePolicyInformationType;
import org.xipki.ca.certprofile.xijson.conf.Describable;
import org.xipki.ca.certprofile.xijson.conf.ExtensionType;
import org.xipki.ca.certprofile.xijson.conf.GeneralSubtreeType;
import org.xipki.ca.certprofile.xijson.conf.QcStatementType;
import org.xipki.ca.certprofile.xijson.conf.X509ProfileType;
import org.xipki.qa.ValidationIssue;
import org.xipki.qa.ca.IssuerInfo;
import org.xipki.qa.ca.QaExtensionValue;
import org.xipki.security.ExtensionExistence;
import org.xipki.security.HashAlgo;
import org.xipki.security.KeyUsage;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.CompareUtil;
import org.xipki.util.Hex;
import org.xipki.util.LogUtil;
import org.xipki.util.TripleState;

public class ExtensionsChecker {
    private static final byte[] DER_NULL = new byte[]{5, 0};
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionsChecker.class);
    private static final List<String> ALL_USAGES = Arrays.asList(KeyUsage.digitalSignature.getName(), KeyUsage.contentCommitment.getName(), KeyUsage.keyEncipherment.getName(), KeyUsage.dataEncipherment.getName(), KeyUsage.keyAgreement.getName(), KeyUsage.keyCertSign.getName(), KeyUsage.cRLSign.getName(), KeyUsage.encipherOnly.getName(), KeyUsage.decipherOnly.getName());
    private ExtensionType.CertificatePolicies certificatePolicies;
    private ExtensionType.PolicyMappings policyMappings;
    private ExtensionType.NameConstraints nameConstraints;
    private ExtensionType.PolicyConstraints policyConstraints;
    private ExtensionType.InhibitAnyPolicy inhibitAnyPolicy;
    private ExtensionType.Restriction restriction;
    private ExtensionType.AdditionalInformation additionalInformation;
    private ASN1ObjectIdentifier validityModelId;
    private ExtensionType.QcStatements qcStatements;
    private ExtensionType.AuthorizationTemplate authorizationTemplate;
    private ExtensionType.TlsFeature tlsFeature;
    private QaExtensionValue smimeCapabilities;
    private Map<ASN1ObjectIdentifier, QaExtensionValue> constantExtensions;
    private XijsonCertprofile certprofile;

    public ExtensionsChecker(X509ProfileType conf, XijsonCertprofile certprofile) throws CertprofileException {
        this.certprofile = (XijsonCertprofile)Args.notNull((Object)certprofile, (String)"certprofile");
        Args.notNull((Object)conf, (String)"conf");
        Map extensions = conf.buildExtensions();
        Map extensionControls = certprofile.getExtensionControls();
        ASN1ObjectIdentifier type = Extension.certificatePolicies;
        if (extensionControls.containsKey(type)) {
            this.certificatePolicies = ((ExtensionType)extensions.get(type.getId())).getCertificatePolicies();
        }
        if (extensionControls.containsKey(type = Extension.policyMappings)) {
            this.policyMappings = ((ExtensionType)extensions.get(type.getId())).getPolicyMappings();
        }
        if (extensionControls.containsKey(type = Extension.nameConstraints)) {
            this.nameConstraints = ((ExtensionType)extensions.get(type.getId())).getNameConstraints();
        }
        if (extensionControls.containsKey(type = Extension.policyConstraints)) {
            this.policyConstraints = ((ExtensionType)extensions.get(type.getId())).getPolicyConstraints();
        }
        if (extensionControls.containsKey(type = Extension.inhibitAnyPolicy)) {
            this.inhibitAnyPolicy = ((ExtensionType)extensions.get(type.getId())).getInhibitAnyPolicy();
        }
        if (extensionControls.containsKey(type = ObjectIdentifiers.id_extension_restriction)) {
            this.restriction = ((ExtensionType)extensions.get(type.getId())).getRestriction();
        }
        if (extensionControls.containsKey(type = ObjectIdentifiers.id_extension_additionalInformation)) {
            this.additionalInformation = ((ExtensionType)extensions.get(type.getId())).getAdditionalInformation();
        }
        if (extensionControls.containsKey(type = ObjectIdentifiers.id_extension_validityModel)) {
            this.validityModelId = ((ExtensionType)extensions.get(type.getId())).getValidityModel().getModelId().toXiOid();
        }
        if (extensionControls.containsKey(type = Extension.qCStatements)) {
            this.qcStatements = ((ExtensionType)extensions.get(type.getId())).getQcStatements();
        }
        if (extensionControls.containsKey(type = ObjectIdentifiers.id_pe_tlsfeature)) {
            this.tlsFeature = ((ExtensionType)extensions.get(type.getId())).getTlsFeature();
        }
        if (extensionControls.containsKey(type = ObjectIdentifiers.id_xipki_ext_authorizationTemplate)) {
            this.authorizationTemplate = ((ExtensionType)extensions.get(type.getId())).getAuthorizationTemplate();
        }
        if (extensionControls.containsKey(type = ObjectIdentifiers.id_smimeCapabilities)) {
            List list = ((ExtensionType)extensions.get(type.getId())).getSmimeCapabilities().getCapabilities();
            ASN1EncodableVector vec = new ASN1EncodableVector();
            for (ExtensionType.SmimeCapability m : list) {
                ASN1ObjectIdentifier oid = m.getCapabilityId().toXiOid();
                ASN1Integer params = null;
                ExtensionType.SmimeCapabilityParameter capParam = m.getParameter();
                if (capParam != null) {
                    if (capParam.getInteger() != null) {
                        params = new ASN1Integer(capParam.getInteger());
                    } else if (capParam.getBinary() != null) {
                        params = ExtensionsChecker.readAsn1Encodable(capParam.getBinary().getValue());
                    }
                }
                SMIMECapability cap = new SMIMECapability(oid, params);
                vec.add((ASN1Encodable)cap);
            }
            DERSequence extValue = new DERSequence(vec);
            try {
                this.smimeCapabilities = new QaExtensionValue(((Certprofile.ExtensionControl)extensionControls.get(type)).isCritical(), extValue.getEncoded());
            }
            catch (IOException ex) {
                throw new CertprofileException("Cannot encode SMIMECapabilities: " + ex.getMessage());
            }
        }
        this.constantExtensions = ExtensionsChecker.buildConstantExtesions(extensions);
    }

    public List<ValidationIssue> checkExtensions(Certificate cert, IssuerInfo issuerInfo, Extensions requestedExtns, X500Name requestedSubject) {
        X509Certificate jceCert;
        Args.notNull((Object)cert, (String)"cert");
        Args.notNull((Object)issuerInfo, (String)"issuerInfo");
        try {
            jceCert = X509Util.toX509Cert((Certificate)cert);
        }
        catch (CertificateException ex) {
            throw new IllegalArgumentException("invalid cert: " + ex.getMessage());
        }
        LinkedList<ValidationIssue> result = new LinkedList<ValidationIssue>();
        Set<ASN1ObjectIdentifier> presentExtenionTypes = this.getExensionTypes(cert, issuerInfo, requestedExtns);
        Extensions extensions = cert.getTBSCertificate().getExtensions();
        ASN1ObjectIdentifier[] oids = extensions.getExtensionOIDs();
        if (oids == null) {
            ValidationIssue issue = new ValidationIssue("X509.EXT.GEN", "extension general");
            result.add(issue);
            issue.setFailureMessage("no extension is present");
            return result;
        }
        List<ASN1ObjectIdentifier> certExtTypes = Arrays.asList(oids);
        for (ASN1ObjectIdentifier extType : presentExtenionTypes) {
            if (certExtTypes.contains(extType)) continue;
            ValidationIssue issue = this.createExtensionIssue(extType);
            result.add(issue);
            issue.setFailureMessage("extension is absent but is required");
        }
        Map extnControls = this.certprofile.getExtensionControls();
        for (ASN1ObjectIdentifier oid : certExtTypes) {
            ValidationIssue issue = this.createExtensionIssue(oid);
            result.add(issue);
            if (!presentExtenionTypes.contains(oid)) {
                issue.setFailureMessage("extension is present but is not permitted");
                continue;
            }
            Extension ext = extensions.getExtension(oid);
            StringBuilder failureMsg = new StringBuilder();
            Certprofile.ExtensionControl extnControl = (Certprofile.ExtensionControl)extnControls.get(oid);
            if (extnControl.isCritical() != ext.isCritical()) {
                ExtensionsChecker.addViolation(failureMsg, "critical", ext.isCritical(), extnControl.isCritical());
            }
            byte[] extnValue = ext.getExtnValue().getOctets();
            try {
                if (Extension.authorityKeyIdentifier.equals((Object)oid)) {
                    this.checkExtnIssuerKeyIdentifier(failureMsg, extnValue, issuerInfo);
                } else if (Extension.subjectKeyIdentifier.equals((Object)oid)) {
                    this.checkExtnSubjectKeyIdentifier(failureMsg, extnValue, cert.getSubjectPublicKeyInfo());
                } else if (Extension.keyUsage.equals((Object)oid)) {
                    this.checkExtnKeyUsage(failureMsg, extnValue, jceCert.getKeyUsage(), requestedExtns, extnControl);
                } else if (Extension.certificatePolicies.equals((Object)oid)) {
                    this.checkExtnCertificatePolicies(failureMsg, extnValue, requestedExtns, extnControl);
                } else if (Extension.policyMappings.equals((Object)oid)) {
                    this.checkExtnPolicyMappings(failureMsg, extnValue, requestedExtns, extnControl);
                } else if (Extension.subjectAlternativeName.equals((Object)oid)) {
                    this.checkExtnSubjectAltName(failureMsg, extnValue, requestedExtns, extnControl, requestedSubject);
                } else if (Extension.subjectDirectoryAttributes.equals((Object)oid)) {
                    this.checkExtnSubjectDirAttrs(failureMsg, extnValue, requestedExtns, extnControl);
                } else if (Extension.issuerAlternativeName.equals((Object)oid)) {
                    this.checkExtnIssuerAltNames(failureMsg, extnValue, issuerInfo);
                } else if (Extension.basicConstraints.equals((Object)oid)) {
                    this.checkExtnBasicConstraints(failureMsg, extnValue);
                } else if (Extension.nameConstraints.equals((Object)oid)) {
                    this.checkExtnNameConstraints(failureMsg, extnValue, extensions, extnControl);
                } else if (Extension.policyConstraints.equals((Object)oid)) {
                    this.checkExtnPolicyConstraints(failureMsg, extnValue, requestedExtns, extnControl);
                } else if (Extension.extendedKeyUsage.equals((Object)oid)) {
                    this.checkExtnExtendedKeyUsage(failureMsg, extnValue, requestedExtns, extnControl);
                } else if (Extension.cRLDistributionPoints.equals((Object)oid)) {
                    this.checkExtnCrlDistributionPoints(failureMsg, extnValue, issuerInfo);
                } else if (Extension.inhibitAnyPolicy.equals((Object)oid)) {
                    this.checkExtnInhibitAnyPolicy(failureMsg, extnValue, extensions, extnControl);
                } else if (Extension.freshestCRL.equals((Object)oid)) {
                    this.checkExtnDeltaCrlDistributionPoints(failureMsg, extnValue, issuerInfo);
                } else if (Extension.authorityInfoAccess.equals((Object)oid)) {
                    this.checkExtnAuthorityInfoAccess(failureMsg, extnValue, issuerInfo);
                } else if (Extension.subjectInfoAccess.equals((Object)oid)) {
                    this.checkExtnSubjectInfoAccess(failureMsg, extnValue, requestedExtns, extnControl);
                } else if (ObjectIdentifiers.id_extension_admission.equals((Object)oid)) {
                    this.checkExtnAdmission(failureMsg, extnValue, requestedExtns, extnControl);
                } else if (ObjectIdentifiers.id_extension_pkix_ocsp_nocheck.equals((Object)oid)) {
                    this.checkExtnOcspNocheck(failureMsg, extnValue);
                } else if (ObjectIdentifiers.id_extension_restriction.equals((Object)oid)) {
                    this.checkExtnRestriction(failureMsg, extnValue, requestedExtns, extnControl);
                } else if (ObjectIdentifiers.id_extension_additionalInformation.equals((Object)oid)) {
                    this.checkExtnAdditionalInformation(failureMsg, extnValue, requestedExtns, extnControl);
                } else if (ObjectIdentifiers.id_extension_validityModel.equals((Object)oid)) {
                    this.checkExtnValidityModel(failureMsg, extnValue, requestedExtns, extnControl);
                } else if (Extension.privateKeyUsagePeriod.equals((Object)oid)) {
                    this.checkExtnPrivateKeyUsagePeriod(failureMsg, extnValue, jceCert.getNotBefore(), jceCert.getNotAfter());
                } else if (Extension.qCStatements.equals((Object)oid)) {
                    this.checkExtnQcStatements(failureMsg, extnValue, requestedExtns, extnControl);
                } else if (Extension.biometricInfo.equals((Object)oid)) {
                    this.checkExtnBiometricInfo(failureMsg, extnValue, requestedExtns, extnControl);
                } else if (ObjectIdentifiers.id_pe_tlsfeature.equals((Object)oid)) {
                    this.checkExtnTlsFeature(failureMsg, extnValue, requestedExtns, extnControl);
                } else if (ObjectIdentifiers.id_xipki_ext_authorizationTemplate.equals((Object)oid)) {
                    this.checkExtnAuthorizationTemplate(failureMsg, extnValue, requestedExtns, extnControl);
                } else {
                    byte[] expected = ObjectIdentifiers.id_smimeCapabilities.equals((Object)oid) ? this.smimeCapabilities.getValue() : this.getExpectedExtValue(oid, requestedExtns, extnControl);
                    if (!Arrays.equals(expected, extnValue)) {
                        ExtensionsChecker.addViolation(failureMsg, "extension valus", ExtensionsChecker.hex(extnValue), expected == null ? "not present" : ExtensionsChecker.hex(expected));
                    }
                }
                if (failureMsg.length() <= 0) continue;
                issue.setFailureMessage(failureMsg.toString());
            }
            catch (ArrayIndexOutOfBoundsException | ClassCastException | IllegalArgumentException ex) {
                LOG.debug("extension value does not have correct syntax", (Throwable)ex);
                issue.setFailureMessage("extension value does not have correct syntax");
            }
        }
        return result;
    }

    private byte[] getExpectedExtValue(ASN1ObjectIdentifier type, Extensions requestedExtns, Certprofile.ExtensionControl extControl) {
        Extension reqExt;
        if (this.constantExtensions != null && this.constantExtensions.containsKey(type)) {
            return this.constantExtensions.get(type).getValue();
        }
        if (requestedExtns != null && extControl.isRequest() && (reqExt = requestedExtns.getExtension(type)) != null) {
            return reqExt.getExtnValue().getOctets();
        }
        return null;
    }

    private Set<ASN1ObjectIdentifier> getExensionTypes(Certificate cert, IssuerInfo issuerInfo, Extensions requestedExtns) {
        Extension reqExtension;
        HashSet<ASN1ObjectIdentifier> types = new HashSet<ASN1ObjectIdentifier>();
        Map extensionControls = this.certprofile.getExtensionControls();
        for (ASN1ObjectIdentifier oid : extensionControls.keySet()) {
            if (!((Certprofile.ExtensionControl)extensionControls.get(oid)).isRequired()) continue;
            types.add(oid);
        }
        HashSet wantedExtensionTypes = new HashSet();
        if (requestedExtns != null && (reqExtension = requestedExtns.getExtension(ObjectIdentifiers.id_xipki_ext_cmpRequestExtensions)) != null) {
            ExtensionExistence ee = ExtensionExistence.getInstance((Object)reqExtension.getParsedValue());
            types.addAll(ee.getNeedExtensions());
            wantedExtensionTypes.addAll(ee.getWantExtensions());
        }
        if (CollectionUtil.isEmpty(wantedExtensionTypes)) {
            return types;
        }
        ASN1ObjectIdentifier type = Extension.authorityKeyIdentifier;
        if (wantedExtensionTypes.contains(type)) {
            types.add(type);
        }
        if (wantedExtensionTypes.contains(type = Extension.subjectKeyIdentifier)) {
            types.add(type);
        }
        if (wantedExtensionTypes.contains(type = Extension.keyUsage)) {
            Set<Certprofile.KeyUsageControl> requiredKeyusage;
            boolean required = false;
            if (requestedExtns != null && requestedExtns.getExtension(type) != null) {
                required = true;
            }
            if (!required && CollectionUtil.isNonEmpty(requiredKeyusage = this.getKeyusage(true))) {
                required = true;
            }
            if (required) {
                types.add(type);
            }
        }
        if (wantedExtensionTypes.contains(type = Extension.certificatePolicies) && this.certificatePolicies != null) {
            types.add(type);
        }
        if (wantedExtensionTypes.contains(type = Extension.policyMappings) && this.policyMappings != null) {
            types.add(type);
        }
        if (wantedExtensionTypes.contains(type = Extension.subjectAlternativeName) && requestedExtns != null && requestedExtns.getExtension(type) != null) {
            types.add(type);
        }
        if (wantedExtensionTypes.contains(type = Extension.issuerAlternativeName) && cert.getTBSCertificate().getExtensions().getExtension(Extension.subjectAlternativeName) != null) {
            types.add(type);
        }
        if (wantedExtensionTypes.contains(type = Extension.basicConstraints)) {
            types.add(type);
        }
        if (wantedExtensionTypes.contains(type = Extension.nameConstraints) && this.nameConstraints != null) {
            types.add(type);
        }
        if (wantedExtensionTypes.contains(type = Extension.policyConstraints) && this.policyConstraints != null) {
            types.add(type);
        }
        if (wantedExtensionTypes.contains(type = Extension.extendedKeyUsage)) {
            Set<Certprofile.ExtKeyUsageControl> requiredExtKeyusage;
            boolean required = false;
            if (requestedExtns != null && requestedExtns.getExtension(type) != null) {
                required = true;
            }
            if (!required && CollectionUtil.isNonEmpty(requiredExtKeyusage = this.getExtKeyusage(true))) {
                required = true;
            }
            if (required) {
                types.add(type);
            }
        }
        if (wantedExtensionTypes.contains(type = Extension.cRLDistributionPoints) && issuerInfo.getCrlUrls() != null) {
            types.add(type);
        }
        if (wantedExtensionTypes.contains(type = Extension.inhibitAnyPolicy) && this.inhibitAnyPolicy != null) {
            types.add(type);
        }
        if (wantedExtensionTypes.contains(type = Extension.freshestCRL) && issuerInfo.getDeltaCrlUrls() != null) {
            types.add(type);
        }
        if (wantedExtensionTypes.contains(type = Extension.authorityInfoAccess) && issuerInfo.getOcspUrls() != null) {
            types.add(type);
        }
        if (wantedExtensionTypes.contains(type = Extension.subjectInfoAccess) && requestedExtns != null && requestedExtns.getExtension(type) != null) {
            types.add(type);
        }
        if (wantedExtensionTypes.contains(type = ObjectIdentifiers.id_extension_admission) && this.certprofile.getAdmission() != null) {
            types.add(type);
        }
        if (wantedExtensionTypes.contains(type = ObjectIdentifiers.id_extension_pkix_ocsp_nocheck)) {
            types.add(type);
        }
        wantedExtensionTypes.removeAll(types);
        for (ASN1ObjectIdentifier oid : wantedExtensionTypes) {
            if (requestedExtns == null || requestedExtns.getExtension(oid) == null || !this.constantExtensions.containsKey(oid)) continue;
            types.add(oid);
        }
        return types;
    }

    private ValidationIssue createExtensionIssue(ASN1ObjectIdentifier extId) {
        String extName = ObjectIdentifiers.getName((ASN1ObjectIdentifier)extId);
        if (extName == null) {
            extName = extId.getId().replace('.', '_');
            return new ValidationIssue("X509.EXT." + extName, "extension " + extId.getId());
        }
        return new ValidationIssue("X509.EXT." + extName, "extension " + extName + " (" + extId.getId() + ")");
    }

    private void checkExtnBasicConstraints(StringBuilder failureMsg, byte[] extensionValue) {
        boolean ca;
        BasicConstraints bc = BasicConstraints.getInstance((Object)extensionValue);
        Certprofile.CertLevel certLevel = this.certprofile.getCertLevel();
        boolean bl = ca = Certprofile.CertLevel.RootCA == certLevel || Certprofile.CertLevel.SubCA == certLevel;
        if (ca != bc.isCA()) {
            ExtensionsChecker.addViolation(failureMsg, "ca", bc.isCA(), ca);
        }
        if (!bc.isCA()) {
            return;
        }
        BigInteger tmpPathLen = bc.getPathLenConstraint();
        Integer pathLen = this.certprofile.getPathLen();
        if (pathLen == null) {
            if (tmpPathLen != null) {
                ExtensionsChecker.addViolation(failureMsg, "pathLen", tmpPathLen, "absent");
            }
        } else if (tmpPathLen == null) {
            ExtensionsChecker.addViolation(failureMsg, "pathLen", "null", pathLen);
        } else if (!BigInteger.valueOf(pathLen.intValue()).equals(tmpPathLen)) {
            ExtensionsChecker.addViolation(failureMsg, "pathLen", tmpPathLen, pathLen);
        }
    }

    private void checkExtnSubjectKeyIdentifier(StringBuilder failureMsg, byte[] extensionValue, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        SubjectKeyIdentifier asn1 = SubjectKeyIdentifier.getInstance((Object)extensionValue);
        byte[] ski = asn1.getKeyIdentifier();
        byte[] pkData = subjectPublicKeyInfo.getPublicKeyData().getBytes();
        byte[] expectedSki = HashAlgo.SHA1.hash(pkData);
        if (!Arrays.equals(expectedSki, ski)) {
            ExtensionsChecker.addViolation(failureMsg, "SKI", ExtensionsChecker.hex(ski), ExtensionsChecker.hex(expectedSki));
        }
    }

    private void checkExtnIssuerKeyIdentifier(StringBuilder failureMsg, byte[] extensionValue, IssuerInfo issuerInfo) {
        AuthorityKeyIdentifier asn1 = AuthorityKeyIdentifier.getInstance((Object)extensionValue);
        byte[] keyIdentifier = asn1.getKeyIdentifier();
        if (keyIdentifier == null) {
            failureMsg.append("keyIdentifier is 'absent' but expected 'present'; ");
        } else if (!Arrays.equals(issuerInfo.getSubjectKeyIdentifier(), keyIdentifier)) {
            ExtensionsChecker.addViolation(failureMsg, "keyIdentifier", ExtensionsChecker.hex(keyIdentifier), ExtensionsChecker.hex(issuerInfo.getSubjectKeyIdentifier()));
        }
        BigInteger serialNumber = asn1.getAuthorityCertSerialNumber();
        GeneralNames names = asn1.getAuthorityCertIssuer();
        if (this.certprofile.isIncludeIssuerAndSerialInAki()) {
            if (serialNumber == null) {
                failureMsg.append("authorityCertSerialNumber is 'absent' but expected 'present'; ");
            } else if (!issuerInfo.getCert().getSerialNumber().equals(serialNumber)) {
                ExtensionsChecker.addViolation(failureMsg, "authorityCertSerialNumber", LogUtil.formatCsn((BigInteger)serialNumber), LogUtil.formatCsn((BigInteger)issuerInfo.getCert().getSerialNumber()));
            }
            if (names == null) {
                failureMsg.append("authorityCertIssuer is 'absent' but expected 'present'; ");
            } else {
                GeneralName[] genNames = names.getNames();
                X500Name x500GenName = null;
                for (GeneralName genName : genNames) {
                    if (genName.getTagNo() != 4) continue;
                    if (x500GenName != null) {
                        failureMsg.append("authorityCertIssuer contains at least two directoryName but expected one; ");
                        break;
                    }
                    x500GenName = (X500Name)genName.getName();
                }
                if (x500GenName == null) {
                    failureMsg.append("authorityCertIssuer does not contain directoryName but expected one; ");
                } else {
                    X500Name caSubject = issuerInfo.getBcCert().getTBSCertificate().getSubject();
                    if (!caSubject.equals(x500GenName)) {
                        ExtensionsChecker.addViolation(failureMsg, "authorityCertIssuer", x500GenName, caSubject);
                    }
                }
            }
        } else {
            if (serialNumber != null) {
                failureMsg.append("authorityCertSerialNumber is 'absent' but expected 'present'; ");
            }
            if (names != null) {
                failureMsg.append("authorityCertIssuer is 'absent' but expected 'present'; ");
            }
        }
    }

    private void checkExtnNameConstraints(StringBuilder failureMsg, byte[] extensionValue, Extensions requestedExtns, Certprofile.ExtensionControl extControl) {
        ExtensionType.NameConstraints conf = this.nameConstraints;
        if (conf == null) {
            this.checkConstantExtnValue(Extension.nameConstraints, failureMsg, extensionValue, requestedExtns, extControl);
            return;
        }
        NameConstraints tmpNameConstraints = NameConstraints.getInstance((Object)extensionValue);
        this.checkExtnNameConstraintsSubtrees(failureMsg, "PermittedSubtrees", tmpNameConstraints.getPermittedSubtrees(), conf.getPermittedSubtrees());
        this.checkExtnNameConstraintsSubtrees(failureMsg, "ExcludedSubtrees", tmpNameConstraints.getExcludedSubtrees(), conf.getExcludedSubtrees());
    }

    private void checkExtnNameConstraintsSubtrees(StringBuilder failureMsg, String description, GeneralSubtree[] subtrees, List<GeneralSubtreeType> expectedSubtrees) {
        int expSize;
        int isSize = subtrees == null ? 0 : subtrees.length;
        int n = expSize = expectedSubtrees == null ? 0 : expectedSubtrees.size();
        if (isSize != expSize) {
            ExtensionsChecker.addViolation(failureMsg, "size of " + description, isSize, expSize);
            return;
        }
        if (subtrees == null || expectedSubtrees == null) {
            return;
        }
        for (int i = 0; i < isSize; ++i) {
            GeneralName expBase;
            Integer expMaximum;
            Integer isMaximum;
            GeneralSubtree isSubtree = subtrees[i];
            GeneralSubtreeType expSubtree = expectedSubtrees.get(i);
            BigInteger bigInt = isSubtree.getMinimum();
            int isMinimum = bigInt == null ? 0 : bigInt.intValue();
            Integer minimum = expSubtree.getMinimum();
            int expMinimum = minimum == null ? 0 : minimum;
            String desc = description + " [" + i + "]";
            if (isMinimum != expMinimum) {
                ExtensionsChecker.addViolation(failureMsg, "minimum of " + desc, isMinimum, expMinimum);
            }
            if (!CompareUtil.equalsObject((Object)(isMaximum = (bigInt = isSubtree.getMaximum()) == null ? null : Integer.valueOf(bigInt.intValue())), (Object)(expMaximum = expSubtree.getMaximum()))) {
                ExtensionsChecker.addViolation(failureMsg, "maxmum of " + desc, isMaximum, expMaximum);
            }
            GeneralName isBase = isSubtree.getBase();
            GeneralSubtreeType.Base expBase0 = expSubtree.getBase();
            if (expSubtree.getBase().getDirectoryName() != null) {
                expBase = new GeneralName(X509Util.reverse((X500Name)new X500Name(expBase0.getDirectoryName())));
            } else if (expBase0.getDnsName() != null) {
                expBase = new GeneralName(2, expBase0.getDnsName());
            } else if (expBase0.getIpAddress() != null) {
                expBase = new GeneralName(7, expBase0.getIpAddress());
            } else if (expBase0.getRfc822Name() != null) {
                expBase = new GeneralName(1, expBase0.getRfc822Name());
            } else if (expBase0.getUri() != null) {
                expBase = new GeneralName(6, expBase0.getUri());
            } else {
                throw new IllegalStateException("should not reach here, unknown child of GeneralName");
            }
            if (isBase.equals((Object)expBase)) continue;
            ExtensionsChecker.addViolation(failureMsg, "base of " + desc, isBase, expBase);
        }
    }

    private void checkExtnPolicyConstraints(StringBuilder failureMsg, byte[] extensionValue, Extensions requestedExtns, Certprofile.ExtensionControl extControl) {
        ExtensionType.PolicyConstraints conf = this.policyConstraints;
        if (conf == null) {
            this.checkConstantExtnValue(Extension.policyConstraints, failureMsg, extensionValue, requestedExtns, extControl);
            return;
        }
        PolicyConstraints isPolicyConstraints = PolicyConstraints.getInstance((Object)extensionValue);
        Integer expRequireExplicitPolicy = conf.getRequireExplicitPolicy();
        BigInteger bigInt = isPolicyConstraints.getRequireExplicitPolicyMapping();
        Integer isRequireExplicitPolicy = bigInt == null ? null : Integer.valueOf(bigInt.intValue());
        boolean match = true;
        if (expRequireExplicitPolicy == null) {
            if (isRequireExplicitPolicy != null) {
                match = false;
            }
        } else if (!expRequireExplicitPolicy.equals(isRequireExplicitPolicy)) {
            match = false;
        }
        if (!match) {
            ExtensionsChecker.addViolation(failureMsg, "requireExplicitPolicy", isRequireExplicitPolicy, expRequireExplicitPolicy);
        }
        Integer expInhibitPolicyMapping = conf.getInhibitPolicyMapping();
        bigInt = isPolicyConstraints.getInhibitPolicyMapping();
        Integer isInhibitPolicyMapping = bigInt == null ? null : Integer.valueOf(bigInt.intValue());
        match = true;
        if (expInhibitPolicyMapping == null) {
            if (isInhibitPolicyMapping != null) {
                match = false;
            }
        } else if (!expInhibitPolicyMapping.equals(isInhibitPolicyMapping)) {
            match = false;
        }
        if (!match) {
            ExtensionsChecker.addViolation(failureMsg, "inhibitPolicyMapping", isInhibitPolicyMapping, expInhibitPolicyMapping);
        }
    }

    private void checkExtnKeyUsage(StringBuilder failureMsg, byte[] extensionValue, boolean[] usages, Extensions requestedExtns, Certprofile.ExtensionControl extControl) {
        Set<String> diffs;
        byte[] constantExtValue;
        Extension extension;
        int len = usages.length;
        if (len > 9) {
            failureMsg.append("invalid syntax: size of valid bits is larger than 9: ").append(len);
            failureMsg.append("; ");
        }
        HashSet<String> isUsages = new HashSet<String>();
        for (int i = 0; i < len; ++i) {
            if (!usages[i]) continue;
            isUsages.add(ALL_USAGES.get(i));
        }
        Set<String> expectedUsages = new HashSet<String>();
        Set<Certprofile.KeyUsageControl> requiredKeyusage = this.getKeyusage(true);
        for (Certprofile.KeyUsageControl usage : requiredKeyusage) {
            expectedUsages.add(usage.getKeyUsage().getName());
        }
        Set<Certprofile.KeyUsageControl> optionalKeyusage = this.getKeyusage(false);
        if (requestedExtns != null && extControl.isRequest() && CollectionUtil.isNonEmpty(optionalKeyusage) && (extension = requestedExtns.getExtension(Extension.keyUsage)) != null) {
            org.bouncycastle.asn1.x509.KeyUsage reqKeyUsage = org.bouncycastle.asn1.x509.KeyUsage.getInstance((Object)extension.getParsedValue());
            for (Certprofile.KeyUsageControl k : optionalKeyusage) {
                if (!reqKeyUsage.hasUsages(k.getKeyUsage().getBcUsage())) continue;
                expectedUsages.add(k.getKeyUsage().getName());
            }
        }
        if (CollectionUtil.isEmpty(expectedUsages) && (constantExtValue = this.getConstantExtensionValue(Extension.keyUsage)) != null) {
            expectedUsages = ExtensionsChecker.getKeyUsage(constantExtValue);
        }
        if (CollectionUtil.isNonEmpty(diffs = ExtensionsChecker.strInBnotInA(expectedUsages, isUsages))) {
            failureMsg.append("usages ").append(diffs).append(" are present but not expected; ");
        }
        if (CollectionUtil.isNonEmpty(diffs = ExtensionsChecker.strInBnotInA(isUsages, expectedUsages))) {
            failureMsg.append("usages ").append(diffs).append(" are absent but are required; ");
        }
    }

    private void checkExtnExtendedKeyUsage(StringBuilder failureMsg, byte[] extensionValue, Extensions requestedExtns, Certprofile.ExtensionControl extControl) {
        Set<String> set;
        Set<String> set2;
        byte[] byArray;
        Extension extension;
        HashSet<String> isUsages = new HashSet<String>();
        ExtendedKeyUsage keyusage = ExtendedKeyUsage.getInstance((Object)extensionValue);
        KeyPurposeId[] usages = keyusage.getUsages();
        if (usages != null) {
            for (KeyPurposeId keyPurposeId : usages) {
                isUsages.add(keyPurposeId.getId());
            }
        }
        Set<String> expectedUsages = new HashSet<String>();
        Set<Certprofile.ExtKeyUsageControl> requiredExtKeyusage = this.getExtKeyusage(true);
        if (requiredExtKeyusage != null) {
            for (Certprofile.ExtKeyUsageControl extKeyUsageControl : requiredExtKeyusage) {
                expectedUsages.add(extKeyUsageControl.getExtKeyUsage().getId());
            }
        }
        Set<Certprofile.ExtKeyUsageControl> optionalExtKeyusage = this.getExtKeyusage(false);
        if (requestedExtns != null && extControl.isRequest() && CollectionUtil.isNonEmpty(optionalExtKeyusage) && (extension = requestedExtns.getExtension(Extension.extendedKeyUsage)) != null) {
            ExtendedKeyUsage reqKeyUsage = ExtendedKeyUsage.getInstance((Object)extension.getParsedValue());
            for (Certprofile.ExtKeyUsageControl k : optionalExtKeyusage) {
                if (!reqKeyUsage.hasKeyPurposeId(KeyPurposeId.getInstance((Object)k.getExtKeyUsage()))) continue;
                expectedUsages.add(k.getExtKeyUsage().getId());
            }
        }
        if (CollectionUtil.isEmpty(expectedUsages) && (byArray = this.getConstantExtensionValue(Extension.keyUsage)) != null) {
            expectedUsages = ExtensionsChecker.getExtKeyUsage(byArray);
        }
        if (CollectionUtil.isNonEmpty(set2 = ExtensionsChecker.strInBnotInA(expectedUsages, isUsages))) {
            failureMsg.append("usages ").append(set2).append(" are present but not expected; ");
        }
        if (CollectionUtil.isNonEmpty(set = ExtensionsChecker.strInBnotInA(isUsages, expectedUsages))) {
            failureMsg.append("usages ").append(set).append(" are absent but are required; ");
        }
    }

    private void checkExtnTlsFeature(StringBuilder failureMsg, byte[] extensionValue, Extensions requestedExtns, Certprofile.ExtensionControl extControl) {
        ExtensionType.TlsFeature conf = this.tlsFeature;
        if (this.tlsFeature == null) {
            this.checkConstantExtnValue(ObjectIdentifiers.id_pe_tlsfeature, failureMsg, extensionValue, requestedExtns, extControl);
            return;
        }
        HashSet<String> isFeatures = new HashSet<String>();
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)extensionValue);
        int n = seq.size();
        for (int i = 0; i < n; ++i) {
            ASN1Integer asn1Feature = ASN1Integer.getInstance((Object)seq.getObjectAt(i));
            isFeatures.add(asn1Feature.getPositiveValue().toString());
        }
        HashSet<String> expFeatures = new HashSet<String>();
        for (Describable.DescribableInt m : conf.getFeatures()) {
            expFeatures.add(Integer.toString(m.getValue()));
        }
        Set<String> diffs = ExtensionsChecker.strInBnotInA(expFeatures, isFeatures);
        if (CollectionUtil.isNonEmpty(diffs)) {
            failureMsg.append("features ").append(diffs).append(" are present but not expected; ");
        }
        if (CollectionUtil.isNonEmpty(diffs = ExtensionsChecker.strInBnotInA(isFeatures, expFeatures))) {
            failureMsg.append("features ").append(diffs).append(" are absent but are required; ");
        }
    }

    private void checkExtnCertificatePolicies(StringBuilder failureMsg, byte[] extensionValue, Extensions requestedExtns, Certprofile.ExtensionControl extControl) {
        ExtensionType.CertificatePolicies conf = this.certificatePolicies;
        if (conf == null) {
            this.checkConstantExtnValue(Extension.certificatePolicies, failureMsg, extensionValue, requestedExtns, extControl);
            return;
        }
        HashMap<String, CertificatePolicyInformationType> expPoliciesMap = new HashMap<String, CertificatePolicyInformationType>();
        for (CertificatePolicyInformationType cp : conf.getCertificatePolicyInformations()) {
            expPoliciesMap.put(cp.getPolicyIdentifier().getOid(), cp);
        }
        HashSet expPolicyIds = new HashSet(expPoliciesMap.keySet());
        CertificatePolicies asn1 = CertificatePolicies.getInstance((Object)extensionValue);
        PolicyInformation[] isPolicyInformations = asn1.getPolicyInformation();
        for (PolicyInformation isPolicyInformation : isPolicyInformations) {
            ASN1ObjectIdentifier isPolicyId = isPolicyInformation.getPolicyIdentifier();
            expPolicyIds.remove(isPolicyId.getId());
            CertificatePolicyInformationType expCp = (CertificatePolicyInformationType)expPoliciesMap.get(isPolicyId.getId());
            if (expCp == null) {
                failureMsg.append("certificate policy '").append(isPolicyId).append("' is not expected; ");
                continue;
            }
            List expCpPq = expCp.getPolicyQualifiers();
            if (CollectionUtil.isEmpty((Collection)expCpPq)) continue;
            ASN1Sequence isPolicyQualifiers = isPolicyInformation.getPolicyQualifiers();
            LinkedList<String> isCpsUris = new LinkedList<String>();
            LinkedList<String> isUserNotices = new LinkedList<String>();
            int size = isPolicyQualifiers.size();
            for (int i = 0; i < size; ++i) {
                UserNotice isUserNotice;
                PolicyQualifierInfo isPolicyQualifierInfo = (PolicyQualifierInfo)isPolicyQualifiers.getObjectAt(i);
                ASN1ObjectIdentifier isPolicyQualifierId = isPolicyQualifierInfo.getPolicyQualifierId();
                ASN1Encodable isQualifier = isPolicyQualifierInfo.getQualifier();
                if (PolicyQualifierId.id_qt_cps.equals((Object)isPolicyQualifierId)) {
                    String isCpsUri = ((DERIA5String)isQualifier).getString();
                    isCpsUris.add(isCpsUri);
                    continue;
                }
                if (!PolicyQualifierId.id_qt_unotice.equals((Object)isPolicyQualifierId) || (isUserNotice = UserNotice.getInstance((Object)isQualifier)).getExplicitText() == null) continue;
                isUserNotices.add(isUserNotice.getExplicitText().getString());
            }
            block7: for (CertificatePolicyInformationType.PolicyQualifier qualifierInfo : expCpPq) {
                String value = qualifierInfo.getValue();
                switch (qualifierInfo.getType()) {
                    case cpsUri: {
                        if (isCpsUris.contains(value)) continue block7;
                        failureMsg.append("CPSUri '").append(value).append("' is absent but is required; ");
                        continue block7;
                    }
                    case userNotice: {
                        if (isUserNotices.contains(value)) continue block7;
                        failureMsg.append("userNotice '").append(value).append("' is absent but is required; ");
                        continue block7;
                    }
                }
                throw new IllegalStateException("should not reach here");
            }
        }
        for (String policyId : expPolicyIds) {
            failureMsg.append("certificate policy '").append(policyId).append("' is absent but is required; ");
        }
    }

    private void checkExtnPolicyMappings(StringBuilder failureMsg, byte[] extensionValue, Extensions requestedExtns, Certprofile.ExtensionControl extControl) {
        ExtensionType.PolicyMappings conf = this.policyMappings;
        if (conf == null) {
            this.checkConstantExtnValue(Extension.policyMappings, failureMsg, extensionValue, requestedExtns, extControl);
            return;
        }
        ASN1Sequence isPolicyMappings = DERSequence.getInstance((Object)extensionValue);
        HashMap<String, String> isMap = new HashMap<String, String>();
        int size = isPolicyMappings.size();
        for (int i = 0; i < size; ++i) {
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)isPolicyMappings.getObjectAt(i));
            CertPolicyId issuerDomainPolicy = CertPolicyId.getInstance((Object)seq.getObjectAt(0));
            CertPolicyId subjectDomainPolicy = CertPolicyId.getInstance((Object)seq.getObjectAt(1));
            isMap.put(issuerDomainPolicy.getId(), subjectDomainPolicy.getId());
        }
        for (ExtensionType.PolicyIdMappingType m : conf.getMappings()) {
            String expIssuerDomainPolicy = m.getIssuerDomainPolicy().getOid();
            String expSubjectDomainPolicy = m.getSubjectDomainPolicy().getOid();
            String isSubjectDomainPolicy = (String)isMap.remove(expIssuerDomainPolicy);
            if (isSubjectDomainPolicy == null) {
                failureMsg.append("issuerDomainPolicy '").append(expIssuerDomainPolicy).append("' is absent but is required; ");
                continue;
            }
            if (isSubjectDomainPolicy.equals(expSubjectDomainPolicy)) continue;
            ExtensionsChecker.addViolation(failureMsg, "subjectDomainPolicy for issuerDomainPolicy", isSubjectDomainPolicy, expSubjectDomainPolicy);
        }
        if (CollectionUtil.isNonEmpty(isMap)) {
            failureMsg.append("issuerDomainPolicies '").append(isMap.keySet()).append("' are present but not expected; ");
        }
    }

    private void checkExtnInhibitAnyPolicy(StringBuilder failureMsg, byte[] extensionValue, Extensions requestedExtns, Certprofile.ExtensionControl extControl) {
        ExtensionType.InhibitAnyPolicy conf = this.inhibitAnyPolicy;
        if (conf == null) {
            this.checkConstantExtnValue(Extension.inhibitAnyPolicy, failureMsg, extensionValue, requestedExtns, extControl);
            return;
        }
        ASN1Integer asn1Int = ASN1Integer.getInstance((Object)extensionValue);
        int isSkipCerts = asn1Int.getPositiveValue().intValue();
        if (isSkipCerts != conf.getSkipCerts()) {
            ExtensionsChecker.addViolation(failureMsg, "skipCerts", isSkipCerts, conf.getSkipCerts());
        }
    }

    private void checkExtnSubjectDirAttrs(StringBuilder failureMsg, byte[] extensionValue, Extensions requestedExtns, Certprofile.ExtensionControl extControl) {
        SubjectDirectoryAttributesControl conf = this.certprofile.getSubjectDirAttrsControl();
        if (conf == null) {
            failureMsg.append("extension is present but not expected; ");
            return;
        }
        ASN1Encodable extInRequest = null;
        if (requestedExtns != null) {
            extInRequest = requestedExtns.getExtensionParsedValue(Extension.subjectDirectoryAttributes);
        }
        if (extInRequest == null) {
            failureMsg.append("extension is present but not expected; ");
            return;
        }
        SubjectDirectoryAttributes requested = SubjectDirectoryAttributes.getInstance((Object)extInRequest);
        Vector reqSubDirAttrs = requested.getAttributes();
        ASN1GeneralizedTime expDateOfBirth = null;
        String expPlaceOfBirth = null;
        String expGender = null;
        HashSet<String> expCountryOfCitizenshipList = new HashSet<String>();
        HashSet<String> expCountryOfResidenceList = new HashSet<String>();
        HashMap<ASN1ObjectIdentifier, HashSet<ASN1Encodable>> expOtherAttrs = new HashMap<ASN1ObjectIdentifier, HashSet<ASN1Encodable>>();
        int expN = reqSubDirAttrs.size();
        for (int i = 0; i < expN; ++i) {
            String country;
            Attribute attr = Attribute.getInstance(reqSubDirAttrs.get(i));
            ASN1ObjectIdentifier attrType = attr.getAttrType();
            ASN1Encodable attrVal = attr.getAttributeValues()[0];
            if (ObjectIdentifiers.DN_DATE_OF_BIRTH.equals((Object)attrType)) {
                expDateOfBirth = ASN1GeneralizedTime.getInstance((Object)attrVal);
                continue;
            }
            if (ObjectIdentifiers.DN_PLACE_OF_BIRTH.equals((Object)attrType)) {
                expPlaceOfBirth = DirectoryString.getInstance((Object)attrVal).getString();
                continue;
            }
            if (ObjectIdentifiers.DN_GENDER.equals((Object)attrType)) {
                expGender = DERPrintableString.getInstance((Object)attrVal).getString();
                continue;
            }
            if (ObjectIdentifiers.DN_COUNTRY_OF_CITIZENSHIP.equals((Object)attrType)) {
                country = DERPrintableString.getInstance((Object)attrVal).getString();
                expCountryOfCitizenshipList.add(country);
                continue;
            }
            if (ObjectIdentifiers.DN_COUNTRY_OF_RESIDENCE.equals((Object)attrType)) {
                country = DERPrintableString.getInstance((Object)attrVal).getString();
                expCountryOfResidenceList.add(country);
                continue;
            }
            HashSet<ASN1Encodable> otherAttrVals = (HashSet<ASN1Encodable>)expOtherAttrs.get(attrType);
            if (otherAttrVals == null) {
                otherAttrVals = new HashSet<ASN1Encodable>();
                expOtherAttrs.put(attrType, otherAttrVals);
            }
            otherAttrVals.add(attrVal);
        }
        SubjectDirectoryAttributes ext = SubjectDirectoryAttributes.getInstance((Object)extensionValue);
        Vector subDirAttrs = ext.getAttributes();
        ASN1GeneralizedTime dateOfBirth = null;
        String placeOfBirth = null;
        String gender = null;
        HashSet<String> countryOfCitizenshipList = new HashSet<String>();
        HashSet<String> countryOfResidenceList = new HashSet<String>();
        HashMap<ASN1ObjectIdentifier, HashSet<ASN1Encodable>> otherAttrs = new HashMap<ASN1ObjectIdentifier, HashSet<ASN1Encodable>>();
        LinkedList attrTypes = new LinkedList(conf.getTypes());
        int n = subDirAttrs.size();
        for (int i = 0; i < n; ++i) {
            String country;
            Attribute attr = Attribute.getInstance(subDirAttrs.get(i));
            ASN1ObjectIdentifier attrType = attr.getAttrType();
            if (!attrTypes.contains(attrType)) {
                failureMsg.append("attribute of type " + attrType.getId()).append(" is present but not expected; ");
                continue;
            }
            ASN1Encodable[] attrs = attr.getAttributeValues();
            if (attrs.length != 1) {
                failureMsg.append("attribute of type ").append(attrType.getId()).append(" does not single-value value: ").append(attrs.length).append("; ");
                continue;
            }
            ASN1Encodable attrVal = attrs[0];
            if (ObjectIdentifiers.DN_DATE_OF_BIRTH.equals((Object)attrType)) {
                dateOfBirth = ASN1GeneralizedTime.getInstance((Object)attrVal);
                continue;
            }
            if (ObjectIdentifiers.DN_PLACE_OF_BIRTH.equals((Object)attrType)) {
                placeOfBirth = DirectoryString.getInstance((Object)attrVal).getString();
                continue;
            }
            if (ObjectIdentifiers.DN_GENDER.equals((Object)attrType)) {
                gender = DERPrintableString.getInstance((Object)attrVal).getString();
                continue;
            }
            if (ObjectIdentifiers.DN_COUNTRY_OF_CITIZENSHIP.equals((Object)attrType)) {
                country = DERPrintableString.getInstance((Object)attrVal).getString();
                countryOfCitizenshipList.add(country);
                continue;
            }
            if (ObjectIdentifiers.DN_COUNTRY_OF_RESIDENCE.equals((Object)attrType)) {
                country = DERPrintableString.getInstance((Object)attrVal).getString();
                countryOfResidenceList.add(country);
                continue;
            }
            HashSet<ASN1Encodable> otherAttrVals = (HashSet<ASN1Encodable>)otherAttrs.get(attrType);
            if (otherAttrVals == null) {
                otherAttrVals = new HashSet<ASN1Encodable>();
                otherAttrs.put(attrType, otherAttrVals);
            }
            otherAttrVals.add(attrVal);
        }
        if (dateOfBirth != null) {
            attrTypes.remove(ObjectIdentifiers.DN_DATE_OF_BIRTH);
        }
        if (placeOfBirth != null) {
            attrTypes.remove(ObjectIdentifiers.DN_PLACE_OF_BIRTH);
        }
        if (gender != null) {
            attrTypes.remove(ObjectIdentifiers.DN_GENDER);
        }
        if (!countryOfCitizenshipList.isEmpty()) {
            attrTypes.remove(ObjectIdentifiers.DN_COUNTRY_OF_CITIZENSHIP);
        }
        if (!countryOfResidenceList.isEmpty()) {
            attrTypes.remove(ObjectIdentifiers.DN_COUNTRY_OF_RESIDENCE);
        }
        attrTypes.removeAll(otherAttrs.keySet());
        if (!attrTypes.isEmpty()) {
            LinkedList<String> attrTypeTexts = new LinkedList<String>();
            for (ASN1ObjectIdentifier oid : attrTypes) {
                attrTypeTexts.add(oid.getId());
            }
            failureMsg.append("required attributes of types ").append(attrTypeTexts).append(" are not present; ");
        }
        if (dateOfBirth != null) {
            String exp;
            String timeStirng = dateOfBirth.getTimeString();
            if (!SubjectDnSpec.PATTERN_DATE_OF_BIRTH.matcher(timeStirng).matches()) {
                failureMsg.append("invalid dateOfBirth: " + timeStirng + "; ");
            }
            String string = exp = expDateOfBirth == null ? null : expDateOfBirth.getTimeString();
            if (!timeStirng.equalsIgnoreCase(exp)) {
                ExtensionsChecker.addViolation(failureMsg, "dateOfBirth", timeStirng, exp);
            }
        }
        if (gender != null) {
            if (!gender.equalsIgnoreCase("F") && !gender.equalsIgnoreCase("M")) {
                failureMsg.append("invalid gender: ").append(gender).append("; ");
            }
            if (!gender.equalsIgnoreCase(expGender)) {
                ExtensionsChecker.addViolation(failureMsg, "gender", gender, expGender);
            }
        }
        if (placeOfBirth != null && !placeOfBirth.equals(expPlaceOfBirth)) {
            ExtensionsChecker.addViolation(failureMsg, "placeOfBirth", placeOfBirth, expPlaceOfBirth);
        }
        if (!countryOfCitizenshipList.isEmpty()) {
            Set<String> diffs = ExtensionsChecker.strInBnotInA(expCountryOfCitizenshipList, countryOfCitizenshipList);
            if (CollectionUtil.isNonEmpty(diffs)) {
                failureMsg.append("countryOfCitizenship ").append(diffs).append(" are present but not expected; ");
            }
            if (CollectionUtil.isNonEmpty(diffs = ExtensionsChecker.strInBnotInA(countryOfCitizenshipList, expCountryOfCitizenshipList))) {
                failureMsg.append("countryOfCitizenship ").append(diffs).append(" are absent but are required; ");
            }
        }
        if (!countryOfResidenceList.isEmpty()) {
            Set<String> diffs = ExtensionsChecker.strInBnotInA(expCountryOfResidenceList, countryOfResidenceList);
            if (CollectionUtil.isNonEmpty(diffs)) {
                failureMsg.append("countryOfResidence ").append(diffs).append(" are present but not expected; ");
            }
            if (CollectionUtil.isNonEmpty(diffs = ExtensionsChecker.strInBnotInA(countryOfResidenceList, expCountryOfResidenceList))) {
                failureMsg.append("countryOfResidence ").append(diffs).append(" are absent but are required; ");
            }
        }
        if (!otherAttrs.isEmpty()) {
            for (ASN1ObjectIdentifier attrType : otherAttrs.keySet()) {
                Set expAttrValues = (Set)expOtherAttrs.get(attrType);
                if (expAttrValues == null) {
                    failureMsg.append("attribute of type ").append(attrType.getId()).append(" is present but not requested; ");
                    continue;
                }
                Set attrValues = (Set)otherAttrs.get(attrType);
                if (attrValues.equals(expAttrValues)) continue;
                failureMsg.append("attribute of type ").append(attrType.getId()).append(" differs from the requested one; ");
            }
        }
    }

    private void checkExtnSubjectAltName(StringBuilder failureMsg, byte[] extensionValue, Extensions requestedExtns, Certprofile.ExtensionControl extControl, X500Name requestedSubject) {
        int i;
        GeneralName[] requested;
        Set conf = this.certprofile.getSubjectAltNameModes();
        try {
            requested = this.getRequestedSubjectAltNames(requestedSubject, requestedExtns);
        }
        catch (BadCertTemplateException | CertprofileException ex) {
            String msg = "error while derive grantedSubject from requestedSubject";
            LogUtil.warn((Logger)LOG, (Throwable)ex, (String)msg);
            failureMsg.append(msg);
            return;
        }
        if (requested == null) {
            failureMsg.append("extension is present but not expected; ");
            return;
        }
        GeneralName[] is = GeneralNames.getInstance((Object)extensionValue).getNames();
        GeneralName[] expected = new GeneralName[requested.length];
        for (i = 0; i < is.length; ++i) {
            try {
                expected[i] = ExtensionsChecker.createGeneralName(is[i], conf);
                continue;
            }
            catch (BadCertTemplateException ex) {
                failureMsg.append("could not process ").append(i + 1).append("-th name: ").append(ex.getMessage()).append("; ");
                return;
            }
        }
        if (is.length != expected.length) {
            ExtensionsChecker.addViolation(failureMsg, "size of GeneralNames", is.length, expected.length);
            return;
        }
        for (i = 0; i < is.length; ++i) {
            if (is[i].equals((Object)expected[i])) continue;
            failureMsg.append(i + 1).append("-th name does not match the requested one; ");
        }
    }

    private GeneralName[] getRequestedSubjectAltNames(X500Name requestedSubject, Extensions requestedExtns) throws CertprofileException, BadCertTemplateException {
        ASN1Encodable extValue = requestedExtns == null ? null : requestedExtns.getExtensionParsedValue(Extension.subjectAlternativeName);
        Map subjectToSubjectAltNameModes = this.certprofile.getSubjectToSubjectAltNameModes();
        if (extValue == null && subjectToSubjectAltNameModes == null) {
            return null;
        }
        GeneralNames reqNames = extValue == null ? null : GeneralNames.getInstance((Object)extValue);
        Set subjectAltNameModes = this.certprofile.getSubjectAltNameModes();
        if (subjectAltNameModes == null && subjectToSubjectAltNameModes == null) {
            return reqNames == null ? null : reqNames.getNames();
        }
        LinkedList<GeneralName> grantedNames = new LinkedList<GeneralName>();
        if (subjectToSubjectAltNameModes != null) {
            X500Name grantedSubject = this.certprofile.getSubject(requestedSubject).getGrantedSubject();
            for (ASN1ObjectIdentifier attrType : subjectToSubjectAltNameModes.keySet()) {
                Certprofile.GeneralNameTag tag = (Certprofile.GeneralNameTag)subjectToSubjectAltNameModes.get(attrType);
                RDN[] rdns = grantedSubject.getRDNs(attrType);
                if (rdns == null) {
                    rdns = requestedSubject.getRDNs(attrType);
                }
                if (rdns == null) continue;
                block4: for (RDN rdn : rdns) {
                    String rdnValue = X509Util.rdnValueToString((ASN1Encodable)rdn.getFirst().getValue());
                    switch (tag) {
                        case rfc822Name: 
                        case DNSName: 
                        case uniformResourceIdentifier: 
                        case IPAddress: 
                        case directoryName: 
                        case registeredID: {
                            grantedNames.add(new GeneralName(tag.getTag(), rdnValue));
                            continue block4;
                        }
                        default: {
                            throw new IllegalStateException("should not reach here, unknown GeneralName tag " + tag);
                        }
                    }
                }
            }
        }
        if (reqNames != null) {
            GeneralName[] reqL = reqNames.getNames();
            for (int i = 0; i < reqL.length; ++i) {
                grantedNames.add(reqL[i]);
            }
        }
        return grantedNames.isEmpty() ? null : grantedNames.toArray(new GeneralName[0]);
    }

    private void checkExtnSubjectInfoAccess(StringBuilder failureMsg, byte[] extensionValue, Extensions requestedExtns, Certprofile.ExtensionControl extControl) {
        Map conf = this.certprofile.getSubjectInfoAccessModes();
        if (conf == null) {
            failureMsg.append("extension is present but not expected; ");
            return;
        }
        ASN1Encodable requestExtValue = null;
        if (requestedExtns != null) {
            requestExtValue = requestedExtns.getExtensionParsedValue(Extension.subjectInfoAccess);
        }
        if (requestExtValue == null) {
            failureMsg.append("extension is present but not expected; ");
            return;
        }
        ASN1Sequence requestSeq = ASN1Sequence.getInstance((Object)requestExtValue);
        ASN1Sequence certSeq = ASN1Sequence.getInstance((Object)extensionValue);
        int size = requestSeq.size();
        if (certSeq.size() != size) {
            ExtensionsChecker.addViolation(failureMsg, "size of GeneralNames", certSeq.size(), size);
            return;
        }
        for (int i = 0; i < size; ++i) {
            GeneralName accessLocation;
            boolean bo;
            AccessDescription ad = AccessDescription.getInstance((Object)requestSeq.getObjectAt(i));
            ASN1ObjectIdentifier accessMethod = ad.getAccessMethod();
            Set generalNameModes = (Set)conf.get(accessMethod);
            if (generalNameModes == null) {
                failureMsg.append("accessMethod in requestedExtension ").append(accessMethod.getId()).append(" is not allowed; ");
                continue;
            }
            AccessDescription certAccessDesc = AccessDescription.getInstance((Object)certSeq.getObjectAt(i));
            ASN1ObjectIdentifier certAccessMethod = certAccessDesc.getAccessMethod();
            boolean bl = accessMethod == null ? certAccessMethod == null : (bo = accessMethod.equals((Object)certAccessMethod));
            if (!bo) {
                ExtensionsChecker.addViolation(failureMsg, "accessMethod", certAccessMethod == null ? "null" : certAccessMethod.getId(), accessMethod == null ? "null" : accessMethod.getId());
                continue;
            }
            try {
                accessLocation = ExtensionsChecker.createGeneralName(ad.getAccessLocation(), generalNameModes);
            }
            catch (BadCertTemplateException ex) {
                failureMsg.append("invalid requestedExtension: ").append(ex.getMessage()).append("; ");
                continue;
            }
            GeneralName certAccessLocation = certAccessDesc.getAccessLocation();
            if (certAccessLocation.equals((Object)accessLocation)) continue;
            failureMsg.append("accessLocation does not match the requested one; ");
        }
    }

    private void checkExtnIssuerAltNames(StringBuilder failureMsg, byte[] extensionValue, IssuerInfo issuerInfo) {
        Extension caSubjectAltExtension = issuerInfo.getBcCert().getTBSCertificate().getExtensions().getExtension(Extension.subjectAlternativeName);
        if (caSubjectAltExtension == null) {
            failureMsg.append("issuerAlternativeName is present but expected 'none'; ");
            return;
        }
        byte[] caSubjectAltExtensionValue = caSubjectAltExtension.getExtnValue().getOctets();
        if (!Arrays.equals(caSubjectAltExtensionValue, extensionValue)) {
            ExtensionsChecker.addViolation(failureMsg, "issuerAltNames", ExtensionsChecker.hex(extensionValue), ExtensionsChecker.hex(caSubjectAltExtensionValue));
        }
    }

    private void checkExtnCrlDistributionPoints(StringBuilder failureMsg, byte[] extensionValue, IssuerInfo issuerInfo) {
        CRLDistPoint isCrlDistPoints = CRLDistPoint.getInstance((Object)extensionValue);
        DistributionPoint[] isDistributionPoints = isCrlDistPoints.getDistributionPoints();
        if (isDistributionPoints == null) {
            ExtensionsChecker.addViolation(failureMsg, "size of CRLDistributionPoints", 0, 1);
            return;
        }
        int len = isDistributionPoints.length;
        if (len != 1) {
            ExtensionsChecker.addViolation(failureMsg, "size of CRLDistributionPoints", len, 1);
            return;
        }
        HashSet<String> isCrlUrls = new HashSet<String>();
        for (DistributionPoint entry : isDistributionPoints) {
            int asn1Type = entry.getDistributionPoint().getType();
            if (asn1Type != 0) {
                ExtensionsChecker.addViolation(failureMsg, "tag of DistributionPointName of CRLDistibutionPoints", asn1Type, 0);
                continue;
            }
            GeneralNames isDistributionPointNames = GeneralNames.getInstance((Object)entry.getDistributionPoint().getName());
            GeneralName[] names = isDistributionPointNames.getNames();
            for (int i = 0; i < names.length; ++i) {
                GeneralName name = names[i];
                if (name.getTagNo() != 6) {
                    ExtensionsChecker.addViolation(failureMsg, "tag of CRL URL", name.getTagNo(), 6);
                    continue;
                }
                String uri = ((ASN1String)name.getName()).getString();
                isCrlUrls.add(uri);
            }
            Set<String> expCrlUrls = issuerInfo.getCrlUrls();
            Set<String> diffs = ExtensionsChecker.strInBnotInA(expCrlUrls, isCrlUrls);
            if (CollectionUtil.isNonEmpty(diffs)) {
                failureMsg.append("CRL URLs ").append(diffs).append(" are present but not expected; ");
            }
            if (!CollectionUtil.isNonEmpty(diffs = ExtensionsChecker.strInBnotInA(isCrlUrls, expCrlUrls))) continue;
            failureMsg.append("CRL URLs ").append(diffs).append(" are absent but are required; ");
        }
    }

    private void checkExtnDeltaCrlDistributionPoints(StringBuilder failureMsg, byte[] extensionValue, IssuerInfo issuerInfo) {
        CRLDistPoint isCrlDistPoints = CRLDistPoint.getInstance((Object)extensionValue);
        DistributionPoint[] isDistributionPoints = isCrlDistPoints.getDistributionPoints();
        if (isDistributionPoints == null) {
            ExtensionsChecker.addViolation(failureMsg, "size of CRLDistributionPoints (deltaCRL)", 0, 1);
            return;
        }
        int len = isDistributionPoints.length;
        if (len != 1) {
            ExtensionsChecker.addViolation(failureMsg, "size of CRLDistributionPoints (deltaCRL)", len, 1);
            return;
        }
        HashSet<String> isCrlUrls = new HashSet<String>();
        for (DistributionPoint entry : isDistributionPoints) {
            int asn1Type = entry.getDistributionPoint().getType();
            if (asn1Type != 0) {
                ExtensionsChecker.addViolation(failureMsg, "tag of DistributionPointName of CRLDistibutionPoints (deltaCRL)", asn1Type, 0);
                continue;
            }
            GeneralNames isDistributionPointNames = GeneralNames.getInstance((Object)entry.getDistributionPoint().getName());
            GeneralName[] names = isDistributionPointNames.getNames();
            for (int i = 0; i < names.length; ++i) {
                GeneralName name = names[i];
                if (name.getTagNo() != 6) {
                    ExtensionsChecker.addViolation(failureMsg, "tag of deltaCRL URL", name.getTagNo(), 6);
                    continue;
                }
                String uri = ((ASN1String)name.getName()).getString();
                isCrlUrls.add(uri);
            }
            Set<String> expCrlUrls = issuerInfo.getCrlUrls();
            Set<String> diffs = ExtensionsChecker.strInBnotInA(expCrlUrls, isCrlUrls);
            if (CollectionUtil.isNonEmpty(diffs)) {
                failureMsg.append("deltaCRL URLs ").append(diffs).append(" are present but not expected; ");
            }
            if (!CollectionUtil.isNonEmpty(diffs = ExtensionsChecker.strInBnotInA(isCrlUrls, expCrlUrls))) continue;
            failureMsg.append("deltaCRL URLs ").append(diffs).append(" are absent but are required; ");
        }
    }

    private void checkExtnAdmission(StringBuilder failureMsg, byte[] extensionValue, Extensions requestedExtns, Certprofile.ExtensionControl extControl) {
        AdmissionSyntaxOption conf = this.certprofile.getAdmission();
        ASN1ObjectIdentifier type = ObjectIdentifiers.id_extension_admission;
        if (conf == null) {
            this.checkConstantExtnValue(type, failureMsg, extensionValue, requestedExtns, extControl);
            return;
        }
        ArrayList reqRegNumsList = null;
        if (requestedExtns != null && conf.isInputFromRequestRequired()) {
            Extension extension = requestedExtns.getExtension(type);
            if (extension == null) {
                failureMsg.append("no Admission extension is contained in the request;");
                return;
            }
            Admissions[] reqAdmissions = AdmissionSyntax.getInstance((Object)extension.getParsedValue()).getContentsOfAdmissions();
            int n = reqAdmissions.length;
            reqRegNumsList = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                Admissions reqAdmission = reqAdmissions[i];
                ProfessionInfo[] reqPis = reqAdmission.getProfessionInfos();
                ArrayList<String> reqNums = new ArrayList<String>(reqPis.length);
                reqRegNumsList.add(reqNums);
                for (ProfessionInfo reqPi : reqPis) {
                    String reqNum = reqPi.getRegistrationNumber();
                    reqNums.add(reqNum);
                }
            }
        }
        try {
            byte[] expected = conf.getExtensionValue(reqRegNumsList).getValue().toASN1Primitive().getEncoded();
            if (!Arrays.equals(expected, extensionValue)) {
                ExtensionsChecker.addViolation(failureMsg, "extension valus", ExtensionsChecker.hex(extensionValue), ExtensionsChecker.hex(expected));
            }
        }
        catch (IOException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex);
            failureMsg.append("IOException while computing the expected extension value;");
        }
        catch (BadCertTemplateException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex);
            failureMsg.append("BadCertTemplateException while computing the expected extension value;");
        }
    }

    private void checkExtnAuthorityInfoAccess(StringBuilder failureMsg, byte[] extensionValue, IssuerInfo issuerInfo) {
        Set<String> expOcspUris;
        Certprofile.AuthorityInfoAccessControl aiaControl = this.certprofile.getAiaControl();
        Set<String> expCaIssuerUris = aiaControl == null || aiaControl.isIncludesCaIssuers() ? issuerInfo.getCaIssuerUrls() : Collections.emptySet();
        Set<String> set = expOcspUris = aiaControl == null || aiaControl.isIncludesOcsp() ? issuerInfo.getOcspUrls() : Collections.emptySet();
        if (CollectionUtil.isEmpty(expCaIssuerUris) && CollectionUtil.isEmpty(expOcspUris)) {
            failureMsg.append("AIA is present but expected is 'none'; ");
            return;
        }
        AuthorityInformationAccess isAia = AuthorityInformationAccess.getInstance((Object)extensionValue);
        ExtensionsChecker.checkAia(failureMsg, isAia, X509ObjectIdentifiers.id_ad_caIssuers, expCaIssuerUris);
        ExtensionsChecker.checkAia(failureMsg, isAia, X509ObjectIdentifiers.id_ad_ocsp, expOcspUris);
    }

    private void checkExtnOcspNocheck(StringBuilder failureMsg, byte[] extensionValue) {
        if (!Arrays.equals(DER_NULL, extensionValue)) {
            failureMsg.append("value is not DER NULL; ");
        }
    }

    private void checkExtnRestriction(StringBuilder failureMsg, byte[] extensionValue, Extensions requestedExtns, Certprofile.ExtensionControl extControl) {
        this.checkDirectoryString(ObjectIdentifiers.id_extension_restriction, this.restriction.getType(), this.restriction.getText(), failureMsg, extensionValue, requestedExtns, extControl);
    }

    private void checkExtnAdditionalInformation(StringBuilder failureMsg, byte[] extensionValue, Extensions requestedExtns, Certprofile.ExtensionControl extControl) {
        this.checkDirectoryString(ObjectIdentifiers.id_extension_additionalInformation, this.additionalInformation.getType(), this.additionalInformation.getText(), failureMsg, extensionValue, requestedExtns, extControl);
    }

    private void checkDirectoryString(ASN1ObjectIdentifier extnType, DirectoryStringType type, String text, StringBuilder failureMsg, byte[] extensionValue, Extensions requestedExtns, Certprofile.ExtensionControl extControl) {
        boolean correctStringType;
        ASN1Primitive asn1;
        if (type == null) {
            this.checkConstantExtnValue(extnType, failureMsg, extensionValue, requestedExtns, extControl);
            return;
        }
        try {
            asn1 = ASN1Primitive.fromByteArray((byte[])extensionValue);
        }
        catch (IOException ex) {
            failureMsg.append("invalid syntax of extension value; ");
            return;
        }
        switch (type) {
            case bmpString: {
                correctStringType = asn1 instanceof DERBMPString;
                break;
            }
            case printableString: {
                correctStringType = asn1 instanceof DERPrintableString;
                break;
            }
            case teletexString: {
                correctStringType = asn1 instanceof DERT61String;
                break;
            }
            case utf8String: {
                correctStringType = asn1 instanceof DERUTF8String;
                break;
            }
            default: {
                throw new IllegalStateException("should not reach here, unknown DirectoryStringType " + type);
            }
        }
        if (!correctStringType) {
            failureMsg.append("extension value is not of type DirectoryString.").append(text).append("; ");
            return;
        }
        String extTextValue = ((ASN1String)asn1).getString();
        if (!text.equals(extTextValue)) {
            ExtensionsChecker.addViolation(failureMsg, "content", extTextValue, text);
        }
    }

    private void checkExtnValidityModel(StringBuilder failureMsg, byte[] extensionValue, Extensions requestedExtns, Certprofile.ExtensionControl extControl) {
        ASN1ObjectIdentifier conf = this.validityModelId;
        if (conf == null) {
            this.checkConstantExtnValue(ObjectIdentifiers.id_extension_validityModel, failureMsg, extensionValue, requestedExtns, extControl);
        } else {
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)extensionValue);
            ASN1ObjectIdentifier extValue = ASN1ObjectIdentifier.getInstance((Object)seq.getObjectAt(0));
            if (!conf.equals((Object)extValue)) {
                ExtensionsChecker.addViolation(failureMsg, "content", extValue, conf);
            }
        }
    }

    private void checkExtnPrivateKeyUsagePeriod(StringBuilder failureMsg, byte[] extensionValue, Date certNotBefore, Date certNotAfter) {
        Date dateNotAfter;
        ASN1GeneralizedTime notBefore = new ASN1GeneralizedTime(certNotBefore);
        Certprofile.CertValidity privateKeyUsagePeriod = this.certprofile.getPrivateKeyUsagePeriod();
        if (privateKeyUsagePeriod == null) {
            dateNotAfter = certNotAfter;
        } else {
            dateNotAfter = privateKeyUsagePeriod.add(certNotBefore);
            if (dateNotAfter.after(certNotAfter)) {
                dateNotAfter = certNotAfter;
            }
        }
        ASN1GeneralizedTime notAfter = new ASN1GeneralizedTime(dateNotAfter);
        PrivateKeyUsagePeriod extValue = PrivateKeyUsagePeriod.getInstance((Object)extensionValue);
        ASN1GeneralizedTime time = extValue.getNotBefore();
        if (time == null) {
            failureMsg.append("notBefore is absent but expected present; ");
        } else if (!time.equals((Object)notBefore)) {
            ExtensionsChecker.addViolation(failureMsg, "notBefore", time.getTimeString(), notBefore.getTimeString());
        }
        time = extValue.getNotAfter();
        if (time == null) {
            failureMsg.append("notAfter is absent but expected present; ");
        } else if (!time.equals((Object)notAfter)) {
            ExtensionsChecker.addViolation(failureMsg, "notAfter", time.getTimeString(), notAfter.getTimeString());
        }
    }

    private void checkExtnQcStatements(StringBuilder failureMsg, byte[] extensionValue, Extensions requestedExtns, Certprofile.ExtensionControl extControl) {
        Extension reqExtension;
        ExtensionType.QcStatements conf = this.qcStatements;
        if (conf == null) {
            this.checkConstantExtnValue(Extension.qCStatements, failureMsg, extensionValue, requestedExtns, extControl);
            return;
        }
        int expSize = conf.getQcStatements().size();
        ASN1Sequence extValue = ASN1Sequence.getInstance((Object)extensionValue);
        int isSize = extValue.size();
        if (isSize != expSize) {
            ExtensionsChecker.addViolation(failureMsg, "number of statements", isSize, expSize);
            return;
        }
        HashMap<String, int[]> reqQcEuLimits = new HashMap<String, int[]>();
        Extension extension = reqExtension = requestedExtns == null ? null : requestedExtns.getExtension(Extension.qCStatements);
        if (reqExtension != null) {
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)reqExtension.getParsedValue());
            int n = seq.size();
            for (int j = 0; j < n; ++j) {
                QCStatement stmt = QCStatement.getInstance((Object)seq.getObjectAt(j));
                if (!ObjectIdentifiers.id_etsi_qcs_QcLimitValue.equals((Object)stmt.getStatementId())) continue;
                MonetaryValue monetaryValue = MonetaryValue.getInstance((Object)stmt.getStatementInfo());
                int amount = monetaryValue.getAmount().intValue();
                int exponent = monetaryValue.getExponent().intValue();
                Iso4217CurrencyCode currency = monetaryValue.getCurrency();
                String currencyS = currency.isAlphabetic() ? currency.getAlphabetic().toUpperCase() : Integer.toString(currency.getNumeric());
                reqQcEuLimits.put(currencyS, new int[]{amount, exponent});
            }
        }
        for (int i = 0; i < expSize; ++i) {
            QCStatement is = QCStatement.getInstance((Object)extValue.getObjectAt(i));
            QcStatementType exp = (QcStatementType)conf.getQcStatements().get(i);
            if (!is.getStatementId().getId().equals(exp.getStatementId().getOid())) {
                ExtensionsChecker.addViolation(failureMsg, "statmentId[" + i + "]", is.getStatementId().getId(), exp.getStatementId().getOid());
                continue;
            }
            if (exp.getStatementValue() == null) {
                if (is.getStatementInfo() == null) continue;
                ExtensionsChecker.addViolation(failureMsg, "statmentInfo[" + i + "]", "present", "absent");
                continue;
            }
            if (is.getStatementInfo() == null) {
                ExtensionsChecker.addViolation(failureMsg, "statmentInfo[" + i + "]", "absent", "present");
                continue;
            }
            QcStatementType.QcStatementValueType expStatementValue = exp.getStatementValue();
            try {
                if (expStatementValue.getConstant() != null) {
                    byte[] expValue = expStatementValue.getConstant().getValue();
                    byte[] isValue = is.getStatementInfo().toASN1Primitive().getEncoded();
                    if (!Arrays.equals(isValue, expValue)) {
                        ExtensionsChecker.addViolation(failureMsg, "statementInfo[" + i + "]", ExtensionsChecker.hex(isValue), ExtensionsChecker.hex(expValue));
                    }
                    continue;
                }
                if (expStatementValue.getQcRetentionPeriod() != null) {
                    String expValue;
                    String isValue = ASN1Integer.getInstance((Object)is.getStatementInfo()).toString();
                    if (!isValue.equals(expValue = expStatementValue.getQcRetentionPeriod().toString())) {
                        ExtensionsChecker.addViolation(failureMsg, "statementInfo[" + i + "]", isValue, expValue);
                    }
                    continue;
                }
                if (expStatementValue.getPdsLocations() != null) {
                    HashSet<String> pdsLocations = new HashSet<String>();
                    ASN1Sequence pdsLocsSeq = ASN1Sequence.getInstance((Object)is.getStatementInfo());
                    int size = pdsLocsSeq.size();
                    for (int k = 0; k < size; ++k) {
                        ASN1Sequence pdsLocSeq = ASN1Sequence.getInstance((Object)pdsLocsSeq.getObjectAt(k));
                        int size2 = pdsLocSeq.size();
                        if (size2 != 2) {
                            throw new IllegalArgumentException("sequence size is " + size2 + " but expected 2");
                        }
                        String url = DERIA5String.getInstance((Object)pdsLocSeq.getObjectAt(0)).getString();
                        String lang = DERPrintableString.getInstance((Object)pdsLocSeq.getObjectAt(1)).getString();
                        pdsLocations.add("url=" + url + ",lang=" + lang);
                    }
                    HashSet<String> expectedPdsLocations = new HashSet<String>();
                    for (QcStatementType.PdsLocationType m : expStatementValue.getPdsLocations()) {
                        expectedPdsLocations.add("url=" + m.getUrl() + ",lang=" + m.getLanguage());
                    }
                    Set<String> diffs = ExtensionsChecker.strInBnotInA(expectedPdsLocations, pdsLocations);
                    if (CollectionUtil.isNonEmpty(diffs)) {
                        failureMsg.append("statementInfo[").append(i).append("]: ").append(diffs).append(" are present but not expected; ");
                    }
                    if (CollectionUtil.isNonEmpty(diffs = ExtensionsChecker.strInBnotInA(pdsLocations, expectedPdsLocations))) {
                        failureMsg.append("statementInfo[").append(i).append("]: ").append(diffs).append(" are absent but are required; ");
                    }
                    continue;
                }
                if (expStatementValue.getQcEuLimitValue() != null) {
                    int value;
                    QcStatementType.QcEuLimitValueType euLimitConf = expStatementValue.getQcEuLimitValue();
                    String expCurrency = euLimitConf.getCurrency().toUpperCase();
                    int[] expAmountExp = (int[])reqQcEuLimits.get(expCurrency);
                    QcStatementType.Range2Type range = euLimitConf.getAmount();
                    if (range.getMin() == range.getMax()) {
                        value = range.getMin();
                    } else if (expAmountExp != null) {
                        value = expAmountExp[0];
                    } else {
                        failureMsg.append("found no QcEuLimit for currency '").append(expCurrency).append("'; ");
                        return;
                    }
                    String expAmount = Integer.toString(value);
                    range = euLimitConf.getExponent();
                    if (range.getMin() == range.getMax()) {
                        value = range.getMin();
                    } else if (expAmountExp != null) {
                        value = expAmountExp[1];
                    } else {
                        failureMsg.append("found no QcEuLimit for currency '").append(expCurrency).append("'; ");
                        return;
                    }
                    String expExponent = Integer.toString(value);
                    MonetaryValue monterayValue = MonetaryValue.getInstance((Object)is.getStatementInfo());
                    Iso4217CurrencyCode currency = monterayValue.getCurrency();
                    String isCurrency = currency.isAlphabetic() ? currency.getAlphabetic() : Integer.toString(currency.getNumeric());
                    String isAmount = monterayValue.getAmount().toString();
                    String isExponent = monterayValue.getExponent().toString();
                    if (!isCurrency.equals(expCurrency)) {
                        ExtensionsChecker.addViolation(failureMsg, "statementInfo[" + i + "].qcEuLimit.currency", isCurrency, expCurrency);
                    }
                    if (!isAmount.equals(expAmount)) {
                        ExtensionsChecker.addViolation(failureMsg, "statementInfo[" + i + "].qcEuLimit.amount", isAmount, expAmount);
                    }
                    if (!isExponent.equals(expExponent)) {
                        ExtensionsChecker.addViolation(failureMsg, "statementInfo[" + i + "].qcEuLimit.exponent", isExponent, expExponent);
                    }
                    continue;
                }
                throw new IllegalStateException("statementInfo[" + i + "]should not reach here");
            }
            catch (IOException ex) {
                failureMsg.append("statementInfo[").append(i).append("] has incorrect syntax; ");
            }
        }
    }

    private void checkExtnBiometricInfo(StringBuilder failureMsg, byte[] extensionValue, Extensions requestedExtns, Certprofile.ExtensionControl extControl) {
        BiometricInfoOption conf = this.certprofile.getBiometricInfo();
        if (conf == null) {
            failureMsg.append("extension is present but not expected; ");
            return;
        }
        ASN1Encodable extInRequest = null;
        if (requestedExtns != null) {
            extInRequest = requestedExtns.getExtensionParsedValue(Extension.biometricInfo);
        }
        if (extInRequest == null) {
            failureMsg.append("extension is present but not expected; ");
            return;
        }
        ASN1Sequence extValueInReq = ASN1Sequence.getInstance((Object)extInRequest);
        int expSize = extValueInReq.size();
        ASN1Sequence extValue = ASN1Sequence.getInstance((Object)extensionValue);
        int isSize = extValue.size();
        if (isSize != expSize) {
            ExtensionsChecker.addViolation(failureMsg, "number of biometricData", isSize, expSize);
            return;
        }
        for (int i = 0; i < expSize; ++i) {
            DERIA5String str;
            byte[] isBytes;
            ASN1Encodable isHashAlgoParam;
            ASN1ObjectIdentifier exp;
            ASN1ObjectIdentifier is;
            TypeOfBiometricData expType;
            BiometricData isData = BiometricData.getInstance((Object)extValue.getObjectAt(i));
            BiometricData expData = BiometricData.getInstance((Object)extValueInReq.getObjectAt(i));
            TypeOfBiometricData isType = isData.getTypeOfBiometricData();
            if (!isType.equals((Object)(expType = expData.getTypeOfBiometricData()))) {
                String isStr = isType.isPredefined() ? Integer.toString(isType.getPredefinedBiometricType()) : isType.getBiometricDataOid().getId();
                String expStr = expType.isPredefined() ? Integer.toString(expType.getPredefinedBiometricType()) : expType.getBiometricDataOid().getId();
                ExtensionsChecker.addViolation(failureMsg, "biometricData[" + i + "].typeOfBiometricData", isStr, expStr);
            }
            if (!(is = isData.getHashAlgorithm().getAlgorithm()).equals((Object)(exp = expData.getHashAlgorithm().getAlgorithm()))) {
                ExtensionsChecker.addViolation(failureMsg, "biometricData[" + i + "].hashAlgorithm", is.getId(), exp.getId());
            }
            if ((isHashAlgoParam = isData.getHashAlgorithm().getParameters()) == null) {
                failureMsg.append("biometricData[").append(i).append("].hashAlgorithm.parameters is 'present' but expected 'absent'; ");
            } else {
                try {
                    isBytes = isHashAlgoParam.toASN1Primitive().getEncoded();
                    if (!Arrays.equals(isBytes, DER_NULL)) {
                        ExtensionsChecker.addViolation(failureMsg, "biometricData[" + i + "].biometricDataHash.parameters", ExtensionsChecker.hex(isBytes), ExtensionsChecker.hex(DER_NULL));
                    }
                }
                catch (IOException ex) {
                    failureMsg.append("biometricData[").append(i).append("].biometricDataHash.parameters has incorrect syntax; ");
                }
            }
            isBytes = isData.getBiometricDataHash().getOctets();
            byte[] expBytes = expData.getBiometricDataHash().getOctets();
            if (!Arrays.equals(isBytes, expBytes)) {
                ExtensionsChecker.addViolation(failureMsg, "biometricData[" + i + "].biometricDataHash", ExtensionsChecker.hex(isBytes), ExtensionsChecker.hex(expBytes));
            }
            String isSourceDataUri = (str = isData.getSourceDataUri()) == null ? null : str.getString();
            String expSourceDataUri = null;
            if (conf.getSourceDataUriOccurrence() != TripleState.forbidden) {
                str = expData.getSourceDataUri();
                String string = expSourceDataUri = str == null ? null : str.getString();
            }
            if (expSourceDataUri == null) {
                if (isSourceDataUri == null) continue;
                ExtensionsChecker.addViolation(failureMsg, "biometricData[" + i + "].sourceDataUri", "present", "absent");
                continue;
            }
            if (isSourceDataUri == null) {
                failureMsg.append("biometricData[").append(i).append("].sourceDataUri is 'absent'");
                failureMsg.append(" but expected 'present'; ");
                continue;
            }
            if (isSourceDataUri.equals(expSourceDataUri)) continue;
            ExtensionsChecker.addViolation(failureMsg, "biometricData[" + i + "].sourceDataUri", isSourceDataUri, expSourceDataUri);
        }
    }

    private void checkExtnAuthorizationTemplate(StringBuilder failureMsg, byte[] extensionValue, Extensions requestedExtns, Certprofile.ExtensionControl extControl) {
        ExtensionType.AuthorizationTemplate conf = this.authorizationTemplate;
        if (conf == null) {
            this.checkConstantExtnValue(ObjectIdentifiers.id_xipki_ext_authorizationTemplate, failureMsg, extensionValue, requestedExtns, extControl);
            byte[] expected = this.getExpectedExtValue(ObjectIdentifiers.id_xipki_ext_authorizationTemplate, requestedExtns, extControl);
            if (!Arrays.equals(expected, extensionValue)) {
                ExtensionsChecker.addViolation(failureMsg, "extension values", ExtensionsChecker.hex(extensionValue), expected == null ? "not present" : ExtensionsChecker.hex(expected));
            }
            return;
        }
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)extensionValue);
        ASN1ObjectIdentifier type = ASN1ObjectIdentifier.getInstance((Object)seq.getObjectAt(0));
        ASN1OctetString accessRights = DEROctetString.getInstance((Object)seq.getObjectAt(1));
        if (!conf.getType().getOid().equals(type.getId())) {
            ExtensionsChecker.addViolation(failureMsg, "type", type.getId(), conf.getType());
        }
        byte[] isRights = accessRights.getOctets();
        if (!Arrays.equals(conf.getAccessRights().getValue(), isRights)) {
            ExtensionsChecker.addViolation(failureMsg, "accessRights", ExtensionsChecker.hex(isRights), ExtensionsChecker.hex(conf.getAccessRights().getValue()));
        }
    }

    private Set<Certprofile.KeyUsageControl> getKeyusage(boolean required) {
        HashSet<Certprofile.KeyUsageControl> ret = new HashSet<Certprofile.KeyUsageControl>();
        Set controls = this.certprofile.getKeyusages();
        if (controls != null) {
            for (Certprofile.KeyUsageControl control : controls) {
                if (control.isRequired() != required) continue;
                ret.add(control);
            }
        }
        return ret;
    }

    private Set<Certprofile.ExtKeyUsageControl> getExtKeyusage(boolean required) {
        HashSet<Certprofile.ExtKeyUsageControl> ret = new HashSet<Certprofile.ExtKeyUsageControl>();
        Set controls = this.certprofile.getExtendedKeyusages();
        if (controls != null) {
            for (Certprofile.ExtKeyUsageControl control : controls) {
                if (control.isRequired() != required) continue;
                ret.add(control);
            }
        }
        return ret;
    }

    private byte[] getConstantExtensionValue(ASN1ObjectIdentifier type) {
        return this.constantExtensions == null ? null : this.constantExtensions.get(type).getValue();
    }

    private static Map<ASN1ObjectIdentifier, QaExtensionValue> buildConstantExtesions(Map<String, ExtensionType> extensions) throws CertprofileException {
        if (extensions == null) {
            return null;
        }
        HashMap<ASN1ObjectIdentifier, QaExtensionValue> map = new HashMap<ASN1ObjectIdentifier, QaExtensionValue>();
        for (String type : extensions.keySet()) {
            ASN1ObjectIdentifier oid;
            ExtensionType extn = extensions.get(type);
            if (extn.getConstant() == null || Extension.subjectAlternativeName.equals((Object)(oid = extn.getType().toXiOid())) || Extension.subjectInfoAccess.equals((Object)oid) || Extension.biometricInfo.equals((Object)oid)) continue;
            byte[] encodedValue = extn.getConstant().getValue();
            ASN1StreamParser parser = new ASN1StreamParser(encodedValue);
            try {
                parser.readObject();
            }
            catch (IOException ex) {
                throw new CertprofileException("could not parse the constant extension value", (Throwable)ex);
            }
            QaExtensionValue extension = new QaExtensionValue(extn.isCritical(), encodedValue);
            map.put(oid, extension);
        }
        if (CollectionUtil.isEmpty(map)) {
            return null;
        }
        return Collections.unmodifiableMap(map);
    }

    private static ASN1Encodable readAsn1Encodable(byte[] encoded) throws CertprofileException {
        ASN1StreamParser parser = new ASN1StreamParser(encoded);
        try {
            return parser.readObject();
        }
        catch (IOException ex) {
            throw new CertprofileException("could not parse the constant extension value", (Throwable)ex);
        }
    }

    private static String hex(byte[] bytes) {
        return Hex.encode((byte[])bytes);
    }

    private static Set<String> strInBnotInA(Collection<String> collectionA, Collection<String> collectionB) {
        if (collectionB == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (String entry : collectionB) {
            if (collectionA != null && collectionA.contains(entry)) continue;
            result.add(entry);
        }
        return result;
    }

    private static GeneralName createGeneralName(GeneralName reqName, Set<Certprofile.GeneralNameMode> modes) throws BadCertTemplateException {
        int tag = reqName.getTagNo();
        Certprofile.GeneralNameMode mode = null;
        if (modes != null) {
            for (Certprofile.GeneralNameMode m : modes) {
                if (m.getTag().getTag() != tag) continue;
                mode = m;
                break;
            }
            if (mode == null) {
                throw new BadCertTemplateException("generalName tag " + tag + " is not allowed");
            }
        }
        switch (tag) {
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                return new GeneralName(tag, reqName.getName());
            }
            case 0: {
                ASN1Sequence reqSeq = ASN1Sequence.getInstance((Object)reqName.getName());
                ASN1ObjectIdentifier type = ASN1ObjectIdentifier.getInstance((Object)reqSeq.getObjectAt(0));
                if (mode != null && !mode.getAllowedTypes().contains(type)) {
                    throw new BadCertTemplateException("otherName.type " + type.getId() + " is not allowed");
                }
                ASN1Primitive value = ASN1TaggedObject.getInstance((Object)reqSeq.getObjectAt(1)).getObject();
                if (!(value instanceof ASN1String)) {
                    throw new BadCertTemplateException("otherName.value is not a String");
                }
                String text = ((ASN1String)value).getString();
                ASN1EncodableVector vector = new ASN1EncodableVector();
                vector.add((ASN1Encodable)type);
                vector.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new DERUTF8String(text)));
                return new GeneralName(0, (ASN1Encodable)new DERSequence(vector));
            }
            case 5: {
                DirectoryString ds;
                ASN1Sequence reqSeq = ASN1Sequence.getInstance((Object)reqName.getName());
                int size = reqSeq.size();
                String nameAssigner = null;
                int idx = 0;
                if (size > 1) {
                    ds = DirectoryString.getInstance((Object)ASN1TaggedObject.getInstance((Object)reqSeq.getObjectAt(idx++)).getObject());
                    nameAssigner = ds.getString();
                }
                ds = DirectoryString.getInstance((Object)ASN1TaggedObject.getInstance((Object)reqSeq.getObjectAt(idx++)).getObject());
                String partyName = ds.getString();
                ASN1EncodableVector vector = new ASN1EncodableVector();
                if (nameAssigner != null) {
                    vector.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)new DirectoryString(nameAssigner)));
                }
                vector.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)new DirectoryString(partyName)));
                return new GeneralName(5, (ASN1Encodable)new DERSequence(vector));
            }
        }
        throw new IllegalStateException("should not reach here, unknown GeneralName tag " + tag);
    }

    private static Set<String> getKeyUsage(byte[] extensionValue) {
        HashSet<String> usages = new HashSet<String>();
        org.bouncycastle.asn1.x509.KeyUsage reqKeyUsage = org.bouncycastle.asn1.x509.KeyUsage.getInstance((Object)extensionValue);
        for (KeyUsage k : KeyUsage.values()) {
            if (!reqKeyUsage.hasUsages(k.getBcUsage())) continue;
            usages.add(k.getName());
        }
        return usages;
    }

    private static Set<String> getExtKeyUsage(byte[] extensionValue) {
        HashSet<String> usages = new HashSet<String>();
        ExtendedKeyUsage reqKeyUsage = ExtendedKeyUsage.getInstance((Object)extensionValue);
        for (KeyPurposeId usage : reqKeyUsage.getUsages()) {
            usages.add(usage.getId());
        }
        return usages;
    }

    private static void checkAia(StringBuilder failureMsg, AuthorityInformationAccess aia, ASN1ObjectIdentifier accessMethod, Set<String> expectedUris) {
        String typeDesc = X509ObjectIdentifiers.id_ad_ocsp.equals((Object)accessMethod) ? "OCSP" : (X509ObjectIdentifiers.id_ad_caIssuers.equals((Object)accessMethod) ? "caIssuer" : accessMethod.getId());
        LinkedList<AccessDescription> isAccessDescriptions = new LinkedList<AccessDescription>();
        for (AccessDescription accessDescription : aia.getAccessDescriptions()) {
            if (!accessMethod.equals((Object)accessDescription.getAccessMethod())) continue;
            isAccessDescriptions.add(accessDescription);
        }
        int size = isAccessDescriptions.size();
        if (size != expectedUris.size()) {
            ExtensionsChecker.addViolation(failureMsg, "number of AIA " + typeDesc + " URIs", size, expectedUris.size());
            return;
        }
        HashSet<String> isUris = new HashSet<String>();
        for (int i = 0; i < size; ++i) {
            GeneralName isAccessLocation = ((AccessDescription)isAccessDescriptions.get(i)).getAccessLocation();
            if (isAccessLocation.getTagNo() != 6) {
                ExtensionsChecker.addViolation(failureMsg, "tag of accessLocation of AIA ", isAccessLocation.getTagNo(), 6);
                continue;
            }
            String isOcspUri = ((ASN1String)isAccessLocation.getName()).getString();
            isUris.add(isOcspUri);
        }
        Set<String> diffs = ExtensionsChecker.strInBnotInA(expectedUris, isUris);
        if (CollectionUtil.isNonEmpty(diffs)) {
            failureMsg.append(typeDesc).append(" URIs ").append(diffs);
            failureMsg.append(" are present but not expected; ");
        }
        if (CollectionUtil.isNonEmpty(diffs = ExtensionsChecker.strInBnotInA(isUris, expectedUris))) {
            failureMsg.append(typeDesc).append(" URIs ").append(diffs);
            failureMsg.append(" are absent but are required; ");
        }
    }

    private void checkConstantExtnValue(ASN1ObjectIdentifier extnType, StringBuilder failureMsg, byte[] extensionValue, Extensions requestedExtns, Certprofile.ExtensionControl extControl) {
        byte[] expected = this.getExpectedExtValue(extnType, requestedExtns, extControl);
        if (!Arrays.equals(expected, extensionValue)) {
            ExtensionsChecker.addViolation(failureMsg, "extension values", ExtensionsChecker.hex(extensionValue), expected == null ? "not present" : ExtensionsChecker.hex(expected));
        }
    }

    private static void addViolation(StringBuilder failureMsg, String field, Object is, Object expected) {
        failureMsg.append(field).append(" is '").append(is).append("' but expected '").append(expected).append("';");
    }
}

