/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.qa.ca;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.x509.Certificate;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;

public class IssuerInfo {
    private final Set<String> caIssuerUrls;
    private final Set<String> ocspUrls;
    private final Set<String> crlUrls;
    private final Set<String> deltaCrlUrls;
    private final X509Certificate cert;
    private final Certificate bcCert;
    private final boolean cutoffNotAfter;
    private final Date caNotBefore;
    private final Date caNotAfter;
    private final byte[] ski;

    public IssuerInfo(List<String> caIssuerUrls, List<String> ocspUrls, List<String> crlUrls, List<String> deltaCrlUrls, byte[] certBytes, boolean cutoffNotAfter) throws CertificateException {
        HashSet<String> set;
        Args.notNull((Object)certBytes, (String)"certBytes");
        this.cutoffNotAfter = cutoffNotAfter;
        if (CollectionUtil.isEmpty(caIssuerUrls)) {
            this.caIssuerUrls = null;
        } else {
            set = new HashSet<String>();
            set.addAll(caIssuerUrls);
            this.caIssuerUrls = Collections.unmodifiableSet(set);
        }
        if (CollectionUtil.isEmpty(ocspUrls)) {
            this.ocspUrls = null;
        } else {
            set = new HashSet();
            set.addAll(ocspUrls);
            this.ocspUrls = Collections.unmodifiableSet(set);
        }
        if (CollectionUtil.isEmpty(crlUrls)) {
            this.crlUrls = null;
        } else {
            set = new HashSet();
            set.addAll(crlUrls);
            this.crlUrls = Collections.unmodifiableSet(set);
        }
        if (CollectionUtil.isEmpty(deltaCrlUrls)) {
            this.deltaCrlUrls = null;
        } else {
            set = new HashSet();
            set.addAll(deltaCrlUrls);
            this.deltaCrlUrls = Collections.unmodifiableSet(set);
        }
        this.cert = X509Util.parseCert((byte[])certBytes);
        this.bcCert = X509Util.parseBcCert((byte[])certBytes);
        this.ski = X509Util.extractSki((X509Certificate)this.cert);
        this.caNotBefore = this.cert.getNotBefore();
        this.caNotAfter = this.cert.getNotAfter();
    }

    public Set<String> getCaIssuerUrls() {
        return this.caIssuerUrls;
    }

    public Set<String> getOcspUrls() {
        return this.ocspUrls;
    }

    public Set<String> getCrlUrls() {
        return this.crlUrls;
    }

    public Set<String> getDeltaCrlUrls() {
        return this.deltaCrlUrls;
    }

    public X509Certificate getCert() {
        return this.cert;
    }

    public byte[] getSubjectKeyIdentifier() {
        return Arrays.copyOf(this.ski, this.ski.length);
    }

    public Certificate getBcCert() {
        return this.bcCert;
    }

    public boolean isCutoffNotAfter() {
        return this.cutoffNotAfter;
    }

    public Date getCaNotBefore() {
        return this.caNotBefore;
    }

    public Date getCaNotAfter() {
        return this.caNotAfter;
    }
}

