/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.qa.ca;

import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECPoint;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSAPublicKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.security.util.KeyUtil;
import org.xipki.util.Args;
import org.xipki.util.Base64;

public abstract class CaEnrollBenchKeyEntry {
    public abstract SubjectPublicKeyInfo getSubjectPublicKeyInfo();

    public static final class ECKeyEntry
    extends CaEnrollBenchKeyEntry {
        private final SubjectPublicKeyInfo spki;

        public ECKeyEntry(String curveNameOrOid) throws Exception {
            Args.notNull((Object)curveNameOrOid, (String)"curveNameOrOid");
            ASN1ObjectIdentifier curveOid = AlgorithmUtil.getCurveOidForCurveNameOrOid((String)curveNameOrOid);
            if (curveOid == null) {
                throw new IllegalArgumentException("unknown curveNameOrOid '" + curveNameOrOid + "'");
            }
            String curveName = AlgorithmUtil.getCurveName((ASN1ObjectIdentifier)curveOid);
            if (curveName == null) {
                curveName = curveOid.getId();
            }
            AlgorithmIdentifier algId = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)curveOid);
            KeyPairGenerator kpgen = KeyPairGenerator.getInstance("ECDSA", "BC");
            ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)curveName);
            kpgen.initialize((AlgorithmParameterSpec)spec);
            KeyPair kp = kpgen.generateKeyPair();
            ECPublicKey pub = (ECPublicKey)kp.getPublic();
            int orderBitLength = pub.getParams().getOrder().bitLength();
            byte[] keyData = KeyUtil.getUncompressedEncodedECPoint((ECPoint)pub.getW(), (int)orderBitLength);
            this.spki = new SubjectPublicKeyInfo(algId, keyData);
        }

        @Override
        public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
            return this.spki;
        }
    }

    public static final class DSAKeyEntry
    extends CaEnrollBenchKeyEntry {
        private static final String P_1024 = "AM/6AjYLnnzRa99zmdhuMmikFKF/HhotHagBxoHlT4alq415sX94psaJPI3D5+/eYUaZbnFMn/IEBh6YyEL4zPQs4xOYdcNoMJ6XccGelEHjVWDvocf00L417XiTJObMUVHgFrkTPZ7G/mDBFMQ1WVrSSwnjPPDSCkIRiiGiCQqv";
        private static final String Q_1024 = "ANMDutPywwIBAbqpSxN8CAvbPkaL";
        private static final String G_1024 = "AcFvVWWRJlZsT2xCtto0gZj6QyaVAVJmvkZinCm2kafbFPQ+MLeZJKk3mvCaq2i8DPptJ5LC1FaaE+Is4rhX0BcW5/rxxSk6JVboakH48KEg5nZvzphMNe9mC2bYV29zBbyiYvs9v7EhAI7bKlvOaAb6XyB//fUh1+GYzP15HOw=";
        private static final String Y_1024 = "AMjz/ko+WVNXbLo7ixe+iIU2OpgngYIaSZQkbFFQ6E/ePlmgPlFY9gOV7CrjKYfnMgU33SZHipa7Zo6LmgjNZ6VE2FE8PGE+CHM+XZMQlZdOtKZLMfRWUdYfUZ5D7j+13HlpW2ahfeClF5xuhwjcTDm7VdxZ+rVscp+QzF7Je35p";
        private static final String P_2048 = "ANAwGdtm8DJ6YHsC9A9c5bmg8saK4TShCmWoC0sLRwaueN/thcXQKjG4qNQu1BiRwIGwlPqbX5F+i/kILuJ4xvcoffMsLZG9WoI8bG5Y+Ld9KWOJ/KDiYjdX5R9flbmqgnMBUbscsLMStNBaHFZYe58S4uClVS6v7poi6s3e/B3ryvWPG4zIamFxV72DmSWonArfljTleJ/pVqlWW5WOTqXjk11ab53PSJGWPAyhfgZWhHTwsKt+HgemrA8D55usvDVPhYNsnEy4FtJEbIJSsIKO4qGrhDA2mZeH30EXhZx83HWRML0GIP+tDguBN+hIw7G9DpwQQL+f4lowf9rde38=";
        private static final String Q_2048 = "AO236rjUtJKK0CDLx+koJmwrX4xzffhW/hdqCOb8eOmV";
        private static final String G_2048 = "ALsVY3D6QRDnBiwfrbl4Br9wE5D9RZlPt6lUYmOIQFptcD1RWP0ZuajmDQ90FLJ/jamGgqeIY+ZyA0UZqDcDtfrIB0sOML7xIqqUyTxV/UiIHnWVf9Xa9JGUWrUoqvVGqiDI1G0OcIuBykDAHTUo0J54TKZP0DMILkwO0kqf+SM/mH4Q1qxV3RfRDUqc3v9s/LgmshkkBsIapsh5AADA2GAoHnrLlgimgJS4zKoytCYYGtL0NqN4vyGiIQaeoOv4JRwZ+gQsy7OA0nkDRWnAFsPOnPxQqsEGmfE8VGzXrHl42jcavPuJ1o3CCeMq30D0VbEuwEMCUNBcjHTEpF0jnqs=";
        private static final String Y_2048 = "Pmn2UvUGcvhAwl57D86OPUdhiPJr4qaBNy9GAkUca4nkoQthP90dhvqB6b4FvJBrjsWoPVQSxW+pX2vfbjscQMm4Kt5zaqeHnV/Rod4l5VeW7sqoRqBR7nzlke+xHkT0wM3XkCp2E6BTAhT0qtp05w6onOoWIMv5Ydd04xwNB8lFF+A2uJrt3QlHXHvRW1noSf7bRDWC6JKLMRd+G0H8USMMT7UNUgen1lXbIH0q1GDph0z1MZkbUwewE/dG6KBL3Km1hBmuWyUrqHLznKYPwhmcOqWpTGn2PJrmdEJdjhdhwpWT1POhiyP+YxxbFNv/Kjkdw4wQAVloP0QZ4wH/IA==";
        private static final String P_3072 = "AOcper98q/F5dOpeZMTAxQiD3Sptsr0b19WMMwO+/P0YqjiS1LNqhX2ULuCv/oD1TtgfRx5bNhsg4jA+mLtGHZAO2nGrF9fwlyxyv5gcx4D6WfDaLx1ZVGGcux8PlgLzdshN10t6Icyl28Ky/G8HOFwu7kmHSw6fujsCqW0CvjiRW+sQ9N2Fuzjivg9axCyLMtFLXUcQuIyHhlQWSQyrQkhAG0qLfLWpzM0BdWpL0hDSKgjOTNvYphRquqdzn90gbXTwcQQdtuiQWg6WGhAz7feyuATmhESE2i2P5LV9LQGBG6j3zfU3ITmyexb4rFbpgRSIWZ0nrs5uQ0lYZgUyr+dnzFnNqYZB7aNw5cFR5TWKcxTx0yp9kMMjjZSiQQc2TVm254f6rztbERjU7HXxPFROujufBoTeBj0ayNxVJRIBs6XgSpE7/Gw3OJWJVMYT5iA0MZv0Vs+WKdHoCKCZ8mfZbIisxCpFV8PW9/Xz6T59rBJxs51ZdwwyHz/EB7esEQ==";
        private static final String Q_3072 = "ALQa/gl8UpkX42IsgfnihnQDS+NQ5US6eYGDz34guCib";
        private static final String G_3072 = "FyAOku6IrTU1iI6S0gl3soIF3mRbA/WiKpXu4ZCOdf9fHA12XtXPWRc7jaFBZucpuxYtmDeUwCZRFX+HWpkptVv6LT8OIDbCFFfJlo6i0d1ulq9ybOLtcWXlqIcp4Z0vLbFcxUr79CYp/mwdXzMwD+v7GFTa6feJdQENEfnwOGLUItOm+6OBcft+94xvDCmxtfYYkgEaFvRFjVKy+9kDuf6OfFKM0RDX4tvvpPwpXdYghjk6C/9e0jqloW20DhsWfBDmhp5cPSkjUDDSOz0JrOvT7MBeqefez6PbgMywZFiY+iBOZiIay2o5tI2uOaGqz1K/1xo7tXMlZu0wFuxtwrThFbmbGIXAMCC4hNeW4hFKDRnYZtnRKChhh3gNx3eO/58as/UIa8ApnjvG9tLpYtmlfJlgzlmEAuuB08qMg+T9tUjKQZWgEOiT6INFZS0PmbSZgzJACYY6dMnywnne97TrgCccXuoTRV3derD91tU6lhfR5B4ZADXVClNrf7Nl";
        private static final String Y_3072 = "aiFUID1NF6SllNJf2RDMik1rU2A5VQc4pLw8wfvxG2WXCSTeuWnDB7b3HBtQOwoxlYaDQnKBEcly61aVbLKP+TD8dngJQNlr42M07u2drT2ADbk3cLWQ8lk27LBWjntXoXduWz2onw1FEdh2nJSTkHZGBaQpUt8vwxB3IWoGsaazOKLnm/rZlK9g9Rs0RCXA8KViQEUuAU1h/tt2bEFgOECQ6efm3oBeG3TfpstMud7QaGyyFnTgRxrZQpC1Et3De8TVvIy3uUjnOjGDVV8qGVjsI3J9zX3w5TbTDB4+lbMpc9/oMd26veU+8+7GY5SziEPTcZF38POgm8I9Nxe5gxtiNJyOMQZC20rnffJljVLe8L1LrXPj0MJfVZMLXiyzSLFRUj7ZpN4rzgQYkB0ETN40DFFk3a2gC9E2g+EdksAW0h+IAElikX4Q4Ja0kzXuwJfVmq5g/Sp4ysk+JTzAl6r4T1dDr9BXpGgRdYdgwE/2RTMfunqTcUYlV752sbvy";
        private SubjectPublicKeyInfo spki;

        public DSAKeyEntry(int plength) throws Exception {
            if (plength == 1024) {
                this.init(P_1024, Q_1024, G_1024, Y_1024);
            } else if (plength == 2048) {
                this.init(P_2048, Q_2048, G_2048, Y_2048);
            } else if (plength == 3072) {
                this.init(P_3072, Q_3072, G_3072, Y_3072);
            } else {
                if (plength % 1024 != 0) {
                    throw new IllegalArgumentException("invalid DSA pLength " + plength);
                }
                int qlength = plength >= 2048 ? 256 : 160;
                KeyPair kp = KeyUtil.generateDSAKeypair((int)plength, (int)qlength, (SecureRandom)new SecureRandom());
                DSAPublicKey pk = (DSAPublicKey)kp.getPublic();
                this.init(pk.getParams().getP(), pk.getParams().getQ(), pk.getParams().getG(), pk.getY());
            }
        }

        private static BigInteger base64ToInt(String base64Str) {
            return new BigInteger(1, Base64.decode((String)base64Str));
        }

        private void init(String p, String q, String g, String y) throws IOException {
            this.init(DSAKeyEntry.base64ToInt(p), DSAKeyEntry.base64ToInt(q), DSAKeyEntry.base64ToInt(g), DSAKeyEntry.base64ToInt(y));
        }

        private void init(BigInteger p, BigInteger q, BigInteger g, BigInteger y) throws IOException {
            ASN1EncodableVector vec = new ASN1EncodableVector();
            vec.add((ASN1Encodable)new ASN1Integer(p));
            vec.add((ASN1Encodable)new ASN1Integer(q));
            vec.add((ASN1Encodable)new ASN1Integer(g));
            DERSequence dssParams = new DERSequence(vec);
            AlgorithmIdentifier algId = new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, (ASN1Encodable)dssParams);
            this.spki = new SubjectPublicKeyInfo(algId, (ASN1Encodable)new ASN1Integer(y));
        }

        @Override
        public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
            return this.spki;
        }
    }

    public static final class RSAKeyEntry
    extends CaEnrollBenchKeyEntry {
        private static final String N_1024 = "ALI9Q2yy0KKsfuJw6tOfXBY3aJevCKyCQYM4DWK0eL1noqh6Uk6Ro3AsLVcoJDlZxCOdqhwq41jsgrj5iEvf9tagNTnsLLscGEUkHWZDJIF9uQd5ISjFtcdaEGdv2v5Kf48Drcg7o+c+LtR5ZNmtaEySUtjRFYh3icMzoh6zzA/z";
        private static final String N_2048 = "AMQdbyhdRJvPE7WoyLBucRfELTPyMZZ3fEpIN+BiALpxfi2AAu4N9kvi/MT2xpfIhdNHLDLX02tECy/XDdQiEKKJ2mfDr29me72yvO7PtpxUaPfyd6vzBEfGQqal42qZU1pmIgJm0jE4Gl4EdfyXEHsnekrLTjHiLnSr2WhlL+yY9xwO589VQIYziG53SbUMcu0eMxzgfwT7UXKvPvbfzJjgWiin8PozENy+8yFzkCUOUK2uFa5iJPky8o5WSsqsQ/nH7Jq0MyQaG58M+//0g3glXirbtX+BARGR130VeMAnxMktLc4VdZ+I75wNxLapksE19yQ4Ta0JRzGMwVZR7Pk=";
        private static final String N_3072 = "AL1F3ms6ImUDkIVEgjqM9NUQ2NpImvoNbvwq+zRLTvamIegsapwDi0cLkdD47vR9bM50zuKX0+4FzJZe8MWQheTmSVbdF8EcORGh1OXYidmV9zFOrym961sBCvJ1x1W3p00kyqi55gONxklvbK2MYAifoUIqe0L6TS4W0eJrWB25JuLP8U09xZQRFm1qAiSQJsZSfxcZfOtVOYp6oDsMqhk3RNKrpw/UqtfcRjYG+ZhccDZcmLS/UmHPHRuDsgCAAebH3bDEqbQZ8hFqVdRDGWnIirLJ67+0e+3j6UjoI4ybSwy9O9g36rooC5bCboEA46r03BiX28JMveHip689b+RAHgKy95Yd5eFIWYQBNAmUNZ+9hq4KTvrSb7ysge7dqVY5nnsnmpXFyqy51dlem4npXAM73a9vLuEOioSOOqBwNDXyxBaETgqH4AWBdNK/aSvwu2cUjFCKfds2Ycik+6pfu4gid2Pp5j2lXMvvtaIQNx88e2UTo8Jn+D+baFBXuw==";
        private static final String N_4096 = "AMO03X0Vp9Diw8KW9zeuDSICAnohZT98o6lnJJR1pUZIPINOMuf/SG2vVR0Uv/cxyY/8Fvn1ySzG0OjYE4mH9l1C4bvaiiKEMT1liX4WK2ndFFtwG3HmueRThn1uq2y5WCUOZkD2/5atrcJfzWiox30zAikyLkOZ6kTY0anZ3UraF4Zj9Rvkpn4NMlUxtxN1CKrW+Cn1D2lPhGFRLB9joNOtlpt6zqv/Dyvfxc/6hnSQeQLd20bozbfKKsHvj+PU1wI2rHVI5XtS7efZCzvMzJ05wVZgTnQldxHbjw397u1uavsNncwmCcsHcrbvRWJDvvWvQWUOoG4KgMcGRbX0fdzMwntUMvO7A9AIlb4KtcPicpIQGYsiTeWxM+Bpawo2a1ENy+HahP9rCU8i+bWRR8zsEhmuT6E7BK6/VmHU6NKbjkMIjIXNGvULvVX6b1+hBOinVTm4ly+33ZK7zsl0nML5e0c7jFvq4XPvpi42kkP1RNjle0zNIHdtWkRw/+lYpKmkuAU2gvu/iZXkvZBw9ncqABsRhbhfiwQlODOaF9h20rUWHArzIk6vrsRyMjm5U9bKVimYaalQCmq1Uq49EYazIa31e5uDDMnbfcmMoPyi9Z5jQAVfm+tWuvM+S118s3d/mCpoX62O3gLaHNpPpD8CHoOagGcqthk+9/wWarhR";
        private static final BigInteger PUBLIC_EXPONENT = BigInteger.valueOf(65535L);
        private final SubjectPublicKeyInfo spki;

        public RSAKeyEntry(int keysize) throws Exception {
            if (keysize % 1024 != 0) {
                throw new IllegalArgumentException("invalid RSA keysize " + keysize);
            }
            AlgorithmIdentifier keyAlgId = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE);
            if (keysize == 1024 || keysize == 2048 || keysize == 3072 || keysize == 4096) {
                String modulusStr = keysize == 1024 ? N_1024 : (keysize == 2048 ? N_2048 : (keysize == 3072 ? N_3072 : N_4096));
                BigInteger modulus = RSAKeyEntry.base64ToInt(modulusStr);
                this.spki = new SubjectPublicKeyInfo(keyAlgId, (ASN1Encodable)new RSAPublicKey(modulus, PUBLIC_EXPONENT));
            } else {
                KeyPairGenerator kp = KeyPairGenerator.getInstance("RSA");
                kp.initialize(keysize);
                java.security.interfaces.RSAPublicKey publicKey = (java.security.interfaces.RSAPublicKey)kp.generateKeyPair().getPublic();
                this.spki = new SubjectPublicKeyInfo(keyAlgId, (ASN1Encodable)new RSAPublicKey(publicKey.getModulus(), publicKey.getPublicExponent()));
            }
        }

        private static BigInteger base64ToInt(String base64Str) {
            return new BigInteger(1, Base64.decode((String)base64Str));
        }

        @Override
        public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
            return this.spki;
        }
    }
}

