/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.qa.ca;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.xipki.ca.api.BadCertTemplateException;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.TextVadidator;
import org.xipki.qa.ValidationIssue;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;

public class SubjectChecker {
    private final Certprofile.SubjectControl subjectControl;

    public SubjectChecker(Certprofile.SubjectControl subjectControl) {
        this.subjectControl = (Certprofile.SubjectControl)Args.notNull((Object)subjectControl, (String)"subjectControl");
    }

    public List<ValidationIssue> checkSubject(X500Name subject, X500Name requestedSubject) {
        Args.notNull((Object)subject, (String)"subject");
        Args.notNull((Object)requestedSubject, (String)"requestedSubject");
        HashSet<ASN1ObjectIdentifier> oids = new HashSet<ASN1ObjectIdentifier>();
        for (ASN1ObjectIdentifier oid : this.subjectControl.getTypes()) {
            if (this.subjectControl.getControl(oid).isNotInSubject()) continue;
            oids.add(oid);
        }
        for (ASN1ObjectIdentifier oid : subject.getAttributeTypes()) {
            oids.add(oid);
        }
        LinkedList<ValidationIssue> result = new LinkedList<ValidationIssue>();
        ValidationIssue issue = new ValidationIssue("X509.SUBJECT.group", "X509 subject RDN group");
        result.add(issue);
        if (CollectionUtil.isNonEmpty((Collection)this.subjectControl.getGroups())) {
            HashSet groups = new HashSet(this.subjectControl.getGroups());
            for (String g : groups) {
                boolean toBreak = false;
                RDN rdn = null;
                for (ASN1ObjectIdentifier type : this.subjectControl.getTypesForGroup(g)) {
                    RDN[] rdns = subject.getRDNs(type);
                    if (rdns == null || rdns.length == 0) continue;
                    if (rdns.length > 1) {
                        issue.setFailureMessage("AttributeTypeAndValues of group " + g + " is not in one RDN");
                        toBreak = true;
                        break;
                    }
                    if (rdn == null) {
                        rdn = rdns[0];
                        continue;
                    }
                    if (rdn == rdns[0]) continue;
                    issue.setFailureMessage("AttributeTypeAndValues of group " + g + " is not in one RDN");
                    toBreak = true;
                    break;
                }
                if (!toBreak) continue;
                break;
            }
        }
        for (ASN1ObjectIdentifier type : oids) {
            ValidationIssue valIssue;
            try {
                valIssue = this.checkSubjectAttribute(type, subject, requestedSubject);
            }
            catch (BadCertTemplateException ex) {
                valIssue = new ValidationIssue("X509.SUBJECT.REQUEST", "Subject in request");
                valIssue.setFailureMessage(ex.getMessage());
            }
            result.add(valIssue);
        }
        return result;
    }

    private ValidationIssue checkSubjectAttribute(ASN1ObjectIdentifier type, X500Name subject, X500Name requestedSubject) throws BadCertTemplateException {
        boolean multiValuedRdn;
        boolean bl = multiValuedRdn = this.subjectControl.getGroup(type) != null;
        if (multiValuedRdn) {
            return this.checkSubjectAttributeMultiValued(type, subject, requestedSubject);
        }
        return this.checkSubjectAttributeNotMultiValued(type, subject, requestedSubject);
    }

    private ValidationIssue checkSubjectAttributeNotMultiValued(ASN1ObjectIdentifier type, X500Name subject, X500Name requestedSubject) throws BadCertTemplateException {
        int rdnsSize;
        ValidationIssue issue = SubjectChecker.createSubjectIssue(type);
        Certprofile.RdnControl rdnControl = this.subjectControl.getControl(type);
        int minOccurs = rdnControl == null ? 0 : rdnControl.getMinOccurs();
        int maxOccurs = rdnControl == null ? 0 : rdnControl.getMaxOccurs();
        RDN[] rdns = subject.getRDNs(type);
        int n = rdnsSize = rdns == null ? 0 : rdns.length;
        if (rdnsSize < minOccurs || rdnsSize > maxOccurs) {
            issue.setFailureMessage("number of RDNs '" + rdnsSize + "' is not within [" + minOccurs + ", " + maxOccurs + "]");
            return issue;
        }
        LinkedList<String> requestedCoreAtvTextValues = new LinkedList<String>();
        RDN[] requestedRdns = requestedSubject.getRDNs(type);
        if (rdnControl == null || rdnControl.isValueOverridable()) {
            if (requestedRdns != null && requestedRdns.length > 0) {
                for (RDN requestedRdn : requestedRdns) {
                    String textValue = SubjectChecker.getRdnTextValueOfRequest(requestedRdn);
                    requestedCoreAtvTextValues.add(textValue);
                }
            } else if (rdnControl != null && rdnControl.getValue() != null) {
                requestedCoreAtvTextValues.add(rdnControl.getValue());
            }
        } else {
            requestedCoreAtvTextValues.add(rdnControl.getValue());
        }
        if (rdnsSize == 0) {
            if (maxOccurs > 0 && !requestedCoreAtvTextValues.isEmpty()) {
                issue.setFailureMessage("is absent but expected present");
            }
            return issue;
        }
        StringBuilder failureMsg = new StringBuilder();
        Certprofile.StringType stringType = null;
        if (rdnControl != null) {
            stringType = rdnControl.getStringType();
        }
        if (stringType == null) {
            stringType = Certprofile.StringType.utf8String;
        }
        for (int i = 0; i < rdns.length; ++i) {
            RDN rdn = rdns[i];
            AttributeTypeAndValue[] atvs = rdn.getTypesAndValues();
            if (atvs.length > 1) {
                failureMsg.append("size of RDN[" + i + "] is '" + atvs.length + "' but expected '1'");
                failureMsg.append("; ");
                continue;
            }
            String atvTextValue = SubjectChecker.getAtvValueString("RDN[" + i + "]", atvs[0], stringType, failureMsg);
            if (atvTextValue == null) continue;
            this.checkAttributeTypeAndValue("RDN[" + i + "]", type, atvTextValue, rdnControl, requestedCoreAtvTextValues, i, failureMsg);
        }
        int len = failureMsg.length();
        if (len > 2) {
            failureMsg.delete(len - 2, len);
            issue.setFailureMessage(failureMsg.toString());
        }
        return issue;
    }

    private ValidationIssue checkSubjectAttributeMultiValued(ASN1ObjectIdentifier type, X500Name subject, X500Name requestedSubject) throws BadCertTemplateException {
        int maxOccurs;
        ValidationIssue issue = SubjectChecker.createSubjectIssue(type);
        RDN[] rdns = subject.getRDNs(type);
        int rdnsSize = rdns == null ? 0 : rdns.length;
        RDN[] requestedRdns = requestedSubject.getRDNs(type);
        if (rdnsSize != 1) {
            if (rdnsSize == 0) {
                if (requestedRdns != null && requestedRdns.length > 0) {
                    issue.setFailureMessage("is absent but expected present");
                }
            } else {
                issue.setFailureMessage("number of RDNs '" + rdnsSize + "' is not 1");
            }
            return issue;
        }
        Certprofile.RdnControl rdnControl = this.subjectControl.getControl(type);
        Certprofile.StringType stringType = null;
        if (rdnControl != null) {
            stringType = rdnControl.getStringType();
        }
        LinkedList<String> requestedCoreAtvTextValues = new LinkedList<String>();
        if (requestedRdns != null) {
            for (RDN rDN : requestedRdns) {
                String textValue = SubjectChecker.getRdnTextValueOfRequest(rDN);
                requestedCoreAtvTextValues.add(textValue);
            }
        }
        if (rdns == null) {
            return issue;
        }
        StringBuilder failureMsg = new StringBuilder();
        AttributeTypeAndValue[] li = rdns[0].getTypesAndValues();
        LinkedList<AttributeTypeAndValue> atvs = new LinkedList<AttributeTypeAndValue>();
        for (AttributeTypeAndValue m : li) {
            if (!type.equals((Object)m.getType())) continue;
            atvs.add(m);
        }
        int n = atvs.size();
        int minOccurs = rdnControl == null ? 0 : rdnControl.getMinOccurs();
        int n2 = maxOccurs = rdnControl == null ? 0 : rdnControl.getMaxOccurs();
        if (n < minOccurs || n > maxOccurs) {
            issue.setFailureMessage("number of AttributeTypeAndValuess '" + n + "' is not within [" + minOccurs + ", " + maxOccurs + "]");
            return issue;
        }
        for (int i = 0; i < n; ++i) {
            AttributeTypeAndValue atv = (AttributeTypeAndValue)atvs.get(i);
            String atvTextValue = SubjectChecker.getAtvValueString("AttributeTypeAndValue[" + i + "]", atv, stringType, failureMsg);
            if (atvTextValue == null) continue;
            this.checkAttributeTypeAndValue("AttributeTypeAndValue[" + i + "]", type, atvTextValue, rdnControl, requestedCoreAtvTextValues, i, failureMsg);
        }
        int len = failureMsg.length();
        if (len > 2) {
            failureMsg.delete(len - 2, len);
            issue.setFailureMessage(failureMsg.toString());
        }
        return issue;
    }

    private void checkAttributeTypeAndValue(String name, ASN1ObjectIdentifier type, String atvTextValue, Certprofile.RdnControl rdnControl, List<String> requestedCoreAtvTextValues, int index, StringBuilder failureMsg) throws BadCertTemplateException {
        if (atvTextValue != null && ObjectIdentifiers.DN.emailAddress.equals((Object)type)) {
            atvTextValue = atvTextValue.toLowerCase();
        }
        if (ObjectIdentifiers.DN.dateOfBirth.equals((Object)type)) {
            if (!TextVadidator.DATE_OF_BIRTH.isValid(atvTextValue)) {
                throw new BadCertTemplateException("Value of RDN dateOfBirth does not have format YYYMMDD000000Z");
            }
        } else if (rdnControl != null) {
            boolean matches;
            TextVadidator pattern;
            String suffix;
            String prefix = rdnControl.getPrefix();
            if (prefix != null) {
                if (!atvTextValue.startsWith(prefix)) {
                    failureMsg.append(name).append(" '").append(atvTextValue).append("' does not start with prefix '").append(prefix).append("'; ");
                    return;
                }
                atvTextValue = atvTextValue.substring(prefix.length());
            }
            if ((suffix = rdnControl.getSuffix()) != null) {
                if (!atvTextValue.endsWith(suffix)) {
                    failureMsg.append(name).append(" '").append(atvTextValue).append("' does not end with suffix '").append(suffix).append("'; ");
                    return;
                }
                atvTextValue = atvTextValue.substring(0, atvTextValue.length() - suffix.length());
            }
            if ((pattern = rdnControl.getPattern()) != null && !(matches = pattern.isValid(atvTextValue))) {
                failureMsg.append(name).append(" '").append(atvTextValue).append("' is not valid against regex '").append(pattern.pattern()).append("'; ");
                return;
            }
        }
        if (CollectionUtil.isEmpty(requestedCoreAtvTextValues)) {
            if (!type.equals((Object)ObjectIdentifiers.DN.serialNumber)) {
                failureMsg.append("is present but not contained in the request; ");
            }
        } else {
            String requestedCoreAtvTextValue = requestedCoreAtvTextValues.get(index);
            if (!type.equals((Object)ObjectIdentifiers.DN.serialNumber)) {
                if (requestedCoreAtvTextValue != null && type.equals((Object)ObjectIdentifiers.DN.emailAddress)) {
                    requestedCoreAtvTextValue = requestedCoreAtvTextValue.toLowerCase();
                }
                if (!atvTextValue.equals(requestedCoreAtvTextValue)) {
                    failureMsg.append("content '").append(atvTextValue).append("' but expected '").append(requestedCoreAtvTextValue).append("'; ");
                }
            }
        }
    }

    private static boolean matchStringType(ASN1Encodable atvValue, Certprofile.StringType stringType) {
        boolean correctStringType = true;
        switch (stringType) {
            case bmpString: {
                correctStringType = atvValue instanceof DERBMPString;
                break;
            }
            case printableString: {
                correctStringType = atvValue instanceof DERPrintableString;
                break;
            }
            case teletexString: {
                correctStringType = atvValue instanceof DERT61String;
                break;
            }
            case utf8String: {
                correctStringType = atvValue instanceof DERUTF8String;
                break;
            }
            case ia5String: {
                correctStringType = atvValue instanceof DERIA5String;
                break;
            }
            default: {
                throw new IllegalStateException("should not reach here, unknown StringType " + stringType);
            }
        }
        return correctStringType;
    }

    private static String getRdnTextValueOfRequest(RDN requestedRdn) throws BadCertTemplateException {
        ASN1ObjectIdentifier type = requestedRdn.getFirst().getType();
        ASN1Encodable vec = requestedRdn.getFirst().getValue();
        if (ObjectIdentifiers.DN.dateOfBirth.equals((Object)type)) {
            if (!(vec instanceof ASN1GeneralizedTime)) {
                throw new BadCertTemplateException("requested RDN is not of GeneralizedTime");
            }
            return ((ASN1GeneralizedTime)vec).getTimeString();
        }
        if (ObjectIdentifiers.DN.postalAddress.equals((Object)type)) {
            if (!(vec instanceof ASN1Sequence)) {
                throw new BadCertTemplateException("requested RDN is not of Sequence");
            }
            ASN1Sequence seq = (ASN1Sequence)vec;
            int n = seq.size();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                ASN1Encodable obj = seq.getObjectAt(i);
                String textValue = X509Util.rdnValueToString((ASN1Encodable)obj);
                sb.append("[").append(i).append("]=").append(textValue).append(",");
            }
            return sb.toString();
        }
        return X509Util.rdnValueToString((ASN1Encodable)vec);
    }

    private static ValidationIssue createSubjectIssue(ASN1ObjectIdentifier subjectAttrType) {
        ValidationIssue issue;
        String attrName = ObjectIdentifiers.getName((ASN1ObjectIdentifier)subjectAttrType);
        if (attrName == null) {
            attrName = subjectAttrType.getId().replace('.', '_');
            issue = new ValidationIssue("X509.SUBJECT." + attrName, "attribute " + subjectAttrType.getId());
        } else {
            issue = new ValidationIssue("X509.SUBJECT." + attrName, "attribute " + attrName + " (" + subjectAttrType.getId() + ")");
        }
        return issue;
    }

    private static String getAtvValueString(String name, AttributeTypeAndValue atv, Certprofile.StringType stringType, StringBuilder failureMsg) {
        ASN1ObjectIdentifier type = atv.getType();
        ASN1Encodable atvValue = atv.getValue();
        if (ObjectIdentifiers.DN.dateOfBirth.equals((Object)type)) {
            if (!(atvValue instanceof ASN1GeneralizedTime)) {
                failureMsg.append(name).append(" is not of type GeneralizedTime; ");
                return null;
            }
            return ((ASN1GeneralizedTime)atvValue).getTimeString();
        }
        if (ObjectIdentifiers.DN.postalAddress.equals((Object)type)) {
            if (!(atvValue instanceof ASN1Sequence)) {
                failureMsg.append(name).append(" is not of type Sequence; ");
                return null;
            }
            ASN1Sequence seq = (ASN1Sequence)atvValue;
            int n = seq.size();
            StringBuilder sb = new StringBuilder();
            boolean validEncoding = true;
            for (int i = 0; i < n; ++i) {
                ASN1Encodable obj = seq.getObjectAt(i);
                if (!SubjectChecker.matchStringType(obj, stringType)) {
                    failureMsg.append(name).append(".[").append(i).append("] is not of type ").append(stringType.name()).append("; ");
                    validEncoding = false;
                    break;
                }
                String textValue = X509Util.rdnValueToString((ASN1Encodable)obj);
                sb.append("[").append(i).append("]=").append(textValue).append(",");
            }
            if (!validEncoding) {
                return null;
            }
            return sb.toString();
        }
        if (!SubjectChecker.matchStringType(atvValue, stringType)) {
            failureMsg.append(name).append(" is not of type " + stringType.name()).append("; ");
            return null;
        }
        return X509Util.rdnValueToString((ASN1Encodable)atvValue);
    }
}

