/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.qa.security;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.EdECConstants;
import org.xipki.security.SecurityFactory;
import org.xipki.security.util.KeyUtil;
import org.xipki.util.Args;
import org.xipki.util.BenchmarkExecutor;

public abstract class P12KeyGenSpeed
extends BenchmarkExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(P12KeyGenSpeed.class);
    private final SecurityFactory securityFactory;

    public P12KeyGenSpeed(String description, SecurityFactory securityFactory) {
        super(description);
        this.securityFactory = (SecurityFactory)Args.notNull((Object)securityFactory, (String)"securityFactory");
    }

    protected abstract void generateKeypair(SecureRandom var1) throws Exception;

    protected Runnable getTestor() throws Exception {
        return new Testor();
    }

    class Testor
    implements Runnable {
        Testor() {
        }

        @Override
        public void run() {
            while (!P12KeyGenSpeed.this.stop() && P12KeyGenSpeed.this.getErrorAccout() < 1L) {
                try {
                    P12KeyGenSpeed.this.generateKeypair(P12KeyGenSpeed.this.securityFactory.getRandom4Key());
                    P12KeyGenSpeed.this.account(1, 0);
                }
                catch (Exception ex) {
                    LOG.error("P12KeyGenSpeed.Testor.run()", (Throwable)ex);
                    P12KeyGenSpeed.this.account(1, 1);
                }
            }
        }
    }

    public static class RSA
    extends P12KeyGenSpeed {
        private final int keysize;
        private final BigInteger publicExponent;

        public RSA(int keysize, BigInteger publicExponent, SecurityFactory securityFactory) throws Exception {
            super("PKCS#12 RSA key generation\nkeysize: " + keysize + "\npublic exponent: " + publicExponent, securityFactory);
            this.keysize = keysize;
            this.publicExponent = publicExponent;
        }

        @Override
        protected void generateKeypair(SecureRandom random) throws Exception {
            KeyUtil.generateRSAKeypair((int)this.keysize, (BigInteger)this.publicExponent, (SecureRandom)random);
        }
    }

    public static class EC
    extends P12KeyGenSpeed {
        private final String curveOidOrName;

        public EC(String curveNameOrOid, SecurityFactory securityFactory) throws Exception {
            super("PKCS#12 EC key generation\ncurve: " + curveNameOrOid, securityFactory);
            this.curveOidOrName = curveNameOrOid;
        }

        @Override
        protected void generateKeypair(SecureRandom random) throws Exception {
            if (EdECConstants.isEdwardsOrMontgemoryCurve((String)this.curveOidOrName)) {
                KeyUtil.generateEdECKeypair((String)this.curveOidOrName, (SecureRandom)random);
            } else {
                KeyUtil.generateECKeypairForCurveNameOrOid((String)this.curveOidOrName, (SecureRandom)random);
            }
        }
    }

    public static class DSA
    extends P12KeyGenSpeed {
        private final int plength;
        private final int qlength;

        public DSA(int plength, int qlength, SecurityFactory securityFactory) throws Exception {
            super("PKCS#12 DSA key generation\nplength: " + plength + "\nqlength: " + qlength, securityFactory);
            this.plength = plength;
            this.qlength = qlength;
        }

        @Override
        protected void generateKeypair(SecureRandom random) throws Exception {
            KeyUtil.generateDSAKeypair((int)this.plength, (int)this.qlength, (SecureRandom)random);
        }
    }
}

