/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.qa;

import java.math.BigInteger;

public class BigIntegerRange {
    private final BigInteger from;
    private final BigInteger to;
    private final BigInteger diff;

    public BigIntegerRange(BigInteger from, BigInteger to) {
        if (from.compareTo(to) > 0) {
            throw new IllegalArgumentException("from (" + from + ") may not be larger than to (" + to + ")");
        }
        this.from = from;
        this.to = to;
        this.diff = to.subtract(from);
    }

    public BigInteger getFrom() {
        return this.from;
    }

    public BigInteger getTo() {
        return this.to;
    }

    public BigInteger getDiff() {
        return this.diff;
    }

    public boolean isInRange(BigInteger num) {
        return num.compareTo(this.from) >= 0 && num.compareTo(this.to) <= 0;
    }
}

