/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.qa.ca.extn;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.DirectoryString;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.Attribute;
import org.bouncycastle.asn1.x509.CertPolicyId;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.PolicyConstraints;
import org.bouncycastle.asn1.x509.PrivateKeyUsagePeriod;
import org.bouncycastle.asn1.x509.SubjectDirectoryAttributes;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.qualified.Iso4217CurrencyCode;
import org.bouncycastle.asn1.x509.qualified.MonetaryValue;
import org.bouncycastle.asn1.x509.qualified.QCStatement;
import org.slf4j.Logger;
import org.xipki.ca.api.BadCertTemplateException;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.api.profile.TextVadidator;
import org.xipki.ca.certprofile.xijson.SubjectDirectoryAttributesControl;
import org.xipki.ca.certprofile.xijson.XijsonCertprofile;
import org.xipki.ca.certprofile.xijson.conf.Describable;
import org.xipki.ca.certprofile.xijson.conf.PolicyMappings;
import org.xipki.ca.certprofile.xijson.conf.QcStatements;
import org.xipki.ca.certprofile.xijson.conf.Restriction;
import org.xipki.ca.certprofile.xijson.conf.TlsFeature;
import org.xipki.qa.ca.extn.CheckerUtil;
import org.xipki.qa.ca.extn.ExtensionChecker;
import org.xipki.qa.ca.extn.ExtensionsChecker;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.ctlog.CtLog;
import org.xipki.security.util.X509Util;
import org.xipki.util.CollectionUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.Validity;

class O2tChecker
extends ExtensionChecker {
    private static final byte[] DER_NULL = new byte[]{5, 0};

    O2tChecker(ExtensionsChecker parent) {
        super(parent);
    }

    void checkExtnOcspNocheck(StringBuilder failureMsg, byte[] extnValue) {
        if (!Arrays.equals(DER_NULL, extnValue)) {
            failureMsg.append("value is not DER NULL; ");
        }
    }

    void checkExtnPolicyConstraints(StringBuilder failureMsg, byte[] extnValue, Extensions requestedExtns, Certprofile.ExtensionControl extnControl) {
        org.xipki.ca.certprofile.xijson.conf.PolicyConstraints conf = this.caller.getPolicyConstraints();
        if (conf == null) {
            this.caller.checkConstantExtnValue(Extension.policyConstraints, failureMsg, extnValue, requestedExtns, extnControl);
            return;
        }
        PolicyConstraints isPolicyConstraints = PolicyConstraints.getInstance((Object)extnValue);
        Integer expRequireExplicitPolicy = conf.getRequireExplicitPolicy();
        BigInteger bigInt = isPolicyConstraints.getRequireExplicitPolicyMapping();
        Integer isRequireExplicitPolicy = bigInt == null ? null : Integer.valueOf(bigInt.intValue());
        boolean match = true;
        if (expRequireExplicitPolicy == null) {
            if (isRequireExplicitPolicy != null) {
                match = false;
            }
        } else if (!expRequireExplicitPolicy.equals(isRequireExplicitPolicy)) {
            match = false;
        }
        if (!match) {
            CheckerUtil.addViolation(failureMsg, "requireExplicitPolicy", isRequireExplicitPolicy, expRequireExplicitPolicy);
        }
        Integer expInhibitPolicyMapping = conf.getInhibitPolicyMapping();
        bigInt = isPolicyConstraints.getInhibitPolicyMapping();
        Integer isInhibitPolicyMapping = bigInt == null ? null : Integer.valueOf(bigInt.intValue());
        match = true;
        if (expInhibitPolicyMapping == null) {
            if (isInhibitPolicyMapping != null) {
                match = false;
            }
        } else if (!expInhibitPolicyMapping.equals(isInhibitPolicyMapping)) {
            match = false;
        }
        if (!match) {
            CheckerUtil.addViolation(failureMsg, "inhibitPolicyMapping", isInhibitPolicyMapping, expInhibitPolicyMapping);
        }
    }

    void checkExtnPolicyMappings(StringBuilder failureMsg, byte[] extnValue, Extensions requestedExtns, Certprofile.ExtensionControl extnControl) {
        PolicyMappings conf = this.caller.getPolicyMappings();
        if (conf == null) {
            this.caller.checkConstantExtnValue(Extension.policyMappings, failureMsg, extnValue, requestedExtns, extnControl);
            return;
        }
        ASN1Sequence isPolicyMappings = DERSequence.getInstance((Object)extnValue);
        HashMap<String, String> isMap = new HashMap<String, String>();
        int size = isPolicyMappings.size();
        for (int i = 0; i < size; ++i) {
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)isPolicyMappings.getObjectAt(i));
            CertPolicyId issuerDomainPolicy = CertPolicyId.getInstance((Object)seq.getObjectAt(0));
            CertPolicyId subjectDomainPolicy = CertPolicyId.getInstance((Object)seq.getObjectAt(1));
            isMap.put(issuerDomainPolicy.getId(), subjectDomainPolicy.getId());
        }
        for (PolicyMappings.PolicyIdMappingType m : conf.getMappings()) {
            String expIssuerDomainPolicy = m.getIssuerDomainPolicy().getOid();
            String expSubjectDomainPolicy = m.getSubjectDomainPolicy().getOid();
            String isSubjectDomainPolicy = (String)isMap.remove(expIssuerDomainPolicy);
            if (isSubjectDomainPolicy == null) {
                failureMsg.append("issuerDomainPolicy '").append(expIssuerDomainPolicy).append("' is absent but is required; ");
                continue;
            }
            if (isSubjectDomainPolicy.equals(expSubjectDomainPolicy)) continue;
            CheckerUtil.addViolation(failureMsg, "subjectDomainPolicy for issuerDomainPolicy", isSubjectDomainPolicy, expSubjectDomainPolicy);
        }
        if (CollectionUtil.isNotEmpty(isMap)) {
            failureMsg.append("issuerDomainPolicies '").append(isMap.keySet()).append("' are present but not expected; ");
        }
    }

    void checkExtnPrivateKeyUsagePeriod(StringBuilder failureMsg, byte[] extnValue, Date certNotBefore, Date certNotAfter) {
        Date dateNotAfter;
        ASN1GeneralizedTime notBefore = new ASN1GeneralizedTime(certNotBefore);
        Validity privateKeyUsagePeriod = this.getCertprofile().extensions().getPrivateKeyUsagePeriod();
        if (privateKeyUsagePeriod == null) {
            dateNotAfter = certNotAfter;
        } else {
            dateNotAfter = privateKeyUsagePeriod.add(certNotBefore);
            if (dateNotAfter.after(certNotAfter)) {
                dateNotAfter = certNotAfter;
            }
        }
        ASN1GeneralizedTime notAfter = new ASN1GeneralizedTime(dateNotAfter);
        PrivateKeyUsagePeriod extValue = PrivateKeyUsagePeriod.getInstance((Object)extnValue);
        ASN1GeneralizedTime time = extValue.getNotBefore();
        if (time == null) {
            failureMsg.append("notBefore is absent but expected present; ");
        } else if (!time.equals((ASN1Primitive)notBefore)) {
            CheckerUtil.addViolation(failureMsg, "notBefore", time.getTimeString(), notBefore.getTimeString());
        }
        time = extValue.getNotAfter();
        if (time == null) {
            failureMsg.append("notAfter is absent but expected present; ");
        } else if (!time.equals((ASN1Primitive)notAfter)) {
            CheckerUtil.addViolation(failureMsg, "notAfter", time.getTimeString(), notAfter.getTimeString());
        }
    }

    void checkExtnQcStatements(StringBuilder failureMsg, byte[] extnValue, Extensions requestedExtns, Certprofile.ExtensionControl extnControl) {
        Extension reqExtension;
        QcStatements qcStatements = this.caller.getQcStatements();
        if (qcStatements == null) {
            this.caller.checkConstantExtnValue(Extension.qCStatements, failureMsg, extnValue, requestedExtns, extnControl);
            return;
        }
        int expSize = qcStatements.getQcStatements().size();
        ASN1Sequence extValue = ASN1Sequence.getInstance((Object)extnValue);
        int isSize = extValue.size();
        if (isSize != expSize) {
            CheckerUtil.addViolation(failureMsg, "number of statements", isSize, expSize);
            return;
        }
        HashMap<String, int[]> reqQcEuLimits = new HashMap<String, int[]>();
        Extension extension = reqExtension = requestedExtns == null ? null : requestedExtns.getExtension(Extension.qCStatements);
        if (reqExtension != null) {
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)reqExtension.getParsedValue());
            int n = seq.size();
            for (int j = 0; j < n; ++j) {
                QCStatement stmt = QCStatement.getInstance((Object)seq.getObjectAt(j));
                if (!ObjectIdentifiers.Extn.id_etsi_qcs_QcLimitValue.equals((ASN1Primitive)stmt.getStatementId())) continue;
                MonetaryValue monetaryValue = MonetaryValue.getInstance((Object)stmt.getStatementInfo());
                int amount = monetaryValue.getAmount().intValue();
                int exponent = monetaryValue.getExponent().intValue();
                Iso4217CurrencyCode currency = monetaryValue.getCurrency();
                String currencyS = currency.isAlphabetic() ? currency.getAlphabetic().toUpperCase() : Integer.toString(currency.getNumeric());
                reqQcEuLimits.put(currencyS, new int[]{amount, exponent});
            }
        }
        for (int i = 0; i < expSize; ++i) {
            QCStatement is = QCStatement.getInstance((Object)extValue.getObjectAt(i));
            QcStatements.QcStatementType exp = (QcStatements.QcStatementType)qcStatements.getQcStatements().get(i);
            if (!is.getStatementId().getId().equals(exp.getStatementId().getOid())) {
                CheckerUtil.addViolation(failureMsg, "statmentId[" + i + "]", is.getStatementId().getId(), exp.getStatementId().getOid());
                continue;
            }
            if (exp.getStatementValue() == null) {
                if (is.getStatementInfo() == null) continue;
                CheckerUtil.addViolation(failureMsg, "statmentInfo[" + i + "]", "present", "absent");
                continue;
            }
            if (is.getStatementInfo() == null) {
                CheckerUtil.addViolation(failureMsg, "statmentInfo[" + i + "]", "absent", "present");
                continue;
            }
            QcStatements.QcStatementValueType expStatementValue = exp.getStatementValue();
            try {
                if (expStatementValue.getConstant() != null) {
                    byte[] expValue = expStatementValue.getConstant().getValue();
                    byte[] isValue = is.getStatementInfo().toASN1Primitive().getEncoded();
                    if (!Arrays.equals(isValue, expValue)) {
                        CheckerUtil.addViolation(failureMsg, "statementInfo[" + i + "]", CheckerUtil.hex(isValue), CheckerUtil.hex(expValue));
                    }
                    continue;
                }
                if (expStatementValue.getQcRetentionPeriod() != null) {
                    String expValue;
                    String isValue = ASN1Integer.getInstance((Object)is.getStatementInfo()).toString();
                    if (!isValue.equals(expValue = expStatementValue.getQcRetentionPeriod().toString())) {
                        CheckerUtil.addViolation(failureMsg, "statementInfo[" + i + "]", isValue, expValue);
                    }
                    continue;
                }
                if (expStatementValue.getPdsLocations() != null) {
                    HashSet<String> pdsLocations = new HashSet<String>();
                    ASN1Sequence pdsLocsSeq = ASN1Sequence.getInstance((Object)is.getStatementInfo());
                    int size = pdsLocsSeq.size();
                    for (int k = 0; k < size; ++k) {
                        ASN1Sequence pdsLocSeq = ASN1Sequence.getInstance((Object)pdsLocsSeq.getObjectAt(k));
                        int size2 = pdsLocSeq.size();
                        if (size2 != 2) {
                            throw new IllegalArgumentException("sequence size is " + size2 + " but expected 2");
                        }
                        String url = DERIA5String.getInstance((Object)pdsLocSeq.getObjectAt(0)).getString();
                        String lang = DERPrintableString.getInstance((Object)pdsLocSeq.getObjectAt(1)).getString();
                        pdsLocations.add("url=" + url + ",lang=" + lang);
                    }
                    HashSet<String> expectedPdsLocations = new HashSet<String>();
                    for (QcStatements.PdsLocationType m : expStatementValue.getPdsLocations()) {
                        expectedPdsLocations.add("url=" + m.getUrl() + ",lang=" + m.getLanguage());
                    }
                    Set<String> diffs = CheckerUtil.strInBnotInA(expectedPdsLocations, pdsLocations);
                    if (CollectionUtil.isNotEmpty(diffs)) {
                        failureMsg.append("statementInfo[").append(i).append("]: ").append(diffs).append(" are present but not expected; ");
                    }
                    if (CollectionUtil.isNotEmpty(diffs = CheckerUtil.strInBnotInA(pdsLocations, expectedPdsLocations))) {
                        failureMsg.append("statementInfo[").append(i).append("]: ").append(diffs).append(" are absent but are required; ");
                    }
                    continue;
                }
                if (expStatementValue.getQcEuLimitValue() != null) {
                    int value;
                    QcStatements.QcEuLimitValueType euLimitConf = expStatementValue.getQcEuLimitValue();
                    String expCurrency = euLimitConf.getCurrency().toUpperCase();
                    int[] expAmountExp = (int[])reqQcEuLimits.get(expCurrency);
                    QcStatements.Range2Type range = euLimitConf.getAmount();
                    if (range.getMin() == range.getMax()) {
                        value = range.getMin();
                    } else if (expAmountExp != null) {
                        value = expAmountExp[0];
                    } else {
                        failureMsg.append("found no QcEuLimit for currency '").append(expCurrency).append("'; ");
                        return;
                    }
                    String expAmount = Integer.toString(value);
                    range = euLimitConf.getExponent();
                    if (range.getMin() == range.getMax()) {
                        value = range.getMin();
                    } else if (expAmountExp != null) {
                        value = expAmountExp[1];
                    } else {
                        failureMsg.append("found no QcEuLimit for currency '").append(expCurrency).append("'; ");
                        return;
                    }
                    String expExponent = Integer.toString(value);
                    MonetaryValue monterayValue = MonetaryValue.getInstance((Object)is.getStatementInfo());
                    Iso4217CurrencyCode currency = monterayValue.getCurrency();
                    String isCurrency = currency.isAlphabetic() ? currency.getAlphabetic() : Integer.toString(currency.getNumeric());
                    String isAmount = monterayValue.getAmount().toString();
                    String isExponent = monterayValue.getExponent().toString();
                    if (!isCurrency.equals(expCurrency)) {
                        CheckerUtil.addViolation(failureMsg, "statementInfo[" + i + "].qcEuLimit.currency", isCurrency, expCurrency);
                    }
                    if (!isAmount.equals(expAmount)) {
                        CheckerUtil.addViolation(failureMsg, "statementInfo[" + i + "].qcEuLimit.amount", isAmount, expAmount);
                    }
                    if (!isExponent.equals(expExponent)) {
                        CheckerUtil.addViolation(failureMsg, "statementInfo[" + i + "].qcEuLimit.exponent", isExponent, expExponent);
                    }
                    continue;
                }
                throw new IllegalStateException("statementInfo[" + i + "]should not reach here");
            }
            catch (IOException ex) {
                failureMsg.append("statementInfo[").append(i).append("] has incorrect syntax; ");
            }
        }
    }

    void checkExtnRestriction(StringBuilder failureMsg, byte[] extnValue, Extensions requestedExtns, Certprofile.ExtensionControl extnControl) {
        Restriction restriction = this.caller.getRestriction();
        this.caller.checkDirectoryString(ObjectIdentifiers.Extn.id_extension_restriction, restriction.getType(), restriction.getText(), failureMsg, extnValue, requestedExtns, extnControl);
    }

    void checkSmimeCapabilities(StringBuilder failureMsg, byte[] extnValue, Certprofile.ExtensionControl extnControl) {
        byte[] expected = this.caller.getSmimeCapabilities().getValue();
        if (!Arrays.equals(expected, extnValue)) {
            CheckerUtil.addViolation(failureMsg, "extension valus", CheckerUtil.hex(extnValue), expected == null ? "not present" : CheckerUtil.hex(expected));
        }
    }

    void checkScts(StringBuilder failureMsg, byte[] extensionValue, Certprofile.ExtensionControl extControl) {
        try {
            ASN1OctetString octet = DEROctetString.getInstance((Object)extensionValue);
            CtLog.SignedCertificateTimestampList sctList = CtLog.SignedCertificateTimestampList.getInstance((byte[])octet.getOctets());
            int size = sctList.getSctList().size();
            for (int i = 0; i < size; ++i) {
                sctList.getSctList().get(i).getDigitallySigned().getSignatureObject();
            }
        }
        catch (Exception ex) {
            failureMsg.append("invalid syntax: ").append(ex.getMessage()).append("; ");
        }
    }

    void checkExtnSubjectAltNames(StringBuilder failureMsg, byte[] extnValue, Extensions requestedExtns, Certprofile.ExtensionControl extnControl, X500Name requestedSubject) {
        int i;
        GeneralName[] requested;
        XijsonCertprofile certprofile = this.getCertprofile();
        Set conf = certprofile.getSubjectAltNameModes();
        try {
            requested = this.getRequestedSubjectAltNames(certprofile, requestedSubject, requestedExtns);
        }
        catch (BadCertTemplateException | CertprofileException ex) {
            String msg = "error while derive grantedSubject from requestedSubject";
            LogUtil.warn((Logger)this.log, (Throwable)ex, (String)msg);
            failureMsg.append(msg);
            return;
        }
        if (requested == null) {
            failureMsg.append("extension is present but not expected; ");
            return;
        }
        GeneralName[] is = GeneralNames.getInstance((Object)extnValue).getNames();
        GeneralName[] expected = new GeneralName[requested.length];
        for (i = 0; i < is.length; ++i) {
            try {
                expected[i] = CheckerUtil.createGeneralName(is[i], conf);
                continue;
            }
            catch (BadCertTemplateException ex) {
                failureMsg.append("could not process ").append(i + 1).append("-th name: ").append(ex.getMessage()).append("; ");
                return;
            }
        }
        if (is.length != expected.length) {
            CheckerUtil.addViolation(failureMsg, "size of GeneralNames", is.length, expected.length);
            return;
        }
        for (i = 0; i < is.length; ++i) {
            if (is[i].equals((Object)expected[i])) continue;
            failureMsg.append(i + 1).append("-th name does not match the requested one; ");
        }
    }

    private GeneralName[] getRequestedSubjectAltNames(XijsonCertprofile certprofile, X500Name requestedSubject, Extensions requestedExtns) throws CertprofileException, BadCertTemplateException {
        ASN1Encodable extValue = requestedExtns == null ? null : requestedExtns.getExtensionParsedValue(Extension.subjectAlternativeName);
        Map subjectToSubjectAltNameModes = certprofile.extensions().getSubjectToSubjectAltNameModes();
        if (extValue == null && subjectToSubjectAltNameModes == null) {
            return null;
        }
        GeneralNames reqNames = extValue == null ? null : GeneralNames.getInstance((Object)extValue);
        Set subjectAltNameModes = certprofile.getSubjectAltNameModes();
        if (subjectAltNameModes == null && subjectToSubjectAltNameModes == null) {
            return reqNames == null ? null : reqNames.getNames();
        }
        LinkedList<GeneralName> grantedNames = new LinkedList<GeneralName>();
        if (subjectToSubjectAltNameModes != null) {
            X500Name grantedSubject = certprofile.getSubject(requestedSubject).getGrantedSubject();
            for (ASN1ObjectIdentifier attrType : subjectToSubjectAltNameModes.keySet()) {
                Certprofile.GeneralNameTag tag = (Certprofile.GeneralNameTag)subjectToSubjectAltNameModes.get(attrType);
                RDN[] rdns = grantedSubject.getRDNs(attrType);
                if (rdns == null || rdns.length == 0) {
                    rdns = requestedSubject.getRDNs(attrType);
                }
                if (rdns == null || rdns.length == 0) continue;
                block5: for (RDN rdn : rdns) {
                    String rdnValue = X509Util.rdnValueToString((ASN1Encodable)rdn.getFirst().getValue());
                    switch (tag) {
                        case rfc822Name: {
                            grantedNames.add(new GeneralName(tag.getTag(), rdnValue.toLowerCase()));
                            continue block5;
                        }
                        case DNSName: 
                        case uniformResourceIdentifier: 
                        case IPAddress: 
                        case directoryName: 
                        case registeredID: {
                            grantedNames.add(new GeneralName(tag.getTag(), rdnValue));
                            continue block5;
                        }
                        default: {
                            throw new IllegalStateException("should not reach here, unknown GeneralName tag " + tag);
                        }
                    }
                }
            }
        }
        if (reqNames != null) {
            GeneralName[] reqL = reqNames.getNames();
            for (int i = 0; i < reqL.length; ++i) {
                grantedNames.add(reqL[i]);
            }
        }
        return grantedNames.isEmpty() ? null : grantedNames.toArray(new GeneralName[0]);
    }

    void checkExtnSubjectDirAttrs(StringBuilder failureMsg, byte[] extnValue, Extensions requestedExtns, Certprofile.ExtensionControl extnControl) {
        SubjectDirectoryAttributesControl conf = this.getCertprofile().extensions().getSubjectDirAttrsControl();
        if (conf == null) {
            failureMsg.append("extension is present but not expected; ");
            return;
        }
        ASN1Encodable extInRequest = null;
        if (requestedExtns != null) {
            extInRequest = requestedExtns.getExtensionParsedValue(Extension.subjectDirectoryAttributes);
        }
        if (extInRequest == null) {
            failureMsg.append("extension is present but not expected; ");
            return;
        }
        SubjectDirectoryAttributes requested = SubjectDirectoryAttributes.getInstance((Object)extInRequest);
        Vector reqSubDirAttrs = requested.getAttributes();
        ASN1GeneralizedTime expDateOfBirth = null;
        String expPlaceOfBirth = null;
        String expGender = null;
        HashSet<String> expCountryOfCitizenshipList = new HashSet<String>();
        HashSet<String> expCountryOfResidenceList = new HashSet<String>();
        HashMap<ASN1ObjectIdentifier, HashSet<ASN1Encodable>> expOtherAttrs = new HashMap<ASN1ObjectIdentifier, HashSet<ASN1Encodable>>();
        int expN = reqSubDirAttrs.size();
        for (int i = 0; i < expN; ++i) {
            String country;
            Attribute attr = Attribute.getInstance(reqSubDirAttrs.get(i));
            ASN1ObjectIdentifier attrType = attr.getAttrType();
            ASN1Encodable attrVal = attr.getAttributeValues()[0];
            if (ObjectIdentifiers.DN.dateOfBirth.equals((ASN1Primitive)attrType)) {
                expDateOfBirth = ASN1GeneralizedTime.getInstance((Object)attrVal);
                continue;
            }
            if (ObjectIdentifiers.DN.placeOfBirth.equals((ASN1Primitive)attrType)) {
                expPlaceOfBirth = DirectoryString.getInstance((Object)attrVal).getString();
                continue;
            }
            if (ObjectIdentifiers.DN.gender.equals((ASN1Primitive)attrType)) {
                expGender = DERPrintableString.getInstance((Object)attrVal).getString();
                continue;
            }
            if (ObjectIdentifiers.DN.countryOfCitizenship.equals((ASN1Primitive)attrType)) {
                country = DERPrintableString.getInstance((Object)attrVal).getString();
                expCountryOfCitizenshipList.add(country);
                continue;
            }
            if (ObjectIdentifiers.DN.countryOfResidence.equals((ASN1Primitive)attrType)) {
                country = DERPrintableString.getInstance((Object)attrVal).getString();
                expCountryOfResidenceList.add(country);
                continue;
            }
            HashSet<ASN1Encodable> otherAttrVals = (HashSet<ASN1Encodable>)expOtherAttrs.get(attrType);
            if (otherAttrVals == null) {
                otherAttrVals = new HashSet<ASN1Encodable>();
                expOtherAttrs.put(attrType, otherAttrVals);
            }
            otherAttrVals.add(attrVal);
        }
        SubjectDirectoryAttributes ext = SubjectDirectoryAttributes.getInstance((Object)extnValue);
        Vector subDirAttrs = ext.getAttributes();
        ASN1GeneralizedTime dateOfBirth = null;
        String placeOfBirth = null;
        String gender = null;
        HashSet<String> countryOfCitizenshipList = new HashSet<String>();
        HashSet<String> countryOfResidenceList = new HashSet<String>();
        HashMap<ASN1ObjectIdentifier, HashSet<ASN1Encodable>> otherAttrs = new HashMap<ASN1ObjectIdentifier, HashSet<ASN1Encodable>>();
        LinkedList attrTypes = new LinkedList(conf.getTypes());
        int n = subDirAttrs.size();
        for (int i = 0; i < n; ++i) {
            String country;
            Attribute attr = Attribute.getInstance(subDirAttrs.get(i));
            ASN1ObjectIdentifier attrType = attr.getAttrType();
            if (!attrTypes.contains(attrType)) {
                failureMsg.append("attribute of type " + attrType.getId()).append(" is present but not expected; ");
                continue;
            }
            ASN1Encodable[] attrs = attr.getAttributeValues();
            if (attrs.length != 1) {
                failureMsg.append("attribute of type ").append(attrType.getId()).append(" does not single-value value: ").append(attrs.length).append("; ");
                continue;
            }
            ASN1Encodable attrVal = attrs[0];
            if (ObjectIdentifiers.DN.dateOfBirth.equals((ASN1Primitive)attrType)) {
                dateOfBirth = ASN1GeneralizedTime.getInstance((Object)attrVal);
                continue;
            }
            if (ObjectIdentifiers.DN.placeOfBirth.equals((ASN1Primitive)attrType)) {
                placeOfBirth = DirectoryString.getInstance((Object)attrVal).getString();
                continue;
            }
            if (ObjectIdentifiers.DN.gender.equals((ASN1Primitive)attrType)) {
                gender = DERPrintableString.getInstance((Object)attrVal).getString();
                continue;
            }
            if (ObjectIdentifiers.DN.countryOfCitizenship.equals((ASN1Primitive)attrType)) {
                country = DERPrintableString.getInstance((Object)attrVal).getString();
                countryOfCitizenshipList.add(country);
                continue;
            }
            if (ObjectIdentifiers.DN.countryOfResidence.equals((ASN1Primitive)attrType)) {
                country = DERPrintableString.getInstance((Object)attrVal).getString();
                countryOfResidenceList.add(country);
                continue;
            }
            HashSet<ASN1Encodable> otherAttrVals = (HashSet<ASN1Encodable>)otherAttrs.get(attrType);
            if (otherAttrVals == null) {
                otherAttrVals = new HashSet<ASN1Encodable>();
                otherAttrs.put(attrType, otherAttrVals);
            }
            otherAttrVals.add(attrVal);
        }
        if (dateOfBirth != null) {
            attrTypes.remove(ObjectIdentifiers.DN.dateOfBirth);
        }
        if (placeOfBirth != null) {
            attrTypes.remove(ObjectIdentifiers.DN.placeOfBirth);
        }
        if (gender != null) {
            attrTypes.remove(ObjectIdentifiers.DN.gender);
        }
        if (!countryOfCitizenshipList.isEmpty()) {
            attrTypes.remove(ObjectIdentifiers.DN.countryOfCitizenship);
        }
        if (!countryOfResidenceList.isEmpty()) {
            attrTypes.remove(ObjectIdentifiers.DN.countryOfResidence);
        }
        attrTypes.removeAll(otherAttrs.keySet());
        if (!attrTypes.isEmpty()) {
            LinkedList<String> attrTypeTexts = new LinkedList<String>();
            for (ASN1ObjectIdentifier oid : attrTypes) {
                attrTypeTexts.add(oid.getId());
            }
            failureMsg.append("required attributes of types ").append(attrTypeTexts).append(" are not present; ");
        }
        if (dateOfBirth != null) {
            String exp;
            String timeStirng = dateOfBirth.getTimeString();
            if (!TextVadidator.DATE_OF_BIRTH.isValid(timeStirng)) {
                failureMsg.append("invalid dateOfBirth: " + timeStirng + "; ");
            }
            String string = exp = expDateOfBirth == null ? null : expDateOfBirth.getTimeString();
            if (!timeStirng.equalsIgnoreCase(exp)) {
                CheckerUtil.addViolation(failureMsg, "dateOfBirth", timeStirng, exp);
            }
        }
        if (gender != null) {
            if (!gender.equalsIgnoreCase("F") && !gender.equalsIgnoreCase("M")) {
                failureMsg.append("invalid gender: ").append(gender).append("; ");
            }
            if (!gender.equalsIgnoreCase(expGender)) {
                CheckerUtil.addViolation(failureMsg, "gender", gender, expGender);
            }
        }
        if (placeOfBirth != null && !placeOfBirth.equals(expPlaceOfBirth)) {
            CheckerUtil.addViolation(failureMsg, "placeOfBirth", placeOfBirth, expPlaceOfBirth);
        }
        if (!countryOfCitizenshipList.isEmpty()) {
            Set<String> diffs = CheckerUtil.strInBnotInA(expCountryOfCitizenshipList, countryOfCitizenshipList);
            if (CollectionUtil.isNotEmpty(diffs)) {
                failureMsg.append("countryOfCitizenship ").append(diffs).append(" are present but not expected; ");
            }
            if (CollectionUtil.isNotEmpty(diffs = CheckerUtil.strInBnotInA(countryOfCitizenshipList, expCountryOfCitizenshipList))) {
                failureMsg.append("countryOfCitizenship ").append(diffs).append(" are absent but are required; ");
            }
        }
        if (!countryOfResidenceList.isEmpty()) {
            Set<String> diffs = CheckerUtil.strInBnotInA(expCountryOfResidenceList, countryOfResidenceList);
            if (CollectionUtil.isNotEmpty(diffs)) {
                failureMsg.append("countryOfResidence ").append(diffs).append(" are present but not expected; ");
            }
            if (CollectionUtil.isNotEmpty(diffs = CheckerUtil.strInBnotInA(countryOfResidenceList, expCountryOfResidenceList))) {
                failureMsg.append("countryOfResidence ").append(diffs).append(" are absent but are required; ");
            }
        }
        if (!otherAttrs.isEmpty()) {
            for (ASN1ObjectIdentifier attrType : otherAttrs.keySet()) {
                Set expAttrValues = (Set)expOtherAttrs.get(attrType);
                if (expAttrValues == null) {
                    failureMsg.append("attribute of type ").append(attrType.getId()).append(" is present but not requested; ");
                    continue;
                }
                Set attrValues = (Set)otherAttrs.get(attrType);
                if (attrValues.equals(expAttrValues)) continue;
                failureMsg.append("attribute of type ").append(attrType.getId()).append(" differs from the requested one; ");
            }
        }
    }

    void checkExtnSubjectInfoAccess(StringBuilder failureMsg, byte[] extnValue, Extensions requestedExtns, Certprofile.ExtensionControl extnControl) {
        Map conf = this.getCertprofile().getSubjectInfoAccessModes();
        if (conf == null) {
            failureMsg.append("extension is present but not expected; ");
            return;
        }
        ASN1Encodable requestExtValue = null;
        if (requestedExtns != null) {
            requestExtValue = requestedExtns.getExtensionParsedValue(Extension.subjectInfoAccess);
        }
        if (requestExtValue == null) {
            failureMsg.append("extension is present but not expected; ");
            return;
        }
        ASN1Sequence requestSeq = ASN1Sequence.getInstance((Object)requestExtValue);
        ASN1Sequence certSeq = ASN1Sequence.getInstance((Object)extnValue);
        int size = requestSeq.size();
        if (certSeq.size() != size) {
            CheckerUtil.addViolation(failureMsg, "size of GeneralNames", certSeq.size(), size);
            return;
        }
        for (int i = 0; i < size; ++i) {
            GeneralName accessLocation;
            boolean bo;
            AccessDescription ad = AccessDescription.getInstance((Object)requestSeq.getObjectAt(i));
            ASN1ObjectIdentifier accessMethod = ad.getAccessMethod();
            Set generalNameModes = (Set)conf.get(accessMethod);
            if (generalNameModes == null) {
                failureMsg.append("accessMethod in requestedExtension ").append(accessMethod.getId()).append(" is not allowed; ");
                continue;
            }
            AccessDescription certAccessDesc = AccessDescription.getInstance((Object)certSeq.getObjectAt(i));
            ASN1ObjectIdentifier certAccessMethod = certAccessDesc.getAccessMethod();
            boolean bl = accessMethod == null ? certAccessMethod == null : (bo = accessMethod.equals((ASN1Primitive)certAccessMethod));
            if (!bo) {
                CheckerUtil.addViolation(failureMsg, "accessMethod", certAccessMethod == null ? "null" : certAccessMethod.getId(), accessMethod == null ? "null" : accessMethod.getId());
                continue;
            }
            try {
                accessLocation = CheckerUtil.createGeneralName(ad.getAccessLocation(), generalNameModes);
            }
            catch (BadCertTemplateException ex) {
                failureMsg.append("invalid requestedExtension: ").append(ex.getMessage()).append("; ");
                continue;
            }
            GeneralName certAccessLocation = certAccessDesc.getAccessLocation();
            if (certAccessLocation.equals((Object)accessLocation)) continue;
            failureMsg.append("accessLocation does not match the requested one; ");
        }
    }

    void checkExtnSubjectKeyIdentifier(StringBuilder failureMsg, byte[] extnValue, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        byte[] expectedSki;
        SubjectKeyIdentifier asn1 = SubjectKeyIdentifier.getInstance((Object)extnValue);
        byte[] ski = asn1.getKeyIdentifier();
        try {
            expectedSki = this.getCertprofile().getSubjectKeyIdentifier(subjectPublicKeyInfo).getKeyIdentifier();
        }
        catch (CertprofileException e) {
            failureMsg.append("error computing expected SubjectKeyIdentifier");
            return;
        }
        if (!Arrays.equals(expectedSki, ski)) {
            CheckerUtil.addViolation(failureMsg, "SKI", CheckerUtil.hex(ski), CheckerUtil.hex(expectedSki));
        }
    }

    void checkExtnTlsFeature(StringBuilder failureMsg, byte[] extnValue, Extensions requestedExtns, Certprofile.ExtensionControl extnControl) {
        TlsFeature tlsFeature = this.caller.getTlsFeature();
        if (tlsFeature == null) {
            this.caller.checkConstantExtnValue(ObjectIdentifiers.Extn.id_pe_tlsfeature, failureMsg, extnValue, requestedExtns, extnControl);
            return;
        }
        HashSet<String> isFeatures = new HashSet<String>();
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)extnValue);
        int n = seq.size();
        for (int i = 0; i < n; ++i) {
            ASN1Integer asn1Feature = ASN1Integer.getInstance((Object)seq.getObjectAt(i));
            isFeatures.add(asn1Feature.getPositiveValue().toString());
        }
        HashSet<String> expFeatures = new HashSet<String>();
        for (Describable.DescribableInt m : tlsFeature.getFeatures()) {
            expFeatures.add(Integer.toString(m.getValue()));
        }
        Set<String> diffs = CheckerUtil.strInBnotInA(expFeatures, isFeatures);
        if (CollectionUtil.isNotEmpty(diffs)) {
            failureMsg.append("features ").append(diffs).append(" are present but not expected; ");
        }
        if (CollectionUtil.isNotEmpty(diffs = CheckerUtil.strInBnotInA(isFeatures, expFeatures))) {
            failureMsg.append("features ").append(diffs).append(" are absent but are required; ");
        }
    }
}

