/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.qa.ocsp;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ocsp.client.RequestOptions;
import org.xipki.qa.BenchmarkHttpClient;
import org.xipki.qa.ocsp.OcspBenchRequestor;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;
import org.xipki.util.BenchmarkExecutor;

public class OcspBenchmark
extends BenchmarkExecutor
implements BenchmarkHttpClient.ResponseHandler {
    private static final Logger LOG = LoggerFactory.getLogger(OcspBenchmark.class);
    private final X509Cert issuerCert;
    private final String responderUrl;
    private final RequestOptions requestOptions;
    private final Iterator<BigInteger> serials;
    private final int maxRequests;
    private final int queueSize;
    private final AtomicInteger processedRequests = new AtomicInteger(0);

    public OcspBenchmark(X509Cert issuerCert, String responderUrl, RequestOptions requestOptions, Iterator<BigInteger> serials, int maxRequests, int queueSize, String description) {
        super(description);
        this.issuerCert = (X509Cert)Args.notNull((Object)issuerCert, (String)"issuerCert");
        this.responderUrl = (String)Args.notNull((Object)responderUrl, (String)"responderUrl");
        this.requestOptions = (RequestOptions)Args.notNull((Object)requestOptions, (String)"requestOptions");
        this.maxRequests = maxRequests;
        this.serials = (Iterator)Args.notNull(serials, (String)"serials");
        this.queueSize = queueSize;
    }

    protected Runnable getTestor() throws Exception {
        return new Testor();
    }

    private BigInteger nextSerialNumber() {
        int num;
        if (this.maxRequests > 0 && (num = this.processedRequests.getAndAdd(1)) >= this.maxRequests) {
            return null;
        }
        try {
            return this.serials.next();
        }
        catch (NoSuchElementException ex) {
            return null;
        }
    }

    @Override
    public void onComplete(FullHttpResponse response) {
        boolean success;
        try {
            success = this.onComplete0(response);
        }
        catch (Throwable th) {
            LOG.warn("unexpected exception", th);
            success = false;
        }
        this.account(1L, success ? 0L : 1L);
    }

    @Override
    public synchronized void onError() {
        this.account(1L, 1L);
    }

    private boolean onComplete0(FullHttpResponse response) {
        Object respObject;
        OCSPResp ocspResp;
        if (response == null) {
            LOG.warn("bad response: response is null");
            return false;
        }
        if (response.decoderResult().isFailure()) {
            LOG.warn("failed: {}", (Object)response.decoderResult());
            return false;
        }
        if (response.status().code() != HttpResponseStatus.OK.code()) {
            LOG.warn("bad response: {}", (Object)response.status());
            return false;
        }
        String responseContentType = response.headers().get("Content-Type");
        if (responseContentType == null) {
            LOG.warn("bad response: mandatory Content-Type not specified");
            return false;
        }
        if (!responseContentType.equalsIgnoreCase("application/ocsp-response")) {
            LOG.warn("bad response: Content-Type {} unsupported", (Object)responseContentType);
            return false;
        }
        ByteBuf buf = response.content();
        if (buf == null || buf.readableBytes() == 0) {
            LOG.warn("no body in response");
            return false;
        }
        byte[] respBytes = new byte[buf.readableBytes()];
        buf.getBytes(buf.readerIndex(), respBytes);
        try {
            ocspResp = new OCSPResp(respBytes);
        }
        catch (IOException ex) {
            LOG.warn("could not parse OCSP response", (Throwable)ex);
            return false;
        }
        try {
            respObject = ocspResp.getResponseObject();
        }
        catch (OCSPException ex) {
            LOG.warn("responseObject is invalid", (Throwable)ex);
            return false;
        }
        if (ocspResp.getStatus() != 0) {
            LOG.warn("bad response: response status is other than OK");
            return false;
        }
        if (!(respObject instanceof BasicOCSPResp)) {
            LOG.warn("bad response: response is not BasiOCSPResp");
            return false;
        }
        return true;
    }

    final class Testor
    implements Runnable {
        private final OcspBenchRequestor requestor = new OcspBenchRequestor();

        Testor() throws Exception {
            this.requestor.init(OcspBenchmark.this, OcspBenchmark.this.responderUrl, OcspBenchmark.this.issuerCert, OcspBenchmark.this.requestOptions, OcspBenchmark.this.queueSize);
        }

        @Override
        public void run() {
            BigInteger sn;
            while (!OcspBenchmark.this.stop() && (sn = OcspBenchmark.this.nextSerialNumber()) != null) {
                try {
                    this.requestor.ask(new BigInteger[]{sn});
                }
                catch (Throwable th) {
                    LOG.warn("{}: {}", (Object)th.getClass().getName(), (Object)th.getMessage());
                    OcspBenchmark.this.account(1L, 1L);
                }
            }
            try {
                this.requestor.shutdown();
            }
            catch (Exception ex) {
                LOG.warn("got IOException in requestor.stop()");
            }
        }
    }
}

