/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.qa.security;

import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.pkcs11.P11IdentityId;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.util.Args;
import org.xipki.util.BenchmarkExecutor;

public abstract class P11KeyGenSpeed
extends BenchmarkExecutor {
    protected final P11Slot slot;
    private static final Logger LOG = LoggerFactory.getLogger(P11KeyGenSpeed.class);
    private byte[] id;
    private AtomicLong idx = new AtomicLong(System.currentTimeMillis());

    public P11KeyGenSpeed(P11Slot slot, byte[] id, String description) {
        super(description);
        this.slot = (P11Slot)Args.notNull((Object)slot, (String)"slot");
        this.id = id;
    }

    protected abstract void genKeypair() throws Exception;

    protected P11Slot.P11NewKeyControl getControl() {
        return new P11Slot.P11NewKeyControl(this.id, "speed-" + this.idx.getAndIncrement());
    }

    protected Runnable getTestor() throws Exception {
        return new Testor();
    }

    class Testor
    implements Runnable {
        Testor() {
        }

        @Override
        public void run() {
            while (!P11KeyGenSpeed.this.stop() && P11KeyGenSpeed.this.getErrorAccout() < 1L) {
                try {
                    P11KeyGenSpeed.this.genKeypair();
                    P11KeyGenSpeed.this.account(1L, 0L);
                }
                catch (Exception ex) {
                    LOG.error("P11KeyGenSpeed.Testor.run()", (Throwable)ex);
                    P11KeyGenSpeed.this.account(1L, 1L);
                }
            }
        }
    }

    public static class SM2
    extends P11KeyGenSpeed {
        public SM2(P11Slot slot, byte[] id) throws Exception {
            super(slot, id, "PKCS#11 SM2 key generation");
        }

        @Override
        protected void genKeypair() throws Exception {
            P11IdentityId objId = this.slot.generateSM2Keypair(this.getControl());
            this.slot.removeIdentity(objId);
        }
    }

    public static class RSA
    extends P11KeyGenSpeed {
        private final int keysize;
        private final BigInteger publicExponent;

        public RSA(P11Slot slot, byte[] id, int keysize, BigInteger publicExponent) throws Exception {
            super(slot, id, "PKCS#11 RSA key generation\nkeysize: " + keysize + "\npublic exponent: " + publicExponent);
            this.keysize = keysize;
            this.publicExponent = publicExponent;
        }

        @Override
        protected void genKeypair() throws Exception {
            P11IdentityId objId = this.slot.generateRSAKeypair(this.keysize, this.publicExponent, this.getControl());
            this.slot.removeIdentity(objId);
        }
    }

    public static class EC
    extends P11KeyGenSpeed {
        private final ASN1ObjectIdentifier curveOid;

        public EC(P11Slot slot, byte[] id, ASN1ObjectIdentifier curveOid) throws Exception {
            super(slot, id, "PKCS#11 EC key generation\ncurve: " + curveOid.getId());
            this.curveOid = (ASN1ObjectIdentifier)Args.notNull((Object)curveOid, (String)"curveOid");
        }

        @Override
        protected void genKeypair() throws Exception {
            P11IdentityId objId = this.slot.generateECKeypair(this.curveOid, this.getControl());
            this.slot.removeIdentity(objId);
        }
    }

    public static class DSA
    extends P11KeyGenSpeed {
        private final int plength;
        private final int qlength;

        public DSA(P11Slot slot, byte[] id, int plength, int qlength) throws Exception {
            super(slot, id, "PKCS#11 DSA key generation\nplength: " + plength + "\nqlength: " + qlength);
            this.plength = plength;
            this.qlength = qlength;
        }

        @Override
        protected void genKeypair() throws Exception {
            P11IdentityId objId = this.slot.generateDSAKeypair(this.plength, this.qlength, this.getControl());
            this.slot.removeIdentity(objId);
        }
    }
}

