/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.qa;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.xipki.qa.ValidationIssue;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;

public class ValidationResult {
    private final List<ValidationIssue> validationIssues;
    private final List<ValidationIssue> failedValidationIssues;
    private final List<ValidationIssue> successfulValidationIssues;

    public ValidationResult(ValidationIssue validationIssues) {
        this(Collections.singletonList(validationIssues));
    }

    public ValidationResult(List<ValidationIssue> validationIssues) {
        this.validationIssues = Args.notEmpty(validationIssues, (String)"validationIssues");
        LinkedList<ValidationIssue> failedIssues = new LinkedList<ValidationIssue>();
        LinkedList<ValidationIssue> successfulIssues = new LinkedList<ValidationIssue>();
        for (ValidationIssue issue : validationIssues) {
            if (issue.isFailed()) {
                failedIssues.add(issue);
                continue;
            }
            successfulIssues.add(issue);
        }
        this.failedValidationIssues = failedIssues;
        this.successfulValidationIssues = successfulIssues;
    }

    public boolean isAllSuccessful() {
        return CollectionUtil.isEmpty(this.failedValidationIssues);
    }

    public List<ValidationIssue> getValidationIssues() {
        return this.validationIssues;
    }

    public List<ValidationIssue> getFailedValidationIssues() {
        return this.failedValidationIssues;
    }

    public List<ValidationIssue> getSuccessfulValidationIssues() {
        return this.successfulValidationIssues;
    }
}

