/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.qa.ca;

import java.util.LinkedList;
import java.util.List;
import org.xipki.util.FileOrBinary;
import org.xipki.util.FileOrValue;
import org.xipki.util.InvalidConfException;
import org.xipki.util.ValidatableConf;

public class QaconfType
extends ValidatableConf {
    private List<Issuer> issuers;
    private List<Certprofile> certprofiles;

    public List<Issuer> getIssuers() {
        if (this.issuers == null) {
            this.issuers = new LinkedList<Issuer>();
        }
        return this.issuers;
    }

    public void setIssuers(List<Issuer> issuers) {
        this.issuers = issuers;
    }

    public List<Certprofile> getCertprofiles() {
        if (this.certprofiles == null) {
            this.certprofiles = new LinkedList<Certprofile>();
        }
        return this.certprofiles;
    }

    public void setCertprofiles(List<Certprofile> certprofiles) {
        this.certprofiles = certprofiles;
    }

    public void validate() throws InvalidConfException {
        QaconfType.validate(this.issuers);
        QaconfType.validate(this.certprofiles);
    }

    public static class Issuer
    extends ValidatableConf {
        private FileOrBinary cert;
        private String validityMode;
        private List<String> caIssuerUrls;
        private List<String> ocspUrls;
        private List<String> crlUrls;
        private List<String> deltaCrlUrls;
        private String name;

        public FileOrBinary getCert() {
            return this.cert;
        }

        public void setCert(FileOrBinary cert) {
            this.cert = cert;
        }

        public String getValidityMode() {
            return this.validityMode;
        }

        public void setValidityMode(String validityMode) {
            this.validityMode = validityMode;
        }

        public List<String> getCaIssuerUrls() {
            if (this.caIssuerUrls == null) {
                this.caIssuerUrls = new LinkedList<String>();
            }
            return this.caIssuerUrls;
        }

        public void setCaIssuerUrls(List<String> caIssuerUrls) {
            this.caIssuerUrls = caIssuerUrls;
        }

        public List<String> getOcspUrls() {
            if (this.ocspUrls == null) {
                this.ocspUrls = new LinkedList<String>();
            }
            return this.ocspUrls;
        }

        public void setOcspUrls(List<String> ocspUrls) {
            this.ocspUrls = ocspUrls;
        }

        public List<String> getCrlUrls() {
            if (this.crlUrls == null) {
                this.crlUrls = new LinkedList<String>();
            }
            return this.crlUrls;
        }

        public void setCrlUrls(List<String> crlUrls) {
            this.crlUrls = crlUrls;
        }

        public List<String> getDeltaCrlUrls() {
            if (this.deltaCrlUrls == null) {
                this.deltaCrlUrls = new LinkedList<String>();
            }
            return this.deltaCrlUrls;
        }

        public void setDeltaCrlUrls(List<String> deltaCrlUrls) {
            this.deltaCrlUrls = deltaCrlUrls;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void validate() throws InvalidConfException {
            Issuer.notNull((Object)this.cert, (String)"cert");
            Issuer.validate((ValidatableConf)this.cert);
            Issuer.notBlank((String)this.name, (String)"name");
        }
    }

    public static class Certprofile
    extends FileOrValue {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void validate() throws InvalidConfException {
            super.validate();
            Certprofile.notBlank((String)this.name, (String)"name");
        }
    }
}

