/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.qa.ca;

import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;

public class IssuerInfo {
    private final Set<String> caIssuerUrls;
    private final Set<String> ocspUrls;
    private final Set<String> crlUrls;
    private final Set<String> deltaCrlUrls;
    private final X509Cert cert;
    private final boolean cutoffNotAfter;

    public IssuerInfo(List<String> caIssuerUrls, List<String> ocspUrls, List<String> crlUrls, List<String> deltaCrlUrls, byte[] certBytes, boolean cutoffNotAfter) throws CertificateException {
        Args.notNull((Object)certBytes, (String)"certBytes");
        this.cutoffNotAfter = cutoffNotAfter;
        this.caIssuerUrls = CollectionUtil.isEmpty(caIssuerUrls) ? null : Collections.unmodifiableSet(new HashSet<String>(caIssuerUrls));
        this.ocspUrls = CollectionUtil.isEmpty(ocspUrls) ? null : Collections.unmodifiableSet(new HashSet<String>(ocspUrls));
        this.crlUrls = CollectionUtil.isEmpty(crlUrls) ? null : Collections.unmodifiableSet(new HashSet<String>(crlUrls));
        this.deltaCrlUrls = CollectionUtil.isEmpty(deltaCrlUrls) ? null : Collections.unmodifiableSet(new HashSet<String>(deltaCrlUrls));
        this.cert = X509Util.parseCert((byte[])certBytes);
    }

    public Set<String> getCaIssuerUrls() {
        return this.caIssuerUrls;
    }

    public Set<String> getOcspUrls() {
        return this.ocspUrls;
    }

    public Set<String> getCrlUrls() {
        return this.crlUrls;
    }

    public Set<String> getDeltaCrlUrls() {
        return this.deltaCrlUrls;
    }

    public X509Cert getCert() {
        return this.cert;
    }

    public byte[] getSubjectKeyIdentifier() {
        return this.cert.getSubjectKeyId();
    }

    public boolean isCutoffNotAfter() {
        return this.cutoffNotAfter;
    }

    public Date getCaNotBefore() {
        return this.cert.getNotBefore();
    }

    public Date getCaNotAfter() {
        return this.cert.getNotAfter();
    }
}

