/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.qa.ca.extn;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.DirectoryString;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.xipki.ca.api.BadCertTemplateException;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.certprofile.xijson.conf.ExtensionType;
import org.xipki.ca.certprofile.xijson.conf.ExtnSyntax;
import org.xipki.qa.ca.extn.QaExtensionValue;
import org.xipki.security.KeyUsage;
import org.xipki.util.CollectionUtil;
import org.xipki.util.Hex;
import org.xipki.util.InvalidConfException;

public class CheckerUtil {
    static void addIfNotIn(Set<ASN1ObjectIdentifier> set, ASN1ObjectIdentifier oid) {
        if (!set.contains(oid)) {
            set.add(oid);
        }
    }

    static Map<ASN1ObjectIdentifier, QaExtensionValue> buildConstantExtesions(Map<String, ExtensionType> extensions) throws CertprofileException {
        if (extensions == null) {
            return null;
        }
        HashMap<ASN1ObjectIdentifier, QaExtensionValue> map = new HashMap<ASN1ObjectIdentifier, QaExtensionValue>();
        for (Map.Entry<String, ExtensionType> entry : extensions.entrySet()) {
            byte[] encodedValue;
            ASN1ObjectIdentifier oid;
            String type = entry.getKey();
            ExtensionType extn = entry.getValue();
            if (extn.getConstant() == null || Extension.subjectAlternativeName.equals((ASN1Primitive)(oid = extn.getType().toXiOid())) || Extension.subjectInfoAccess.equals((ASN1Primitive)oid) || Extension.biometricInfo.equals((ASN1Primitive)oid)) continue;
            try {
                encodedValue = extn.getConstant().toASN1Encodable().toASN1Primitive().getEncoded();
            }
            catch (IOException | InvalidConfException ex) {
                throw new CertprofileException("could not parse the constant extension value of type" + type, ex);
            }
            QaExtensionValue extension = new QaExtensionValue(extn.isCritical(), encodedValue);
            map.put(oid, extension);
        }
        if (CollectionUtil.isEmpty(map)) {
            return null;
        }
        return Collections.unmodifiableMap(map);
    }

    static Map<ASN1ObjectIdentifier, ExtnSyntax> buildExtesionSyntaxes(Map<String, ExtensionType> extensions) throws CertprofileException {
        if (extensions == null) {
            return null;
        }
        HashMap<ASN1ObjectIdentifier, ExtnSyntax> map = new HashMap<ASN1ObjectIdentifier, ExtnSyntax>();
        for (Map.Entry<String, ExtensionType> entry : extensions.entrySet()) {
            ExtensionType extn = entry.getValue();
            if (extn.getSyntax() == null) continue;
            map.put(extn.getType().toXiOid(), extn.getSyntax());
        }
        if (CollectionUtil.isEmpty(map)) {
            return null;
        }
        return Collections.unmodifiableMap(map);
    }

    static ASN1Encodable readAsn1Encodable(byte[] encoded) throws CertprofileException {
        ASN1StreamParser parser = new ASN1StreamParser(encoded);
        try {
            return parser.readObject();
        }
        catch (IOException ex) {
            throw new CertprofileException("could not parse the constant extension value", (Throwable)ex);
        }
    }

    static String hex(byte[] bytes) {
        return Hex.encode((byte[])bytes);
    }

    static Set<String> strInBnotInA(Collection<String> collectionA, Collection<String> collectionB) {
        if (collectionB == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (String entry : collectionB) {
            if (collectionA != null && collectionA.contains(entry)) continue;
            result.add(entry);
        }
        return result;
    }

    static GeneralName createGeneralName(GeneralName reqName, Set<Certprofile.GeneralNameMode> modes) throws BadCertTemplateException {
        int tag = reqName.getTagNo();
        Certprofile.GeneralNameMode mode = null;
        if (modes != null) {
            for (Certprofile.GeneralNameMode m : modes) {
                if (m.getTag().getTag() != tag) continue;
                mode = m;
                break;
            }
            if (mode == null) {
                throw new BadCertTemplateException("generalName tag " + tag + " is not allowed");
            }
        }
        switch (tag) {
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                return new GeneralName(tag, reqName.getName());
            }
            case 0: {
                ASN1Sequence reqSeq = ASN1Sequence.getInstance((Object)reqName.getName());
                ASN1ObjectIdentifier type = ASN1ObjectIdentifier.getInstance((Object)reqSeq.getObjectAt(0));
                if (mode != null && !mode.getAllowedTypes().contains(type)) {
                    throw new BadCertTemplateException("otherName.type " + type.getId() + " is not allowed");
                }
                ASN1Primitive value = ASN1TaggedObject.getInstance((Object)reqSeq.getObjectAt(1)).getObject();
                if (!(value instanceof ASN1String)) {
                    throw new BadCertTemplateException("otherName.value is not a String");
                }
                String text = ((ASN1String)value).getString();
                ASN1EncodableVector vector = new ASN1EncodableVector();
                vector.add((ASN1Encodable)type);
                vector.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new DERUTF8String(text)));
                return new GeneralName(0, (ASN1Encodable)new DERSequence(vector));
            }
            case 5: {
                DirectoryString ds;
                ASN1Sequence reqSeq = ASN1Sequence.getInstance((Object)reqName.getName());
                int size = reqSeq.size();
                String nameAssigner = null;
                int idx = 0;
                if (size > 1) {
                    ds = DirectoryString.getInstance((Object)ASN1TaggedObject.getInstance((Object)reqSeq.getObjectAt(idx++)).getObject());
                    nameAssigner = ds.getString();
                }
                ds = DirectoryString.getInstance((Object)ASN1TaggedObject.getInstance((Object)reqSeq.getObjectAt(idx++)).getObject());
                String partyName = ds.getString();
                ASN1EncodableVector vector = new ASN1EncodableVector();
                if (nameAssigner != null) {
                    vector.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)new DirectoryString(nameAssigner)));
                }
                vector.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)new DirectoryString(partyName)));
                return new GeneralName(5, (ASN1Encodable)new DERSequence(vector));
            }
        }
        throw new IllegalStateException("should not reach here, unknown GeneralName tag " + tag);
    }

    static Set<String> getKeyUsage(byte[] extensionValue) {
        HashSet<String> usages = new HashSet<String>();
        org.bouncycastle.asn1.x509.KeyUsage reqKeyUsage = org.bouncycastle.asn1.x509.KeyUsage.getInstance((Object)extensionValue);
        for (KeyUsage k : KeyUsage.values()) {
            if (!reqKeyUsage.hasUsages(k.getBcUsage())) continue;
            usages.add(k.getName());
        }
        return usages;
    }

    static Set<String> getExtKeyUsage(byte[] extensionValue) {
        HashSet<String> usages = new HashSet<String>();
        ExtendedKeyUsage reqKeyUsage = ExtendedKeyUsage.getInstance((Object)extensionValue);
        for (KeyPurposeId usage : reqKeyUsage.getUsages()) {
            usages.add(usage.getId());
        }
        return usages;
    }

    static void checkAia(StringBuilder failureMsg, AuthorityInformationAccess aia, ASN1ObjectIdentifier accessMethod, Set<String> expectedUris) {
        String typeDesc = X509ObjectIdentifiers.id_ad_ocsp.equals((ASN1Primitive)accessMethod) ? "OCSP" : (X509ObjectIdentifiers.id_ad_caIssuers.equals((ASN1Primitive)accessMethod) ? "caIssuer" : accessMethod.getId());
        LinkedList<AccessDescription> isAccessDescriptions = new LinkedList<AccessDescription>();
        for (AccessDescription accessDescription : aia.getAccessDescriptions()) {
            if (!accessMethod.equals((ASN1Primitive)accessDescription.getAccessMethod())) continue;
            isAccessDescriptions.add(accessDescription);
        }
        int size = isAccessDescriptions.size();
        if (size != expectedUris.size()) {
            CheckerUtil.addViolation(failureMsg, "number of AIA " + typeDesc + " URIs", size, expectedUris.size());
            return;
        }
        HashSet<String> isUris = new HashSet<String>();
        for (int i = 0; i < size; ++i) {
            GeneralName isAccessLocation = ((AccessDescription)isAccessDescriptions.get(i)).getAccessLocation();
            if (isAccessLocation.getTagNo() != 6) {
                CheckerUtil.addViolation(failureMsg, "tag of accessLocation of AIA ", isAccessLocation.getTagNo(), 6);
                continue;
            }
            String isOcspUri = ((ASN1String)isAccessLocation.getName()).getString();
            isUris.add(isOcspUri);
        }
        Set<String> diffs = CheckerUtil.strInBnotInA(expectedUris, isUris);
        if (CollectionUtil.isNotEmpty(diffs)) {
            failureMsg.append(typeDesc).append(" URIs ").append(diffs);
            failureMsg.append(" are present but not expected; ");
        }
        if (CollectionUtil.isNotEmpty(diffs = CheckerUtil.strInBnotInA(isUris, expectedUris))) {
            failureMsg.append(typeDesc).append(" URIs ").append(diffs);
            failureMsg.append(" are absent but are required; ");
        }
    }

    static void addViolation(StringBuilder failureMsg, String field, Object is, Object expected) {
        failureMsg.append(field).append(" is '").append(is).append("' but expected '").append(expected).append("';");
    }
}

