/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.qa.ca;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.asn1.x509.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.certprofile.xijson.XijsonCertprofile;
import org.xipki.ca.certprofile.xijson.conf.ExtensionType;
import org.xipki.ca.certprofile.xijson.conf.X509ProfileType;
import org.xipki.qa.ValidationIssue;
import org.xipki.qa.ValidationResult;
import org.xipki.qa.ca.ExtensionsChecker;
import org.xipki.qa.ca.IssuerInfo;
import org.xipki.qa.ca.PublicKeyChecker;
import org.xipki.qa.ca.QaExtensionValue;
import org.xipki.qa.ca.SubjectChecker;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.InvalidConfException;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.Validity;

public class CertprofileQa {
    private static final Logger LOG = LoggerFactory.getLogger(CertprofileQa.class);
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final long SECOND = 1000L;
    private static final long MAX_CERT_TIME_MS = 253402300799982L;
    private static final long EPOCHTIME_2050010100 = 2524608000L;
    private final SubjectChecker subjectChecker;
    private final PublicKeyChecker publicKeyChecker;
    private final ExtensionsChecker extensionsChecker;
    private final XijsonCertprofile certprofile;

    public CertprofileQa(String data) throws CertprofileException {
        this(StringUtil.toUtf8Bytes((String)((String)Args.notNull((Object)data, (String)"data"))));
    }

    public CertprofileQa(byte[] dataBytes) throws CertprofileException {
        Args.notNull((Object)dataBytes, (String)"dataBytes");
        try {
            X509ProfileType conf = X509ProfileType.parse((InputStream)new ByteArrayInputStream(dataBytes));
            this.certprofile = new XijsonCertprofile();
            this.certprofile.initialize(conf);
            this.publicKeyChecker = new PublicKeyChecker(this.certprofile.getKeyAlgorithms());
            this.subjectChecker = new SubjectChecker(this.certprofile.getSubjectControl());
            this.extensionsChecker = new ExtensionsChecker(conf, this.certprofile);
        }
        catch (RuntimeException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex);
            throw new CertprofileException("RuntimeException thrown while initializing certprofile: " + ex.getMessage());
        }
    }

    public ValidationResult checkCert(byte[] certBytes, IssuerInfo issuerInfo, X500Name requestedSubject, SubjectPublicKeyInfo requestedPublicKey, Extensions requestedExtensions) {
        X509Certificate cert;
        TBSCertificate tbsCert;
        Certificate bcCert;
        int size;
        Args.notNull((Object)certBytes, (String)"certBytes");
        Args.notNull((Object)issuerInfo, (String)"issuerInfo");
        Args.notNull((Object)requestedSubject, (String)"requestedSubject");
        Args.notNull((Object)requestedPublicKey, (String)"requestedPublicKey");
        LinkedList<ValidationIssue> resultIssues = new LinkedList<ValidationIssue>();
        ValidationIssue issue = new ValidationIssue("X509.SIZE", "certificate size");
        resultIssues.add(issue);
        certBytes = X509Util.toDerEncoded((byte[])certBytes);
        Integer maxSize = this.certprofile.getMaxSize();
        if (maxSize != 0 && (size = certBytes.length) > maxSize) {
            issue.setFailureMessage(String.format("certificate exceeds the maximal allowed size: %d > %d", size, maxSize));
        }
        issue = new ValidationIssue("X509.ENCODING", "certificate encoding");
        resultIssues.add(issue);
        try {
            bcCert = Certificate.getInstance((Object)certBytes);
            tbsCert = bcCert.getTBSCertificate();
            cert = X509Util.parseCert((byte[])certBytes);
        }
        catch (CertificateException ex) {
            issue.setFailureMessage("certificate is not corrected encoded");
            return new ValidationResult(resultIssues);
        }
        issue = new ValidationIssue("X509.VERSION", "certificate version");
        resultIssues.add(issue);
        int versionNumber = tbsCert.getVersionNumber();
        Certprofile.X509CertVersion expVersion = this.certprofile.getVersion();
        if (versionNumber != expVersion.getVersionNumber()) {
            issue.setFailureMessage("is '" + versionNumber + "' but expected '" + expVersion.getVersionNumber() + "'");
        }
        issue = new ValidationIssue("X509.serialNumber", "certificate serial number");
        resultIssues.add(issue);
        BigInteger serialNumber = tbsCert.getSerialNumber().getValue();
        if (serialNumber.signum() != 1) {
            issue.setFailureMessage("not positive");
        } else if (serialNumber.bitLength() >= 160) {
            issue.setFailureMessage("serial number has more than 20 octets");
        }
        List signatureAlgorithms = this.certprofile.getSignatureAlgorithms();
        if (CollectionUtil.isNotEmpty((Collection)signatureAlgorithms)) {
            issue = new ValidationIssue("X509.SIGALG", "signature algorithm");
            resultIssues.add(issue);
            AlgorithmIdentifier sigAlgId = bcCert.getSignatureAlgorithm();
            AlgorithmIdentifier tbsSigAlgId = tbsCert.getSignature();
            if (!tbsSigAlgId.equals((Object)sigAlgId)) {
                issue.setFailureMessage("Certificate.tbsCertificate.signature != Certificate.signatureAlgorithm");
            }
            try {
                AlgorithmIdentifier expSigAlgId;
                String sigAlgo = AlgorithmUtil.getSignatureAlgoName((AlgorithmIdentifier)sigAlgId);
                if (!issue.isFailed() && !signatureAlgorithms.contains(sigAlgo)) {
                    issue.setFailureMessage("signatureAlgorithm '" + sigAlgo + "' is not allowed");
                }
                if (!issue.isFailed() && !(expSigAlgId = AlgorithmUtil.getSigAlgId((String)sigAlgo)).equals((Object)sigAlgId)) {
                    issue.setFailureMessage("invalid parameters");
                }
            }
            catch (NoSuchAlgorithmException ex) {
                issue.setFailureMessage("unsupported signature algorithm " + sigAlgId.getAlgorithm().getId());
            }
        }
        issue = new ValidationIssue("X509.NOTBEFORE.ENCODING", "notBefore encoding");
        CertprofileQa.checkTime(tbsCert.getStartDate(), issue);
        issue = new ValidationIssue("X509.NOTAFTER.ENCODING", "notAfter encoding");
        CertprofileQa.checkTime(tbsCert.getStartDate(), issue);
        if (this.certprofile.getNotBeforeOption().getMidNightTimeZone() != null) {
            issue = new ValidationIssue("X509.NOTBEFORE", "notBefore midnight");
            resultIssues.add(issue);
            Calendar cal = Calendar.getInstance(UTC);
            cal.setTime(cert.getNotBefore());
            int minute = cal.get(12);
            int second = cal.get(13);
            if (minute != 0 || second != 0) {
                issue.setFailureMessage(" '" + cert.getNotBefore() + "' is not midnight time");
            }
        }
        issue = new ValidationIssue("X509.VALIDITY", "cert validity");
        resultIssues.add(issue);
        if (cert.getNotAfter().before(cert.getNotBefore())) {
            issue.setFailureMessage("notAfter may not be before notBefore");
        } else if (cert.getNotBefore().before(issuerInfo.getCaNotBefore())) {
            issue.setFailureMessage("notBefore may not be before CA's notBefore");
        } else {
            Validity validity = this.certprofile.getValidity();
            Date expectedNotAfter = validity.add(cert.getNotBefore());
            if (expectedNotAfter.getTime() > 253402300799982L) {
                expectedNotAfter = new Date(253402300799982L);
            }
            if (issuerInfo.isCutoffNotAfter() && expectedNotAfter.after(issuerInfo.getCaNotAfter())) {
                expectedNotAfter = issuerInfo.getCaNotAfter();
            }
            if (Math.abs(expectedNotAfter.getTime() - cert.getNotAfter().getTime()) > 60000L) {
                issue.setFailureMessage("cert validity is not within " + validity.toString());
            }
        }
        resultIssues.addAll(this.publicKeyChecker.checkPublicKey(bcCert.getSubjectPublicKeyInfo(), requestedPublicKey));
        issue = new ValidationIssue("X509.SIG", "whether certificate is signed by CA");
        resultIssues.add(issue);
        try {
            cert.verify(issuerInfo.getCert().getPublicKey(), "BC");
        }
        catch (Exception ex) {
            issue.setFailureMessage("invalid signature");
        }
        issue = new ValidationIssue("X509.ISSUER", "certificate issuer");
        resultIssues.add(issue);
        if (!cert.getIssuerX500Principal().equals(issuerInfo.getCert().getSubjectX500Principal())) {
            issue.setFailureMessage("issue in certificate does not equal the subject of CA certificate");
        }
        resultIssues.addAll(this.subjectChecker.checkSubject(bcCert.getSubject(), requestedSubject));
        issue = new ValidationIssue("X509.IssuerUniqueID", "issuerUniqueID");
        resultIssues.add(issue);
        if (tbsCert.getIssuerUniqueId() != null) {
            issue.setFailureMessage("is present but not permitted");
        }
        issue = new ValidationIssue("X509.SubjectUniqueID", "subjectUniqueID");
        resultIssues.add(issue);
        if (tbsCert.getSubjectUniqueId() != null) {
            issue.setFailureMessage("is present but not permitted");
        }
        issue = new ValidationIssue("X509.GrantedSubject", "grantedSubject");
        resultIssues.add(issue);
        resultIssues.addAll(this.extensionsChecker.checkExtensions(bcCert, issuerInfo, requestedExtensions, requestedSubject));
        return new ValidationResult(resultIssues);
    }

    public static Map<ASN1ObjectIdentifier, QaExtensionValue> buildConstantExtesions(Map<String, ExtensionType> extensionsType) throws CertprofileException {
        if (extensionsType == null) {
            return null;
        }
        HashMap<ASN1ObjectIdentifier, QaExtensionValue> map = new HashMap<ASN1ObjectIdentifier, QaExtensionValue>();
        for (String type : extensionsType.keySet()) {
            byte[] encodedValue;
            ASN1ObjectIdentifier oid;
            ExtensionType extn = extensionsType.get(type);
            if (extn.getConstant() == null || Extension.subjectAlternativeName.equals((Object)(oid = new ASN1ObjectIdentifier(type))) || Extension.subjectInfoAccess.equals((Object)oid) || Extension.biometricInfo.equals((Object)oid)) continue;
            try {
                encodedValue = extn.getConstant().toASN1Encodable().toASN1Primitive().getEncoded();
            }
            catch (IOException | InvalidConfException ex) {
                throw new CertprofileException("could not parse the constant extension value of type" + type, ex);
            }
            QaExtensionValue extension = new QaExtensionValue(extn.isCritical(), encodedValue);
            map.put(oid, extension);
        }
        if (CollectionUtil.isEmpty(map)) {
            return null;
        }
        return Collections.unmodifiableMap(map);
    }

    private static void checkTime(Time time, ValidationIssue issue) {
        ASN1Primitive asn1Time = time.toASN1Primitive();
        if (time.getDate().getTime() / 1000L < 2524608000L) {
            if (!(asn1Time instanceof ASN1UTCTime)) {
                issue.setFailureMessage("not encoded as UTCTime");
            }
        } else if (!(asn1Time instanceof ASN1GeneralizedTime)) {
            issue.setFailureMessage("not encoded as GeneralizedTime");
        }
    }
}

