/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.qa.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.EdECConstants;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignerConf;
import org.xipki.security.pkcs12.KeystoreGenerationParameters;
import org.xipki.security.pkcs12.P12KeyGenerationResult;
import org.xipki.security.pkcs12.P12KeyGenerator;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.BenchmarkExecutor;
import org.xipki.util.ConfPairs;
import org.xipki.util.IoUtil;

public abstract class P12SignSpeed
extends BenchmarkExecutor {
    protected static final String PASSWORD = "1234";
    private static Logger LOG = LoggerFactory.getLogger(P12SignSpeed.class);
    private final ConcurrentContentSigner signer;

    public P12SignSpeed(SecurityFactory securityFactory, String signatureAlgorithm, byte[] keystore, String description, int threads) throws Exception {
        this("PKCS12", securityFactory, signatureAlgorithm, keystore, description, threads);
    }

    public P12SignSpeed(String tokenType, SecurityFactory securityFactory, String signatureAlgorithm, byte[] keystore, String description, int threads) throws Exception {
        super(description);
        Args.notNull((Object)securityFactory, (String)"securityFactory");
        Args.notBlank((String)signatureAlgorithm, (String)"signatureAlgorithm");
        Args.notNull((Object)keystore, (String)"keystore");
        SignerConf signerConf = P12SignSpeed.getKeystoreSignerConf(new ByteArrayInputStream(keystore), PASSWORD, signatureAlgorithm, threads + Math.max(2, threads * 5 / 4));
        this.signer = securityFactory.createSigner(tokenType, signerConf, (X509Certificate)null);
    }

    protected Runnable getTestor() throws Exception {
        return new Testor();
    }

    protected static byte[] getPrecomputedRSAKeystore(int keysize, BigInteger publicExponent) throws IOException {
        return P12SignSpeed.getPrecomputedKeystore("rsa-" + keysize + "-0x" + publicExponent.toString(16) + ".p12");
    }

    protected static byte[] getPrecomputedDSAKeystore(int plength, int qlength) throws IOException {
        return P12SignSpeed.getPrecomputedKeystore("dsa-" + plength + "-" + qlength + ".p12");
    }

    protected static byte[] getPrecomputedECKeystore(ASN1ObjectIdentifier curveOid) throws IOException {
        return P12SignSpeed.getPrecomputedKeystore("ec-" + curveOid.getId() + ".p12");
    }

    private static byte[] getPrecomputedKeystore(String filename) throws IOException {
        InputStream in = P12SignSpeed.class.getResourceAsStream("/testkeys/" + filename);
        return in == null ? null : IoUtil.read((InputStream)in);
    }

    private static SignerConf getKeystoreSignerConf(InputStream keystoreStream, String password, String signatureAlgorithm, int parallelism) throws IOException {
        ConfPairs conf = new ConfPairs("password", password);
        conf.putPair("algo", signatureAlgorithm);
        conf.putPair("parallelism", Integer.toString(parallelism));
        conf.putPair("keystore", "base64:" + Base64.encodeToString((byte[])IoUtil.read((InputStream)keystoreStream)));
        return new SignerConf(conf.getEncoded());
    }

    class Testor
    implements Runnable {
        private static final int batch = 16;
        private final byte[][] data = new byte[16][16];

        public Testor() {
            for (int i = 0; i < this.data.length; ++i) {
                new SecureRandom().nextBytes(this.data[i]);
            }
        }

        @Override
        public void run() {
            while (!P12SignSpeed.this.stop() && P12SignSpeed.this.getErrorAccout() < 1L) {
                try {
                    P12SignSpeed.this.signer.sign(this.data);
                    P12SignSpeed.this.account(16, 0);
                }
                catch (Exception ex) {
                    LOG.error("P12SignSpeed.Testor.run()", (Throwable)ex);
                    P12SignSpeed.this.account(16, 16);
                }
            }
        }
    }

    public static class SM2
    extends P12SignSpeed {
        public SM2(SecurityFactory securityFactory, int threads) throws Exception {
            super(securityFactory, "SM3WITHSM2", SM2.generateKeystore(GMObjectIdentifiers.sm2p256v1), "PKCS#12 SM2 signature creation", threads);
        }

        private static byte[] generateKeystore(ASN1ObjectIdentifier curveNOid) throws Exception {
            byte[] keystoreBytes = SM2.getPrecomputedECKeystore(curveNOid);
            if (keystoreBytes == null) {
                KeystoreGenerationParameters params = new KeystoreGenerationParameters(P12SignSpeed.PASSWORD.toCharArray());
                params.setRandom(new SecureRandom());
                P12KeyGenerationResult identity = new P12KeyGenerator().generateECKeypair(curveNOid, params, null);
                keystoreBytes = identity.keystore();
            }
            return keystoreBytes;
        }
    }

    public static class RSA
    extends P12SignSpeed {
        public RSA(SecurityFactory securityFactory, String signatureAlgorithm, int threads, int keysize, BigInteger publicExponent) throws Exception {
            super(securityFactory, signatureAlgorithm, RSA.generateKeystore(keysize, publicExponent), "PKCS#12 RSA signature creation\nkeysize: " + keysize + "\npublic exponent: " + publicExponent, threads);
        }

        private static byte[] generateKeystore(int keysize, BigInteger publicExponent) throws Exception {
            byte[] keystoreBytes = RSA.getPrecomputedRSAKeystore(keysize, publicExponent);
            if (keystoreBytes == null) {
                KeystoreGenerationParameters params = new KeystoreGenerationParameters(P12SignSpeed.PASSWORD.toCharArray());
                params.setRandom(new SecureRandom());
                P12KeyGenerationResult identity = new P12KeyGenerator().generateRSAKeypair(keysize, publicExponent, params, null);
                keystoreBytes = identity.keystore();
            }
            return keystoreBytes;
        }
    }

    public static class HMAC
    extends P12SignSpeed {
        public HMAC(SecurityFactory securityFactory, String signatureAlgorithm, int threads) throws Exception {
            super("JCEKS", securityFactory, signatureAlgorithm, HMAC.generateKeystore(signatureAlgorithm), "JCEKS HMAC signature creation", threads);
        }

        private static byte[] generateKeystore(String signatureAlgorithm) throws Exception {
            int keysize = HMAC.getKeysize(signatureAlgorithm);
            P12KeyGenerationResult identity = new P12KeyGenerator().generateSecretKey("GENERIC", keysize, new KeystoreGenerationParameters(P12SignSpeed.PASSWORD.toCharArray()));
            return identity.keystore();
        }

        private static int getKeysize(String hmacAlgorithm) {
            int keysize;
            if ("HMACSHA1".equals(hmacAlgorithm = hmacAlgorithm.toUpperCase())) {
                keysize = 160;
            } else if ("HMACSHA224".equals(hmacAlgorithm) || "HMACSHA3-224".equals(hmacAlgorithm)) {
                keysize = 224;
            } else if ("HMACSHA256".equals(hmacAlgorithm) || "HMACSHA3-256".equals(hmacAlgorithm)) {
                keysize = 256;
            } else if ("HMACSHA384".equals(hmacAlgorithm) || "HMACSHA3-384".equals(hmacAlgorithm)) {
                keysize = 384;
            } else if ("HMACSHA512".equals(hmacAlgorithm) || "HMACSHA3-512".equals(hmacAlgorithm)) {
                keysize = 512;
            } else {
                throw new IllegalArgumentException("unknown HMAC algorithm " + hmacAlgorithm);
            }
            return keysize;
        }
    }

    public static class EC
    extends P12SignSpeed {
        public EC(SecurityFactory securityFactory, String signatureAlgorithm, int threads, ASN1ObjectIdentifier curveOid) throws Exception {
            super(securityFactory, signatureAlgorithm, EC.generateKeystore(curveOid), "PKCS#12 EC signature creation\ncurve: " + curveOid.getId(), threads);
        }

        private static byte[] generateKeystore(ASN1ObjectIdentifier curveOid) throws Exception {
            byte[] keystoreBytes = EC.getPrecomputedECKeystore(curveOid);
            if (keystoreBytes == null) {
                KeystoreGenerationParameters params = new KeystoreGenerationParameters(P12SignSpeed.PASSWORD.toCharArray());
                params.setRandom(new SecureRandom());
                P12KeyGenerationResult identity = EdECConstants.isEdwardsOrMontgomeryCurve((ASN1ObjectIdentifier)curveOid) ? new P12KeyGenerator().generateEdECKeypair(curveOid, params, null) : new P12KeyGenerator().generateECKeypair(curveOid, params, null);
                keystoreBytes = identity.keystore();
            }
            return keystoreBytes;
        }
    }

    public static class DSA
    extends P12SignSpeed {
        public DSA(SecurityFactory securityFactory, String signatureAlgorithm, int threads, int plength, int qlength) throws Exception {
            super(securityFactory, signatureAlgorithm, DSA.generateKeystore(plength, qlength), "PKCS#12 DSA signature creation\nplength: " + plength + "\nqlength: " + qlength, threads);
        }

        private static byte[] generateKeystore(int plength, int qlength) throws Exception {
            byte[] keystoreBytes = DSA.getPrecomputedDSAKeystore(plength, qlength);
            if (keystoreBytes == null) {
                KeystoreGenerationParameters params = new KeystoreGenerationParameters(P12SignSpeed.PASSWORD.toCharArray());
                params.setRandom(new SecureRandom());
                P12KeyGenerationResult identity = new P12KeyGenerator().generateDSAKeypair(plength, qlength, params, null);
                keystoreBytes = identity.keystore();
            }
            return keystoreBytes;
        }
    }

    public static class AESGmac
    extends P12SignSpeed {
        public AESGmac(SecurityFactory securityFactory, String signatureAlgorithm, int threads) throws Exception {
            super("JCEKS", securityFactory, signatureAlgorithm, AESGmac.generateKeystore(signatureAlgorithm), "JCEKS AES-GMAC signature creation", threads);
        }

        private static byte[] generateKeystore(String signatureAlgorithm) throws Exception {
            int keysize = AESGmac.getKeysize(signatureAlgorithm);
            P12KeyGenerationResult identity = new P12KeyGenerator().generateSecretKey("AES", keysize, new KeystoreGenerationParameters(P12SignSpeed.PASSWORD.toCharArray()));
            return identity.keystore();
        }

        public static int getKeysize(String hmacAlgorithm) {
            int keysize;
            if ("AES128-GMAC".equals(hmacAlgorithm = hmacAlgorithm.toUpperCase())) {
                keysize = 128;
            } else if ("AES192-GMAC".equals(hmacAlgorithm)) {
                keysize = 192;
            } else if ("AES256-GMAC".equals(hmacAlgorithm)) {
                keysize = 256;
            } else {
                throw new IllegalArgumentException("unknown GMAC algorithm " + hmacAlgorithm);
            }
            return keysize;
        }
    }
}

