/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.qa.ca;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.xipki.qa.ca.CaEnrollBenchKeyEntry;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;

public class CaEnrollBenchEntry {
    private final String certprofile;
    private final CaEnrollBenchKeyEntry keyEntry;
    private final IncreasableSubject subject;

    public CaEnrollBenchEntry(String certprofile, CaEnrollBenchKeyEntry keyEntry, String subjectTemplate, RandomDn randomDn) {
        this.certprofile = Args.notBlank((String)certprofile, (String)"certprofile");
        this.keyEntry = (CaEnrollBenchKeyEntry)Args.notNull((Object)keyEntry, (String)"keyEntry");
        this.subject = new IncreasableSubject(subjectTemplate, randomDn);
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.keyEntry.getSubjectPublicKeyInfo();
    }

    public X500Name getX500Name(long index) {
        return this.subject.getX500Name(index);
    }

    public String getCertprofile() {
        return this.certprofile;
    }

    private static class IncreasableSubject {
        private final X500Name subjectTemplate;
        private final ASN1ObjectIdentifier subjectRdnForIncrement;

        private IncreasableSubject(String subjectTemplate, RandomDn randomDn) {
            Args.notBlank((String)subjectTemplate, (String)"subjectTemplate");
            Args.notNull((Object)((Object)randomDn), (String)"randomDn");
            this.subjectTemplate = new X500Name(subjectTemplate);
            switch (randomDn) {
                case GIVENNAME: {
                    this.subjectRdnForIncrement = ObjectIdentifiers.DN.givenName;
                    break;
                }
                case SURNAME: {
                    this.subjectRdnForIncrement = ObjectIdentifiers.DN.surname;
                    break;
                }
                case STREET: {
                    this.subjectRdnForIncrement = ObjectIdentifiers.DN.street;
                    break;
                }
                case POSTALCODE: {
                    this.subjectRdnForIncrement = ObjectIdentifiers.DN.postalCode;
                    break;
                }
                case O: {
                    this.subjectRdnForIncrement = ObjectIdentifiers.DN.O;
                    break;
                }
                case OU: {
                    this.subjectRdnForIncrement = ObjectIdentifiers.DN.OU;
                    break;
                }
                case CN: {
                    this.subjectRdnForIncrement = ObjectIdentifiers.DN.CN;
                    break;
                }
                default: {
                    throw new IllegalStateException("should not reach here, unknown randomDn " + (Object)((Object)randomDn));
                }
            }
            if (this.subjectRdnForIncrement != null && this.subjectTemplate.getRDNs(this.subjectRdnForIncrement).length == 0) {
                throw new IllegalArgumentException("subjectTemplate does not contain DN field " + ObjectIdentifiers.oidToDisplayName((ASN1ObjectIdentifier)this.subjectRdnForIncrement));
            }
        }

        private X500Name getX500Name(long index) {
            RDN[] baseRdns = this.subjectTemplate.getRDNs();
            int n = baseRdns.length;
            RDN[] newRdns = new RDN[n];
            boolean incremented = false;
            for (int i = 0; i < n; ++i) {
                RDN rdn = baseRdns[i];
                if (!incremented && rdn.getFirst().getType().equals((ASN1Primitive)this.subjectRdnForIncrement)) {
                    String text = X509Util.rdnValueToString((ASN1Encodable)rdn.getFirst().getValue());
                    rdn = new RDN(this.subjectRdnForIncrement, (ASN1Encodable)new DERUTF8String(text + index));
                    incremented = true;
                }
                newRdns[i] = rdn;
            }
            return new X500Name(newRdns);
        }
    }

    public static enum RandomDn {
        GIVENNAME,
        SURNAME,
        STREET,
        POSTALCODE,
        O,
        OU,
        CN;


        public static RandomDn getInstance(String text) {
            Args.notNull((Object)text, (String)"text");
            for (RandomDn value : RandomDn.values()) {
                if (!value.name().equalsIgnoreCase(text)) continue;
                return value;
            }
            return null;
        }
    }
}

