/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.qa.ca;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cmp.CMPObjectIdentifiers;
import org.bouncycastle.asn1.cmp.CertRepMessage;
import org.bouncycastle.asn1.cmp.CertResponse;
import org.bouncycastle.asn1.cmp.ErrorMsgContent;
import org.bouncycastle.asn1.cmp.InfoTypeAndValue;
import org.bouncycastle.asn1.cmp.PKIBody;
import org.bouncycastle.asn1.cmp.PKIHeaderBuilder;
import org.bouncycastle.asn1.cmp.PKIMessage;
import org.bouncycastle.asn1.cmp.PKIStatusInfo;
import org.bouncycastle.asn1.crmf.AttributeTypeAndValue;
import org.bouncycastle.asn1.crmf.CertReqMessages;
import org.bouncycastle.asn1.crmf.CertReqMsg;
import org.bouncycastle.asn1.crmf.CertRequest;
import org.bouncycastle.asn1.crmf.CertTemplate;
import org.bouncycastle.asn1.crmf.CertTemplateBuilder;
import org.bouncycastle.asn1.crmf.ProofOfPossession;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.qa.BenchmarkHttpClient;
import org.xipki.qa.ca.CaEnrollBenchEntry;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.BenchmarkExecutor;
import org.xipki.util.InvalidConfException;
import org.xipki.util.ValidatableConf;

public class CaEnrollBenchmark
extends BenchmarkExecutor
implements BenchmarkHttpClient.ResponseHandler {
    private static final String CONf_FILE = "xipki/ca-qa/qa-benchmark-conf.json";
    private static final String REQUEST_MIMETYPE = "application/pkixcmp";
    private static final String RESPONSE_MIMETYPE = "application/pkixcmp";
    private static final ProofOfPossession RA_VERIFIED = new ProofOfPossession();
    private static final InfoTypeAndValue IMPLICIT_CONFIRM = new InfoTypeAndValue(CMPObjectIdentifiers.it_implicitConfirm, (ASN1Encodable)DERNull.INSTANCE);
    private static final Logger LOG = LoggerFactory.getLogger(CaEnrollBenchmark.class);
    private final CaEnrollBenchEntry benchmarkEntry;
    private final AtomicLong index;
    private final SecureRandom random = new SecureRandom();
    private final int num;
    private final int queueSize;
    private final AtomicInteger processedRequests = new AtomicInteger(0);
    private final Conf conf;
    private final String caHost;
    private final int caPort;
    private final int maxRequests;
    private final SslContext sslContext;

    public CaEnrollBenchmark(CaEnrollBenchEntry benchmarkEntry, int maxRequests, int num, int queueSize, String description) throws IOException, InvalidConfException {
        super(description);
        this.maxRequests = maxRequests;
        this.num = Args.positive((int)num, (String)"num");
        this.benchmarkEntry = (CaEnrollBenchEntry)Args.notNull((Object)benchmarkEntry, (String)"benchmarkEntry");
        this.index = new AtomicLong(CaEnrollBenchmark.getSecureIndex());
        this.queueSize = queueSize;
        try (InputStream is = Files.newInputStream(Paths.get(CONf_FILE, new String[0]), new OpenOption[0]);){
            URI uri;
            Conf tmpConf = (Conf)((Object)JSON.parseObject((InputStream)is, Conf.class, (Feature[])new Feature[0]));
            tmpConf.validate();
            this.conf = tmpConf;
            try {
                this.sslContext = tmpConf.getSsl().buildSslContext();
            }
            catch (GeneralSecurityException ex) {
                throw new InvalidConfException(ex.getMessage(), (Throwable)ex);
            }
            try {
                uri = new URI(this.conf.getCaUrl());
            }
            catch (URISyntaxException ex) {
                throw new InvalidConfException(ex.getMessage(), (Throwable)ex);
            }
            int port = uri.getPort();
            if (port == -1) {
                port = uri.getScheme().equalsIgnoreCase("https") ? 443 : 80;
            }
            this.caHost = uri.getHost();
            this.caPort = port;
        }
    }

    protected Runnable getTestor() throws Exception {
        return new Testor();
    }

    protected long getRealAccount(long account) {
        return (long)this.num * account;
    }

    public PKIMessage nextCertRequest() throws IOException, CertificateException {
        int num;
        if (this.maxRequests > 0 && (num = this.processedRequests.getAndAdd(1)) >= this.maxRequests) {
            return null;
        }
        CertReqMsg[] certReqMsgs = new CertReqMsg[this.num];
        for (int i = 0; i < this.num; ++i) {
            CertTemplateBuilder certTempBuilder = new CertTemplateBuilder();
            long thisIndex = this.index.getAndIncrement();
            certTempBuilder.setSubject(this.benchmarkEntry.getX500Name(thisIndex));
            SubjectPublicKeyInfo spki = this.benchmarkEntry.getSubjectPublicKeyInfo();
            certTempBuilder.setPublicKey(spki);
            CertTemplate certTemplate = certTempBuilder.build();
            CertRequest certRequest = new CertRequest(new ASN1Integer((long)(i + 1)), certTemplate, null);
            String utf8pairs = "certprofile?" + this.benchmarkEntry.getCertprofile() + "%";
            AttributeTypeAndValue certprofileInfo = new AttributeTypeAndValue(CMPObjectIdentifiers.regInfo_utf8Pairs, (ASN1Encodable)new DERUTF8String(utf8pairs));
            AttributeTypeAndValue[] atvs = new AttributeTypeAndValue[]{certprofileInfo};
            certReqMsgs[i] = new CertReqMsg(certRequest, RA_VERIFIED, atvs);
        }
        PKIHeaderBuilder builder = new PKIHeaderBuilder(2, this.conf.requestor(), this.conf.responder());
        builder.setMessageTime(new ASN1GeneralizedTime(new Date()));
        builder.setTransactionID(this.randomBytes(8));
        builder.setSenderNonce(this.randomBytes(8));
        builder.setGeneralInfo(IMPLICIT_CONFIRM);
        PKIBody body = new PKIBody(2, (ASN1Encodable)new CertReqMessages(certReqMsgs));
        return new PKIMessage(builder.build(), body);
    }

    @Override
    public void onComplete(FullHttpResponse response) {
        boolean success;
        try {
            success = this.onComplete0(response);
        }
        catch (Throwable th) {
            LOG.warn("unexpected exception", th);
            success = false;
        }
        this.account(1L, success ? 0L : 1L);
    }

    private boolean onComplete0(FullHttpResponse response) {
        if (response == null) {
            LOG.warn("bad response: response is null");
            return false;
        }
        if (response.decoderResult().isFailure()) {
            LOG.warn("failed: {}", (Object)response.decoderResult());
            return false;
        }
        if (response.status().code() != HttpResponseStatus.OK.code()) {
            LOG.warn("bad response: {}", (Object)response.status());
            return false;
        }
        String responseContentType = response.headers().get("Content-Type");
        if (responseContentType == null) {
            LOG.warn("bad response: mandatory Content-Type not specified");
            return false;
        }
        if (!responseContentType.equalsIgnoreCase("application/pkixcmp")) {
            LOG.warn("bad response: Content-Type {} unsupported", (Object)responseContentType);
            return false;
        }
        ByteBuf buf = response.content();
        if (buf == null || buf.readableBytes() == 0) {
            LOG.warn("no body in response");
            return false;
        }
        byte[] respBytes = new byte[buf.readableBytes()];
        buf.getBytes(buf.readerIndex(), respBytes);
        PKIMessage cmpResponse = PKIMessage.getInstance((Object)respBytes);
        try {
            this.parseEnrollCertResult(cmpResponse, 3, this.num);
            return true;
        }
        catch (Throwable th) {
            LOG.warn("exception while parsing response", th);
            return false;
        }
    }

    private void parseEnrollCertResult(PKIMessage response, int resonseBodyType, int numCerts) throws Exception {
        PKIBody respBody = response.getBody();
        int bodyType = respBody.getType();
        if (23 == bodyType) {
            ErrorMsgContent content = ErrorMsgContent.getInstance((Object)respBody.getContent());
            throw new Exception("Server returned PKIStatus: " + CaEnrollBenchmark.buildText(content.getPKIStatusInfo()));
        }
        if (resonseBodyType != bodyType) {
            throw new Exception(String.format("unknown PKI body type %s instead the expected [%s, %s]", bodyType, resonseBodyType, 23));
        }
        CertRepMessage certRep = CertRepMessage.getInstance((Object)respBody.getContent());
        CertResponse[] certResponses = certRep.getResponse();
        if (certResponses.length != numCerts) {
            throw new Exception("expected " + numCerts + " CertResponse, but returned " + certResponses.length);
        }
        for (int i = 0; i < numCerts; ++i) {
            CertResponse certResp = certResponses[i];
            PKIStatusInfo statusInfo = certResp.getStatus();
            int status = statusInfo.getStatus().intValue();
            BigInteger certReqId = certResp.getCertReqId().getValue();
            if (status == 0 || status == 1) continue;
            throw new Exception("CertReqId " + certReqId + ": server returned PKIStatus: " + CaEnrollBenchmark.buildText(statusInfo));
        }
    }

    @Override
    public void onError() {
        this.account(1L, 1L);
    }

    private byte[] randomBytes(int size) {
        byte[] bytes = new byte[size];
        this.random.nextBytes(bytes);
        return bytes;
    }

    private static String buildText(PKIStatusInfo pkiStatusInfo) {
        int status = pkiStatusInfo.getStatus().intValue();
        switch (status) {
            case 0: {
                return "accepted (0)";
            }
            case 1: {
                return "grantedWithMods (1)";
            }
            case 2: {
                return "rejection (2)";
            }
            case 3: {
                return "waiting (3)";
            }
            case 4: {
                return "revocationWarning (4)";
            }
            case 5: {
                return "revocationNotification (5)";
            }
            case 6: {
                return "keyUpdateWarning (6)";
            }
        }
        return Integer.toString(status);
    }

    class Testor
    implements Runnable {
        private final BenchmarkHttpClient httpClient;

        public Testor() {
            this.httpClient = new BenchmarkHttpClient(CaEnrollBenchmark.this.caHost, CaEnrollBenchmark.this.caPort, CaEnrollBenchmark.this.sslContext, CaEnrollBenchmark.this, CaEnrollBenchmark.this.queueSize);
            this.httpClient.start();
        }

        @Override
        public void run() {
            while (!CaEnrollBenchmark.this.stop() && CaEnrollBenchmark.this.getErrorAccout() < 1L) {
                try {
                    PKIMessage certReq = CaEnrollBenchmark.this.nextCertRequest();
                    if (certReq == null) break;
                    this.testNext(certReq);
                }
                catch (IOException | CertificateException | BenchmarkHttpClient.HttpClientException ex) {
                    LOG.warn("exception", (Throwable)ex);
                    CaEnrollBenchmark.this.account(1L, 1L);
                }
                catch (Error | RuntimeException ex) {
                    LOG.warn("unexpected exception", ex);
                    CaEnrollBenchmark.this.account(1L, 1L);
                }
            }
            try {
                this.httpClient.shutdown();
            }
            catch (Exception ex) {
                LOG.warn("got IOException in requestor.stop()", (Throwable)ex);
            }
        }

        private void testNext(PKIMessage certReq) throws BenchmarkHttpClient.HttpClientException, IOException {
            byte[] encoded = certReq.getEncoded();
            ByteBuf content = Unpooled.wrappedBuffer((byte[])encoded);
            DefaultFullHttpRequest httpReq = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, CaEnrollBenchmark.this.conf.caUrl, content);
            httpReq.headers().addInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, content.readableBytes()).add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/pkixcmp");
            this.httpClient.send((FullHttpRequest)httpReq);
        }
    }

    public static class Conf
    extends ValidatableConf {
        private String caUrl;
        private String requestorCert;
        private String responderCert;
        private BenchmarkHttpClient.SslConf ssl;
        private GeneralName requestor;
        private GeneralName responder;

        public String getCaUrl() {
            return this.caUrl;
        }

        public void setCaUrl(String caUrl) {
            this.caUrl = caUrl;
        }

        public String getRequestorCert() {
            return this.requestorCert;
        }

        public void setRequestorCert(String requestorCert) {
            this.requestorCert = requestorCert;
        }

        public String getResponderCert() {
            return this.responderCert;
        }

        public void setResponderCert(String responderCert) {
            this.responderCert = responderCert;
        }

        public BenchmarkHttpClient.SslConf getSsl() {
            return this.ssl;
        }

        public void setSsl(BenchmarkHttpClient.SslConf ssl) {
            this.ssl = ssl;
        }

        public GeneralName requestor() throws CertificateException, IOException {
            if (this.requestor == null && this.requestorCert != null) {
                X500Name subject = X509Util.parseCert((File)new File(this.requestorCert)).getSubject();
                this.requestor = new GeneralName(subject);
            }
            return this.requestor;
        }

        public GeneralName responder() throws CertificateException, IOException {
            if (this.responder == null && this.responderCert != null) {
                X500Name subject = X509Util.parseCert((File)new File(this.responderCert)).getSubject();
                this.responder = new GeneralName(subject);
            }
            return this.responder;
        }

        public void validate() throws InvalidConfException {
            Conf.notBlank((String)this.requestorCert, (String)"requestorCert");
            Conf.notBlank((String)this.responderCert, (String)"responderCert");
            Conf.notBlank((String)this.caUrl, (String)"caUrl");
            Conf.notNull((Object)((Object)this.ssl), (String)"ssl");
            Conf.validate((ValidatableConf)this.ssl);
        }
    }
}

