/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.qa.ca;

import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECPoint;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSAPublicKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.xipki.security.EdECConstants;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.security.util.KeyUtil;
import org.xipki.util.Args;
import org.xipki.util.Base64;

public abstract class CaEnrollBenchKeyEntry {
    public abstract SubjectPublicKeyInfo getSubjectPublicKeyInfo() throws IOException, Exception;

    public static final class ECKeyEntry
    extends CaEnrollBenchKeyEntry {
        private SubjectPublicKeyInfo spki;
        private KeyPairGenerator keyPairGenerator;

        public ECKeyEntry(ASN1ObjectIdentifier curveOid, boolean reuse) throws Exception {
            if (!reuse) {
                if (!EdECConstants.isEdwardsOrMontgomeryCurve((ASN1ObjectIdentifier)curveOid)) {
                    this.keyPairGenerator = ECKeyEntry.initKeyPairGenrator(curveOid);
                }
                return;
            }
            this.spki = this.buildSpki(curveOid);
        }

        private SubjectPublicKeyInfo buildSpki(ASN1ObjectIdentifier curveOid) throws Exception {
            Args.notNull((Object)curveOid, (String)"curveOid");
            if (EdECConstants.isEdwardsOrMontgomeryCurve((ASN1ObjectIdentifier)curveOid)) {
                KeyPair keypair = KeyUtil.generateEdECKeypair((ASN1ObjectIdentifier)curveOid, null);
                return KeyUtil.createSubjectPublicKeyInfo((PublicKey)keypair.getPublic());
            }
            KeyPairGenerator kpgen = this.keyPairGenerator != null ? this.keyPairGenerator : ECKeyEntry.initKeyPairGenrator(curveOid);
            AlgorithmIdentifier algId = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)curveOid);
            KeyPair kp = kpgen.generateKeyPair();
            ECPublicKey pub = (ECPublicKey)kp.getPublic();
            int orderBitLength = pub.getParams().getOrder().bitLength();
            byte[] keyData = KeyUtil.getUncompressedEncodedECPoint((ECPoint)pub.getW(), (int)orderBitLength);
            return new SubjectPublicKeyInfo(algId, keyData);
        }

        private static KeyPairGenerator initKeyPairGenrator(ASN1ObjectIdentifier curveOid) throws Exception {
            String curveName = AlgorithmUtil.getCurveName((ASN1ObjectIdentifier)curveOid);
            if (curveName == null) {
                curveName = curveOid.getId();
            }
            KeyPairGenerator kpgen = KeyPairGenerator.getInstance("ECDSA", "BC");
            ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)curveName);
            kpgen.initialize((AlgorithmParameterSpec)spec);
            return kpgen;
        }

        @Override
        public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
            return this.spki;
        }
    }

    public static final class DSAKeyEntry
    extends CaEnrollBenchKeyEntry {
        private SubjectPublicKeyInfo spki;
        private int plength;

        public DSAKeyEntry(int plength, boolean reuse) throws Exception {
            if (!reuse) {
                this.plength = plength;
                return;
            }
            if (plength % 1024 != 0) {
                throw new IllegalArgumentException("invalid DSA pLength " + plength);
            }
            int qlength = plength >= 2048 ? 256 : 160;
            KeyPair kp = KeyUtil.generateDSAKeypair((int)plength, (int)qlength, (SecureRandom)new SecureRandom());
            DSAPublicKey pk = (DSAPublicKey)kp.getPublic();
            this.spki = DSAKeyEntry.buildSpki(pk.getParams().getP(), pk.getParams().getQ(), pk.getParams().getG(), pk.getY());
        }

        private static BigInteger base64ToInt(String base64Str) {
            return new BigInteger(1, Base64.decode((String)base64Str));
        }

        private void init(String p, String q, String g, String y) throws IOException {
            this.spki = DSAKeyEntry.buildSpki(DSAKeyEntry.base64ToInt(p), DSAKeyEntry.base64ToInt(q), DSAKeyEntry.base64ToInt(g), DSAKeyEntry.base64ToInt(y));
        }

        private static SubjectPublicKeyInfo buildSpki(BigInteger p, BigInteger q, BigInteger g, BigInteger y) throws IOException {
            ASN1EncodableVector vec = new ASN1EncodableVector();
            vec.add((ASN1Encodable)new ASN1Integer(p));
            vec.add((ASN1Encodable)new ASN1Integer(q));
            vec.add((ASN1Encodable)new ASN1Integer(g));
            DERSequence dssParams = new DERSequence(vec);
            AlgorithmIdentifier algId = new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, (ASN1Encodable)dssParams);
            return new SubjectPublicKeyInfo(algId, (ASN1Encodable)new ASN1Integer(y));
        }

        @Override
        public SubjectPublicKeyInfo getSubjectPublicKeyInfo() throws Exception {
            if (this.spki != null) {
                return this.spki;
            }
            int qlength = this.plength >= 2048 ? 256 : 160;
            KeyPair kp = KeyUtil.generateDSAKeypair((int)this.plength, (int)qlength, (SecureRandom)new SecureRandom());
            DSAPublicKey pk = (DSAPublicKey)kp.getPublic();
            return DSAKeyEntry.buildSpki(pk.getParams().getP(), pk.getParams().getQ(), pk.getParams().getG(), pk.getY());
        }
    }

    public static final class RSAKeyEntry
    extends CaEnrollBenchKeyEntry {
        private static final BigInteger PUBLIC_EXPONENT = BigInteger.valueOf(65535L);
        private static final AlgorithmIdentifier keyAlgId = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE);
        private SubjectPublicKeyInfo spki;
        private KeyPairGenerator keyPairGenerator;

        public RSAKeyEntry(int keysize, boolean reuse) throws Exception {
            if (keysize % 1024 != 0) {
                throw new IllegalArgumentException("invalid RSA keysize " + keysize);
            }
            if (!reuse) {
                this.keyPairGenerator = KeyPairGenerator.getInstance("RSA");
                this.keyPairGenerator.initialize(keysize);
                return;
            }
            KeyPairGenerator kp = KeyPairGenerator.getInstance("RSA");
            kp.initialize(keysize);
            java.security.interfaces.RSAPublicKey publicKey = (java.security.interfaces.RSAPublicKey)kp.generateKeyPair().getPublic();
            this.spki = new SubjectPublicKeyInfo(keyAlgId, (ASN1Encodable)new RSAPublicKey(publicKey.getModulus(), publicKey.getPublicExponent()));
        }

        private static BigInteger base64ToInt(String base64Str) {
            return new BigInteger(1, Base64.decode((String)base64Str));
        }

        @Override
        public SubjectPublicKeyInfo getSubjectPublicKeyInfo() throws Exception {
            if (this.spki != null) {
                return this.spki;
            }
            java.security.interfaces.RSAPublicKey publicKey = (java.security.interfaces.RSAPublicKey)this.keyPairGenerator.generateKeyPair().getPublic();
            return new SubjectPublicKeyInfo(keyAlgId, (ASN1Encodable)new RSAPublicKey(publicKey.getModulus(), publicKey.getPublicExponent()));
        }
    }
}

