/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.qa.ca.extn;

import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1PrintableString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1UTF8String;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.PolicyQualifierId;
import org.bouncycastle.asn1.x509.PolicyQualifierInfo;
import org.bouncycastle.asn1.x509.UserNotice;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.asn1.x509.qualified.BiometricData;
import org.bouncycastle.asn1.x509.qualified.TypeOfBiometricData;
import org.slf4j.Logger;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.certprofile.xijson.AdmissionExtension;
import org.xipki.ca.certprofile.xijson.BiometricInfoOption;
import org.xipki.ca.certprofile.xijson.XijsonCertprofile;
import org.xipki.ca.certprofile.xijson.conf.AdditionalInformation;
import org.xipki.ca.certprofile.xijson.conf.CertificatePolicies;
import org.xipki.qa.ca.IssuerInfo;
import org.xipki.qa.ca.extn.CheckerUtil;
import org.xipki.qa.ca.extn.ExtensionChecker;
import org.xipki.qa.ca.extn.ExtensionsChecker;
import org.xipki.security.HashAlgo;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.util.X509Util;
import org.xipki.util.CollectionUtil;
import org.xipki.util.CompareUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.Hex;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.TripleState;
import org.xipki.util.exception.BadCertTemplateException;

class A2gChecker
extends ExtensionChecker {
    A2gChecker(ExtensionsChecker parent) {
        super(parent);
    }

    void checkExtnAdditionalInformation(StringBuilder failureMsg, byte[] extnValue, Extensions requestedExtns, Certprofile.ExtensionControl extControl) {
        AdditionalInformation additionalInformation = this.caller.getAdditionalInformation();
        this.caller.checkDirectoryString(ObjectIdentifiers.Extn.id_extension_additionalInformation, additionalInformation.getType(), additionalInformation.getText(), failureMsg, extnValue, requestedExtns, extControl);
    }

    void checkExtnAdmission(StringBuilder failureMsg, byte[] extnValue, Extensions requestedExtns, X500Name requestedSubject, Certprofile.ExtensionControl extnControl) {
        AdmissionExtension.AdmissionSyntaxOption conf = this.getCertprofile().extensions().getAdmission();
        ASN1ObjectIdentifier type = ObjectIdentifiers.Extn.id_extension_admission;
        if (conf == null) {
            this.caller.checkConstantExtnValue(type, failureMsg, extnValue, requestedExtns, extnControl);
            return;
        }
        LinkedList<List> reqRegNumsList = null;
        if (requestedSubject != null && conf.isInputFromRequestRequired()) {
            RDN[] admissionRdns = requestedSubject.getRDNs(type);
            if (admissionRdns == null || admissionRdns.length == 0) {
                failureMsg.append("no subject RDN Admission is contained in the request;");
                return;
            }
            reqRegNumsList = new LinkedList<List>();
            for (RDN m : admissionRdns) {
                String str = X509Util.rdnValueToString((ASN1Encodable)m.getFirst().getValue());
                ConfPairs pairs = new ConfPairs(str);
                for (String name : pairs.names()) {
                    if (!"registrationNumber".equalsIgnoreCase(name)) continue;
                    reqRegNumsList.add(StringUtil.split((String)pairs.value(name), (String)" ,;:"));
                }
            }
        }
        try {
            byte[] expected = conf.getExtensionValue(reqRegNumsList).getValue().toASN1Primitive().getEncoded();
            if (!Arrays.equals(expected, extnValue)) {
                CheckerUtil.addViolation(failureMsg, "extension valus", CheckerUtil.hex(extnValue), CheckerUtil.hex(expected));
            }
        }
        catch (IOException ex) {
            LogUtil.error((Logger)this.log, (Throwable)ex);
            failureMsg.append("IOException while computing the expected extension value;");
        }
        catch (BadCertTemplateException ex) {
            LogUtil.error((Logger)this.log, (Throwable)ex);
            failureMsg.append("BadCertTemplateException while computing the expected extension value;");
        }
    }

    void checkExtnAuthorityInfoAccess(StringBuilder failureMsg, byte[] extnValue, IssuerInfo issuerInfo) {
        Set<String> expOcspUris;
        Certprofile.AuthorityInfoAccessControl aiaControl = this.getCertprofile().getAiaControl();
        Set<String> expCaIssuerUris = aiaControl == null || aiaControl.isIncludesCaIssuers() ? issuerInfo.getCaIssuerUrls() : Collections.emptySet();
        Set<String> set = expOcspUris = aiaControl == null || aiaControl.isIncludesOcsp() ? issuerInfo.getOcspUrls() : Collections.emptySet();
        if (CollectionUtil.isEmpty(expCaIssuerUris) && CollectionUtil.isEmpty(expOcspUris)) {
            failureMsg.append("AIA is present but expected is 'none'; ");
            return;
        }
        AuthorityInformationAccess isAia = AuthorityInformationAccess.getInstance((Object)extnValue);
        CheckerUtil.checkAia(failureMsg, isAia, X509ObjectIdentifiers.id_ad_caIssuers, expCaIssuerUris);
        CheckerUtil.checkAia(failureMsg, isAia, X509ObjectIdentifiers.id_ad_ocsp, expOcspUris);
    }

    void checkExtnAuthorityKeyId(StringBuilder failureMsg, byte[] extnValue, IssuerInfo issuerInfo) {
        AuthorityKeyIdentifier asn1 = AuthorityKeyIdentifier.getInstance((Object)extnValue);
        byte[] keyIdentifier = asn1.getKeyIdentifier();
        BigInteger authorityCertSerialNumber = asn1.getAuthorityCertSerialNumber();
        GeneralNames authorityCertIssuer = asn1.getAuthorityCertIssuer();
        if (this.getCertprofile().useIssuerAndSerialInAki()) {
            if (authorityCertIssuer == null) {
                failureMsg.append("authorityCertIssuer is 'absent', but expected 'present'; ");
            } else {
                GeneralName[] genNames = authorityCertIssuer.getNames();
                X500Name x500GenName = null;
                for (GeneralName genName : genNames) {
                    if (genName.getTagNo() != 4) continue;
                    if (x500GenName != null) {
                        failureMsg.append("authorityCertIssuer contains at least two directoryName but expected one; ");
                        break;
                    }
                    x500GenName = (X500Name)genName.getName();
                }
                if (x500GenName == null) {
                    failureMsg.append("authorityCertIssuer does not contain directoryName but expected one; ");
                } else {
                    X500Name caIssuer = issuerInfo.getCert().getIssuer();
                    if (!caIssuer.equals(x500GenName)) {
                        CheckerUtil.addViolation(failureMsg, "authorityCertIssuer", x500GenName, caIssuer);
                    }
                }
            }
            if (authorityCertSerialNumber == null) {
                failureMsg.append("authorityCertSerialNumber is 'absent', but expected 'present'; ");
            } else {
                BigInteger issuerSn = issuerInfo.getCert().getSerialNumber();
                if (!issuerSn.equals(authorityCertSerialNumber)) {
                    CheckerUtil.addViolation(failureMsg, "authorityCertSerialNumber", authorityCertSerialNumber, issuerSn);
                }
            }
            if (keyIdentifier != null) {
                failureMsg.append("keyIdentifier is 'present', but expected 'absent'; ");
            }
        } else {
            if (keyIdentifier == null) {
                failureMsg.append("keyIdentifier is 'absent', but expected 'present'; ");
            } else if (!Arrays.equals(issuerInfo.getSubjectKeyIdentifier(), keyIdentifier)) {
                CheckerUtil.addViolation(failureMsg, "keyIdentifier", CheckerUtil.hex(keyIdentifier), CheckerUtil.hex(issuerInfo.getSubjectKeyIdentifier()));
            }
            if (authorityCertIssuer != null) {
                failureMsg.append("authorityCertIssuer is 'present', but expected 'absent'; ");
            }
            if (authorityCertSerialNumber != null) {
                failureMsg.append("authorityCertSerialNumber is 'present', but expected 'absent'; ");
            }
        }
    }

    void checkExtnBasicConstraints(StringBuilder failureMsg, byte[] extnValue) {
        boolean ca;
        XijsonCertprofile certprofile = this.getCertprofile();
        BasicConstraints bc = BasicConstraints.getInstance((Object)extnValue);
        Certprofile.CertLevel certLevel = certprofile.getCertLevel();
        boolean bl = ca = Certprofile.CertLevel.EndEntity != certLevel;
        if (ca != bc.isCA()) {
            CheckerUtil.addViolation(failureMsg, "ca", bc.isCA(), ca);
        }
        if (!bc.isCA()) {
            return;
        }
        BigInteger tmpPathLen = bc.getPathLenConstraint();
        Integer pathLen = certprofile.extensions().getPathLen();
        if (pathLen == null) {
            if (tmpPathLen != null) {
                CheckerUtil.addViolation(failureMsg, "pathLen", tmpPathLen, "absent");
            }
        } else if (tmpPathLen == null) {
            CheckerUtil.addViolation(failureMsg, "pathLen", "null", pathLen);
        } else if (!BigInteger.valueOf(pathLen.intValue()).equals(tmpPathLen)) {
            CheckerUtil.addViolation(failureMsg, "pathLen", tmpPathLen, pathLen);
        }
    }

    void checkExtnBiometricInfo(StringBuilder failureMsg, byte[] extnValue, Extensions requestedExtns) {
        BiometricInfoOption conf = this.getCertprofile().extensions().getBiometricInfo();
        if (conf == null) {
            failureMsg.append("extension is present but not expected; ");
            return;
        }
        ASN1Encodable extInRequest = null;
        if (requestedExtns != null) {
            extInRequest = requestedExtns.getExtensionParsedValue(Extension.biometricInfo);
        }
        if (extInRequest == null) {
            failureMsg.append("extension is present but not expected; ");
            return;
        }
        ASN1Sequence extValueInReq = ASN1Sequence.getInstance((Object)extInRequest);
        int expSize = extValueInReq.size();
        ASN1Sequence extValue = ASN1Sequence.getInstance((Object)extnValue);
        int isSize = extValue.size();
        if (isSize != expSize) {
            CheckerUtil.addViolation(failureMsg, "number of biometricData", isSize, expSize);
            return;
        }
        for (int i = 0; i < expSize; ++i) {
            ASN1IA5String str;
            byte[] expBytes;
            byte[] isBytes;
            HashAlgo hashAlgo;
            TypeOfBiometricData expType;
            BiometricData isData = BiometricData.getInstance((Object)extValue.getObjectAt(i));
            BiometricData expData = BiometricData.getInstance((Object)extValueInReq.getObjectAt(i));
            TypeOfBiometricData isType = isData.getTypeOfBiometricData();
            if (!isType.equals((Object)(expType = expData.getTypeOfBiometricData()))) {
                String isStr = isType.isPredefined() ? Integer.toString(isType.getPredefinedBiometricType()) : isType.getBiometricDataOid().getId();
                String expStr = expType.isPredefined() ? Integer.toString(expType.getPredefinedBiometricType()) : expType.getBiometricDataOid().getId();
                CheckerUtil.addViolation(failureMsg, "biometricData[" + i + "].typeOfBiometricData", isStr, expStr);
            }
            try {
                hashAlgo = HashAlgo.getInstance((AlgorithmIdentifier)expData.getHashAlgorithm());
            }
            catch (NoSuchAlgorithmException e) {
                hashAlgo = null;
                failureMsg.append("biometricData[").append(i).append("].biometricDataHash of the request has incorrect syntax; ");
            }
            if (hashAlgo != null && !hashAlgo.getAlgorithmIdentifier().equals((Object)isData.getHashAlgorithm())) {
                try {
                    CheckerUtil.addViolation(failureMsg, "biometricData[" + i + "].hashAlgorithm", Hex.encode((byte[])isData.getHashAlgorithm().getEncoded()), Hex.encode((byte[])hashAlgo.getAlgorithmIdentifier().getEncoded()));
                }
                catch (Exception ex) {
                    failureMsg.append("biometricData[").append(i).append("].biometricDataHash: could not encode; ");
                }
            }
            if (!Arrays.equals(isBytes = isData.getBiometricDataHash().getOctets(), expBytes = expData.getBiometricDataHash().getOctets())) {
                CheckerUtil.addViolation(failureMsg, "biometricData[" + i + "].biometricDataHash", CheckerUtil.hex(isBytes), CheckerUtil.hex(expBytes));
            }
            String isSourceDataUri = (str = isData.getSourceDataUriIA5()) == null ? null : str.getString();
            String expSourceDataUri = null;
            if (conf.getSourceDataUriOccurrence() != TripleState.forbidden) {
                str = expData.getSourceDataUriIA5();
                String string = expSourceDataUri = str == null ? null : str.getString();
            }
            if (expSourceDataUri == null) {
                if (isSourceDataUri == null) continue;
                CheckerUtil.addViolation(failureMsg, "biometricData[" + i + "].sourceDataUri", "present", "absent");
                continue;
            }
            if (isSourceDataUri == null) {
                failureMsg.append("biometricData[").append(i).append("].sourceDataUri is 'absent'");
                failureMsg.append(" but expected 'present'; ");
                continue;
            }
            if (isSourceDataUri.equals(expSourceDataUri)) continue;
            CheckerUtil.addViolation(failureMsg, "biometricData[" + i + "].sourceDataUri", isSourceDataUri, expSourceDataUri);
        }
    }

    void checkExtnCertificatePolicies(StringBuilder failureMsg, byte[] extnValue, Extensions requestedExtns, Certprofile.ExtensionControl extnControl) {
        CertificatePolicies certificatePolicies = this.caller.getCertificatePolicies();
        if (certificatePolicies == null) {
            this.caller.checkConstantExtnValue(Extension.certificatePolicies, failureMsg, extnValue, requestedExtns, extnControl);
            return;
        }
        HashMap<String, CertificatePolicies.CertificatePolicyInformationType> expPoliciesMap = new HashMap<String, CertificatePolicies.CertificatePolicyInformationType>();
        for (CertificatePolicies.CertificatePolicyInformationType cp : this.caller.getCertificatePolicies().getCertificatePolicyInformations()) {
            expPoliciesMap.put(cp.getPolicyIdentifier().getOid(), cp);
        }
        HashSet expPolicyIds = new HashSet(expPoliciesMap.keySet());
        org.bouncycastle.asn1.x509.CertificatePolicies asn1 = org.bouncycastle.asn1.x509.CertificatePolicies.getInstance((Object)extnValue);
        PolicyInformation[] isPolicyInformations = asn1.getPolicyInformation();
        for (PolicyInformation isPolicyInformation : isPolicyInformations) {
            ASN1ObjectIdentifier isPolicyId = isPolicyInformation.getPolicyIdentifier();
            expPolicyIds.remove(isPolicyId.getId());
            CertificatePolicies.CertificatePolicyInformationType expCp = (CertificatePolicies.CertificatePolicyInformationType)expPoliciesMap.get(isPolicyId.getId());
            if (expCp == null) {
                failureMsg.append("certificate policy '").append(isPolicyId).append("' is not expected; ");
                continue;
            }
            List expCpPq = expCp.getPolicyQualifiers();
            if (CollectionUtil.isEmpty((Collection)expCpPq)) continue;
            ASN1Sequence isPolicyQualifiers = isPolicyInformation.getPolicyQualifiers();
            LinkedList<String> isCpsUris = new LinkedList<String>();
            LinkedList<String> isUserNotices = new LinkedList<String>();
            int size = isPolicyQualifiers.size();
            for (int i = 0; i < size; ++i) {
                UserNotice isUserNotice;
                PolicyQualifierInfo isPolicyQualifierInfo = PolicyQualifierInfo.getInstance((Object)isPolicyQualifiers.getObjectAt(i));
                ASN1ObjectIdentifier isPolicyQualifierId = isPolicyQualifierInfo.getPolicyQualifierId();
                ASN1Encodable isQualifier = isPolicyQualifierInfo.getQualifier();
                if (PolicyQualifierId.id_qt_cps.equals((ASN1Primitive)isPolicyQualifierId)) {
                    String isCpsUri = ASN1IA5String.getInstance((Object)isQualifier).getString();
                    isCpsUris.add(isCpsUri);
                    continue;
                }
                if (!PolicyQualifierId.id_qt_unotice.equals((ASN1Primitive)isPolicyQualifierId) || (isUserNotice = UserNotice.getInstance((Object)isQualifier)).getExplicitText() == null) continue;
                isUserNotices.add(isUserNotice.getExplicitText().getString());
            }
            block7: for (CertificatePolicies.PolicyQualifier qualifierInfo : expCpPq) {
                String value = qualifierInfo.getValue();
                switch (qualifierInfo.getType()) {
                    case cpsUri: {
                        if (isCpsUris.contains(value)) continue block7;
                        failureMsg.append("CPSUri '").append(value).append("' is absent but is required; ");
                        continue block7;
                    }
                    case userNotice: {
                        if (isUserNotices.contains(value)) continue block7;
                        failureMsg.append("userNotice '").append(value).append("' is absent but is required; ");
                        continue block7;
                    }
                }
                throw new IllegalStateException("should not reach here");
            }
        }
        for (String policyId : expPolicyIds) {
            failureMsg.append("certificate policy '").append(policyId).append("' is absent but is required; ");
        }
    }

    void checkExtnDeltaCrlDistributionPoints(StringBuilder failureMsg, byte[] extnValue, IssuerInfo issuerInfo) {
        this.checkExtnCrlDistributionPoints(true, failureMsg, extnValue, issuerInfo);
    }

    void checkExtnCrlDistributionPoints(StringBuilder failureMsg, byte[] extnValue, IssuerInfo issuerInfo) {
        this.checkExtnCrlDistributionPoints(false, failureMsg, extnValue, issuerInfo);
    }

    private void checkExtnCrlDistributionPoints(boolean deltaCrl, StringBuilder failureMsg, byte[] extnValue, IssuerInfo issuerInfo) {
        String type;
        CRLDistPoint isCrlDistPoints = CRLDistPoint.getInstance((Object)extnValue);
        DistributionPoint[] isDistributionPoints = isCrlDistPoints.getDistributionPoints();
        String string = type = deltaCrl ? "deltaCRL" : "CRL";
        if (isDistributionPoints == null) {
            CheckerUtil.addViolation(failureMsg, "size of DistributionPoints of " + type, 0, 1);
            return;
        }
        int len = isDistributionPoints.length;
        if (len != 1) {
            CheckerUtil.addViolation(failureMsg, "size of DistributionPoints of " + type, len, 1);
            return;
        }
        HashSet<String> isCrlUrls = new HashSet<String>();
        for (DistributionPoint entry : isDistributionPoints) {
            GeneralName[] names;
            int asn1Type = entry.getDistributionPoint().getType();
            if (asn1Type != 0) {
                CheckerUtil.addViolation(failureMsg, "tag of DistributionPointName of CRLDistributionPoints of " + type, asn1Type, 0);
                continue;
            }
            GeneralNames isDistributionPointNames = GeneralNames.getInstance((Object)entry.getDistributionPoint().getName());
            for (GeneralName name : names = isDistributionPointNames.getNames()) {
                if (name.getTagNo() != 6) {
                    CheckerUtil.addViolation(failureMsg, "tag of URL of " + type, name.getTagNo(), 6);
                    continue;
                }
                String uri = ((ASN1String)name.getName()).getString();
                isCrlUrls.add(uri);
            }
            Set<String> expCrlUrls = deltaCrl ? issuerInfo.getDeltaCrlUrls() : issuerInfo.getCrlUrls();
            Set<String> diffs = CheckerUtil.strInBnotInA(expCrlUrls, isCrlUrls);
            if (CollectionUtil.isNotEmpty(diffs)) {
                failureMsg.append("URLs of ").append(type).append(" ").append(diffs).append(" are present but not expected; ");
            }
            if (!CollectionUtil.isNotEmpty(diffs = CheckerUtil.strInBnotInA(isCrlUrls, expCrlUrls))) continue;
            failureMsg.append("URLs of ").append(type).append(" ").append(diffs).append(" are absent but are required; ");
        }
    }

    void checkExtnExtendedKeyUsage(StringBuilder failureMsg, byte[] extnValue, Extensions requestedExtns, Certprofile.ExtensionControl extnControl) {
        Set<String> set;
        Set<String> set2;
        byte[] byArray;
        Extension extension;
        HashSet<String> isUsages = new HashSet<String>();
        ExtendedKeyUsage keyusage = ExtendedKeyUsage.getInstance((Object)extnValue);
        KeyPurposeId[] usages = keyusage.getUsages();
        if (usages != null) {
            for (KeyPurposeId keyPurposeId : usages) {
                isUsages.add(keyPurposeId.getId());
            }
        }
        Set<String> expectedUsages = new HashSet<String>();
        Set<Certprofile.ExtKeyUsageControl> requiredExtKeyusage = this.caller.getExtKeyusage(true);
        if (requiredExtKeyusage != null) {
            for (Certprofile.ExtKeyUsageControl extKeyUsageControl : requiredExtKeyusage) {
                expectedUsages.add(extKeyUsageControl.getExtKeyUsage().getId());
            }
        }
        Set<Certprofile.ExtKeyUsageControl> optionalExtKeyusage = this.caller.getExtKeyusage(false);
        if (requestedExtns != null && extnControl.isPermittedInRequest() && CollectionUtil.isNotEmpty(optionalExtKeyusage) && (extension = requestedExtns.getExtension(Extension.extendedKeyUsage)) != null) {
            ExtendedKeyUsage reqKeyUsage = ExtendedKeyUsage.getInstance((Object)extension.getParsedValue());
            for (Certprofile.ExtKeyUsageControl k : optionalExtKeyusage) {
                if (!reqKeyUsage.hasKeyPurposeId(KeyPurposeId.getInstance((Object)k.getExtKeyUsage()))) continue;
                expectedUsages.add(k.getExtKeyUsage().getId());
            }
        }
        if (CollectionUtil.isEmpty(expectedUsages) && (byArray = this.caller.getConstantExtensionValue(Extension.extendedKeyUsage)) != null) {
            expectedUsages = CheckerUtil.getExtKeyUsage(byArray);
        }
        if (CollectionUtil.isNotEmpty(set2 = CheckerUtil.strInBnotInA(expectedUsages, isUsages))) {
            failureMsg.append("usages ").append(set2).append(" are present but not expected; ");
        }
        if (CollectionUtil.isNotEmpty(set = CheckerUtil.strInBnotInA(isUsages, expectedUsages))) {
            failureMsg.append("usages ").append(set).append(" are absent but are required; ");
        }
    }

    void checkExtnGmt0015(StringBuilder failureMsg, byte[] extnValue, Extensions requestedExtns, Certprofile.ExtensionControl extnControl, ASN1ObjectIdentifier oid, X500Name requestedSubject) throws IOException {
        if (ObjectIdentifiers.Extn.id_GMT_0015_ICRegistrationNumber.equals((ASN1Primitive)oid) || ObjectIdentifiers.Extn.id_GMT_0015_InsuranceNumber.equals((ASN1Primitive)oid) || ObjectIdentifiers.Extn.id_GMT_0015_OrganizationCode.equals((ASN1Primitive)oid) || ObjectIdentifiers.Extn.id_GMT_0015_TaxationNumber.equals((ASN1Primitive)oid)) {
            Extension extension;
            String expStr = null;
            Extension extension2 = extension = requestedExtns == null ? null : requestedExtns.getExtension(oid);
            if (extension != null) {
                expStr = ((ASN1String)extension.getParsedValue()).getString();
            } else {
                RDN[] rdns = requestedSubject.getRDNs(oid);
                if (rdns != null && rdns.length > 0) {
                    expStr = X509Util.rdnValueToString((ASN1Encodable)rdns[0].getFirst().getValue());
                }
            }
            String isStr = null;
            try {
                isStr = ASN1PrintableString.getInstance((Object)extnValue).getString();
            }
            catch (Exception ex) {
                failureMsg.append("exension value is not of type PrintableString; ");
            }
            if (isStr != null && !CompareUtil.equalsObject((Object)expStr, (Object)isStr)) {
                CheckerUtil.addViolation(failureMsg, "extension value", isStr, expStr);
            }
        } else if (ObjectIdentifiers.Extn.id_GMT_0015_IdentityCode.equals((ASN1Primitive)oid)) {
            Extension extension;
            int tag = -1;
            String extnStr = null;
            Extension extension3 = extension = requestedExtns == null ? null : requestedExtns.getExtension(oid);
            if (extension != null) {
                ASN1Encodable reqExtnValue = extension.getParsedValue();
                if (reqExtnValue instanceof ASN1TaggedObject) {
                    ASN1TaggedObject tagged = (ASN1TaggedObject)reqExtnValue;
                    tag = tagged.getTagNo();
                    if (tagged.isExplicit()) {
                        extnStr = ((ASN1String)tagged.getExplicitBaseObject()).getString();
                    } else if (tag == 0 || tag == 2) {
                        extnStr = ASN1PrintableString.getInstance((ASN1TaggedObject)tagged, (boolean)false).getString();
                    } else if (tag == 1) {
                        extnStr = ASN1UTF8String.getInstance((ASN1TaggedObject)tagged, (boolean)false).getString();
                    }
                }
            } else {
                RDN[] rdns = requestedSubject.getRDNs(oid);
                String str = rdns != null && rdns.length > 0 ? X509Util.rdnValueToString((ASN1Encodable)rdns[0].getFirst().getValue()) : "";
                if (str.length() > 3 && str.charAt(0) == '[' && str.charAt(2) == ']') {
                    tag = Integer.parseInt(str.substring(1, 2));
                    extnStr = str.substring(3);
                }
            }
            byte[] expected = null;
            if (StringUtil.isNotBlank(extnStr)) {
                boolean explicit = true;
                if (tag == 0 || tag == 2) {
                    expected = new DERTaggedObject(true, tag, (ASN1Encodable)new DERPrintableString(extnStr)).getEncoded();
                } else if (tag == 1) {
                    expected = new DERTaggedObject(true, tag, (ASN1Encodable)new DERUTF8String(extnStr)).getEncoded();
                }
            }
            if (!Arrays.equals(expected, extnValue)) {
                CheckerUtil.addViolation(failureMsg, "extension value", CheckerUtil.hex(extnValue), expected == null ? "not present" : CheckerUtil.hex(expected));
            }
        } else {
            throw new IllegalArgumentException("unknown extension type " + oid.getId());
        }
    }
}

