/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.qa.security;

import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignAlgo;
import org.xipki.security.SignerConf;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;
import org.xipki.util.BenchmarkExecutor;
import org.xipki.util.ConfPairs;
import org.xipki.util.RandomUtil;
import org.xipki.util.exception.ObjectCreationException;

public class JceSignSpeed
extends BenchmarkExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(JceSignSpeed.class);
    private final ConcurrentContentSigner signer;

    public JceSignSpeed(SecurityFactory securityFactory, String type, String alias, String signatureAlgorithm, String description, int threads) throws ObjectCreationException {
        super(description + "\nsignature algorithm: " + signatureAlgorithm);
        Args.notBlank((String)signatureAlgorithm, (String)"signatureAlgorithm");
        try {
            SignerConf signerConf = JceSignSpeed.getJceSignerConf(alias, threads, SignAlgo.getInstance((String)signatureAlgorithm));
            this.signer = securityFactory.createSigner(type, signerConf, (X509Cert)null);
        }
        catch (ObjectCreationException ex) {
            this.close();
            throw ex;
        }
        catch (NoSuchAlgorithmException ex) {
            this.close();
            throw new ObjectCreationException(ex.getMessage());
        }
    }

    public final void close() {
    }

    protected Runnable getTestor() throws Exception {
        return new Testor();
    }

    private static SignerConf getJceSignerConf(String alias, int parallelism, SignAlgo signAlgo) {
        ConfPairs conf = new ConfPairs();
        conf.putPair("parallelism", Integer.toString(parallelism));
        conf.putPair("alias", alias);
        conf.putPair("algo", signAlgo.getJceName());
        return new SignerConf(conf.getEncoded());
    }

    class Testor
    implements Runnable {
        private static final int batch = 10;
        private final byte[][] data = new byte[10][16];

        public Testor() {
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = RandomUtil.nextBytes((int)this.data[i].length);
            }
        }

        @Override
        public void run() {
            while (!JceSignSpeed.this.stop() && JceSignSpeed.this.getErrorAccout() < 1L) {
                try {
                    JceSignSpeed.this.signer.sign(this.data);
                    JceSignSpeed.this.account(10L, 0L);
                }
                catch (Exception ex) {
                    LOG.error("P11SignSpeed.Testor.run()", (Throwable)ex);
                    JceSignSpeed.this.account(10L, 10L);
                }
            }
        }
    }
}

