/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.qa;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.xipki.util.Args;
import org.xipki.util.StringUtil;

public class FileBigIntegerIterator
implements Iterator<BigInteger>,
Closeable {
    private final boolean hex;
    private final boolean loop;
    private final String fileName;
    private BufferedReader reader;
    private final ConcurrentLinkedQueue<BigInteger> nextNumbers = new ConcurrentLinkedQueue();
    private BigInteger currentNumber;

    public FileBigIntegerIterator(String fileName, boolean hex, boolean loop) throws IOException {
        this.fileName = Args.notBlank((String)fileName, (String)"fileName");
        this.hex = hex;
        this.loop = loop;
        this.reader = Files.newBufferedReader(Paths.get(fileName, new String[0]));
        this.currentNumber = this.readNextNumber();
    }

    @Override
    public synchronized boolean hasNext() {
        return this.currentNumber != null;
    }

    @Override
    public synchronized BigInteger next() {
        if (this.currentNumber == null) {
            return null;
        }
        BigInteger ret = this.currentNumber;
        this.currentNumber = this.readNextNumber();
        return ret;
    }

    private BigInteger readNextNumber() {
        String line;
        BigInteger number = this.nextNumbers.poll();
        if (number != null) {
            return number;
        }
        try {
            line = this.reader.readLine();
            if (this.loop && line == null) {
                this.reader.close();
                this.reader = Files.newBufferedReader(Paths.get(this.fileName, new String[0]));
                line = this.reader.readLine();
            }
            if (line == null) {
                this.reader.close();
                return null;
            }
        }
        catch (IOException ex) {
            throw new NoSuchElementException("could not read next number from file " + this.fileName);
        }
        if (line.indexOf(44) == -1) {
            this.nextNumbers.add(StringUtil.toBigInt((String)line.trim(), (boolean)this.hex));
        } else {
            StringTokenizer st = new StringTokenizer(line.trim(), ", ");
            while (st.hasMoreTokens()) {
                this.nextNumbers.add(StringUtil.toBigInt((String)st.nextToken(), (boolean)this.hex));
            }
        }
        return this.nextNumbers.poll();
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

