/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.qa.ca;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.qa.ca.CaQaSystemManager;
import org.xipki.qa.ca.CertprofileQa;
import org.xipki.qa.ca.IssuerInfo;
import org.xipki.qa.ca.QaconfType;
import org.xipki.security.util.JSON;
import org.xipki.util.Args;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;

public class CaQaSystemManagerImpl
implements CaQaSystemManager {
    private static final Logger LOG = LoggerFactory.getLogger(CaQaSystemManagerImpl.class);
    private String confFile;
    private final Map<String, CertprofileQa> x509ProfileMap = new HashMap<String, CertprofileQa>();
    private final Map<String, IssuerInfo> x509IssuerInfoMap = new HashMap<String, IssuerInfo>();
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    public String getConfFile() {
        return this.confFile;
    }

    public void setConfFile(String confFile) {
        this.confFile = Args.notBlank((String)confFile, (String)"confFile");
    }

    @Override
    public boolean init() {
        QaconfType qaConf;
        if (StringUtil.isBlank((String)this.confFile)) {
            throw new IllegalStateException("confFile may not be null and empty");
        }
        LOG.info("initializing ...");
        this.initialized.set(false);
        this.x509IssuerInfoMap.clear();
        try {
            InputStream confStream = Files.newInputStream(Paths.get(this.confFile, new String[0]), new OpenOption[0]);
            qaConf = (QaconfType)((Object)JSON.parseObject((InputStream)confStream, QaconfType.class));
        }
        catch (Exception ex) {
            String message = "could not parse the QA configuration";
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not parse the QA configuration");
            return false;
        }
        for (QaconfType.Issuer issuer : qaConf.getIssuers()) {
            IssuerInfo issuerInfo;
            boolean cutoffNotAfter;
            byte[] certBytes;
            try {
                certBytes = issuer.getCert().readContent();
            }
            catch (IOException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not read the certificate bytes of issuer " + issuer.getName()));
                continue;
            }
            String str = issuer.getValidityMode();
            if (StringUtil.isBlank((String)str) || "CUTOFF".equalsIgnoreCase(str)) {
                cutoffNotAfter = true;
            } else if ("LAX".equalsIgnoreCase(str)) {
                cutoffNotAfter = false;
            } else {
                LOG.error("invalid validityMode {}", (Object)str);
                return false;
            }
            try {
                issuerInfo = new IssuerInfo(issuer.getCaIssuerUrls(), issuer.getOcspUrls(), issuer.getCrlUrls(), issuer.getDeltaCrlUrls(), certBytes, cutoffNotAfter);
            }
            catch (CertificateException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not parse certificate of issuer " + issuer.getName()));
                continue;
            }
            this.x509IssuerInfoMap.put(issuer.getName(), issuerInfo);
            LOG.info("configured X509 issuer {}", (Object)issuer.getName());
        }
        for (QaconfType.Certprofile type : qaConf.getCertprofiles()) {
            String name = type.getName();
            try {
                String content = type.readContent();
                this.x509ProfileMap.put(name, new CertprofileQa(content));
                LOG.info("configured X509 certificate profile {}", (Object)name);
            }
            catch (IOException | CertprofileException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not parse QA certificate profile " + name));
            }
        }
        this.initialized.set(true);
        LOG.info("initialized");
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public Set<String> getIssuerNames() {
        this.assertInitialized();
        return Collections.unmodifiableSet(this.x509IssuerInfoMap.keySet());
    }

    @Override
    public IssuerInfo getIssuer(String issuerName) {
        this.assertInitialized();
        return this.x509IssuerInfoMap.get(Args.notNull((Object)issuerName, (String)"issuerName"));
    }

    @Override
    public Set<String> getCertprofileNames() {
        this.assertInitialized();
        return Collections.unmodifiableSet(this.x509ProfileMap.keySet());
    }

    @Override
    public CertprofileQa getCertprofile(String certprofileName) {
        this.assertInitialized();
        return this.x509ProfileMap.get(Args.notNull((Object)certprofileName, (String)"certprofileName"));
    }

    private void assertInitialized() {
        if (!this.initialized.get()) {
            this.init();
        }
        if (!this.initialized.get()) {
            throw new IllegalStateException("Could not start CaQaSystemManager.");
        }
    }
}

