/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.qa.ca.extn;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.api.profile.CertprofileException;
import org.xipki.ca.certprofile.xijson.DirectoryStringType;
import org.xipki.ca.certprofile.xijson.XijsonCertprofile;
import org.xipki.ca.certprofile.xijson.conf.AdditionalInformation;
import org.xipki.ca.certprofile.xijson.conf.CCCSimpleExtensionSchema;
import org.xipki.ca.certprofile.xijson.conf.CertificatePolicies;
import org.xipki.ca.certprofile.xijson.conf.ExtensionType;
import org.xipki.ca.certprofile.xijson.conf.InhibitAnyPolicy;
import org.xipki.ca.certprofile.xijson.conf.NameConstraints;
import org.xipki.ca.certprofile.xijson.conf.PolicyConstraints;
import org.xipki.ca.certprofile.xijson.conf.PolicyMappings;
import org.xipki.ca.certprofile.xijson.conf.QcStatements;
import org.xipki.ca.certprofile.xijson.conf.Restriction;
import org.xipki.ca.certprofile.xijson.conf.SmimeCapabilities;
import org.xipki.ca.certprofile.xijson.conf.TlsFeature;
import org.xipki.ca.certprofile.xijson.conf.X509ProfileType;
import org.xipki.qa.ValidationIssue;
import org.xipki.qa.ca.IssuerInfo;
import org.xipki.qa.ca.extn.A2gChecker;
import org.xipki.qa.ca.extn.CheckerUtil;
import org.xipki.qa.ca.extn.H2nChecker;
import org.xipki.qa.ca.extn.O2tChecker;
import org.xipki.qa.ca.extn.QaExtensionValue;
import org.xipki.qa.ca.extn.U2zChecker;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;

public class ExtensionsChecker {
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionsChecker.class);
    private CertificatePolicies certificatePolicies;
    private PolicyMappings policyMappings;
    private NameConstraints nameConstraints;
    private PolicyConstraints policyConstraints;
    private InhibitAnyPolicy inhibitAnyPolicy;
    private Restriction restriction;
    private AdditionalInformation additionalInformation;
    private ASN1ObjectIdentifier validityModelId;
    private QcStatements qcStatements;
    private TlsFeature tlsFeature;
    private QaExtensionValue smimeCapabilities;
    private ASN1ObjectIdentifier cccExtensionSchemaType;
    private byte[] cccExtensionSchemaValue;
    private final Map<ASN1ObjectIdentifier, QaExtensionValue> constantExtensions;
    private final XijsonCertprofile certprofile;
    private final A2gChecker a2gChecker;
    private final H2nChecker h2nChecker;
    private final O2tChecker o2tChecker;
    private final U2zChecker u2zChecker;

    public ExtensionsChecker(X509ProfileType conf, XijsonCertprofile certprofile) throws CertprofileException {
        this.certprofile = (XijsonCertprofile)Args.notNull((Object)certprofile, (String)"certprofile");
        Args.notNull((Object)conf, (String)"conf");
        Map extensions = conf.buildExtensions();
        Map extensionControls = certprofile.getExtensionControls();
        ASN1ObjectIdentifier type = Extension.certificatePolicies;
        if (extensionControls.containsKey(type)) {
            this.certificatePolicies = ((ExtensionType)extensions.get(type.getId())).getCertificatePolicies();
        }
        if (extensionControls.containsKey(type = Extension.policyMappings)) {
            this.policyMappings = ((ExtensionType)extensions.get(type.getId())).getPolicyMappings();
        }
        if (extensionControls.containsKey(type = Extension.nameConstraints)) {
            this.nameConstraints = ((ExtensionType)extensions.get(type.getId())).getNameConstraints();
        }
        if (extensionControls.containsKey(type = Extension.policyConstraints)) {
            this.policyConstraints = ((ExtensionType)extensions.get(type.getId())).getPolicyConstraints();
        }
        if (extensionControls.containsKey(type = Extension.inhibitAnyPolicy)) {
            this.inhibitAnyPolicy = ((ExtensionType)extensions.get(type.getId())).getInhibitAnyPolicy();
        }
        if (extensionControls.containsKey(type = ObjectIdentifiers.Extn.id_extension_restriction)) {
            this.restriction = ((ExtensionType)extensions.get(type.getId())).getRestriction();
        }
        if (extensionControls.containsKey(type = ObjectIdentifiers.Extn.id_extension_additionalInformation)) {
            this.additionalInformation = ((ExtensionType)extensions.get(type.getId())).getAdditionalInformation();
        }
        if (extensionControls.containsKey(type = ObjectIdentifiers.Extn.id_extension_validityModel)) {
            this.validityModelId = ((ExtensionType)extensions.get(type.getId())).getValidityModel().getModelId().toXiOid();
        }
        if (extensionControls.containsKey(type = Extension.qCStatements)) {
            this.qcStatements = ((ExtensionType)extensions.get(type.getId())).getQcStatements();
        }
        if (extensionControls.containsKey(type = ObjectIdentifiers.Extn.id_pe_tlsfeature)) {
            this.tlsFeature = ((ExtensionType)extensions.get(type.getId())).getTlsFeature();
        }
        if (extensionControls.containsKey(type = ObjectIdentifiers.Extn.id_smimeCapabilities)) {
            List list = ((ExtensionType)extensions.get(type.getId())).getSmimeCapabilities().getCapabilities();
            ASN1EncodableVector vec = new ASN1EncodableVector();
            for (SmimeCapabilities.SmimeCapability m : list) {
                ASN1ObjectIdentifier oid = m.getCapabilityId().toXiOid();
                ASN1Integer params = null;
                SmimeCapabilities.SmimeCapabilityParameter capParam = m.getParameter();
                if (capParam != null) {
                    if (capParam.getInteger() != null) {
                        params = new ASN1Integer(capParam.getInteger());
                    } else if (capParam.getBinary() != null) {
                        params = CheckerUtil.readAsn1Encodable(capParam.getBinary().getValue());
                    }
                }
                SMIMECapability cap = new SMIMECapability(oid, params);
                vec.add((ASN1Encodable)cap);
            }
            DERSequence extValue = new DERSequence(vec);
            try {
                this.smimeCapabilities = new QaExtensionValue(((Certprofile.ExtensionControl)extensionControls.get(type)).isCritical(), extValue.getEncoded());
            }
            catch (IOException ex) {
                throw new CertprofileException("Cannot encode SMIMECapabilities: " + ex.getMessage());
            }
        }
        this.initCCCExtensionSchemas(extensions);
        this.constantExtensions = CheckerUtil.buildConstantExtesions(extensions);
        this.a2gChecker = new A2gChecker(this);
        this.h2nChecker = new H2nChecker(this);
        this.o2tChecker = new O2tChecker(this);
        this.u2zChecker = new U2zChecker(this);
    }

    private void initCCCExtensionSchemas(Map<String, ExtensionType> extensions) throws CertprofileException {
        Set<String> extnIds = extensions.keySet();
        ASN1ObjectIdentifier type = null;
        for (String m : extnIds) {
            ASN1ObjectIdentifier mOid = new ASN1ObjectIdentifier(m);
            if (!mOid.on(ObjectIdentifiers.Extn.id_ccc_extn)) continue;
            if (type != null) {
                throw new CertprofileException("Maximal one CCC Extension is allowed, but configured at least 2.");
            }
            type = mOid;
        }
        if (type == null) {
            return;
        }
        ExtensionType ex = extensions.get(type.getId());
        if (!ex.critical()) {
            throw new CertprofileException("CCC Extension must be set to critical, but configured non-critical.");
        }
        List<ASN1ObjectIdentifier> simpleSchemaTypes = Arrays.asList(ObjectIdentifiers.Extn.id_ccc_Vehicle_Cert_K, ObjectIdentifiers.Extn.id_ccc_External_CA_Cert_F, ObjectIdentifiers.Extn.id_ccc_VehicleOEM_Enc_Cert, ObjectIdentifiers.Extn.id_ccc_VehicleOEM_Sig_Cert, ObjectIdentifiers.Extn.id_ccc_Device_Enc_Cert, ObjectIdentifiers.Extn.id_ccc_Vehicle_Intermediate_Cert, ObjectIdentifiers.Extn.id_ccc_VehicleOEM_CA_Cert_J, ObjectIdentifiers.Extn.id_ccc_VehicleOEM_CA_Cert_M);
        if (!simpleSchemaTypes.contains(type)) {
            return;
        }
        CCCSimpleExtensionSchema schema = ex.getCccExtensionSchema();
        if (schema == null) {
            throw new CertprofileException("ccExtensionSchema is not set for " + type);
        }
        DERSequence seq = new DERSequence((ASN1Encodable)new ASN1Integer((long)schema.getVersion()));
        this.cccExtensionSchemaType = type;
        try {
            this.cccExtensionSchemaValue = seq.getEncoded();
        }
        catch (IOException e) {
            throw new CertprofileException("error encoding CCC extensionSchemaValue");
        }
    }

    CertificatePolicies getCertificatePolicies() {
        return this.certificatePolicies;
    }

    PolicyMappings getPolicyMappings() {
        return this.policyMappings;
    }

    NameConstraints getNameConstraints() {
        return this.nameConstraints;
    }

    PolicyConstraints getPolicyConstraints() {
        return this.policyConstraints;
    }

    InhibitAnyPolicy getInhibitAnyPolicy() {
        return this.inhibitAnyPolicy;
    }

    Restriction getRestriction() {
        return this.restriction;
    }

    AdditionalInformation getAdditionalInformation() {
        return this.additionalInformation;
    }

    ASN1ObjectIdentifier getValidityModelId() {
        return this.validityModelId;
    }

    QcStatements getQcStatements() {
        return this.qcStatements;
    }

    TlsFeature getTlsFeature() {
        return this.tlsFeature;
    }

    QaExtensionValue getSmimeCapabilities() {
        return this.smimeCapabilities;
    }

    Map<ASN1ObjectIdentifier, QaExtensionValue> getConstantExtensions() {
        return this.constantExtensions;
    }

    XijsonCertprofile getCertprofile() {
        return this.certprofile;
    }

    public List<ValidationIssue> checkExtensions(Certificate cert, IssuerInfo issuerInfo, Extensions requestedExtns, X500Name requestedSubject) {
        Args.notNull((Object)cert, (String)"cert");
        Args.notNull((Object)issuerInfo, (String)"issuerInfo");
        X509Cert jceCert = new X509Cert(cert);
        LinkedList<ValidationIssue> result = new LinkedList<ValidationIssue>();
        Set<ASN1ObjectIdentifier> presentExtensionTypes = this.getExtensionTypes(cert, issuerInfo, requestedExtns);
        Extensions extensions = cert.getTBSCertificate().getExtensions();
        ASN1ObjectIdentifier[] oids = extensions.getExtensionOIDs();
        if (oids == null) {
            ValidationIssue issue = new ValidationIssue("X509.EXT.GEN", "extension general");
            result.add(issue);
            issue.setFailureMessage("no extension is present");
            return result;
        }
        List<ASN1ObjectIdentifier> certExtTypes = Arrays.asList(oids);
        for (ASN1ObjectIdentifier extType : presentExtensionTypes) {
            if (certExtTypes.contains(extType)) continue;
            ValidationIssue issue = this.createExtensionIssue(extType);
            result.add(issue);
            issue.setFailureMessage("extension is absent but is required");
        }
        Map extnControls = this.certprofile.getExtensionControls();
        for (ASN1ObjectIdentifier oid : certExtTypes) {
            ValidationIssue issue = this.createExtensionIssue(oid);
            result.add(issue);
            if (!presentExtensionTypes.contains(oid)) {
                issue.setFailureMessage("extension is present but is not permitted");
                continue;
            }
            Extension ext = extensions.getExtension(oid);
            StringBuilder failureMsg = new StringBuilder();
            Certprofile.ExtensionControl extnControl = (Certprofile.ExtensionControl)extnControls.get(oid);
            if (extnControl.isCritical() != ext.isCritical()) {
                CheckerUtil.addViolation(failureMsg, "critical", ext.isCritical(), extnControl.isCritical());
            }
            byte[] extnValue = ext.getExtnValue().getOctets();
            try {
                byte[] expected;
                if (Extension.authorityKeyIdentifier.equals((ASN1Primitive)oid)) {
                    this.a2gChecker.checkExtnAuthorityKeyId(failureMsg, extnValue, issuerInfo);
                } else if (Extension.subjectKeyIdentifier.equals((ASN1Primitive)oid)) {
                    this.o2tChecker.checkExtnSubjectKeyIdentifier(failureMsg, extnValue, cert.getSubjectPublicKeyInfo());
                } else if (Extension.keyUsage.equals((ASN1Primitive)oid)) {
                    this.h2nChecker.checkExtnKeyUsage(failureMsg, jceCert.getKeyUsage(), requestedExtns, extnControl);
                } else if (Extension.certificatePolicies.equals((ASN1Primitive)oid)) {
                    this.a2gChecker.checkExtnCertificatePolicies(failureMsg, extnValue, requestedExtns, extnControl);
                } else if (Extension.policyMappings.equals((ASN1Primitive)oid)) {
                    this.o2tChecker.checkExtnPolicyMappings(failureMsg, extnValue, requestedExtns, extnControl);
                } else if (Extension.subjectAlternativeName.equals((ASN1Primitive)oid)) {
                    this.o2tChecker.checkExtnSubjectAltNames(failureMsg, extnValue, requestedExtns, extnControl, requestedSubject);
                } else if (Extension.subjectDirectoryAttributes.equals((ASN1Primitive)oid)) {
                    this.o2tChecker.checkExtnSubjectDirAttrs(failureMsg, extnValue, requestedExtns, extnControl);
                } else if (Extension.issuerAlternativeName.equals((ASN1Primitive)oid)) {
                    this.h2nChecker.checkExtnIssuerAltNames(failureMsg, extnValue, issuerInfo);
                } else if (Extension.basicConstraints.equals((ASN1Primitive)oid)) {
                    this.a2gChecker.checkExtnBasicConstraints(failureMsg, extnValue);
                } else if (Extension.nameConstraints.equals((ASN1Primitive)oid)) {
                    this.h2nChecker.checkExtnNameConstraints(failureMsg, extnValue, requestedExtns, extnControl);
                } else if (Extension.policyConstraints.equals((ASN1Primitive)oid)) {
                    this.o2tChecker.checkExtnPolicyConstraints(failureMsg, extnValue, requestedExtns, extnControl);
                } else if (Extension.extendedKeyUsage.equals((ASN1Primitive)oid)) {
                    this.a2gChecker.checkExtnExtendedKeyUsage(failureMsg, extnValue, requestedExtns, extnControl);
                } else if (Extension.cRLDistributionPoints.equals((ASN1Primitive)oid)) {
                    this.a2gChecker.checkExtnCrlDistributionPoints(failureMsg, extnValue, issuerInfo);
                } else if (Extension.inhibitAnyPolicy.equals((ASN1Primitive)oid)) {
                    this.h2nChecker.checkExtnInhibitAnyPolicy(failureMsg, extnValue, extensions, extnControl);
                } else if (Extension.freshestCRL.equals((ASN1Primitive)oid)) {
                    this.a2gChecker.checkExtnDeltaCrlDistributionPoints(failureMsg, extnValue, issuerInfo);
                } else if (Extension.authorityInfoAccess.equals((ASN1Primitive)oid)) {
                    this.a2gChecker.checkExtnAuthorityInfoAccess(failureMsg, extnValue, issuerInfo);
                } else if (Extension.subjectInfoAccess.equals((ASN1Primitive)oid)) {
                    this.o2tChecker.checkExtnSubjectInfoAccess(failureMsg, extnValue, requestedExtns, extnControl);
                } else if (ObjectIdentifiers.Extn.id_extension_admission.equals((ASN1Primitive)oid)) {
                    this.a2gChecker.checkExtnAdmission(failureMsg, extnValue, requestedExtns, requestedSubject, extnControl);
                } else if (ObjectIdentifiers.Extn.id_extension_pkix_ocsp_nocheck.equals((ASN1Primitive)oid)) {
                    this.o2tChecker.checkExtnOcspNocheck(failureMsg, extnValue);
                } else if (ObjectIdentifiers.Extn.id_extension_restriction.equals((ASN1Primitive)oid)) {
                    this.o2tChecker.checkExtnRestriction(failureMsg, extnValue, requestedExtns, extnControl);
                } else if (ObjectIdentifiers.Extn.id_extension_additionalInformation.equals((ASN1Primitive)oid)) {
                    this.a2gChecker.checkExtnAdditionalInformation(failureMsg, extnValue, requestedExtns, extnControl);
                } else if (ObjectIdentifiers.Extn.id_extension_validityModel.equals((ASN1Primitive)oid)) {
                    this.u2zChecker.checkExtnValidityModel(failureMsg, extnValue, requestedExtns, extnControl);
                } else if (Extension.privateKeyUsagePeriod.equals((ASN1Primitive)oid)) {
                    this.o2tChecker.checkExtnPrivateKeyUsagePeriod(failureMsg, extnValue, jceCert.getNotBefore(), jceCert.getNotAfter());
                } else if (Extension.qCStatements.equals((ASN1Primitive)oid)) {
                    this.o2tChecker.checkExtnQcStatements(failureMsg, extnValue, requestedExtns, extnControl);
                } else if (Extension.biometricInfo.equals((ASN1Primitive)oid)) {
                    this.a2gChecker.checkExtnBiometricInfo(failureMsg, extnValue, requestedExtns);
                } else if (ObjectIdentifiers.Extn.id_pe_tlsfeature.equals((ASN1Primitive)oid)) {
                    this.o2tChecker.checkExtnTlsFeature(failureMsg, extnValue, requestedExtns, extnControl);
                } else if (ObjectIdentifiers.Extn.id_smimeCapabilities.equals((ASN1Primitive)oid)) {
                    this.o2tChecker.checkSmimeCapabilities(failureMsg, extnValue, extnControl);
                } else if (ObjectIdentifiers.Extn.id_SCTs.equals((ASN1Primitive)oid)) {
                    this.o2tChecker.checkScts(failureMsg, extnValue, extnControl);
                } else if (ObjectIdentifiers.Extn.id_GMT_0015_ICRegistrationNumber.equals((ASN1Primitive)oid) || ObjectIdentifiers.Extn.id_GMT_0015_InsuranceNumber.equals((ASN1Primitive)oid) || ObjectIdentifiers.Extn.id_GMT_0015_OrganizationCode.equals((ASN1Primitive)oid) || ObjectIdentifiers.Extn.id_GMT_0015_TaxationNumber.equals((ASN1Primitive)oid) || ObjectIdentifiers.Extn.id_GMT_0015_IdentityCode.equals((ASN1Primitive)oid)) {
                    this.a2gChecker.checkExtnGmt0015(failureMsg, extnValue, requestedExtns, extnControl, oid, requestedSubject);
                } else if (oid.equals((ASN1Primitive)this.cccExtensionSchemaType)) {
                    expected = this.cccExtensionSchemaValue;
                    if (!Arrays.equals(this.cccExtensionSchemaValue, extnValue)) {
                        CheckerUtil.addViolation(failureMsg, "extension value", CheckerUtil.hex(extnValue), expected == null ? "not present" : CheckerUtil.hex(expected));
                    }
                } else {
                    expected = this.getExpectedExtValue(oid, requestedExtns, extnControl);
                    if (!Arrays.equals(expected, extnValue)) {
                        CheckerUtil.addViolation(failureMsg, "extension value", CheckerUtil.hex(extnValue), expected == null ? "not present" : CheckerUtil.hex(expected));
                    }
                }
                if (failureMsg.length() <= 0) continue;
                issue.setFailureMessage(failureMsg.toString());
            }
            catch (IOException | ArrayIndexOutOfBoundsException | ClassCastException | IllegalArgumentException ex) {
                LOG.debug("extension value does not have correct syntax", (Throwable)ex);
                issue.setFailureMessage("extension value does not have correct syntax");
            }
        }
        return result;
    }

    private byte[] getExpectedExtValue(ASN1ObjectIdentifier type, Extensions requestedExtns, Certprofile.ExtensionControl extControl) {
        Extension reqExt;
        if (this.constantExtensions != null && this.constantExtensions.containsKey(type)) {
            return this.constantExtensions.get(type).getValue();
        }
        if (requestedExtns != null && extControl.isPermittedInRequest() && (reqExt = requestedExtns.getExtension(type)) != null) {
            return reqExt.getExtnValue().getOctets();
        }
        return null;
    }

    private Set<ASN1ObjectIdentifier> getExtensionTypes(Certificate cert, IssuerInfo issuerInfo, Extensions requestedExtns) {
        HashSet<ASN1ObjectIdentifier> types = new HashSet<ASN1ObjectIdentifier>();
        Map extensionControls = this.certprofile.getExtensionControls();
        for (Map.Entry entry : extensionControls.entrySet()) {
            ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)entry.getKey();
            if (((Certprofile.ExtensionControl)entry.getValue()).isRequired()) {
                types.add(oid);
                continue;
            }
            if (requestedExtns == null || requestedExtns.getExtension(oid) == null) continue;
            types.add(oid);
        }
        ASN1ObjectIdentifier type = Extension.authorityKeyIdentifier;
        if (extensionControls.containsKey(type)) {
            CheckerUtil.addIfNotIn(types, type);
        }
        if (extensionControls.containsKey(type = Extension.subjectKeyIdentifier)) {
            CheckerUtil.addIfNotIn(types, type);
        }
        if (extensionControls.containsKey(type = Extension.keyUsage)) {
            Set<Certprofile.KeyUsageControl> requiredKeyusage;
            boolean required;
            boolean bl = required = requestedExtns != null && requestedExtns.getExtension(type) != null;
            if (!required && CollectionUtil.isNotEmpty(requiredKeyusage = this.h2nChecker.getKeyusage(true))) {
                required = true;
            }
            if (required) {
                CheckerUtil.addIfNotIn(types, type);
            }
        }
        if (extensionControls.containsKey(type = Extension.certificatePolicies) && this.certificatePolicies != null) {
            CheckerUtil.addIfNotIn(types, type);
        }
        if (extensionControls.containsKey(type = Extension.policyMappings) && this.policyMappings != null) {
            CheckerUtil.addIfNotIn(types, type);
        }
        if (extensionControls.containsKey(type = Extension.subjectAlternativeName) && requestedExtns != null && requestedExtns.getExtension(type) != null) {
            CheckerUtil.addIfNotIn(types, type);
        }
        if (extensionControls.containsKey(type = Extension.issuerAlternativeName) && cert.getTBSCertificate().getExtensions().getExtension(Extension.subjectAlternativeName) != null) {
            CheckerUtil.addIfNotIn(types, type);
        }
        if (extensionControls.containsKey(type = Extension.basicConstraints)) {
            CheckerUtil.addIfNotIn(types, type);
        }
        if (extensionControls.containsKey(type = Extension.nameConstraints) && this.nameConstraints != null) {
            CheckerUtil.addIfNotIn(types, type);
        }
        if (extensionControls.containsKey(type = Extension.policyConstraints) && this.policyConstraints != null) {
            CheckerUtil.addIfNotIn(types, type);
        }
        if (extensionControls.containsKey(type = Extension.extendedKeyUsage)) {
            Set<Certprofile.ExtKeyUsageControl> requiredExtKeyusage;
            boolean required;
            boolean bl = required = requestedExtns != null && requestedExtns.getExtension(type) != null;
            if (!required && CollectionUtil.isNotEmpty(requiredExtKeyusage = this.getExtKeyusage(true))) {
                required = true;
            }
            if (required) {
                CheckerUtil.addIfNotIn(types, type);
            }
        }
        if (extensionControls.containsKey(type = Extension.cRLDistributionPoints) && issuerInfo.getCrlUrls() != null) {
            CheckerUtil.addIfNotIn(types, type);
        }
        if (extensionControls.containsKey(type = Extension.inhibitAnyPolicy) && this.inhibitAnyPolicy != null) {
            CheckerUtil.addIfNotIn(types, type);
        }
        if (extensionControls.containsKey(type = Extension.freshestCRL) && issuerInfo.getDeltaCrlUrls() != null) {
            CheckerUtil.addIfNotIn(types, type);
        }
        if (extensionControls.containsKey(type = Extension.authorityInfoAccess) && issuerInfo.getOcspUrls() != null) {
            CheckerUtil.addIfNotIn(types, type);
        }
        if (extensionControls.containsKey(type = Extension.subjectInfoAccess) && requestedExtns != null && requestedExtns.getExtension(type) != null) {
            CheckerUtil.addIfNotIn(types, type);
        }
        if (extensionControls.containsKey(type = ObjectIdentifiers.Extn.id_extension_admission) && this.certprofile.extensions().getAdmission() != null) {
            CheckerUtil.addIfNotIn(types, type);
        }
        if (extensionControls.containsKey(type = ObjectIdentifiers.Extn.id_extension_pkix_ocsp_nocheck)) {
            CheckerUtil.addIfNotIn(types, type);
        }
        if (requestedExtns != null) {
            ASN1ObjectIdentifier[] extOids;
            for (ASN1ObjectIdentifier oid : extOids = requestedExtns.getExtensionOIDs()) {
                if (!extensionControls.containsKey(oid)) continue;
                CheckerUtil.addIfNotIn(types, oid);
            }
        }
        return types;
    }

    private ValidationIssue createExtensionIssue(ASN1ObjectIdentifier extId) {
        String extName = ObjectIdentifiers.getName((ASN1ObjectIdentifier)extId);
        if (extName == null) {
            extName = extId.getId().replace('.', '_');
            return new ValidationIssue("X509.EXT." + extName, "extension " + extId.getId());
        }
        return new ValidationIssue("X509.EXT." + extName, "extension " + extName + " (" + extId.getId() + ")");
    }

    void checkDirectoryString(ASN1ObjectIdentifier extnType, DirectoryStringType type, String text, StringBuilder failureMsg, byte[] extensionValue, Extensions requestedExtns, Certprofile.ExtensionControl extControl) {
        boolean correctStringType;
        ASN1Primitive asn1;
        if (type == null) {
            this.checkConstantExtnValue(extnType, failureMsg, extensionValue, requestedExtns, extControl);
            return;
        }
        try {
            asn1 = ASN1Primitive.fromByteArray((byte[])extensionValue);
        }
        catch (IOException ex) {
            failureMsg.append("invalid syntax of extension value; ");
            return;
        }
        switch (type) {
            case bmpString: {
                correctStringType = asn1 instanceof DERBMPString;
                break;
            }
            case printableString: {
                correctStringType = asn1 instanceof DERPrintableString;
                break;
            }
            case teletexString: {
                correctStringType = asn1 instanceof DERT61String;
                break;
            }
            case utf8String: {
                correctStringType = asn1 instanceof DERUTF8String;
                break;
            }
            default: {
                throw new IllegalStateException("should not reach here, unknown DirectoryStringType " + type);
            }
        }
        if (!correctStringType) {
            failureMsg.append("extension value is not of type DirectoryString.").append(text).append("; ");
            return;
        }
        String extTextValue = ((ASN1String)asn1).getString();
        if (!text.equals(extTextValue)) {
            CheckerUtil.addViolation(failureMsg, "content", extTextValue, text);
        }
    }

    Set<Certprofile.ExtKeyUsageControl> getExtKeyusage(boolean required) {
        HashSet<Certprofile.ExtKeyUsageControl> ret = new HashSet<Certprofile.ExtKeyUsageControl>();
        Set controls = this.certprofile.extensions().getExtendedKeyusages();
        if (controls != null) {
            for (Certprofile.ExtKeyUsageControl control : controls) {
                if (control.isRequired() != required) continue;
                ret.add(control);
            }
        }
        return ret;
    }

    byte[] getConstantExtensionValue(ASN1ObjectIdentifier type) {
        return this.constantExtensions == null ? null : this.constantExtensions.get(type).getValue();
    }

    void checkConstantExtnValue(ASN1ObjectIdentifier extnType, StringBuilder failureMsg, byte[] extensionValue, Extensions requestedExtns, Certprofile.ExtensionControl extControl) {
        byte[] expected = this.getExpectedExtValue(extnType, requestedExtns, extControl);
        if (!Arrays.equals(expected, extensionValue)) {
            CheckerUtil.addViolation(failureMsg, "extension values", CheckerUtil.hex(extensionValue), expected == null ? "not present" : CheckerUtil.hex(expected));
        }
    }
}

