/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.qa.ca.extn;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralSubtree;
import org.bouncycastle.asn1.x509.NameConstraints;
import org.xipki.ca.api.profile.Certprofile;
import org.xipki.ca.certprofile.xijson.conf.GeneralSubtreeType;
import org.xipki.ca.certprofile.xijson.conf.InhibitAnyPolicy;
import org.xipki.qa.ca.IssuerInfo;
import org.xipki.qa.ca.extn.CheckerUtil;
import org.xipki.qa.ca.extn.ExtensionChecker;
import org.xipki.qa.ca.extn.ExtensionsChecker;
import org.xipki.security.KeyUsage;
import org.xipki.security.util.X509Util;
import org.xipki.util.CollectionUtil;
import org.xipki.util.CompareUtil;

class H2nChecker
extends ExtensionChecker {
    private static final List<String> ALL_USAGES = Arrays.asList(KeyUsage.digitalSignature.getName(), KeyUsage.contentCommitment.getName(), KeyUsage.keyEncipherment.getName(), KeyUsage.dataEncipherment.getName(), KeyUsage.keyAgreement.getName(), KeyUsage.keyCertSign.getName(), KeyUsage.cRLSign.getName(), KeyUsage.encipherOnly.getName(), KeyUsage.decipherOnly.getName());

    H2nChecker(ExtensionsChecker parent) {
        super(parent);
    }

    void checkExtnInhibitAnyPolicy(StringBuilder failureMsg, byte[] extensionValue, Extensions requestedExtns, Certprofile.ExtensionControl extControl) {
        InhibitAnyPolicy conf = this.caller.getInhibitAnyPolicy();
        if (conf == null) {
            this.caller.checkConstantExtnValue(Extension.inhibitAnyPolicy, failureMsg, extensionValue, requestedExtns, extControl);
            return;
        }
        ASN1Integer asn1Int = ASN1Integer.getInstance((Object)extensionValue);
        int isSkipCerts = asn1Int.getPositiveValue().intValue();
        if (isSkipCerts != conf.getSkipCerts()) {
            CheckerUtil.addViolation(failureMsg, "skipCerts", isSkipCerts, conf.getSkipCerts());
        }
    }

    void checkExtnIssuerAltNames(StringBuilder failureMsg, byte[] extensionValue, IssuerInfo issuerInfo) {
        byte[] caSubjectAltExtensionValue = issuerInfo.getCert().getExtensionCoreValue(Extension.subjectAlternativeName);
        if (caSubjectAltExtensionValue == null) {
            failureMsg.append("issuerAlternativeName is present but expected 'none'; ");
            return;
        }
        if (!Arrays.equals(caSubjectAltExtensionValue, extensionValue)) {
            CheckerUtil.addViolation(failureMsg, "issuerAltNames", CheckerUtil.hex(extensionValue), CheckerUtil.hex(caSubjectAltExtensionValue));
        }
    }

    void checkExtnKeyUsage(StringBuilder failureMsg, boolean[] usages, Extensions requestedExtns, Certprofile.ExtensionControl extnControl) {
        Set<String> diffs;
        byte[] constantExtValue;
        Extension extension;
        int len = usages.length;
        if (len > 9) {
            failureMsg.append("invalid syntax: size of valid bits is larger than 9: ").append(len);
            failureMsg.append("; ");
        }
        HashSet<String> isUsages = new HashSet<String>();
        for (int i = 0; i < len; ++i) {
            if (!usages[i]) continue;
            isUsages.add(ALL_USAGES.get(i));
        }
        Set<String> expectedUsages = new HashSet<String>();
        Set<Certprofile.KeyUsageControl> requiredKeyusage = this.getKeyusage(true);
        for (Certprofile.KeyUsageControl usage : requiredKeyusage) {
            expectedUsages.add(usage.getKeyUsage().getName());
        }
        Set<Certprofile.KeyUsageControl> optionalKeyusage = this.getKeyusage(false);
        if (requestedExtns != null && extnControl.isPermittedInRequest() && CollectionUtil.isNotEmpty(optionalKeyusage) && (extension = requestedExtns.getExtension(Extension.keyUsage)) != null) {
            org.bouncycastle.asn1.x509.KeyUsage reqKeyUsage = org.bouncycastle.asn1.x509.KeyUsage.getInstance((Object)extension.getParsedValue());
            for (Certprofile.KeyUsageControl k : optionalKeyusage) {
                if (!reqKeyUsage.hasUsages(k.getKeyUsage().getBcUsage())) continue;
                expectedUsages.add(k.getKeyUsage().getName());
            }
        }
        if (CollectionUtil.isEmpty(expectedUsages) && (constantExtValue = this.caller.getConstantExtensionValue(Extension.keyUsage)) != null) {
            expectedUsages = CheckerUtil.getKeyUsage(constantExtValue);
        }
        if (CollectionUtil.isNotEmpty(diffs = CheckerUtil.strInBnotInA(expectedUsages, isUsages))) {
            failureMsg.append("usages ").append(diffs).append(" are present but not expected; ");
        }
        if (CollectionUtil.isNotEmpty(diffs = CheckerUtil.strInBnotInA(isUsages, expectedUsages))) {
            failureMsg.append("usages ").append(diffs).append(" are absent but are required; ");
        }
    }

    Set<Certprofile.KeyUsageControl> getKeyusage(boolean required) {
        HashSet<Certprofile.KeyUsageControl> ret = new HashSet<Certprofile.KeyUsageControl>();
        Set controls = this.getCertprofile().extensions().getKeyusages();
        if (controls != null) {
            for (Certprofile.KeyUsageControl control : controls) {
                if (control.isRequired() != required) continue;
                ret.add(control);
            }
        }
        return ret;
    }

    void checkExtnNameConstraints(StringBuilder failureMsg, byte[] extnValue, Extensions requestedExtns, Certprofile.ExtensionControl extnControl) {
        org.xipki.ca.certprofile.xijson.conf.NameConstraints nameConstraints = this.caller.getNameConstraints();
        if (nameConstraints == null) {
            this.caller.checkConstantExtnValue(Extension.nameConstraints, failureMsg, extnValue, requestedExtns, extnControl);
            return;
        }
        NameConstraints tmpNameConstraints = NameConstraints.getInstance((Object)extnValue);
        this.checkExtnNameConstraintsSubtrees(failureMsg, "PermittedSubtrees", tmpNameConstraints.getPermittedSubtrees(), nameConstraints.getPermittedSubtrees());
        this.checkExtnNameConstraintsSubtrees(failureMsg, "ExcludedSubtrees", tmpNameConstraints.getExcludedSubtrees(), nameConstraints.getExcludedSubtrees());
    }

    private void checkExtnNameConstraintsSubtrees(StringBuilder failureMsg, String description, GeneralSubtree[] subtrees, List<GeneralSubtreeType> expectedSubtrees) {
        int expSize;
        int isSize = subtrees == null ? 0 : subtrees.length;
        int n = expSize = expectedSubtrees == null ? 0 : expectedSubtrees.size();
        if (isSize != expSize) {
            CheckerUtil.addViolation(failureMsg, "size of " + description, isSize, expSize);
            return;
        }
        if (subtrees == null || expectedSubtrees == null) {
            return;
        }
        for (int i = 0; i < isSize; ++i) {
            GeneralName expBase;
            Integer expMaximum;
            Integer isMaximum;
            GeneralSubtree isSubtree = subtrees[i];
            GeneralSubtreeType expSubtree = expectedSubtrees.get(i);
            BigInteger bigInt = isSubtree.getMinimum();
            int isMinimum = bigInt == null ? 0 : bigInt.intValue();
            Integer minimum = expSubtree.getMinimum();
            int expMinimum = minimum == null ? 0 : minimum;
            String desc = description + " [" + i + "]";
            if (isMinimum != expMinimum) {
                CheckerUtil.addViolation(failureMsg, "minimum of " + desc, isMinimum, expMinimum);
            }
            if (!CompareUtil.equalsObject((Object)(isMaximum = (bigInt = isSubtree.getMaximum()) == null ? null : Integer.valueOf(bigInt.intValue())), (Object)(expMaximum = expSubtree.getMaximum()))) {
                CheckerUtil.addViolation(failureMsg, "maxmum of " + desc, isMaximum, expMaximum);
            }
            GeneralName isBase = isSubtree.getBase();
            GeneralSubtreeType.Base expBase0 = expSubtree.getBase();
            if (expSubtree.getBase().getDirectoryName() != null) {
                expBase = new GeneralName(X509Util.reverse((X500Name)new X500Name(expBase0.getDirectoryName())));
            } else if (expBase0.getDnsName() != null) {
                expBase = new GeneralName(2, expBase0.getDnsName());
            } else if (expBase0.getIpAddress() != null) {
                expBase = new GeneralName(7, expBase0.getIpAddress());
            } else if (expBase0.getRfc822Name() != null) {
                expBase = new GeneralName(1, expBase0.getRfc822Name());
            } else if (expBase0.getUri() != null) {
                expBase = new GeneralName(6, expBase0.getUri());
            } else {
                throw new IllegalStateException("should not reach here, unknown child of GeneralName");
            }
            if (isBase.equals((Object)expBase)) continue;
            CheckerUtil.addViolation(failureMsg, "base of " + desc, isBase, expBase);
        }
    }
}

