/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.qa.ocsp;

import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ocsp.client.HttpOcspRequestor;
import org.xipki.ocsp.client.OcspRequestor;
import org.xipki.ocsp.client.RequestOptions;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;
import org.xipki.util.BenchmarkExecutor;

public class OcspBenchmark
extends BenchmarkExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(OcspBenchmark.class);
    private final OcspRequestor client;
    private final X509Cert issuerCert;
    private final URL responderUrl;
    private final RequestOptions requestOptions;
    private final Iterator<BigInteger> serials;
    private final int maxRequests;
    private final AtomicInteger processedRequests = new AtomicInteger(0);

    public OcspBenchmark(X509Cert issuerCert, String responderUrl, RequestOptions requestOptions, Iterator<BigInteger> serials, int maxRequests, String description) throws MalformedURLException {
        super(description);
        this.client = new HttpOcspRequestor();
        this.issuerCert = (X509Cert)Args.notNull((Object)issuerCert, (String)"issuerCert");
        this.responderUrl = new URL((String)Args.notNull((Object)responderUrl, (String)"responderUrl"));
        this.requestOptions = (RequestOptions)Args.notNull((Object)requestOptions, (String)"requestOptions");
        this.maxRequests = maxRequests;
        this.serials = (Iterator)Args.notNull(serials, (String)"serials");
    }

    protected Runnable getTester() {
        return new Tester();
    }

    private BigInteger nextSerialNumber() {
        int num;
        if (this.maxRequests > 0 && (num = this.processedRequests.getAndAdd(1)) >= this.maxRequests) {
            return null;
        }
        try {
            return this.serials.next();
        }
        catch (NoSuchElementException ex) {
            return null;
        }
    }

    public boolean ask(BigInteger[] serialNumbers) {
        Object respObject;
        OCSPResp ocspResp;
        try {
            ocspResp = this.client.ask(this.issuerCert, serialNumbers, this.responderUrl, this.requestOptions, null);
        }
        catch (Exception e) {
            LOG.warn("error client.ask", (Throwable)e);
            return false;
        }
        try {
            respObject = ocspResp.getResponseObject();
        }
        catch (OCSPException ex) {
            LOG.warn("responseObject is invalid", (Throwable)ex);
            return false;
        }
        if (ocspResp.getStatus() != 0) {
            LOG.warn("bad response: response status is other than OK: {}", (Object)ocspResp.getStatus());
            return false;
        }
        if (!(respObject instanceof BasicOCSPResp)) {
            LOG.warn("bad response: response is not BasicOCSPResp");
            return false;
        }
        return true;
    }

    final class Tester
    implements Runnable {
        Tester() {
        }

        @Override
        public void run() {
            BigInteger sn;
            while (!OcspBenchmark.this.stop() && (sn = OcspBenchmark.this.nextSerialNumber()) != null) {
                try {
                    boolean valid = OcspBenchmark.this.ask(new BigInteger[]{sn});
                    OcspBenchmark.this.account(1L, valid ? 0L : 1L);
                }
                catch (Throwable th) {
                    LOG.warn("{}: {}", (Object)th.getClass().getName(), (Object)th.getMessage());
                    OcspBenchmark.this.account(1L, 1L);
                }
            }
        }
    }
}

